/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim3.utilities;

import java.math.BigInteger;
import java.util.ArrayList;
import javax.cim.CIMDateTime;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMDateTimeInterval;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.cim.UnsignedInteger8;
import javax.cim3.CIMDataType;
import javax.cim3.CIMObjectPath;

public class CIMUtilities {
    public static CIMDataType getArrayType(CIMDataType type) {
        switch (type.getType()) {
            case 9: {
                return CIMDataType.BOOLEAN_ARRAY_T;
            }
            case 12: {
                return CIMDataType.DATETIME_ARRAY_T;
            }
            case 13: {
                return CIMDataType.OBJECT_ARRAY_T;
            }
            case 10: {
                return CIMDataType.REAL32_ARRAY_T;
            }
            case 11: {
                return CIMDataType.REAL64_ARRAY_T;
            }
            case 14: {
                return new CIMDataType(14, type.getClassName(), true);
            }
            case 3: {
                return CIMDataType.SINT16_ARRAY_T;
            }
            case 5: {
                return CIMDataType.SINT32_ARRAY_T;
            }
            case 7: {
                return CIMDataType.SINT64_ARRAY_T;
            }
            case 1: {
                return CIMDataType.SINT8_ARRAY_T;
            }
            case 8: {
                return CIMDataType.STRING_ARRAY_T;
            }
            case 2: {
                return CIMDataType.UINT16_ARRAY_T;
            }
            case 4: {
                return CIMDataType.UINT32_ARRAY_T;
            }
            case 6: {
                return CIMDataType.UINT64_ARRAY_T;
            }
            case 0: {
                return CIMDataType.UINT8_ARRAY_T;
            }
            case 16: {
                return new CIMDataType(16, type.getClassName(), true);
            }
            case 18: {
                return new CIMDataType(18, type.getClassName(), true);
            }
            case 15: {
                return new CIMDataType(15, type.getClassName(), true);
            }
            case 17: {
                return new CIMDataType(17, type.getClassName(), true);
            }
            case 20: {
                return new CIMDataType(20, type.getClassName(), true);
            }
        }
        return CIMDataType.STRING_ARRAY_T;
    }

    static Object convertArrayToType(ArrayList<Object> l, CIMDataType type) {
        Object[] o = null;
        switch (type.getType()) {
            case 9: {
                o = l.toArray(new Boolean[l.size()]);
                break;
            }
            case 12: {
                o = l.toArray(new CIMDateTime[l.size()]);
                break;
            }
            case 10: {
                o = l.toArray(new Float[l.size()]);
                break;
            }
            case 11: {
                o = l.toArray(new Double[l.size()]);
                break;
            }
            case 14: {
                o = l.toArray(new CIMObjectPath[l.size()]);
                break;
            }
            case 3: {
                o = l.toArray(new Short[l.size()]);
                break;
            }
            case 5: {
                o = l.toArray(new Integer[l.size()]);
                break;
            }
            case 7: {
                o = l.toArray(new Long[l.size()]);
                break;
            }
            case 1: {
                o = l.toArray(new Byte[l.size()]);
                break;
            }
            case 8: {
                o = l.toArray(new String[l.size()]);
                break;
            }
            case 2: {
                o = l.toArray(new UnsignedInteger16[l.size()]);
                break;
            }
            case 4: {
                o = l.toArray(new UnsignedInteger32[l.size()]);
                break;
            }
            case 6: {
                o = l.toArray(new UnsignedInteger64[l.size()]);
                break;
            }
            case 0: {
                o = l.toArray(new UnsignedInteger8[l.size()]);
            }
        }
        return o;
    }

    public static Object convertStringToProperType(CIMDataType type, String value) {
        Object o = null;
        if (null == value || "null".equals(value)) {
            return o;
        }
        int inType = type.getType();
        int radix = 10;
        if ((inType == 3 || inType == 5 || inType == 7 || inType == 1) && (value.startsWith("0x") || value.startsWith("+0x") || value.startsWith("-0x") || value.startsWith("0X") || value.startsWith("+0X") || value.startsWith("-0X")) || (inType == 2 || inType == 4 || inType == 6 || inType == 0) && (value.startsWith("0x") || value.startsWith("0X"))) {
            radix = 16;
            int dot = (value.indexOf("x") > 0 ? value.indexOf("x") : value.indexOf("X")) + 1;
            value = value.startsWith("-") ? "-" + value.substring(dot) : value.substring(dot);
        }
        switch (type.getType()) {
            case 9: {
                o = Boolean.valueOf(value);
                break;
            }
            case 12: {
                try {
                    o = new CIMDateTimeAbsolute(value);
                }
                catch (IllegalArgumentException exp) {
                    o = new CIMDateTimeInterval(value);
                }
                break;
            }
            case 10: {
                o = new Float(value);
                break;
            }
            case 11: {
                o = new Double(value);
                break;
            }
            case 14: {
                o = new CIMObjectPath(value);
                break;
            }
            case 3: {
                o = Short.valueOf(value, radix);
                break;
            }
            case 5: {
                o = Integer.valueOf(value, radix);
                break;
            }
            case 7: {
                o = Long.valueOf(value, radix);
                break;
            }
            case 1: {
                o = Byte.valueOf(value, radix);
                break;
            }
            case 8: {
                o = CIMUtilities.parseQuotedString(value);
                break;
            }
            case 2: {
                o = new UnsignedInteger16(Integer.valueOf(value, radix));
                break;
            }
            case 4: {
                o = new UnsignedInteger32(Long.valueOf(value, radix));
                break;
            }
            case 6: {
                o = new UnsignedInteger64(new BigInteger(value, radix));
                break;
            }
            case 0: {
                o = new UnsignedInteger8(Short.valueOf(value, radix));
                break;
            }
            case 20: {
                o = value;
            }
        }
        return o;
    }

    static CIMDataType getDataType(String type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (type.equals("boolean")) {
            return CIMDataType.BOOLEAN_T;
        }
        if (type.equals("datetime")) {
            return CIMDataType.DATETIME_T;
        }
        if (type.equals("real32")) {
            return CIMDataType.REAL32_T;
        }
        if (type.equals("real64")) {
            return CIMDataType.REAL64_T;
        }
        if (type.equals("sint16")) {
            return CIMDataType.SINT16_T;
        }
        if (type.equals("sint32")) {
            return CIMDataType.SINT32_T;
        }
        if (type.equals("sint64")) {
            return CIMDataType.SINT64_T;
        }
        if (type.equals("sint8")) {
            return CIMDataType.SINT8_T;
        }
        if (type.equals("string")) {
            return CIMDataType.STRING_T;
        }
        if (type.equals("uint16")) {
            return CIMDataType.UINT16_T;
        }
        if (type.equals("uint32")) {
            return CIMDataType.UINT32_T;
        }
        if (type.equals("uint64")) {
            return CIMDataType.UINT64_T;
        }
        if (type.equals("uint8")) {
            return CIMDataType.UINT8_T;
        }
        return CIMDataType.STRING_T;
    }

    static CIMDataType getDataType(String type, boolean isArray) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (isArray) {
            if (type.equals("boolean")) {
                return CIMDataType.BOOLEAN_ARRAY_T;
            }
            if (type.equals("datetime")) {
                return CIMDataType.DATETIME_ARRAY_T;
            }
            if (type.equals("real32")) {
                return CIMDataType.REAL32_ARRAY_T;
            }
            if (type.equals("real64")) {
                return CIMDataType.REAL64_ARRAY_T;
            }
            if (type.equals("sint16")) {
                return CIMDataType.SINT16_ARRAY_T;
            }
            if (type.equals("sint32")) {
                return CIMDataType.SINT32_ARRAY_T;
            }
            if (type.equals("sint64")) {
                return CIMDataType.SINT64_ARRAY_T;
            }
            if (type.equals("sint8")) {
                return CIMDataType.SINT8_ARRAY_T;
            }
            if (type.equals("string")) {
                return CIMDataType.STRING_ARRAY_T;
            }
            if (type.equals("uint16")) {
                return CIMDataType.UINT16_ARRAY_T;
            }
            if (type.equals("uint32")) {
                return CIMDataType.UINT32_ARRAY_T;
            }
            if (type.equals("uint64")) {
                return CIMDataType.UINT64_ARRAY_T;
            }
            if (type.equals("uint8")) {
                return CIMDataType.UINT8_ARRAY_T;
            }
            return CIMDataType.STRING_ARRAY_T;
        }
        return CIMUtilities.getDataType(type);
    }

    public static String parseQuotedString(String s) {
        if (!s.startsWith("\"")) {
            return s;
        }
        String t = s.substring(1, s.length() - 1);
        int i = t.length();
        StringBuilder b = new StringBuilder();
        block10: for (int j = 0; j < i; ++j) {
            if (t.charAt(j) == '\\') {
                switch (t.charAt(++j)) {
                    case 'n': {
                        b.append(System.getProperty("line.separator"));
                        continue block10;
                    }
                    case 't': {
                        b.append('\t');
                        continue block10;
                    }
                    case 'b': {
                        b.append('\b');
                        continue block10;
                    }
                    case 'r': {
                        b.append('\r');
                        continue block10;
                    }
                    case 'f': {
                        b.append('\f');
                        continue block10;
                    }
                    case '\\': {
                        b.append('\\');
                        continue block10;
                    }
                    case '\'': {
                        b.append('\'');
                        continue block10;
                    }
                    case '\"': {
                        b.append('\"');
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException(s);
                    }
                }
            }
            b.append(t.charAt(j));
        }
        return b.toString();
    }
}

