/*
 * Decompiled with CFR 0.152.
 */
package javax.cim3;

import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import javax.cim.CIMDateTime;
import javax.cim3.CIMDataType;
import javax.cim3.CIMElement;
import javax.cim3.CIMProperty;
import javax.cim3.CIMValuedElement;
import javax.cim3.Messages;

public class CIMObjectPath
implements Serializable {
    private static final long serialVersionUID = 4593259690658425064L;
    private String mScheme;
    private String mHost;
    private String mPort;
    private String mNamespace;
    private String mElementName;
    private URL mSchemaNamespace;
    private CIMProperty<?>[] mKeys;

    public CIMObjectPath(String objectPath) {
        if (null == objectPath || objectPath.isEmpty()) {
            throw new IllegalArgumentException("The object name can not be empty or null.");
        }
        this.mKeys = new CIMProperty[0];
        this.parseOp(objectPath);
    }

    public CIMObjectPath(String scheme, String host, String port, String namespace, String objectName, CIMProperty<?>[] keys) {
        this.parseOp(objectName);
        this.mHost = host;
        this.mNamespace = this.validateNameSpace(namespace);
        this.mKeys = keys;
        this.mScheme = scheme;
        this.mPort = port;
    }

    public CIMObjectPath(String scheme, String host, String port, String namespace, String objectName, CIMProperty<?>[] keys, String xmlSchemaName) {
        this(scheme, host, port, namespace, objectName, keys);
        try {
            if (null != xmlSchemaName) {
                this.mSchemaNamespace = new URL(xmlSchemaName);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("xmlSchemaName is malformed");
        }
    }

    public boolean equals(Object o) {
        return this.equals(o, false);
    }

    private boolean equals(Object o, boolean modelPath) {
        if (!(o instanceof CIMObjectPath)) {
            return false;
        }
        CIMObjectPath inp = (CIMObjectPath)o;
        if (!modelPath) {
            if (inp.mHost == null ? this.mHost != null && this.mHost.length() != 0 : !inp.mHost.equalsIgnoreCase(this.mHost)) {
                return false;
            }
            if (inp.mNamespace == null ? this.mNamespace != null && this.mNamespace.length() != 0 : !inp.mNamespace.equalsIgnoreCase(this.mNamespace)) {
                return false;
            }
        }
        if (inp.mElementName == null ? this.mElementName != null && this.mElementName.length() != 0 : !inp.mElementName.equalsIgnoreCase(this.mElementName)) {
            return false;
        }
        if (inp.mKeys == null) {
            if (this.mKeys != null) {
                return false;
            }
        } else {
            if (this.mKeys == null) {
                return false;
            }
            if (inp.mKeys.length != this.mKeys.length) {
                return false;
            }
            for (CIMProperty<?> p : this.mKeys) {
                CIMObjectPath inppValue;
                CIMObjectPath pValue;
                CIMProperty<?> inpp = inp.getKey(p.getName());
                if (null == inpp) {
                    return false;
                }
                if (!(null != p.getDataType().getClassName() && null != inpp.getDataType().getClassName() ? !(pValue = (CIMObjectPath)p.getValue()).equals(inppValue = (CIMObjectPath)inpp.getValue(), modelPath) : !p.getValue().equals(inpp.getValue()))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equalsModelPath(CIMObjectPath modelPath) {
        return this.equals(modelPath, true);
    }

    private String escape(String str) {
        int size = str.length();
        StringBuilder sb = new StringBuilder(size);
        block11: for (int i = 0; i < size; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\u0000': {
                    continue block11;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block11;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block11;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block11;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block11;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block11;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block11;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block11;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block11;
                }
                default: {
                    ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = Integer.toString(ch, 16);
                        sb.append("\\x" + "0000".substring(s.length() - 4) + s);
                        continue block11;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public String getHost() {
        return this.mHost;
    }

    public CIMProperty<?> getKey(String name) {
        if (null != this.mKeys) {
            for (CIMProperty<?> mKey : this.mKeys) {
                if (!mKey.getName().equalsIgnoreCase(name)) continue;
                return mKey;
            }
        }
        return null;
    }

    public CIMProperty<?>[] getKeys() {
        return this.mKeys == null ? new CIMProperty[]{} : this.mKeys;
    }

    public Object getKeyValue(String name) {
        for (CIMProperty<?> mKey : this.mKeys) {
            if (!mKey.getName().equalsIgnoreCase(name)) continue;
            return mKey.getValue();
        }
        return null;
    }

    public String getNamespace() {
        return this.mNamespace;
    }

    public String getObjectName() {
        return this.mElementName;
    }

    public String getPort() {
        return this.mPort;
    }

    public String getScheme() {
        return this.mScheme;
    }

    public String getXmlSchemaName() {
        String retString = null;
        if (this.mSchemaNamespace != null) {
            retString = this.mSchemaNamespace.toString();
        }
        return retString;
    }

    public int hashCode() {
        int hashcode = 0;
        if (this.getScheme() != null) {
            hashcode ^= this.getScheme().toLowerCase().hashCode();
        }
        if (this.getHost() != null) {
            hashcode ^= this.getHost().toLowerCase().hashCode();
        }
        if (this.getPort() != null) {
            hashcode ^= this.getPort().toLowerCase().hashCode();
        }
        if (this.getNamespace() != null) {
            hashcode ^= this.getNamespace().hashCode();
        }
        if (this.getObjectName() != null) {
            hashcode ^= this.getObjectName().toLowerCase().hashCode();
        }
        if (null != this.mKeys) {
            Object[] tmpKeys = (CIMProperty[])this.mKeys.clone();
            Arrays.sort(tmpKeys);
            for (int i = 0; i < tmpKeys.length; ++i) {
                hashcode ^= ((CIMElement)tmpKeys[i]).getName().toLowerCase().hashCode();
                if (((CIMValuedElement)tmpKeys[i]).getValue() == null) continue;
                Object value = ((CIMValuedElement)tmpKeys[i]).getValue();
                hashcode ^= value.hashCode() * (i + 1);
            }
        }
        return hashcode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseOp(String op) {
        op = this.unquote(op);
        String scheme = "";
        String host = "";
        String port = "";
        String namespace = "";
        String classname = "";
        String values = "";
        int hostIndexBegin = op.indexOf("//");
        int hostIndexEnd = op.indexOf("/", hostIndexBegin == -1 ? 0 : hostIndexBegin + 2);
        if (hostIndexBegin != -1) {
            if (hostIndexBegin > 0) {
                scheme = op.substring(0, hostIndexBegin - 1);
            }
            if (hostIndexEnd == -1) {
                host = op.substring(hostIndexBegin + 2);
                this.mScheme = scheme;
                this.mHost = host;
                return;
            }
            host = op.substring(hostIndexBegin + 2, hostIndexEnd);
            int ipv6Begin = host.indexOf("[");
            int ipv6End = host.indexOf("]", ipv6Begin + 2);
            if (ipv6Begin != -1) {
                int portBegin = host.indexOf(":", ipv6End);
                if (portBegin != -1) {
                    port = host.substring(portBegin + 1);
                }
                if (ipv6End == -1) throw new IllegalArgumentException("host portion of the object path is malformed - no closing bracket for IPV6 Address.");
                host = host.substring(ipv6Begin, ipv6End + 1);
            } else if (host.indexOf(58) != -1) {
                port = host.substring(host.indexOf(58) + 1);
                host = host.substring(0, host.indexOf(58));
            }
            if ((op = op.substring(hostIndexEnd)).indexOf(58) == -1) {
                this.mNamespace = op.substring(1);
                this.mScheme = scheme;
                this.mHost = host;
                this.mPort = port;
                return;
            }
        }
        int cnIndex = op.indexOf(46);
        int nsIndex = -1;
        if (cnIndex != -1 && op.charAt(cnIndex - 1) == '/') {
            cnIndex = op.indexOf(46, cnIndex + 1);
        }
        if ((nsIndex = cnIndex == -1 ? op.lastIndexOf(58, op.length()) : op.lastIndexOf(58, cnIndex)) != -1) {
            namespace = op.substring(0, nsIndex);
            if (namespace.equals(":")) {
                namespace = "";
            }
            if (namespace.startsWith("//")) {
                int idx = namespace.indexOf(47, 2);
                if (idx == -1) {
                    host = namespace.substring(2);
                    namespace = "";
                } else {
                    host = namespace.substring(2, idx);
                    namespace = namespace.substring(idx + 1);
                }
            }
            ++nsIndex;
        } else {
            nsIndex = 0;
        }
        if (cnIndex != -1) {
            classname = op.substring(nsIndex, cnIndex);
            values = op.substring(cnIndex + 1, op.length());
        } else {
            classname = op.substring(nsIndex, op.length());
        }
        ArrayList<CIMProperty<String>> keyList = new ArrayList<CIMProperty<String>>();
        if (values.length() != 0) {
            String[] propertyList;
            for (String element : propertyList = this.parsePropertyList(values)) {
                int eqIndex = element.indexOf(61);
                if (eqIndex == -1) continue;
                String value = element.substring(eqIndex + 1);
                value = this.unquote(value);
                keyList.add(new CIMProperty<String>(element.substring(0, eqIndex), CIMDataType.STRING_T, value, true));
            }
        }
        this.mScheme = scheme;
        this.mHost = host;
        this.mPort = port;
        this.mNamespace = namespace;
        this.mElementName = classname;
        if (keyList.size() <= 0) return;
        this.mKeys = keyList.toArray(new CIMProperty[keyList.size()]);
    }

    private String[] parsePropertyList(String properties) {
        ArrayList<String> propertyList = new ArrayList<String>();
        boolean inQuotes = false;
        int lastComma = 0;
        int length = properties.length();
        for (int i = 0; i < length; ++i) {
            char c = properties.charAt(i);
            if (c == '\"') {
                inQuotes = !inQuotes;
                continue;
            }
            if (inQuotes || c != ',') continue;
            propertyList.add(properties.substring(lastComma, i));
            lastComma = i + 1;
        }
        if (inQuotes) {
            Object[] args = new Object[]{properties};
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CIMObjectPath.2"), args));
        }
        if (lastComma >= length) {
            Object[] args = new Object[]{properties};
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CIMObjectPath.3"), args));
        }
        propertyList.add(properties.substring(lastComma));
        return propertyList.toArray(new String[0]);
    }

    private String quote(String inp) {
        StringBuilder sb = new StringBuilder(inp.length());
        sb.append('\"');
        sb.append(this.escape(inp));
        sb.append('\"');
        return sb.toString();
    }

    public String toString() {
        boolean haveNameSpace;
        StringBuilder buffer = new StringBuilder();
        boolean haveHost = this.mHost != null && this.mHost.length() > 0;
        boolean bl = haveNameSpace = this.mNamespace != null && this.mNamespace.length() > 0;
        if (this.mScheme != null && this.mScheme.length() > 0) {
            buffer.append(this.mScheme);
            buffer.append(":");
        }
        if (haveHost) {
            buffer.append("//");
            buffer.append(this.mHost);
            if (this.mPort != null && this.mPort.length() > 0) {
                buffer.append(":");
                buffer.append(this.mPort);
            }
        }
        if (haveNameSpace) {
            if (this.mNamespace.charAt(0) != '/') {
                buffer.append('/');
            }
            buffer.append(this.mNamespace);
        }
        if (this.mElementName != null && this.mElementName.length() != 0) {
            if (haveHost || haveNameSpace) {
                buffer.append(':');
            }
            buffer.append(this.mElementName);
            if (this.mKeys != null) {
                if (this.mKeys.length > 0) {
                    buffer.append('.');
                }
                for (int i = 0; i < this.mKeys.length; ++i) {
                    if (this.mKeys[i] == null) continue;
                    buffer.append(this.mKeys[i].getName());
                    buffer.append('=');
                    if (this.mKeys[i].getValue() != null) {
                        if (this.mKeys[i].getValue() instanceof String) {
                            buffer.append(this.quote(this.mKeys[i].getValue().toString()));
                        } else if (this.mKeys[i].getValue() instanceof CIMObjectPath) {
                            buffer.append(this.quote(this.mKeys[i].getValue().toString()));
                        } else if (this.mKeys[i].getValue() instanceof CIMDateTime) {
                            buffer.append('\"');
                            buffer.append(this.mKeys[i].getValue().toString());
                            buffer.append('\"');
                        } else {
                            buffer.append(String.valueOf(this.mKeys[i].getValue()));
                        }
                    } else {
                        buffer.append("null");
                    }
                    if (i >= this.mKeys.length - 1) continue;
                    buffer.append(',');
                }
            }
        }
        return buffer.toString();
    }

    private String unescapeString(String inp) {
        StringBuilder sb = new StringBuilder();
        int size = inp.length();
        for (int i = 0; i < size; ++i) {
            char ch = inp.charAt(i);
            if (ch == '\\') {
                if (++i >= size) {
                    throw new IllegalArgumentException(Messages.getString("CIMObjectPath.0"));
                }
                ch = inp.charAt(i);
                switch (ch) {
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        sb.append(ch);
                        break;
                    }
                    case 'X': 
                    case 'x': {
                        sb.append("\\x");
                        break;
                    }
                    default: {
                        Object[] args = new Object[]{new Character(ch)};
                        throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CIMObjectPath.1"), args));
                    }
                }
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private String unquote(String value) {
        if (value.startsWith("\"")) {
            if (value.endsWith("\"")) {
                value = this.unescapeString(value.substring(1, value.length() - 1));
            } else {
                Object[] args = new Object[]{value};
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CIMObjectPath.2"), args));
            }
        }
        return value;
    }

    private String validateNameSpace(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        s = s.replace('\\', '/');
        int len = s.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            sb.append(c);
            if (c != '/') continue;
            int nextChar = i + 1;
            while (nextChar < len && s.charAt(nextChar) == '/') {
                i = nextChar++;
            }
        }
        int lastChar = sb.length() - 1;
        if (lastChar > 0 && sb.charAt(lastChar) == '/') {
            sb.deleteCharAt(lastChar);
        }
        if (sb.charAt(0) == '/') {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }
}

