/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.json;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import javax.cim.CIMArgument;
import javax.cim.CIMClass;
import javax.cim.CIMClassProperty;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTime;
import javax.cim.CIMInstance;
import javax.cim.CIMMethod;
import javax.cim.CIMObjectPath;
import javax.cim.CIMParameter;
import javax.cim.CIMProperty;
import javax.cim.CIMQualifier;
import javax.cim.CIMQualifierType;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.cim.UnsignedInteger8;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.client.EnumerateResponse;

public class CIMRSElementsWriter {
    private static final String URISEPARATOR = "/";
    private final boolean mIsPrettyPrint;
    private final JsonGeneratorFactory mFactory;

    public CIMRSElementsWriter() {
        this(false);
    }

    public CIMRSElementsWriter(boolean prettyPrint) {
        this.mIsPrettyPrint = prettyPrint;
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>(1);
        if (this.mIsPrettyPrint) {
            properties.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        }
        this.mFactory = Json.createGeneratorFactory(properties);
    }

    private String generateSelf(CIMObjectPath path) {
        String retVal = null;
        String namespace = path.getNamespace();
        try {
            namespace = URLEncoder.encode(path.getNamespace(), "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        retVal = namespace + "/classes/" + path.getObjectName() + "/instances/";
        boolean first = true;
        for (CIMProperty p : path.getKeys()) {
            if (null != p.getValue()) {
                if (!first) {
                    retVal = retVal + ",";
                }
                retVal = retVal + p.getName();
                retVal = retVal + "=";
                try {
                    retVal = retVal + URLEncoder.encode(p.getValue().toString(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    retVal = retVal + "null";
                }
            }
            first = false;
        }
        return retVal;
    }

    private String getEncodedNamespace(CIMObjectPath path) {
        if (null == path || null == path.getNamespace()) {
            throw new IllegalArgumentException("path or path.getNamespace() can not be null");
        }
        return this.getEncodedNamespace(path.getNamespace());
    }

    private String getEncodedNamespace(String namespace) {
        String encodedNS = null;
        try {
            encodedNS = URLEncoder.encode(namespace, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return encodedNS;
    }

    private JsonGeneratorFactory getFactory() {
        return this.mFactory;
    }

    private void streamCIMClass(JsonGenerator jsonGenerator, CIMClass clazz, boolean includeSelf) {
        String namespace;
        jsonGenerator.writeStartObject();
        jsonGenerator.write("kind", "class");
        if (null != clazz.getObjectPath()) {
            namespace = clazz.getObjectPath().getNamespace();
            if (includeSelf) {
                jsonGenerator.write("self", this.getEncodedNamespace(namespace) + URISEPARATOR + "classes" + URISEPARATOR + clazz.getName());
            }
        } else {
            throw new IllegalArgumentException("objectpath can not be null");
        }
        jsonGenerator.write("namespace", namespace);
        jsonGenerator.write("name", clazz.getName());
        if (null != clazz.getSuperClassName()) {
            jsonGenerator.write("superclassname", clazz.getSuperClassName());
        }
        if (clazz.getQualifierCount() > 0) {
            jsonGenerator.writeStartObject("qualifiers");
            for (CIMQualifier cIMQualifier : clazz.getQualifiers()) {
                this.streamCIMQualifier(jsonGenerator, cIMQualifier);
            }
            jsonGenerator.writeEnd();
        }
        if (clazz.getPropertyCount() > 0) {
            jsonGenerator.writeStartObject("properties");
            for (CIMQualifier cIMQualifier : clazz.getProperties()) {
                this.streamCIMClassProperty(jsonGenerator, (CIMClassProperty<?>)cIMQualifier);
            }
            jsonGenerator.writeEnd();
        }
        if (clazz.getMethodCount() > 0) {
            jsonGenerator.writeStartObject("methods");
            for (CIMQualifier cIMQualifier : clazz.getMethods()) {
                this.streamMethod(jsonGenerator, (CIMMethod<?>)cIMQualifier);
            }
            jsonGenerator.writeEnd();
        }
        jsonGenerator.writeEnd();
    }

    private void streamCIMClassProperty(JsonGenerator jsonGenerator, CIMClassProperty<?> property) {
        jsonGenerator.writeStartObject(property.getName());
        this.streamDataType(jsonGenerator, property.getDataType());
        if (null != property.getValue()) {
            this.streamCIMValue(jsonGenerator, property.getDataType(), property.getValue(), "default");
        }
        if (property.getQualifierCount() > 0) {
            jsonGenerator.writeStartObject("qualifiers");
            for (CIMQualifier t : property.getQualifiers()) {
                this.streamCIMQualifier(jsonGenerator, t);
            }
            jsonGenerator.writeEnd();
        }
        jsonGenerator.writeEnd();
    }

    private void streamCIMFlavor(JsonGenerator jsonGenerator, int flavors) {
        if ((flavors & 2) == 2) {
            jsonGenerator.write("propagation", "false");
        } else {
            jsonGenerator.write("propagation", "true");
            if ((flavors & 1) == 1) {
                jsonGenerator.write("overrride", "false");
            } else {
                jsonGenerator.write("overrride", "true");
            }
        }
        if ((flavors & 4) == 4) {
            jsonGenerator.write("translatable", "true");
        }
    }

    private void streamCIMInstance(JsonGenerator jsonGenerator, CIMInstance instance, boolean isEmbeddedInstance, String tag) {
        if (null == tag) {
            jsonGenerator.writeStartObject();
        } else {
            jsonGenerator.writeStartObject(tag);
        }
        jsonGenerator.write("kind", "instance");
        if (null != instance.getObjectPath() && !isEmbeddedInstance) {
            jsonGenerator.write("self", this.generateSelf(instance.getObjectPath()));
            jsonGenerator.write("namespace", instance.getObjectPath().getNamespace());
        } else if (!isEmbeddedInstance) {
            throw new IllegalArgumentException("objectpath can not be null");
        }
        jsonGenerator.write("classname", instance.getClassName());
        if (instance.getPropertyCount() > 0) {
            jsonGenerator.writeStartObject("properties");
            for (CIMProperty p : instance.getProperties()) {
                this.streamCIMProperty(jsonGenerator, p);
            }
            jsonGenerator.writeEnd();
        }
        jsonGenerator.writeEnd();
    }

    private void streamCIMArgument(JsonGenerator jsonGenerator, CIMArgument<?> arg) {
        jsonGenerator.writeStartObject(arg.getName());
        this.streamDataType(jsonGenerator, arg.getDataType());
        if (null != arg.getValue()) {
            this.streamCIMValue(jsonGenerator, arg.getDataType(), arg.getValue(), "value");
        }
        jsonGenerator.writeEnd();
    }

    private void streamCIMProperty(JsonGenerator jsonGenerator, CIMProperty<?> property) {
        jsonGenerator.writeStartObject(property.getName());
        this.streamDataType(jsonGenerator, property.getDataType());
        if (null != property.getValue()) {
            this.streamCIMValue(jsonGenerator, property.getDataType(), property.getValue(), "value");
        }
        jsonGenerator.writeEnd();
    }

    private void streamCIMPropertyNoType(JsonGenerator jsonGenerator, CIMProperty<?> property) {
        this.streamCIMValue(jsonGenerator, property.getDataType(), property.getValue(), property.getName());
    }

    private void streamCIMQualifier(JsonGenerator jsonGenerator, CIMQualifier<?> qualifier) {
        jsonGenerator.writeStartObject(qualifier.getName());
        this.streamDataType(jsonGenerator, qualifier.getDataType());
        this.streamCIMValue(jsonGenerator, qualifier.getDataType(), qualifier.getValue(), "value");
        jsonGenerator.writeEnd();
    }

    private void streamCIMQualifierType(JsonGenerator jsonGenerator, CIMQualifierType<?> qualifierType, boolean named) {
        if (named) {
            jsonGenerator.writeStartObject(qualifierType.getName());
        } else {
            jsonGenerator.writeStartObject();
        }
        jsonGenerator.write("kind", "qualifiertype");
        if (null == qualifierType.getObjectPath()) {
            throw new IllegalArgumentException("objectpath can not be null");
        }
        String namespace = qualifierType.getObjectPath().getNamespace();
        jsonGenerator.write("self", this.getEncodedNamespace(namespace) + URISEPARATOR + "qualifiertypes" + URISEPARATOR + qualifierType.getName());
        jsonGenerator.write("namespace", namespace);
        jsonGenerator.write("name", qualifierType.getName());
        this.streamDataType(jsonGenerator, qualifierType.getDataType());
        if (null != qualifierType.getValue()) {
            this.streamCIMValue(jsonGenerator, qualifierType.getDataType(), qualifierType.getValue(), "defaultvalue");
        }
        this.streamCIMScope(jsonGenerator, qualifierType.getScope());
        this.streamCIMFlavor(jsonGenerator, qualifierType.getFlavor());
        jsonGenerator.writeEnd();
    }

    private void streamCIMScope(JsonGenerator jsonGenerator, int scope) {
        jsonGenerator.writeStartArray("scopes");
        if ((scope & 1) == 1) {
            jsonGenerator.write("class");
        }
        if ((scope & 2) == 2) {
            jsonGenerator.write("association");
        }
        if ((scope & 0x10) == 16) {
            jsonGenerator.write("reference");
        }
        if ((scope & 8) == 8) {
            jsonGenerator.write("property");
        }
        if ((scope & 0x20) == 32) {
            jsonGenerator.write("method");
        }
        if ((scope & 0x40) == 64) {
            jsonGenerator.write("parameter");
        }
        if ((scope & 4) == 4) {
            jsonGenerator.write("indication");
        }
        jsonGenerator.writeEnd();
    }

    private void streamCIMSimpleValue(JsonGenerator jsonGenerator, CIMDataType dataType, Object value, String tag) {
        if (null == value) {
            if (null == tag) {
                jsonGenerator.write("null");
            } else {
                jsonGenerator.write(tag, "null");
            }
        } else if (17 == dataType.getType()) {
            this.streamCIMClass(jsonGenerator, (CIMClass)value, true);
        } else if (15 == dataType.getType()) {
            this.streamCIMInstance(jsonGenerator, (CIMInstance)value, true, tag);
        } else if (14 == dataType.getType()) {
            jsonGenerator.write(value.toString());
        } else {
            switch (dataType.getType()) {
                case 9: {
                    if (null == tag) {
                        jsonGenerator.write(new Boolean(value.toString()).booleanValue());
                        break;
                    }
                    jsonGenerator.write(tag, new Boolean(value.toString()).booleanValue());
                    break;
                }
                case 13: {
                    if (null == tag) {
                        jsonGenerator.write((int)new Character(value.toString().charAt(0)).charValue());
                        break;
                    }
                    jsonGenerator.write(tag, (int)new Character(value.toString().charAt(0)).charValue());
                    break;
                }
                case 8: 
                case 12: {
                    if (null == tag) {
                        jsonGenerator.write(value.toString());
                        break;
                    }
                    jsonGenerator.write(tag, value.toString());
                    break;
                }
                case 10: {
                    if (null == tag) {
                        jsonGenerator.write((double)new Float(value.toString()).floatValue());
                        break;
                    }
                    jsonGenerator.write(tag, (double)new Float(value.toString()).floatValue());
                    break;
                }
                case 11: {
                    if (null == tag) {
                        jsonGenerator.write(new Double(value.toString()).doubleValue());
                        break;
                    }
                    jsonGenerator.write(tag, new Double(value.toString()).doubleValue());
                    break;
                }
                case 1: {
                    if (null == tag) {
                        jsonGenerator.write((int)new Byte(value.toString()).byteValue());
                        break;
                    }
                    jsonGenerator.write(tag, (int)new Byte(value.toString()).byteValue());
                    break;
                }
                case 3: {
                    if (null == tag) {
                        jsonGenerator.write((int)new Short(value.toString()).shortValue());
                        break;
                    }
                    jsonGenerator.write(tag, (int)new Short(value.toString()).shortValue());
                    break;
                }
                case 5: {
                    if (null == tag) {
                        jsonGenerator.write(new Integer(value.toString()).intValue());
                        break;
                    }
                    jsonGenerator.write(tag, new Integer(value.toString()).intValue());
                    break;
                }
                case 7: {
                    if (null == tag) {
                        jsonGenerator.write(new Long(value.toString()).longValue());
                        break;
                    }
                    jsonGenerator.write(tag, new Long(value.toString()).longValue());
                    break;
                }
                case 0: {
                    if (null == tag) {
                        jsonGenerator.write((int)((UnsignedInteger8)value).shortValue());
                        break;
                    }
                    jsonGenerator.write(tag, (int)((UnsignedInteger8)value).shortValue());
                    break;
                }
                case 2: {
                    if (null == tag) {
                        jsonGenerator.write(((UnsignedInteger16)value).intValue());
                        break;
                    }
                    jsonGenerator.write(tag, ((UnsignedInteger16)value).intValue());
                    break;
                }
                case 4: {
                    if (null == tag) {
                        jsonGenerator.write(((UnsignedInteger32)value).longValue());
                        break;
                    }
                    jsonGenerator.write(tag, ((UnsignedInteger32)value).longValue());
                    break;
                }
                case 6: {
                    if (null == tag) {
                        jsonGenerator.write(((UnsignedInteger64)value).bigIntegerValue());
                        break;
                    }
                    jsonGenerator.write(tag, ((UnsignedInteger64)value).bigIntegerValue());
                    break;
                }
            }
        }
    }

    private void streamCIMValue(JsonGenerator jsonGenerator, CIMDataType dataType, Object value, String tag) {
        if (dataType.isArray()) {
            jsonGenerator.writeStartArray(tag);
            for (Object o : (Object[])value) {
                this.streamCIMSimpleValue(jsonGenerator, dataType, o, null);
            }
            jsonGenerator.writeEnd();
        } else {
            this.streamCIMSimpleValue(jsonGenerator, dataType, value, tag);
        }
    }

    private void streamDataType(JsonGenerator jsonGenerator, CIMDataType type) {
        if (null == type) {
            throw new IllegalArgumentException("type can not be null!");
        }
        if (type.isArray()) {
            jsonGenerator.write("array", true);
        }
        if (type.getType() == 14) {
            jsonGenerator.write("type", "reference");
            jsonGenerator.write("classname", type.getRefClassName());
        } else if (15 == type.getType()) {
            jsonGenerator.write("type", "instance");
        } else if (17 == type.getType()) {
            jsonGenerator.write("type", "class");
        } else {
            jsonGenerator.write("type", type.toString());
        }
    }

    private void streamException(JsonGenerator jsonGenerator, CIMObjectPath target, WBEMException exception, String httpMethod) {
        jsonGenerator.writeStartObject();
        jsonGenerator.write("kind", "errorresponse");
        if (null == target) {
            throw new IllegalArgumentException("objectpath can not be null");
        }
        jsonGenerator.write("self", this.generateSelf(target));
        jsonGenerator.write("httpmethod", httpMethod);
        jsonGenerator.write("statuscode", exception.getID());
        jsonGenerator.write("statusdescription", exception.getMessage());
        jsonGenerator.writeStartArray("errors");
        for (CIMInstance i : exception.getCIMErrors()) {
            this.streamCIMInstance(jsonGenerator, i, true, null);
        }
        jsonGenerator.writeEnd();
        jsonGenerator.writeEnd();
    }

    private void streamMethod(JsonGenerator jsonGenerator, CIMMethod<?> method) {
        CIMParameter[] params;
        jsonGenerator.writeStartObject(method.getName());
        this.streamDataType(jsonGenerator, method.getDataType());
        if (method.getQualifierCount() > 0) {
            jsonGenerator.writeStartObject("qualifiers");
            for (CIMQualifier t : method.getQualifiers()) {
                this.streamCIMQualifier(jsonGenerator, t);
            }
            jsonGenerator.writeEnd();
        }
        if (null != (params = method.getParameters()) && params.length > 0) {
            jsonGenerator.writeStartObject("parameters");
            for (CIMParameter p : method.getParameters()) {
                this.streamParameter(jsonGenerator, p);
            }
            jsonGenerator.writeEnd();
        }
        jsonGenerator.writeEnd();
    }

    public void streamNoTypedInstance(JsonGenerator jsonGenerator, CIMInstance instance) {
        jsonGenerator.writeStartObject();
        jsonGenerator.write("kind", "instance");
        if (null == instance.getObjectPath()) {
            throw new IllegalArgumentException("objectpath can not be null");
        }
        jsonGenerator.write("self", this.generateSelf(instance.getObjectPath()));
        jsonGenerator.write("namespace", instance.getObjectPath().getNamespace());
        jsonGenerator.write("classname", instance.getClassName());
        if (instance.getPropertyCount() > 0) {
            jsonGenerator.writeStartObject("properties");
            for (CIMProperty p : instance.getProperties()) {
                this.streamCIMPropertyNoType(jsonGenerator, p);
            }
            jsonGenerator.writeEnd();
        }
        jsonGenerator.writeEnd();
    }

    private void streamParameter(JsonGenerator jsonGenerator, CIMParameter<?> parameter) {
        jsonGenerator.writeStartObject(parameter.getName());
        this.streamDataType(jsonGenerator, parameter.getDataType());
        if (parameter.getQualifierCount() > 0) {
            jsonGenerator.writeStartObject("qualifiers");
            for (CIMQualifier t : parameter.getQualifiers()) {
                this.streamCIMQualifier(jsonGenerator, t);
            }
            jsonGenerator.writeEnd();
        }
        jsonGenerator.writeEnd();
    }

    public void writeCIMClass(OutputStream stream, CIMClass clazz, boolean includeSelf) throws IOException {
        JsonGeneratorFactory jf = this.getFactory();
        JsonGenerator jsonGenerator = jf.createGenerator(stream);
        this.streamCIMClass(jsonGenerator, clazz, true);
        jsonGenerator.flush();
    }

    public void writeCIMError(OutputStream stream, CIMObjectPath target, WBEMException exception, String httpMethod) {
        JsonGeneratorFactory jf = this.getFactory();
        JsonGenerator jsonGenerator = jf.createGenerator(stream);
        this.streamException(jsonGenerator, target, exception, httpMethod);
        jsonGenerator.flush();
    }

    public void writeCIMInstance(OutputStream stream, CIMInstance instance, boolean typed) throws IOException {
        JsonGeneratorFactory jf = this.getFactory();
        JsonGenerator jsonGenerator = jf.createGenerator(stream);
        if (typed) {
            this.streamCIMInstance(jsonGenerator, instance, false, null);
        } else {
            this.streamNoTypedInstance(jsonGenerator, instance);
        }
        jsonGenerator.flush();
    }

    public void writeCIMClassCollection(OutputStream stream, CIMObjectPath target, String self, CloseableIterator<CIMClass> iterator) throws WBEMException {
        JsonGeneratorFactory jf = this.getFactory();
        JsonGenerator jsonGenerator = jf.createGenerator(stream);
        jsonGenerator.writeStartObject();
        jsonGenerator.write("kind", "classcollection");
        jsonGenerator.write("self", self);
        jsonGenerator.writeStartArray("classes");
        while (iterator.hasNext()) {
            this.streamCIMClass(jsonGenerator, (CIMClass)iterator.next(), false);
        }
        jsonGenerator.writeEnd();
        jsonGenerator.writeEnd();
        jsonGenerator.flush();
    }

    public void writeCIMInstanceCollection(OutputStream stream, CIMObjectPath target, String self, EnumerateResponse<CIMInstance> enumerationResponse, boolean typed) throws WBEMException {
        JsonGeneratorFactory jf = this.getFactory();
        JsonGenerator jsonGenerator = jf.createGenerator(stream);
        jsonGenerator.writeStartObject();
        jsonGenerator.write("kind", "instancecollection");
        jsonGenerator.write("self", self);
        CloseableIterator ci = enumerationResponse.getResponses();
        jsonGenerator.writeStartArray("instances");
        while (ci.hasNext()) {
            if (typed) {
                this.streamCIMInstance(jsonGenerator, (CIMInstance)ci.next(), false, null);
                continue;
            }
            this.streamNoTypedInstance(jsonGenerator, (CIMInstance)ci.next());
        }
        jsonGenerator.writeEnd();
        if (!enumerationResponse.isEnd()) {
            String nextURI = target.getNamespace() + "/page/" + enumerationResponse.getContext();
            jsonGenerator.write("next", nextURI);
        }
        jsonGenerator.writeEnd();
        jsonGenerator.flush();
    }

    public void writeCIMQualifierType(OutputStream stream, CIMQualifierType<?> type) {
        JsonGeneratorFactory jf = this.getFactory();
        JsonGenerator jsonGenerator = jf.createGenerator(stream);
        this.streamCIMQualifierType(jsonGenerator, type, false);
        jsonGenerator.flush();
    }

    public void writeCIMQualifierTypeCollection(OutputStream stream, CIMObjectPath target, CloseableIterator<CIMQualifierType<?>> types) {
        JsonGeneratorFactory jf = this.getFactory();
        JsonGenerator jsonGenerator = jf.createGenerator(stream);
        jsonGenerator.writeStartObject();
        jsonGenerator.write("kind", "qualifiertypecollection");
        String uri = this.getEncodedNamespace(target) + URISEPARATOR + "qualifiertypes";
        jsonGenerator.write("self", uri);
        jsonGenerator.writeStartArray("qualifiertypes");
        while (types.hasNext()) {
            CIMQualifierType qt = (CIMQualifierType)types.next();
            this.streamCIMQualifierType(jsonGenerator, qt, false);
        }
        jsonGenerator.writeEnd();
        jsonGenerator.writeEnd();
        jsonGenerator.flush();
    }

    public void writeMethodRequest(OutputStream stream, CIMObjectPath target, String methodName, CIMArgument<?>[] args) {
        JsonGeneratorFactory jf = this.getFactory();
        JsonGenerator jsonGenerator = jf.createGenerator(stream);
        jsonGenerator.writeStartObject();
        jsonGenerator.write("kind", "methodrequest");
        jsonGenerator.write("self", this.generateSelf(target));
        jsonGenerator.write("methodname", methodName);
        jsonGenerator.writeStartObject("parameters");
        if (null != args) {
            for (CIMArgument<?> arg : args) {
                this.streamCIMArgument(jsonGenerator, arg);
            }
        }
        jsonGenerator.writeEnd();
        jsonGenerator.writeEnd();
        jsonGenerator.flush();
    }

    public void writeMethodResponse(OutputStream stream, String self, String methodName, CIMArgument<?>[] args, Object value) {
        JsonGeneratorFactory jf = this.getFactory();
        JsonGenerator jsonGenerator = jf.createGenerator(stream);
        jsonGenerator.writeStartObject();
        jsonGenerator.write("kind", "methodresponse");
        jsonGenerator.write("self", self);
        jsonGenerator.write("methodname", methodName);
        jsonGenerator.writeStartObject("returnvalue");
        CIMDataType type = this.getTypeFromValue(value);
        this.streamDataType(jsonGenerator, type);
        this.streamCIMValue(jsonGenerator, type, value, "value");
        jsonGenerator.writeEnd();
        for (CIMArgument<?> arg : args) {
            if (null == arg) continue;
            this.streamCIMArgument(jsonGenerator, arg);
        }
        jsonGenerator.writeEnd();
        jsonGenerator.flush();
    }

    private CIMDataType getTypeFromValue(Object value) {
        if (value instanceof UnsignedInteger64) {
            return CIMDataType.UINT64_T;
        }
        if (value instanceof UnsignedInteger32) {
            return CIMDataType.UINT32_T;
        }
        if (value instanceof UnsignedInteger16) {
            return CIMDataType.UINT16_T;
        }
        if (value instanceof UnsignedInteger8) {
            return CIMDataType.UINT8_T;
        }
        if (value instanceof Long) {
            return CIMDataType.UINT64_T;
        }
        if (value instanceof Integer) {
            return CIMDataType.UINT32_T;
        }
        if (value instanceof Short) {
            return CIMDataType.UINT16_T;
        }
        if (value instanceof Byte) {
            return CIMDataType.UINT8_T;
        }
        if (value instanceof Float) {
            return CIMDataType.REAL32_T;
        }
        if (value instanceof Double) {
            return CIMDataType.REAL64_T;
        }
        if (value instanceof String) {
            return CIMDataType.STRING_T;
        }
        if (value instanceof Boolean) {
            return CIMDataType.BOOLEAN_T;
        }
        if (value instanceof CIMDateTime) {
            return CIMDataType.DATETIME_T;
        }
        if (value instanceof Character) {
            return CIMDataType.CHAR16_T;
        }
        if (value instanceof CIMObjectPath) {
            CIMObjectPath p = (CIMObjectPath)value;
            return new CIMDataType(p.getObjectName(), 0);
        }
        return CIMDataType.UINT32_T;
    }
}

