/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.json;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger32;
import javax.wbem.WBEMOperation;

public class CIMRSURI {
    public static final String STANDARD_HTTPPORT = "5993";
    public static final String STANDARD_HTTPSPORT = "5994";
    private static final String AND = "&";
    private static final String EQUAL = "=";
    private static final String INSTANCES2 = "/instances";
    private static final String QUALIFIERTYPES = "/qualifiertypes";
    private static final String INSTANCES = "/instances/";
    private static final String ASSOCIATORS = "/associators";
    private static final String REFERENCES = "/references";
    private static final String CLASSES = "/classes/";
    private final CIMObjectPath mContextParameter;
    private String mURI;

    public CIMRSURI(WBEMOperation operation, CIMObjectPath path) {
        this(operation, path, null);
    }

    public CIMRSURI(WBEMOperation operation, CIMObjectPath path, String context) {
        this.mContextParameter = path;
        StringBuilder retVal = new StringBuilder("");
        String namespace = path.getNamespace();
        try {
            namespace = URLEncoder.encode(path.getNamespace(), "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        retVal.append(namespace);
        switch (operation) {
            case GETINSTANCE: 
            case DELETEINSTANCE: 
            case MODIFYINSTANCE: {
                retVal.append(CLASSES);
                retVal.append(path.getObjectName());
                retVal.append(INSTANCES);
                retVal.append(this.getCIMRSURIKeyValueString(path));
                break;
            }
            case OPENASSOCIATORS: {
                retVal.append(CLASSES);
                retVal.append(path.getObjectName());
                retVal.append(INSTANCES);
                retVal.append(this.getCIMRSURIKeyValueString(path));
                retVal.append(ASSOCIATORS);
                break;
            }
            case OPENREFERENCES: {
                retVal.append(CLASSES);
                retVal.append(path.getObjectName());
                retVal.append(INSTANCES);
                retVal.append(this.getCIMRSURIKeyValueString(path));
                retVal.append(REFERENCES);
                break;
            }
            case CREATEINSTANCE: 
            case OPENENUMERATEINSTANCES: {
                retVal.append(CLASSES);
                retVal.append(path.getObjectName());
                retVal.append(INSTANCES2);
                break;
            }
            case PULLINSTANCESWITHPATH: 
            case CLOSEENUMERATION: {
                retVal = new StringBuilder('/' == context.charAt(0) ? context.substring(1) : context);
                break;
            }
            case INVOKEMETHOD: {
                retVal.append(CLASSES);
                retVal.append(path.getObjectName());
                if (null == path.getKeys()) break;
                retVal.append(INSTANCES);
                retVal.append(this.getCIMRSURIKeyValueString(path));
                break;
            }
            case GETCLASS: 
            case DELETECLASS: 
            case MODIFYCLASS: {
                retVal.append(CLASSES);
                retVal.append(path.getObjectName());
                break;
            }
            case CREATECLASS: 
            case ENUMERATECLASSES: {
                retVal.append(CLASSES);
                break;
            }
            case ASSOCIATORCLASSES: {
                retVal.append(CLASSES);
                retVal.append(path.getObjectName());
                retVal.append(ASSOCIATORS);
                break;
            }
            case REFERENCECLASSES: {
                retVal.append(CLASSES);
                retVal.append(path.getObjectName());
                retVal.append(REFERENCES);
                break;
            }
            case GETQUALIFIERTYPE: 
            case DELETEQUALIFIERTYPE: 
            case MODIFYQUALIFIERTYPE: {
                retVal.append(QUALIFIERTYPES);
                retVal.append("/");
                retVal.append(path.getObjectName());
                break;
            }
            case CREATEQUALIFIERTYPE: 
            case ENUMERATEQUALIFIERTYPES: {
                retVal.append(QUALIFIERTYPES);
                break;
            }
        }
        this.mURI = retVal.toString();
    }

    private String getCIMRSURIKeyValueString(CIMObjectPath path) {
        StringBuilder retVal = new StringBuilder("");
        boolean first = true;
        for (CIMProperty p : path.getKeys()) {
            if (null != p.getValue()) {
                if (!first) {
                    retVal.append(",");
                }
                retVal.append(p.getName());
                retVal.append(EQUAL);
                try {
                    if (null != p.getValue()) {
                        retVal.append(URLEncoder.encode(p.getValue().toString(), "UTF-8"));
                    } else {
                        retVal.append("null");
                    }
                }
                catch (UnsupportedEncodingException e) {
                    retVal.append("null");
                }
            }
            first = false;
        }
        return retVal.toString();
    }

    public void setQueryParameters(String[] propertyList, String filterQueryLanguage, String filterQuery, UnsignedInteger32 timeout, boolean continueOnError, UnsignedInteger32 maxObjectCount, String associationClass, String sourceRole, String associatedClass, String associatedRole, boolean includeQualifiers, String className) {
        StringBuilder queryString = new StringBuilder("?");
        if (null != maxObjectCount) {
            queryString.append("$max");
            queryString.append(EQUAL);
            queryString.append(maxObjectCount);
        }
        if (null != timeout) {
            if (queryString.length() > 1) {
                queryString.append(AND);
            }
            queryString.append("$pagingtimeout");
            queryString.append(EQUAL);
            queryString.append(timeout);
        }
        if (null != propertyList) {
            StringBuilder props = new StringBuilder("");
            for (String s : propertyList) {
                props.append(",");
                props.append(s);
            }
            if (queryString.length() > 1) {
                queryString.append(AND);
            }
            queryString.append("$properties");
            queryString.append(EQUAL);
            queryString.append(props.substring(1));
        }
        if (null != filterQueryLanguage) {
            if (queryString.length() > 1) {
                queryString.append(AND);
            }
            queryString.append("$filterlanguage");
            queryString.append(EQUAL);
            queryString.append(filterQueryLanguage);
        }
        if (null != filterQuery) {
            if (queryString.length() > 1) {
                queryString.append(AND);
            }
            queryString.append("$filter");
            queryString.append(EQUAL);
            queryString.append(filterQuery);
        }
        if (continueOnError) {
            if (queryString.length() > 1) {
                queryString.append(AND);
            }
            queryString.append("$continueonerror");
            queryString.append(EQUAL);
            queryString.append("true");
        }
        if (null != associationClass) {
            if (queryString.length() > 1) {
                queryString.append(AND);
            }
            queryString.append("$associationclass");
            queryString.append(EQUAL);
            queryString.append(associationClass);
        }
        if (null != sourceRole) {
            if (queryString.length() > 1) {
                queryString.append(AND);
            }
            queryString.append("$sourcerole");
            queryString.append(EQUAL);
            queryString.append(sourceRole);
        }
        if (null != associatedClass) {
            if (queryString.length() > 1) {
                queryString.append(AND);
            }
            queryString.append("$associatedclass");
            queryString.append(EQUAL);
            queryString.append(associatedClass);
        }
        if (null != associatedRole) {
            if (queryString.length() > 1) {
                queryString.append(AND);
            }
            queryString.append("$associatedrole");
            queryString.append(EQUAL);
            queryString.append(associatedRole);
        }
        if (includeQualifiers) {
            if (queryString.length() > 1) {
                queryString.append(AND);
            }
            queryString.append("$qualifiers");
            queryString.append(EQUAL);
            queryString.append("true");
        }
        if (null != className) {
            if (queryString.length() > 1) {
                queryString.append(AND);
            }
            queryString.append("$class");
            queryString.append(EQUAL);
            queryString.append(className);
        }
        this.mURI = this.mURI + (queryString.length() > 1 ? queryString.toString() : "");
    }

    public String getURIString() {
        return this.mURI;
    }

    public URL getURL() throws MalformedURLException {
        return new URL(this.mContextParameter.getScheme() + "://" + this.mContextParameter.getHost() + ":" + this.getPort() + "/" + this.getURIString());
    }

    private String getPort() {
        String port = this.mContextParameter.getPort();
        if (null == port) {
            port = STANDARD_HTTPSPORT;
            if ("http".equalsIgnoreCase(this.mContextParameter.getScheme())) {
                port = STANDARD_HTTPPORT;
            }
        }
        return port;
    }
}

