/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.xmlcim;

import com.ws.cim.xmlcim.CIMXMLUtilities;
import com.ws.wbem.CloseableAddableIterator;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.cim.CIMArgument;
import javax.cim.CIMClass;
import javax.cim.CIMClassProperty;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMMethod;
import javax.cim.CIMObjectPath;
import javax.cim.CIMParameter;
import javax.cim.CIMProperty;
import javax.cim.CIMQualifier;
import javax.cim.CIMQualifierType;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class CIMXMLElementsParser {
    public static CIMClass parseClass(XMLStreamReader reader, CIMObjectPath target) throws XMLStreamException {
        boolean isKeyed = false;
        boolean isAssociation = false;
        String name = reader.getAttributeValue(null, "NAME");
        String superClassName = reader.getAttributeValue(null, "SUPERCLASS");
        ArrayList props = new ArrayList();
        ArrayList quals = new ArrayList();
        ArrayList methods = new ArrayList();
        int eventType = reader.next();
        QName startTag = null;
        while (eventType != 8) {
            switch (eventType) {
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag) break;
                    if ("QUALIFIER".equals(startTag.getLocalPart())) {
                        quals.add(CIMXMLElementsParser.parseQualifier(reader));
                        break;
                    }
                    if (startTag.getLocalPart().startsWith("PROPERTY")) {
                        CIMClassProperty<?> p = CIMXMLElementsParser.parseClassProperty(reader, target);
                        if (p.isKey()) {
                            isKeyed = true;
                        }
                        if (p.getDataType().getType() == 14) {
                            isAssociation = true;
                        }
                        props.add(p);
                        break;
                    }
                    if (!"METHOD".equals(startTag.getLocalPart())) break;
                    methods.add(CIMXMLElementsParser.parseMethod(reader));
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!qName.getLocalPart().equals("CLASS")) break;
                    return new CIMClass(new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), target.getNamespace(), name, null), superClassName, quals.toArray(new CIMQualifier[quals.size()]), props.toArray(new CIMClassProperty[props.size()]), methods.toArray(new CIMMethod[methods.size()]), isAssociation, isKeyed);
                }
                case 4: {
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        return null;
    }

    public static CIMObjectPath parseClassName(XMLStreamReader reader, CIMObjectPath target) throws XMLStreamException {
        String className = reader.getAttributeValue(null, "NAME");
        int eventType = reader.next();
        while (eventType != 8) {
            switch (eventType) {
                case 15: {
                    break;
                }
                case 10: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!qName.getLocalPart().equals("CLASSNAME")) break;
                    return new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), target.getNamespace(), className, null);
                }
                case 4: {
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        return null;
    }

    public static CIMObjectPath parseClassPath(XMLStreamReader reader, CIMObjectPath target) throws XMLStreamException {
        CIMObjectPath nsPath = null;
        CIMObjectPath classPath = null;
        int eventType = reader.next();
        while (eventType != 8) {
            switch (eventType) {
                case 15: {
                    break;
                }
                case 10: {
                    break;
                }
                case 1: {
                    QName startTag = reader.getName();
                    if (null == startTag) break;
                    if ("NAMESPACEPATH".equals(startTag.getLocalPart())) {
                        nsPath = CIMXMLElementsParser.parseNamespacePath(reader, target);
                    }
                    if (!"CLASSNAME".equals(startTag.getLocalPart()) || null == nsPath) break;
                    classPath = new CIMObjectPath(nsPath.getScheme(), nsPath.getHost(), nsPath.getPort(), nsPath.getNamespace(), reader.getAttributeValue(null, "NAME"), null);
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!qName.getLocalPart().equals("CLASSNAME")) break;
                    return classPath;
                }
                case 4: {
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        return null;
    }

    public static CIMClassProperty<?> parseClassProperty(XMLStreamReader reader, CIMObjectPath target) throws XMLStreamException {
        ArrayList quals = new ArrayList();
        boolean key = false;
        Object value = null;
        String propName = reader.getAttributeValue(null, "NAME");
        String propType = reader.getAttributeValue(null, "TYPE");
        String refClass = reader.getAttributeValue(null, "REFERENCECLASS");
        String propagated = reader.getAttributeValue(null, "PROPAGATED");
        boolean isPropagated = propagated != null ? Boolean.valueOf(propagated) : false;
        String origin = reader.getAttributeValue(null, "CLASSORIGIN");
        String eo = reader.getAttributeValue(null, "EmbeddedObject");
        boolean isEmbedded = "object".equalsIgnoreCase(eo) || "INSTANCE".equalsIgnoreCase(eo);
        CIMDataType cdt = null;
        if (null != propType) {
            cdt = CIMXMLUtilities.getDataType(propType);
        } else if (null != refClass) {
            cdt = new CIMDataType(refClass);
        }
        int eventType = reader.next();
        QName startTag = null;
        while (eventType != 8) {
            switch (eventType) {
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag) break;
                    if ("VALUE".equals(startTag.getLocalPart())) {
                        value = CIMXMLElementsParser.parseValue(reader, cdt, isEmbedded);
                    }
                    if ("VALUE.ARRAY".equals(startTag.getLocalPart())) {
                        value = CIMXMLElementsParser.parseValueArray(reader, cdt, isEmbedded);
                    }
                    if ("VALUE.REFERENCE".equals(startTag.getLocalPart())) {
                        value = CIMXMLElementsParser.parseValueReference(reader, target);
                    }
                    if (!"QUALIFIER".equals(startTag.getLocalPart())) break;
                    CIMQualifier<?> q = CIMXMLElementsParser.parseQualifier(reader);
                    if ("KEY".equalsIgnoreCase(q.getName())) {
                        key = true;
                    }
                    quals.add(q);
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (qName.getLocalPart().equals("PROPERTY")) {
                        return new CIMClassProperty(propName, cdt, value, quals.toArray(new CIMQualifier[quals.size()]), key, isPropagated);
                    }
                    if (qName.getLocalPart().equals("PROPERTY.ARRAY")) {
                        CIMDataType dt = CIMXMLUtilities.getDataType(propType, true);
                        return new CIMClassProperty(propName, dt, value, quals.toArray(new CIMQualifier[quals.size()]), key, isPropagated);
                    }
                    if (!qName.getLocalPart().equals("PROPERTY.REFERENCE")) break;
                    return new CIMClassProperty(propName, cdt, value, quals.toArray(new CIMQualifier[quals.size()]), key, isPropagated);
                }
                case 4: {
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        return null;
    }

    public static WBEMException parseError(XMLStreamReader reader, CIMObjectPath target, WBEMOperation operation, String classMethodName) throws WBEMException {
        String code = reader.getAttributeValue(null, "CODE");
        String description = reader.getAttributeValue(null, "DESCRIPTION");
        ArrayList<CIMInstance> l = new ArrayList<CIMInstance>();
        try {
            int eventType = reader.next();
            QName startTag = null;
            while (eventType != 8) {
                switch (eventType) {
                    case 1: {
                        startTag = reader.getName();
                        if (null == startTag || !"INSTANCE".equals(startTag.getLocalPart())) break;
                        l.add(CIMXMLElementsParser.parseInstance(reader, target));
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                eventType = reader.next();
            }
            reader.close();
        }
        catch (XMLStreamException ex) {
            return WBEMOperationErrors.getOtherFailureException((CIMObjectPath)target, (Throwable)ex, (WBEMOperation)operation, (String)classMethodName);
        }
        return new WBEMException(Integer.parseInt(code), description, l.toArray(new CIMInstance[l.size()]));
    }

    public static CIMInstance parseInstance(XMLStreamReader reader, CIMObjectPath instanceName) throws XMLStreamException {
        String className = reader.getAttributeValue(null, "CLASSNAME");
        if (null == instanceName) {
            instanceName = new CIMObjectPath(className);
        }
        int eventType = reader.next();
        QName startTag = null;
        ArrayList instProps = new ArrayList();
        while (eventType != 8) {
            switch (eventType) {
                case 15: {
                    break;
                }
                case 10: {
                    break;
                }
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag) break;
                    if ("PROPERTY".equals(startTag.getLocalPart())) {
                        instProps.add(CIMXMLElementsParser.parseProperty(reader));
                    }
                    if ("PROPERTY.ARRAY".equals(startTag.getLocalPart())) {
                        instProps.add(CIMXMLElementsParser.parsePropertyArray(reader));
                    }
                    if (!"PROPERTY.REFERENCE".equals(startTag.getLocalPart())) break;
                    instProps.add(CIMXMLElementsParser.parsePropertyReference(reader, instanceName));
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!qName.getLocalPart().equals("INSTANCE")) break;
                    if (instanceName.getObjectName().isEmpty()) {
                        instanceName = new CIMObjectPath(instanceName.getScheme(), instanceName.getHost(), instanceName.getPort(), instanceName.getNamespace(), className, null);
                    }
                    return new CIMInstance(instanceName, instProps.toArray(new CIMProperty[instProps.size()]));
                }
                case 4: {
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        return null;
    }

    public static CIMObjectPath parseInstanceName(XMLStreamReader reader, CIMObjectPath target) throws XMLStreamException {
        String className = reader.getAttributeValue(null, "CLASSNAME");
        String name = null;
        String type = null;
        String valueType = null;
        String value = "";
        CIMObjectPath p = null;
        int eventType = reader.next();
        QName startTag = null;
        ArrayList<CIMProperty> keyProps = new ArrayList<CIMProperty>();
        while (eventType != 8) {
            switch (eventType) {
                case 15: {
                    break;
                }
                case 10: {
                    break;
                }
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag) break;
                    if ("KEYBINDING".equals(startTag.getLocalPart())) {
                        name = reader.getAttributeValue(null, "NAME");
                        break;
                    }
                    if ("KEYVALUE".equals(startTag.getLocalPart())) {
                        type = reader.getAttributeValue(null, "TYPE");
                        valueType = reader.getAttributeValue(null, "VALUETYPE");
                        value = reader.getElementText();
                        break;
                    }
                    if ("VALUE.REFERENCE".equals(startTag.getLocalPart())) {
                        p = CIMXMLElementsParser.parseValueReference(reader, target);
                        break;
                    }
                    if (!"INSTANCENAME".equals(startTag.getLocalPart())) break;
                    className = reader.getAttributeValue(null, "CLASSNAME");
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (qName.getLocalPart().equals("KEYBINDING")) {
                        CIMDataType dt = null;
                        if (null == p) {
                            dt = null == type ? (null == valueType ? CIMDataType.INVALID_T : ("boolean".equals(valueType) ? CIMDataType.BOOLEAN_T : ("string".equals(valueType) ? CIMDataType.STRING_T : ("numeric".equals(valueType) ? CIMDataType.UINT32_T : CIMDataType.INVALID_T)))) : CIMXMLUtilities.getDataType(type);
                            keyProps.add(new CIMProperty(name, dt, (Object)value, true));
                        } else {
                            keyProps.add(new CIMProperty(name, new CIMDataType(p.getObjectName()), (Object)p, true));
                        }
                        p = null;
                        type = null;
                        name = null;
                        value = null;
                    }
                    if (!qName.getLocalPart().equals("INSTANCENAME")) break;
                    return new CIMObjectPath(null != target ? target.getScheme() : null, null != target ? target.getHost() : null, null != target ? target.getPort() : null, null != target ? target.getNamespace() : null, className, keyProps.toArray(new CIMProperty[keyProps.size()]));
                }
                case 4: {
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        return null;
    }

    public static CIMObjectPath parseInstancePath(XMLStreamReader reader, CIMObjectPath target) throws XMLStreamException {
        CIMObjectPath nsPath = null;
        CIMObjectPath inPath = null;
        int eventType = reader.next();
        QName startTag = null;
        while (eventType != 8) {
            switch (eventType) {
                case 15: {
                    break;
                }
                case 10: {
                    break;
                }
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag) break;
                    if ("NAMESPACEPATH".equals(startTag.getLocalPart())) {
                        nsPath = CIMXMLElementsParser.parseNamespacePath(reader, target);
                    }
                    if (!"INSTANCENAME".equals(startTag.getLocalPart())) break;
                    inPath = CIMXMLElementsParser.parseInstanceName(reader, nsPath);
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!qName.getLocalPart().equals("INSTANCEPATH")) break;
                    return inPath;
                }
                case 4: {
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        return null;
    }

    public static CIMObjectPath parseLocalClassPath(XMLStreamReader reader, CIMObjectPath target) throws XMLStreamException {
        String nsPath = null;
        CIMObjectPath classPath = null;
        int eventType = reader.next();
        QName startTag = null;
        while (eventType != 8) {
            switch (eventType) {
                case 15: {
                    break;
                }
                case 10: {
                    break;
                }
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag) break;
                    if ("LOCALNAMESPACEPATH".equals(startTag.getLocalPart())) {
                        nsPath = CIMXMLElementsParser.parseLocalNamespacePath(reader);
                    }
                    if (!"CLASSNAME".equals(startTag.getLocalPart())) break;
                    classPath = new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), nsPath, reader.getAttributeValue(null, "NAME"), null);
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!qName.getLocalPart().equals("CLASSNAME")) break;
                    return classPath;
                }
                case 4: {
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        return null;
    }

    public static CIMObjectPath parseLocalInstancePath(XMLStreamReader reader, CIMObjectPath target) throws XMLStreamException {
        String nsPath = null;
        int eventType = reader.next();
        QName startTag = null;
        while (eventType != 8) {
            switch (eventType) {
                case 15: {
                    break;
                }
                case 10: {
                    break;
                }
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag) break;
                    if ("LOCALNAMESPACEPATH".equals(startTag.getLocalPart())) {
                        nsPath = CIMXMLElementsParser.parseLocalNamespacePath(reader);
                    }
                    if (!"INSTANCENAME".equals(startTag.getLocalPart())) break;
                    CIMObjectPath p = new CIMObjectPath(target.getScheme(), target.getHost(), target.getPort(), nsPath, target.getObjectName(), target.getKeys());
                    return CIMXMLElementsParser.parseInstanceName(reader, p);
                }
                case 2: {
                    break;
                }
                case 4: {
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        return null;
    }

    public static String parseLocalNamespacePath(XMLStreamReader reader) throws XMLStreamException {
        String namespace = "";
        int eventType = reader.next();
        QName startTag = null;
        while (eventType != 8) {
            switch (eventType) {
                case 15: {
                    break;
                }
                case 10: {
                    break;
                }
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag || !"NAMESPACE".equals(startTag.getLocalPart())) break;
                    if (!"".equals(namespace)) {
                        namespace = namespace + "/";
                    }
                    namespace = namespace + reader.getAttributeValue(null, "NAME");
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!qName.getLocalPart().equals("LOCALNAMESPACEPATH")) break;
                    return namespace;
                }
                case 4: {
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        return null;
    }

    public static CIMMethod<?> parseMethod(XMLStreamReader reader) throws XMLStreamException {
        String name = reader.getAttributeValue(null, "NAME");
        String type = reader.getAttributeValue(null, "TYPE");
        String propagated = reader.getAttributeValue(null, "PROPAGATED");
        String originClass = reader.getAttributeValue(null, "CLASSORIGIN");
        boolean isPropagated = Boolean.valueOf(propagated);
        CIMDataType cdt = CIMXMLUtilities.getDataType(type);
        ArrayList params = new ArrayList();
        ArrayList quals = new ArrayList();
        int eventType = reader.next();
        QName startTag = null;
        while (eventType != 8) {
            switch (eventType) {
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag) break;
                    if ("QUALIFIER".equals(startTag.getLocalPart())) {
                        quals.add(CIMXMLElementsParser.parseQualifier(reader));
                    }
                    if (!startTag.getLocalPart().startsWith("PARAMETER")) break;
                    params.add(CIMXMLElementsParser.parseParameter(reader, startTag.getLocalPart()));
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!qName.getLocalPart().equals("METHOD")) break;
                    return new CIMMethod(name, cdt, quals.toArray(new CIMQualifier[quals.size()]), params.toArray(new CIMParameter[params.size()]), isPropagated);
                }
                case 4: {
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        return null;
    }

    public static CIMObjectPath parseNamespacePath(XMLStreamReader reader, CIMObjectPath target) throws XMLStreamException {
        String host = null;
        String namespace = null;
        int eventType = reader.next();
        QName startTag = null;
        while (eventType != 8) {
            switch (eventType) {
                case 15: {
                    break;
                }
                case 10: {
                    break;
                }
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag) break;
                    if ("HOST".equals(startTag.getLocalPart())) {
                        host = reader.getElementText();
                    }
                    if (!"LOCALNAMESPACEPATH".equals(startTag.getLocalPart())) break;
                    namespace = CIMXMLElementsParser.parseLocalNamespacePath(reader);
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!qName.getLocalPart().equals("NAMESPACEPATH")) break;
                    String scheme = namespace != null && !namespace.isEmpty() ? target.getScheme() : null;
                    return new CIMObjectPath(scheme, host, null, namespace, "", null, null);
                }
                case 4: {
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        return null;
    }

    public static CloseableIterator<?> parseObjectWithPathArray(XMLStreamReader reader, CIMObjectPath target) throws XMLStreamException {
        CloseableAddableIterator<Object> caIterator = new CloseableAddableIterator<Object>();
        int eventType = reader.next();
        QName startTag = null;
        while (eventType != 8) {
            switch (eventType) {
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag || !"VALUE.OBJECTWITHPATH".equals(startTag.getLocalPart())) break;
                    caIterator.add(CIMXMLElementsParser.parseValueObjectWithPath(reader, target));
                }
            }
            eventType = reader.next();
        }
        reader.close();
        caIterator.done();
        return caIterator;
    }

    public static CIMParameter<?> parseParameter(XMLStreamReader reader, String pType) throws XMLStreamException {
        boolean isArray = false;
        if ("PARAMETER.ARRAY".equals(pType) || "PARAMETER.REFARRAY".equals(pType)) {
            isArray = true;
        }
        String name = reader.getAttributeValue(null, "NAME");
        String type = reader.getAttributeValue(null, "TYPE");
        String refClass = reader.getAttributeValue(null, "REFERENCECLASS");
        String size = reader.getAttributeValue(null, "ARRAYSIZE");
        ArrayList quals = new ArrayList();
        int eventType = reader.next();
        QName startTag = null;
        while (eventType != 8) {
            switch (eventType) {
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag || !"QUALIFIER".equals(startTag.getLocalPart())) break;
                    quals.add(CIMXMLElementsParser.parseQualifier(reader));
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!qName.getLocalPart().startsWith("PARAMETER")) break;
                    CIMDataType cdt = null;
                    cdt = null != type ? CIMXMLUtilities.getDataType(type, isArray) : (isArray ? new CIMDataType(refClass, null == size ? 0 : Integer.parseInt(size)) : new CIMDataType(refClass));
                    return new CIMParameter(name, cdt, quals.toArray(new CIMQualifier[quals.size()]));
                }
                case 4: {
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        return null;
    }

    public static CIMArgument<?> parseParamValue(XMLStreamReader reader, CIMObjectPath target) throws XMLStreamException {
        Object value = null;
        String name = reader.getAttributeValue(null, "NAME");
        String type = reader.getAttributeValue(null, "PARAMTYPE");
        String eo = reader.getAttributeValue(null, "EmbeddedObject");
        boolean isEmbedded = "object".equalsIgnoreCase(eo) || "INSTANCE".equalsIgnoreCase(eo);
        CIMDataType cdt = CIMXMLUtilities.getDataType(type);
        int eventType = reader.next();
        while (eventType != 8) {
            switch (eventType) {
                case 15: {
                    break;
                }
                case 10: {
                    break;
                }
                case 1: {
                    QName start = reader.getName();
                    if (start.getLocalPart().equals("VALUE")) {
                        if (isEmbedded) {
                            cdt = CIMDataType.OBJECT_T;
                        }
                        value = CIMXMLElementsParser.parseValue(reader, cdt, isEmbedded);
                    }
                    if (start.getLocalPart().equals("QUALIFIER")) {
                        CIMXMLElementsParser.parseQualifier(reader);
                    }
                    if (start.getLocalPart().equals("VALUE.REFERENCE") && null != (value = CIMXMLElementsParser.parseValueReference(reader, target)) && value instanceof CIMObjectPath) {
                        cdt = new CIMDataType(((CIMObjectPath)value).getObjectName());
                    }
                    if (start.getLocalPart().equals("VALUE.ARRAY")) {
                        cdt = !isEmbedded ? CIMXMLUtilities.getDataType(type, true) : CIMDataType.OBJECT_ARRAY_T;
                        value = CIMXMLElementsParser.parseValueArray(reader, cdt, isEmbedded);
                    }
                    if (start.getLocalPart().equals("VALUE.REFARRAY") && null != (value = CIMXMLElementsParser.parseValueReferenceArray(reader, target)) && value instanceof CIMObjectPath[]) {
                        CIMObjectPath[] x = (CIMObjectPath[])value;
                        cdt = x.length > 0 && null != x[0] ? new CIMDataType(x[0].getObjectName(), 0) : new CIMDataType("CIM_ManagedElement", 0);
                    }
                    if (start.getLocalPart().equals("CLASSNAME")) {
                        value = CIMXMLElementsParser.parseClassName(reader, target);
                    }
                    if (start.getLocalPart().equals("INSTANCENAME")) {
                        value = CIMXMLElementsParser.parseInstanceName(reader, target);
                    }
                    if (start.getLocalPart().equals("CLASS")) {
                        value = CIMXMLElementsParser.parseClass(reader, target);
                    }
                    if (start.getLocalPart().equals("INSTANCE")) {
                        value = CIMXMLElementsParser.parseInstance(reader, target);
                    }
                    if (!start.getLocalPart().equals("VALUE.NAMEDINSTANCE")) break;
                    value = CIMXMLElementsParser.parseValueNamedInstance(reader, target);
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!qName.getLocalPart().equals("PARAMVALUE")) break;
                    if (isEmbedded) {
                        cdt = cdt.isArray() ? CIMDataType.OBJECT_ARRAY_T : CIMDataType.OBJECT_T;
                    }
                    return new CIMArgument(name, cdt, value);
                }
                case 4: {
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        return null;
    }

    public static CIMProperty<?> parseProperty(XMLStreamReader reader) throws XMLStreamException {
        String name = reader.getAttributeValue(null, "NAME");
        String type = reader.getAttributeValue(null, "TYPE");
        String eo = reader.getAttributeValue(null, "EmbeddedObject");
        boolean isEmbedded = "object".equalsIgnoreCase(eo) || "INSTANCE".equalsIgnoreCase(eo);
        QName startTag = null;
        CIMProperty property = null;
        Object value = null;
        CIMDataType cdType = CIMXMLUtilities.getDataType(type);
        boolean bDone = false;
        int eventType = reader.next();
        while (eventType != 8 && !bDone) {
            switch (eventType) {
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag || !"VALUE".equals(startTag.getLocalPart()) || !((value = CIMXMLElementsParser.parseValue(reader, cdType, isEmbedded)) instanceof CIMInstance)) break;
                    cdType = CIMDataType.OBJECT_T;
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!"PROPERTY".equals(qName.getLocalPart())) break;
                    property = new CIMProperty(name, cdType, value);
                    bDone = true;
                }
            }
            if (bDone) continue;
            eventType = reader.next();
        }
        return property;
    }

    public static CIMProperty<?> parsePropertyArray(XMLStreamReader reader) throws XMLStreamException {
        String name = reader.getAttributeValue(null, "NAME");
        String type = reader.getAttributeValue(null, "TYPE");
        String arraySize = reader.getAttributeValue(null, "ARRAYSIZE");
        String eo = reader.getAttributeValue(null, "EmbeddedObject");
        boolean isEmbedded = "object".equalsIgnoreCase(eo) || "INSTANCE".equalsIgnoreCase(eo);
        CIMDataType cdt = CIMXMLUtilities.getDataType(type, true);
        if (null != eo) {
            cdt = CIMDataType.OBJECT_ARRAY_T;
        }
        if (null != arraySize) {
            cdt = new CIMDataType(cdt.getType(), Integer.parseInt(arraySize));
        }
        QName startTag = null;
        CIMProperty property = null;
        Object value = null;
        boolean bDone = false;
        int eventType = reader.next();
        while (eventType != 8 && !bDone) {
            switch (eventType) {
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag || !"VALUE.ARRAY".equals(startTag.getLocalPart())) break;
                    value = CIMXMLElementsParser.parseValueArray(reader, cdt, isEmbedded);
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!"PROPERTY.ARRAY".equals(qName.getLocalPart())) break;
                    property = new CIMProperty(name, cdt, value);
                    bDone = true;
                }
            }
            if (bDone) continue;
            eventType = reader.next();
        }
        return property;
    }

    public static CIMProperty<?> parsePropertyReference(XMLStreamReader reader, CIMObjectPath instanceName) throws XMLStreamException {
        String name = reader.getAttributeValue(null, "NAME");
        String clazz = reader.getAttributeValue(null, "REFERENCECLASS");
        QName startTag = null;
        CIMProperty property = null;
        CIMObjectPath value = null;
        CIMDataType cdType = new CIMDataType(clazz == null ? "CIM_ManagedElement" : clazz);
        boolean bDone = false;
        int eventType = reader.next();
        while (eventType != 8 && !bDone) {
            switch (eventType) {
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag || !"VALUE.REFERENCE".equals(startTag.getLocalPart())) break;
                    value = CIMXMLElementsParser.parseValueReference(reader, instanceName);
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!"PROPERTY.REFERENCE".equals(qName.getLocalPart())) break;
                    property = new CIMProperty(name, cdType, value);
                    bDone = true;
                }
            }
            if (bDone) continue;
            eventType = reader.next();
        }
        return property;
    }

    public static CIMQualifier<?> parseQualifier(XMLStreamReader reader) throws XMLStreamException {
        boolean isArray = false;
        String propName = reader.getAttributeValue(null, "NAME");
        String propType = reader.getAttributeValue(null, "TYPE");
        String propagated = reader.getAttributeValue(null, "PROPAGATED");
        String overridable = reader.getAttributeValue(null, "OVERRIDABLE");
        String toSubClass = reader.getAttributeValue(null, "TOSUBCLASS");
        String translatable = reader.getAttributeValue(null, "TRANSLATABLE");
        boolean isPropagated = propagated != null ? Boolean.valueOf(propagated) : false;
        CIMDataType cdt = CIMXMLUtilities.getDataType(propType);
        Object value = null;
        int eventType = reader.next();
        QName startTag = null;
        while (eventType != 8) {
            switch (eventType) {
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag) break;
                    if ("VALUE.ARRAY".equals(startTag.getLocalPart())) {
                        isArray = true;
                        value = CIMXMLElementsParser.parseValueArray(reader, cdt, false);
                    }
                    if (!"VALUE".equals(startTag.getLocalPart())) break;
                    value = CIMXMLElementsParser.parseValue(reader, cdt, false);
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!qName.getLocalPart().equals("QUALIFIER")) break;
                    int flavor = 0;
                    if (overridable != null && !"true".equalsIgnoreCase(overridable)) {
                        flavor |= 1;
                    }
                    if (toSubClass != null && !"true".equalsIgnoreCase(toSubClass)) {
                        flavor |= 2;
                    }
                    if (translatable != null && "true".equalsIgnoreCase(translatable)) {
                        flavor |= 4;
                    }
                    CIMDataType dt = cdt;
                    if (isArray) {
                        dt = CIMXMLUtilities.getDataType(propType, isArray);
                    }
                    return new CIMQualifier(propName, dt, value, flavor, isPropagated);
                }
                case 4: {
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        return null;
    }

    public static CIMQualifierType<?> parseQualifierType(XMLStreamReader reader, CIMObjectPath target, int eventType) throws XMLStreamException {
        CIMQualifierType returnQT = null;
        String name = null;
        String value = null;
        CIMDataType cdt = null;
        int flavor = 0;
        int qScope = 0;
        QName startTag = null;
        while (eventType != 8) {
            switch (eventType) {
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag) break;
                    if ("QUALIFIER.DECLARATION".equals(startTag.getLocalPart())) {
                        String valTranslate;
                        String valSubClass;
                        name = reader.getAttributeValue(null, "NAME");
                        String type = reader.getAttributeValue(null, "TYPE");
                        boolean isArray = Boolean.parseBoolean(reader.getAttributeValue(null, "ISARRAY"));
                        cdt = CIMXMLUtilities.getDataType(type, isArray);
                        String valOverride = reader.getAttributeValue(null, "OVERRIDABLE");
                        if ("false".equalsIgnoreCase(valOverride)) {
                            flavor |= 1;
                        }
                        if ("false".equalsIgnoreCase(valSubClass = reader.getAttributeValue(null, "TOSUBCLASS"))) {
                            flavor |= 2;
                        }
                        if ("true".equalsIgnoreCase(valTranslate = reader.getAttributeValue(null, "TRANSLATABLE"))) {
                            flavor |= 4;
                        }
                    }
                    if ("SCOPE".equals(startTag.getLocalPart())) {
                        if ("true".equals(reader.getAttributeValue(null, "CLASS"))) {
                            qScope |= 1;
                        }
                        if ("true".equals(reader.getAttributeValue(null, "ASSOCIATION"))) {
                            qScope |= 2;
                        }
                        if ("true".equals(reader.getAttributeValue(null, "REFERENCE"))) {
                            qScope |= 0x10;
                        }
                        if ("true".equals(reader.getAttributeValue(null, "PROPERTY"))) {
                            qScope |= 8;
                        }
                        if ("true".equals(reader.getAttributeValue(null, "METHOD"))) {
                            qScope |= 0x20;
                        }
                        if ("true".equals(reader.getAttributeValue(null, "PARAMETER"))) {
                            qScope |= 0x40;
                        }
                        if (!"true".equals(reader.getAttributeValue(null, "INDICATION"))) break;
                        qScope |= 4;
                        break;
                    }
                    if (!"VALUE".equals(startTag.getLocalPart())) break;
                    value = reader.getElementText();
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!qName.getLocalPart().equals("QUALIFIER.DECLARATION")) break;
                    CIMObjectPath path = new CIMObjectPath(null, null, null, target.getNamespace(), name, null);
                    returnQT = new CIMQualifierType(path, cdt, CIMXMLUtilities.convertStringToProperType(cdt, value), qScope, flavor);
                    return returnQT;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        return returnQT;
    }

    public static CloseableIterator<CIMQualifierType<?>> parseQualifierTypes(XMLStreamReader reader, CIMObjectPath target) throws XMLStreamException {
        CloseableAddableIterator caIterator = new CloseableAddableIterator();
        int eventType = reader.next();
        QName startTag = null;
        while (eventType != 8) {
            switch (eventType) {
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag || !"QUALIFIER.DECLARATION".equals(startTag.getLocalPart())) break;
                    caIterator.add(CIMXMLElementsParser.parseQualifierType(reader, target, eventType));
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        caIterator.done();
        return caIterator;
    }

    public static Object parseReturnValue(XMLStreamReader reader, CIMObjectPath target) throws XMLStreamException {
        QName startTag = null;
        Object returnValue = null;
        String type = reader.getAttributeValue(null, "PARAMTYPE");
        String eo = reader.getAttributeValue(null, "EmbeddedObject");
        boolean isReturnEmbedded = "object".equalsIgnoreCase(eo) || "INSTANCE".equalsIgnoreCase(eo);
        CIMDataType returnType = CIMXMLUtilities.getDataType(type == null ? "string" : type);
        int eventType = reader.next();
        while (eventType != 8) {
            switch (eventType) {
                case 15: {
                    break;
                }
                case 10: {
                    break;
                }
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag) break;
                    if ("VALUE".equals(startTag.getLocalPart())) {
                        returnValue = CIMXMLElementsParser.parseValue(reader, returnType, isReturnEmbedded);
                        break;
                    }
                    if (!"VALUE.REFERENCE".equals(startTag.getLocalPart())) break;
                    returnValue = CIMXMLElementsParser.parseValueReference(reader, target);
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!qName.getLocalPart().equals("RETURNVALUE")) break;
                    return returnValue;
                }
                case 4: {
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        return null;
    }

    public static Object parseValue(XMLStreamReader reader, CIMDataType cdt, boolean isEmbeddedInstance) throws XMLStreamException {
        String value = "";
        boolean bDone = false;
        int eventType = reader.next();
        while (eventType != 8 && !bDone) {
            switch (eventType) {
                case 1: {
                    QName sName = reader.getName();
                    if (!"QUALIFIER".equals(sName.getLocalPart())) break;
                    CIMXMLElementsParser.parseQualifier(reader);
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!"VALUE".equals(qName.getLocalPart())) break;
                    bDone = true;
                    break;
                }
                case 4: {
                    value = value + reader.getText();
                    break;
                }
            }
            if (bDone) continue;
            eventType = reader.next();
        }
        if (isEmbeddedInstance) {
            try {
                byte[] byteArray = value.getBytes("UTF-8");
                ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArray);
                XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                XMLStreamReader readerValue = inputFactory.createXMLStreamReader(inputStream);
                int iEventType = readerValue.next();
                while (iEventType != 8) {
                    switch (iEventType) {
                        case 1: {
                            QName qName = readerValue.getName();
                            if (!"INSTANCE".equals(qName.getLocalPart())) break;
                            return CIMXMLElementsParser.parseInstance(readerValue, null);
                        }
                    }
                    iEventType = readerValue.next();
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return CIMXMLUtilities.convertStringToProperType(cdt, value);
    }

    public static Object parseValueArray(XMLStreamReader reader, CIMDataType cdt, boolean isEmbedded) throws XMLStreamException {
        QName startTag = null;
        ArrayList<Object> values = new ArrayList<Object>();
        boolean bDone = false;
        int eventType = reader.next();
        while (eventType != 8 && !bDone) {
            switch (eventType) {
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag || !"VALUE".equals(startTag.getLocalPart())) break;
                    values.add(CIMXMLElementsParser.parseValue(reader, cdt, isEmbedded));
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!"VALUE.ARRAY".equals(qName.getLocalPart())) break;
                    bDone = true;
                }
            }
            if (bDone) continue;
            eventType = reader.next();
        }
        return CIMXMLUtilities.convertArrayToType(values, cdt);
    }

    public static CIMInstance parseValueInstanceWithPath(XMLStreamReader reader, CIMObjectPath target) throws XMLStreamException {
        CIMInstance i = null;
        CIMObjectPath inPath = null;
        int eventType = reader.next();
        QName startTag = null;
        while (eventType != 8) {
            switch (eventType) {
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag) break;
                    if ("INSTANCEPATH".equals(startTag.getLocalPart())) {
                        inPath = CIMXMLElementsParser.parseInstancePath(reader, target);
                    }
                    if (!"INSTANCE".equals(startTag.getLocalPart())) break;
                    i = CIMXMLElementsParser.parseInstance(reader, inPath);
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!qName.getLocalPart().equals("VALUE.INSTANCEWITHPATH")) break;
                    return i;
                }
                case 4: {
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        return null;
    }

    public static CIMInstance parseValueNamedInstance(XMLStreamReader reader, CIMObjectPath target) throws XMLStreamException {
        CIMInstance i = null;
        CIMObjectPath inPath = null;
        int eventType = reader.next();
        QName startTag = null;
        while (eventType != 8) {
            switch (eventType) {
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag) break;
                    if ("INSTANCENAME".equals(startTag.getLocalPart())) {
                        inPath = CIMXMLElementsParser.parseInstanceName(reader, target);
                    }
                    if (!"INSTANCE".equals(startTag.getLocalPart())) break;
                    i = CIMXMLElementsParser.parseInstance(reader, inPath);
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!qName.getLocalPart().equals("VALUE.NAMEDINSTANCE")) break;
                    return i;
                }
                case 4: {
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        return null;
    }

    static Object parseValueObjectWithPath(XMLStreamReader reader, CIMObjectPath target) throws XMLStreamException {
        CIMClass obj = null;
        CIMObjectPath path = null;
        int eventType = reader.next();
        QName startTag = null;
        while (eventType != 8) {
            switch (eventType) {
                case 15: {
                    break;
                }
                case 10: {
                    break;
                }
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag) break;
                    if ("CLASSPATH".equals(startTag.getLocalPart())) {
                        path = CIMXMLElementsParser.parseClassPath(reader, target);
                    }
                    if ("CLASS".equals(startTag.getLocalPart())) {
                        obj = CIMXMLElementsParser.parseClass(reader, path);
                    }
                    if ("INSTANCEPATH".equals(startTag.getLocalPart())) {
                        path = CIMXMLElementsParser.parseInstancePath(reader, target);
                    }
                    if (!"INSTANCE".equals(startTag.getLocalPart())) break;
                    obj = CIMXMLElementsParser.parseInstance(reader, path);
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!qName.getLocalPart().equals("VALUE.OBJECTWITHPATH")) break;
                    return obj;
                }
                case 4: {
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        return null;
    }

    public static CIMObjectPath parseValueReference(XMLStreamReader reader, CIMObjectPath target) throws XMLStreamException {
        CIMObjectPath path = null;
        int eventType = reader.next();
        QName startTag = null;
        while (eventType != 8) {
            switch (eventType) {
                case 15: {
                    break;
                }
                case 10: {
                    break;
                }
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag) break;
                    if ("CLASSPATH".equals(startTag.getLocalPart())) {
                        return CIMXMLElementsParser.parseClassPath(reader, target);
                    }
                    if ("LOCALCLASSPATH".equals(startTag.getLocalPart())) {
                        return CIMXMLElementsParser.parseLocalClassPath(reader, target);
                    }
                    if ("CLASSNAME".equals(startTag.getLocalPart())) {
                        return CIMXMLElementsParser.parseClassName(reader, target);
                    }
                    if ("INSTANCEPATH".equals(startTag.getLocalPart())) {
                        path = CIMXMLElementsParser.parseInstancePath(reader, target);
                    }
                    if ("LOCALINSTANCEPATH".equals(startTag.getLocalPart())) {
                        return CIMXMLElementsParser.parseLocalInstancePath(reader, target);
                    }
                    if (!"INSTANCENAME".equals(startTag.getLocalPart())) break;
                    path = CIMXMLElementsParser.parseInstanceName(reader, target);
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!qName.getLocalPart().equals("VALUE.REFERENCE")) break;
                    return path;
                }
                case 4: {
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        return null;
    }

    public static Object parseValueReferenceArray(XMLStreamReader reader, CIMObjectPath target) throws XMLStreamException {
        QName startTag = null;
        ArrayList<CIMObjectPath> values = new ArrayList<CIMObjectPath>();
        boolean bDone = false;
        int eventType = reader.next();
        while (eventType != 8 && !bDone) {
            switch (eventType) {
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag || !"VALUE.REFERENCE".equals(startTag.getLocalPart())) break;
                    CIMObjectPath value = CIMXMLElementsParser.parseValueReference(reader, target);
                    values.add(value);
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!"VALUE.REFARRAY".equals(qName.getLocalPart())) break;
                    bDone = true;
                }
            }
            if (bDone) continue;
            eventType = reader.next();
        }
        return values.toArray(new CIMObjectPath[values.size()]);
    }
}

