/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.xmlcim;

import com.ws.cim.xmlcim.CIMXMLUtilities;
import java.io.IOException;
import java.io.StringWriter;
import javax.cim.CIMArgument;
import javax.cim.CIMClass;
import javax.cim.CIMClassProperty;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTime;
import javax.cim.CIMInstance;
import javax.cim.CIMMethod;
import javax.cim.CIMObjectPath;
import javax.cim.CIMParameter;
import javax.cim.CIMProperty;
import javax.cim.CIMQualifier;
import javax.cim.CIMQualifierType;
import javax.wbem.WBEMException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class CIMXMLElementsWriter {
    public static void writeClass(XMLStreamWriter writer, CIMClass clazz) throws XMLStreamException {
        writer.writeStartElement("CLASS");
        writer.writeAttribute("NAME", clazz.getName());
        if (null != clazz.getSuperClassName()) {
            writer.writeAttribute("SUPERCLASS", clazz.getSuperClassName());
        }
        for (CIMQualifier cIMQualifier : clazz.getQualifiers()) {
            CIMXMLElementsWriter.writeQualifier(writer, cIMQualifier);
        }
        for (CIMQualifier cIMQualifier : clazz.getProperties()) {
            CIMXMLElementsWriter.writeClassProperty(writer, cIMQualifier);
        }
        for (CIMQualifier cIMQualifier : clazz.getMethods()) {
            CIMXMLElementsWriter.writeMethod(writer, cIMQualifier);
        }
        writer.writeEndElement();
    }

    public static void writeClassName(XMLStreamWriter writer, CIMObjectPath target) throws XMLStreamException {
        writer.writeStartElement("CLASSNAME");
        writer.writeAttribute("NAME", target.getObjectName());
        writer.writeEndElement();
    }

    public static void writeClassPath(XMLStreamWriter writer, CIMObjectPath path) throws XMLStreamException {
        writer.writeStartElement("CLASSPATH");
        CIMXMLElementsWriter.writeNamespacePath(writer, path);
        CIMXMLElementsWriter.writeClassName(writer, path);
        writer.writeEndElement();
    }

    private static void writeClassProperty(XMLStreamWriter writer, CIMClassProperty<?> property) throws XMLStreamException {
        if (null != property && null != property.getDataType()) {
            CIMDataType cdt = property.getDataType();
            if (cdt.getType() == 14) {
                CIMXMLElementsWriter.writeClassPropertyReference(writer, property);
            } else if (cdt.isArray()) {
                CIMXMLElementsWriter.writeClassPropertyArray(writer, property);
            } else {
                CIMXMLElementsWriter.writeClassPropertyStandard(writer, property);
            }
        }
    }

    private static void writeClassPropertyArray(XMLStreamWriter writer, CIMClassProperty<?> property) throws XMLStreamException {
        writer.writeStartElement("PROPERTY.ARRAY");
        writer.writeAttribute("NAME", property.getName());
        CIMDataType cdt = property.getDataType();
        writer.writeAttribute("TYPE", CIMXMLUtilities.getCIMXMLDataTypefromCIMDataType(cdt));
        if (cdt.getSize() > 0) {
            writer.writeAttribute("ARRAYSIZE", Integer.toString(cdt.getSize()));
        }
        writer.writeAttribute("PROPAGATED", Boolean.toString(property.isPropagated()));
        if (property.hasQualifier("EmbeddedInstance")) {
            writer.writeAttribute("EmbeddedObject", "INSTANCE".toLowerCase());
        }
        if (property.hasQualifier("EmbeddedObject")) {
            writer.writeAttribute("EmbeddedObject", "object");
        }
        if (property.isKey() && !property.hasQualifier("Key")) {
            CIMQualifier keyQual = new CIMQualifier("Key", CIMDataType.BOOLEAN_T, (Object)true, 0);
            CIMXMLElementsWriter.writeQualifier(writer, keyQual);
        }
        for (CIMQualifier q : property.getQualifiers()) {
            CIMXMLElementsWriter.writeQualifier(writer, q);
        }
        if (null != property.getValue()) {
            CIMXMLElementsWriter.writeValueArray(writer, (Object[])property.getValue());
        }
        writer.writeEndElement();
    }

    private static void writeClassPropertyReference(XMLStreamWriter writer, CIMClassProperty<?> property) throws XMLStreamException {
        writer.writeStartElement("PROPERTY.REFERENCE");
        writer.writeAttribute("NAME", property.getName());
        CIMDataType cdt = property.getDataType();
        writer.writeAttribute("REFERENCECLASS", cdt.getRefClassName());
        writer.writeAttribute("PROPAGATED", Boolean.toString(property.isPropagated()));
        for (CIMQualifier q : property.getQualifiers()) {
            CIMXMLElementsWriter.writeQualifier(writer, q);
        }
        if (property.isKey() && !property.hasQualifier("Key")) {
            CIMQualifier keyQual = new CIMQualifier("Key", CIMDataType.BOOLEAN_T, (Object)true, 0);
            CIMXMLElementsWriter.writeQualifier(writer, keyQual);
        }
        if (null != property.getValue()) {
            CIMXMLElementsWriter.writeValueReference(writer, (CIMObjectPath)property.getValue());
        }
        writer.writeEndElement();
    }

    private static void writeClassPropertyStandard(XMLStreamWriter writer, CIMClassProperty<?> property) throws XMLStreamException {
        writer.writeStartElement("PROPERTY");
        writer.writeAttribute("NAME", property.getName());
        CIMDataType cdt = property.getDataType();
        writer.writeAttribute("TYPE", CIMXMLUtilities.getCIMXMLDataTypefromCIMDataType(cdt));
        writer.writeAttribute("PROPAGATED", Boolean.toString(property.isPropagated()));
        if (property.hasQualifier("EmbeddedInstance")) {
            writer.writeAttribute("EmbeddedObject", "INSTANCE".toLowerCase());
        }
        if (property.hasQualifier("EmbeddedObject")) {
            writer.writeAttribute("EmbeddedObject", "object");
        }
        if (property.isKey() && !property.hasQualifier("Key")) {
            CIMQualifier keyQual = new CIMQualifier("Key", CIMDataType.BOOLEAN_T, (Object)true, 0);
            CIMXMLElementsWriter.writeQualifier(writer, keyQual);
        }
        for (CIMQualifier q : property.getQualifiers()) {
            CIMXMLElementsWriter.writeQualifier(writer, q);
        }
        if (null != property.getValue()) {
            CIMXMLElementsWriter.writeValue(writer, property.getValue());
        }
        writer.writeEndElement();
    }

    public static void writeEmbeddedInstance(XMLStreamWriter writer, CIMInstance instance) throws XMLStreamException {
        StringWriter sw = new StringWriter();
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter iwriter = factory.createXMLStreamWriter(sw);
        CIMXMLElementsWriter.writeInstance(iwriter, instance);
        iwriter.flush();
        StringBuffer b = new StringBuffer();
        b.append(sw);
        try {
            sw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        iwriter.close();
        writer.writeCharacters(b.toString());
    }

    public static void writeInstance(XMLStreamWriter writer, CIMInstance instance) throws XMLStreamException {
        writer.writeStartElement("INSTANCE");
        writer.writeAttribute("CLASSNAME", instance.getClassName());
        for (CIMProperty p : instance.getProperties()) {
            CIMXMLElementsWriter.writeInstanceProperty(writer, p);
        }
        writer.writeEndElement();
    }

    public static void writeInstanceName(XMLStreamWriter writer, CIMObjectPath target) throws XMLStreamException {
        writer.writeStartElement("INSTANCENAME");
        writer.writeAttribute("CLASSNAME", target.getObjectName());
        for (CIMProperty p : target.getKeys()) {
            writer.writeStartElement("KEYBINDING");
            writer.writeAttribute("NAME", p.getName());
            String type = null;
            CIMDataType cdt = p.getDataType();
            int cdtType = cdt.getType();
            if (14 == cdtType) {
                CIMXMLElementsWriter.writeValueReference(writer, (CIMObjectPath)p.getValue());
            } else {
                writer.writeStartElement("KEYVALUE");
                type = 8 == cdtType || 12 == cdtType || 13 == cdtType || 17 == cdtType || 15 == cdtType ? "string" : (9 == cdtType ? "boolean" : (1 == cdtType || 3 == cdtType || 5 == cdtType || 7 == cdtType || 0 == cdtType || 2 == cdtType || 4 == cdtType || 6 == cdtType || 10 == cdtType || 11 == cdtType ? "numeric" : "string"));
                writer.writeAttribute("TYPE", CIMXMLUtilities.getCIMXMLDataTypefromCIMDataType(cdt));
                writer.writeAttribute("VALUETYPE", type);
                writer.writeCharacters(p.getValue().toString());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public static void writeInstancePath(XMLStreamWriter writer, CIMObjectPath path) throws XMLStreamException {
        writer.writeStartElement("INSTANCEPATH");
        CIMXMLElementsWriter.writeNamespacePath(writer, path);
        CIMXMLElementsWriter.writeInstanceName(writer, path);
        writer.writeEndElement();
    }

    private static void writeInstanceProperty(XMLStreamWriter writer, CIMProperty<?> property) throws XMLStreamException {
        if (null != property && null != property.getDataType()) {
            CIMDataType cdt = property.getDataType();
            if (cdt.getType() == 14) {
                CIMXMLElementsWriter.writeInstancePropertyReference(writer, property);
            } else if (cdt.isArray()) {
                CIMXMLElementsWriter.writeInstancePropertyArray(writer, property);
            } else {
                CIMXMLElementsWriter.writeInstancePropertyStandard(writer, property);
            }
        }
    }

    private static void writeInstancePropertyArray(XMLStreamWriter writer, CIMProperty<?> property) throws XMLStreamException {
        writer.writeStartElement("PROPERTY.ARRAY");
        writer.writeAttribute("NAME", property.getName());
        CIMDataType cdt = property.getDataType();
        writer.writeAttribute("TYPE", CIMXMLUtilities.getCIMXMLDataTypefromCIMDataType(cdt));
        if (cdt.getSize() > 0) {
            writer.writeAttribute("ARRAYSIZE", Integer.toString(cdt.getSize()));
        }
        if (null != property.getValue()) {
            Object value = property.getValue();
            if (value instanceof CIMClass || value instanceof CIMInstance || value instanceof CIMInstance[] || value instanceof CIMClass[]) {
                writer.writeAttribute("EmbeddedObject", "object");
            }
            CIMXMLElementsWriter.writeValueArray(writer, (Object[])value);
        }
        writer.writeEndElement();
    }

    private static void writeInstancePropertyReference(XMLStreamWriter writer, CIMProperty<?> property) throws XMLStreamException {
        writer.writeStartElement("PROPERTY.REFERENCE");
        writer.writeAttribute("NAME", property.getName());
        CIMDataType cdt = property.getDataType();
        writer.writeAttribute("REFERENCECLASS", cdt.getRefClassName());
        if (null != property.getValue()) {
            CIMXMLElementsWriter.writeValueReference(writer, (CIMObjectPath)property.getValue());
        }
        writer.writeEndElement();
    }

    private static void writeInstancePropertyStandard(XMLStreamWriter writer, CIMProperty<?> property) throws XMLStreamException {
        writer.writeStartElement("PROPERTY");
        writer.writeAttribute("NAME", property.getName());
        CIMDataType cdt = property.getDataType();
        writer.writeAttribute("TYPE", CIMXMLUtilities.getCIMXMLDataTypefromCIMDataType(cdt));
        if (null != property.getValue()) {
            Object value = property.getValue();
            if (value instanceof CIMClass || value instanceof CIMInstance || value instanceof CIMInstance[] || value instanceof CIMClass[]) {
                writer.writeAttribute("EmbeddedObject", "object");
            }
            CIMXMLElementsWriter.writeValue(writer, value);
        }
        writer.writeEndElement();
    }

    public static void writeLocalClassPath(XMLStreamWriter writer, CIMObjectPath path) throws XMLStreamException {
        writer.writeStartElement("CLASSPATH");
        CIMXMLElementsWriter.writeLocalNamespacePath(writer, path.getNamespace());
        CIMXMLElementsWriter.writeClassName(writer, path);
        writer.writeEndElement();
    }

    public static void writeLocalInstancePath(XMLStreamWriter writer, CIMObjectPath path) throws XMLStreamException {
        writer.writeStartElement("LOCALINSTANCEPATH");
        CIMXMLElementsWriter.writeLocalNamespacePath(writer, path.getNamespace());
        CIMXMLElementsWriter.writeInstanceName(writer, path);
        writer.writeEndElement();
    }

    public static void writeLocalNamespacePath(XMLStreamWriter writer, String namespace) throws XMLStreamException {
        writer.writeStartElement("LOCALNAMESPACEPATH");
        CIMXMLElementsWriter.writeNamespace(namespace, writer);
        writer.writeEndElement();
    }

    private static void writeMethod(XMLStreamWriter writer, CIMMethod<?> method) throws XMLStreamException {
        writer.writeStartElement("METHOD");
        writer.writeAttribute("NAME", method.getName());
        CIMDataType cdt = method.getDataType();
        writer.writeAttribute("TYPE", CIMXMLUtilities.getCIMXMLDataTypefromCIMDataType(cdt));
        writer.writeAttribute("PROPAGATED", Boolean.toString(method.isPropagated()));
        for (CIMQualifier cIMQualifier : method.getQualifiers()) {
            CIMXMLElementsWriter.writeQualifier(writer, cIMQualifier);
        }
        for (CIMQualifier cIMQualifier : method.getParameters()) {
            CIMXMLElementsWriter.writeParameter(writer, cIMQualifier);
        }
        writer.writeEndElement();
    }

    private static void writeNamespace(String namespace, XMLStreamWriter writer) throws XMLStreamException {
        int index = namespace.indexOf(47);
        while (index >= 0) {
            if (index != 0) {
                writer.writeStartElement("NAMESPACE");
                writer.writeAttribute("NAME", namespace.substring(0, index));
                writer.writeEndElement();
            }
            namespace = namespace.substring(index + 1);
            index = namespace.indexOf(47);
        }
        writer.writeStartElement("NAMESPACE");
        writer.writeAttribute("NAME", namespace);
        writer.writeEndElement();
    }

    private static void writeNamespacePath(XMLStreamWriter writer, CIMObjectPath path) throws XMLStreamException {
        writer.writeStartElement("NAMESPACEPATH");
        writer.writeStartElement("HOST");
        writer.writeCharacters(path.getHost());
        writer.writeEndElement();
        CIMXMLElementsWriter.writeLocalNamespacePath(writer, path.getNamespace());
        writer.writeEndElement();
    }

    private static void writeParameter(XMLStreamWriter writer, CIMParameter<?> parmeter) throws XMLStreamException {
        if (null != parmeter && null != parmeter.getDataType()) {
            CIMDataType cdt = parmeter.getDataType();
            if (cdt.getType() == 14) {
                if (cdt.isArray()) {
                    CIMXMLElementsWriter.writeParameterRefArray(writer, parmeter);
                } else {
                    CIMXMLElementsWriter.writeParameterReference(writer, parmeter);
                }
            } else if (cdt.isArray()) {
                CIMXMLElementsWriter.writeParameterArray(writer, parmeter);
            } else {
                CIMXMLElementsWriter.writeParameterStandard(writer, parmeter);
            }
        }
    }

    private static void writeParameterArray(XMLStreamWriter writer, CIMParameter<?> parmeter) throws XMLStreamException {
        writer.writeStartElement("PARAMETER.ARRAY");
        writer.writeAttribute("NAME", parmeter.getName());
        CIMDataType cdt = parmeter.getDataType();
        writer.writeAttribute("TYPE", CIMXMLUtilities.getCIMXMLDataTypefromCIMDataType(cdt));
        writer.writeAttribute("ARRAYSIZE", Integer.toString(cdt.getSize()));
        for (CIMQualifier q : parmeter.getQualifiers()) {
            CIMXMLElementsWriter.writeQualifier(writer, q);
        }
        writer.writeEndElement();
    }

    private static void writeParameterRefArray(XMLStreamWriter writer, CIMParameter<?> parmeter) throws XMLStreamException {
        writer.writeStartElement("PARAMETER.REFARRAY");
        writer.writeAttribute("NAME", parmeter.getName());
        CIMDataType cdt = parmeter.getDataType();
        writer.writeAttribute("REFERENCECLASS", cdt.getRefClassName());
        writer.writeAttribute("ARRAYSIZE", Integer.toString(cdt.getSize()));
        for (CIMQualifier q : parmeter.getQualifiers()) {
            CIMXMLElementsWriter.writeQualifier(writer, q);
        }
        writer.writeEndElement();
    }

    private static void writeParameterReference(XMLStreamWriter writer, CIMParameter<?> parmeter) throws XMLStreamException {
        writer.writeStartElement("PARAMETER.REFERENCE");
        writer.writeAttribute("NAME", parmeter.getName());
        CIMDataType cdt = parmeter.getDataType();
        writer.writeAttribute("REFERENCECLASS", cdt.getRefClassName());
        for (CIMQualifier q : parmeter.getQualifiers()) {
            CIMXMLElementsWriter.writeQualifier(writer, q);
        }
        writer.writeEndElement();
    }

    private static void writeParameterStandard(XMLStreamWriter writer, CIMParameter<?> parmeter) throws XMLStreamException {
        writer.writeStartElement("PARAMETER");
        writer.writeAttribute("NAME", parmeter.getName());
        CIMDataType cdt = parmeter.getDataType();
        writer.writeAttribute("TYPE", CIMXMLUtilities.getCIMXMLDataTypefromCIMDataType(cdt));
        for (CIMQualifier q : parmeter.getQualifiers()) {
            CIMXMLElementsWriter.writeQualifier(writer, q);
        }
        writer.writeEndElement();
    }

    private static void writeQualifier(XMLStreamWriter writer, CIMQualifier<?> qualifier) throws XMLStreamException {
        if (null != qualifier) {
            writer.writeStartElement("QUALIFIER");
            writer.writeAttribute("NAME", qualifier.getName());
            CIMDataType cdt = qualifier.getDataType();
            writer.writeAttribute("TYPE", CIMXMLUtilities.getCIMXMLDataTypefromCIMDataType(cdt));
            if (qualifier.isPropagated()) {
                writer.writeAttribute("PROPAGATED", "true");
            } else {
                writer.writeAttribute("PROPAGATED", "false");
            }
            CIMXMLElementsWriter.writeQualifierTypeFlavors(writer, qualifier.getFlavor());
            if (null != qualifier.getValue()) {
                CIMXMLElementsWriter.writeValue(writer, qualifier.getValue());
            }
            writer.writeEndElement();
        }
    }

    public static void writeQualifierType(XMLStreamWriter writer, CIMQualifierType<?> cqt) throws XMLStreamException {
        writer.writeStartElement("QUALIFIER.DECLARATION");
        writer.writeAttribute("NAME", cqt.getName());
        CIMDataType cdt = cqt.getDataType();
        writer.writeAttribute("TYPE", CIMXMLUtilities.getCIMXMLDataTypefromCIMDataType(cdt));
        writer.writeAttribute("ISARRAY", cdt.isArray() ? "true" : "false");
        CIMXMLElementsWriter.writeQualifierTypeFlavors(writer, cqt.getFlavor());
        CIMXMLElementsWriter.writeQualifierTypeScope(writer, cqt.getScope());
        CIMXMLElementsWriter.writeValue(writer, cqt.getValue());
        writer.writeEndElement();
    }

    private static void writeQualifierTypeFlavors(XMLStreamWriter writer, int flavors) throws XMLStreamException {
        if ((flavors & 1) == 1) {
            writer.writeAttribute("OVERRIDABLE", "false");
        } else {
            writer.writeAttribute("OVERRIDABLE", "true");
        }
        if ((flavors & 2) == 2) {
            writer.writeAttribute("TOSUBCLASS", "false");
        } else {
            writer.writeAttribute("TOSUBCLASS", "true");
        }
        if ((flavors & 4) == 4) {
            writer.writeAttribute("TRANSLATABLE", "true");
        } else {
            writer.writeAttribute("TRANSLATABLE", "false");
        }
    }

    private static void writeQualifierTypeScope(XMLStreamWriter writer, int scope) throws XMLStreamException {
        writer.writeStartElement("SCOPE");
        if ((scope & 1) == 1) {
            writer.writeAttribute("CLASS", "true");
        }
        if ((scope & 2) == 2) {
            writer.writeAttribute("ASSOCIATION", "true");
        }
        if ((scope & 0x10) == 16) {
            writer.writeAttribute("REFERENCE", "true");
        }
        if ((scope & 8) == 8) {
            writer.writeAttribute("PROPERTY", "true");
        }
        if ((scope & 0x20) == 32) {
            writer.writeAttribute("METHOD", "true");
        }
        if ((scope & 0x40) == 64) {
            writer.writeAttribute("PARAMETER", "true");
        }
        if ((scope & 4) == 4) {
            writer.writeAttribute("INDICATION", "true");
        }
        writer.writeEndElement();
    }

    public static void writeValueNullForArray(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("VALUE.NULL");
        writer.writeEndElement();
    }

    public static void writeValue(XMLStreamWriter writer, Object value) throws XMLStreamException {
        if (value instanceof Object[]) {
            CIMXMLElementsWriter.writeValueArray(writer, (Object[])value);
        } else if (value instanceof CIMInstance) {
            writer.writeStartElement("VALUE");
            CIMXMLElementsWriter.writeEmbeddedInstance(writer, (CIMInstance)value);
            writer.writeEndElement();
        } else if (value instanceof CIMClass) {
            writer.writeStartElement("VALUE");
            CIMXMLElementsWriter.writeClass(writer, (CIMClass)value);
            writer.writeEndElement();
        } else if (null != value) {
            writer.writeStartElement("VALUE");
            if (value instanceof CIMDateTime) {
                writer.writeCharacters(((CIMDateTime)value).getDateTimeString());
            } else {
                writer.writeCharacters(value.toString());
            }
            writer.writeEndElement();
        }
    }

    public static void writeValueArray(XMLStreamWriter writer, Object[] values) throws XMLStreamException {
        writer.writeStartElement("VALUE.ARRAY");
        for (Object s : values) {
            if (null == s) {
                CIMXMLElementsWriter.writeValueNullForArray(writer);
                continue;
            }
            CIMXMLElementsWriter.writeValue(writer, s);
        }
        writer.writeEndElement();
    }

    public static void writeValueRefArray(XMLStreamWriter writer, CIMObjectPath[] values) throws XMLStreamException {
        writer.writeStartElement("VALUE.REFARRAY");
        for (CIMObjectPath s : values) {
            if (null == s) {
                CIMXMLElementsWriter.writeValueNullForArray(writer);
                continue;
            }
            CIMXMLElementsWriter.writeValueReference(writer, s);
        }
        writer.writeEndElement();
    }

    public static void writeValueReference(XMLStreamWriter writer, CIMObjectPath path) throws XMLStreamException {
        boolean bInstance;
        writer.writeStartElement("VALUE.REFERENCE");
        boolean bHost = path.getHost() != null;
        boolean bNamespace = path.getNamespace() != null;
        boolean bl = bInstance = path.getKeys() != null;
        if (bHost) {
            if (bInstance) {
                CIMXMLElementsWriter.writeInstancePath(writer, path);
            } else {
                CIMXMLElementsWriter.writeClassPath(writer, path);
            }
        } else if (bNamespace) {
            if (bInstance) {
                CIMXMLElementsWriter.writeLocalInstancePath(writer, path);
            } else {
                CIMXMLElementsWriter.writeLocalClassPath(writer, path);
            }
        } else if (bInstance) {
            CIMXMLElementsWriter.writeInstanceName(writer, path);
        } else {
            CIMXMLElementsWriter.writeClassName(writer, path);
        }
        writer.writeEndElement();
    }

    public static void writeException(XMLStreamWriter writer, WBEMException e) {
        try {
            writer.writeStartElement("ERROR");
            writer.writeAttribute("CODE", String.valueOf(e.getID()));
            writer.writeAttribute("DESCRIPTION", e.getMessage());
            if (null != e.getCIMErrors()) {
                for (CIMInstance i : e.getCIMErrors()) {
                    writer.writeStartElement("INSTANCE");
                    CIMXMLElementsWriter.writeInstance(writer, i);
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    public static void writeValueObjectWithPath(XMLStreamWriter writer, CIMClass clazz) throws XMLStreamException {
        writer.writeStartElement("VALUE.OBJECTWITHPATH");
        CIMXMLElementsWriter.writeClassPath(writer, clazz.getObjectPath());
        CIMXMLElementsWriter.writeClass(writer, clazz);
        writer.writeEndElement();
    }

    public static void writeValueObjectWithPath(XMLStreamWriter writer, CIMInstance instance) throws XMLStreamException {
        writer.writeStartElement("VALUE.OBJECTWITHPATH");
        CIMXMLElementsWriter.writeInstancePath(writer, instance.getObjectPath());
        CIMXMLElementsWriter.writeInstance(writer, instance);
        writer.writeEndElement();
    }

    public static void writeValueInstanceWithPath(XMLStreamWriter writer, CIMInstance instance) throws XMLStreamException {
        writer.writeStartElement("VALUE.INSTANCEWITHPATH");
        CIMXMLElementsWriter.writeInstancePath(writer, instance.getObjectPath());
        CIMXMLElementsWriter.writeInstance(writer, instance);
        writer.writeEndElement();
    }

    public static void writeValueNamedInstance(XMLStreamWriter writer, CIMInstance instance) throws XMLStreamException {
        writer.writeStartElement("VALUE.NAMEDINSTANCE");
        CIMXMLElementsWriter.writeInstanceName(writer, instance.getObjectPath());
        CIMXMLElementsWriter.writeInstance(writer, instance);
        writer.writeEndElement();
    }

    public static void writeParamValue(XMLStreamWriter writer, CIMArgument<?> arg) throws XMLStreamException {
        if (null != arg && null != arg.getValue()) {
            writer.writeStartElement("PARAMVALUE");
            writer.writeAttribute("NAME", arg.getName());
            writer.writeAttribute("PARAMTYPE", CIMXMLUtilities.getCIMXMLDataTypefromCIMDataType(arg.getDataType()));
            if (arg.getValue() instanceof CIMInstance || arg.getValue() instanceof CIMInstance[]) {
                writer.writeAttribute("EmbeddedObject", "INSTANCE".toLowerCase());
            }
            if (14 == arg.getDataType().getType()) {
                if (arg.getValue() instanceof CIMObjectPath) {
                    CIMXMLElementsWriter.writeValueReference(writer, (CIMObjectPath)arg.getValue());
                } else if (arg.getValue() instanceof CIMObjectPath[]) {
                    CIMXMLElementsWriter.writeValueRefArray(writer, (CIMObjectPath[])arg.getValue());
                }
            } else {
                CIMXMLElementsWriter.writeValue(writer, arg.getValue());
            }
            writer.writeEndElement();
        }
    }

    public static void writeInvokeMethod(XMLStreamWriter writer, CIMMethod<?> method, Object returnValue, CIMArgument<?>[] outArgs) throws XMLStreamException {
        writer.writeStartElement("RETURNVALUE");
        writer.writeAttribute("PARAMTYPE", CIMXMLUtilities.getCIMXMLDataTypefromCIMDataType(method.getDataType()));
        CIMXMLElementsWriter.writeValue(writer, returnValue);
        writer.writeEndElement();
        for (CIMArgument<?> a : outArgs) {
            if (null == a) continue;
            CIMXMLElementsWriter.writeParamValue(writer, a);
        }
    }
}

