/*
 * Decompiled with CFR 0.152.
 */
package com.ws.utilities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLServerSocketFactory;
import javax.wbem.WBEMException;

public class CipherUtilities {
    public static String[] getDefaultJavaCiphers() throws WBEMException {
        try {
            SSLServerSocketFactory sslfact = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
            return sslfact.getDefaultCipherSuites();
        }
        catch (Throwable e) {
            throw new WBEMException(1, "Could not determine enabled ciphers", null, e);
        }
    }

    public static String[] getSupportedJavaCiphers() throws WBEMException {
        try {
            SSLServerSocketFactory sslfact = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
            return sslfact.getSupportedCipherSuites();
        }
        catch (Throwable e) {
            throw new WBEMException(1, "Could not determine supported ciphers", null, e);
        }
    }

    public static String validateCiphers(String[] ciphers) throws WBEMException {
        ArrayList<String> invalidCiphers = new ArrayList<String>();
        if (null != ciphers) {
            String[] supportedCiphers = null;
            supportedCiphers = CipherUtilities.getSupportedJavaCiphers();
            List<String> cipherList = Arrays.asList(supportedCiphers);
            for (String cipher : ciphers) {
                if (cipherList.contains(cipher)) continue;
                invalidCiphers.add(cipher);
            }
        }
        if (invalidCiphers.isEmpty()) {
            return null;
        }
        return invalidCiphers.toString();
    }
}

