/*
 * Decompiled with CFR 0.152.
 */
package com.ws.utilities.commandgenerator;

import com.ws.utilities.Resources;
import com.ws.utilities.commandgenerator.CommandGenerator;
import com.ws.utilities.commandgenerator.WBEMArguments;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.cim.CIMArgument;

public class TextCommandGenerator
implements CommandGenerator {
    private static final String BUNDLE = "com.ws.utilities.commandgenerator.TextCommandGenerator";
    private static final String TEXT_FORMAT = "TEXT_FORMAT";
    private static final String COMMA_SPACE = ", ";
    private static final String EQUAL_OPERATOR = "=";
    private static final String EMPTY = "empty";
    private final Resources mResourceBundleHandle = new Resources("com.ws.utilities.commandgenerator.TextCommandGenerator");

    @Override
    public String getCommand(WBEMArguments pArguments) {
        String operation = this.mResourceBundleHandle.loadString(pArguments.getOperation().toString());
        String argumentResult = "";
        ArrayList<String> argumentList = new ArrayList<String>();
        switch (pArguments.getOperation()) {
            case ASSOCIATORS: {
                this.setAssociatorArguments(argumentList);
                break;
            }
            case ASSOCIATOR_NAMES: {
                this.setAssociatorNamesArguments(argumentList);
                break;
            }
            case REFERENCES: {
                this.setReferencesArguments(argumentList);
                break;
            }
            case REFERENCE_NAMES: {
                this.setReferenceNamesArguments(argumentList);
                break;
            }
            case ENUMERATE_INSTANCE_NAMES: {
                this.setEnumerateInstanceNamesArguments(argumentList);
                break;
            }
            case ENUMERATE_INSTANCES: {
                this.setEnumerateInstancesArguments(argumentList);
                break;
            }
            case ENUMERATE_CLASSES: {
                this.setEnumerateClassesArguments(argumentList);
                break;
            }
            case ENUMERATE_CLASS_NAMES: {
                this.setEnumerateClassNamesArguments(argumentList);
                break;
            }
            case ENUMERATE_QUALIFIER_TYPES: {
                this.setEnumerateQualifierTypesArguments(argumentList);
                break;
            }
            case EXECUTE_QUERY: {
                this.setExecQueryArguments(argumentList);
                break;
            }
            case GET_CLASS: {
                this.setGetClassArguments(argumentList);
                break;
            }
            case GET_INSTANCE: {
                this.setGetInstanceArguments(argumentList);
                break;
            }
            case GET_QUALIFIER_TYPE: {
                this.setGetQualifierTypeArguments(argumentList);
                break;
            }
            case MODIFY_INSTANCE: {
                this.setModifyInstanceArguments(argumentList);
                break;
            }
            case CREATE_INSTANCE: {
                this.setCreateInstanceArguments(argumentList);
                break;
            }
            case DELETE_CLASS: {
                this.setDeleteClassArguments(argumentList);
                break;
            }
            case DELETE_INSTANCE: {
                this.setDeleteInstanceArguments(argumentList);
                break;
            }
            case DELETE_QUALIFIER_TYPE: {
                this.setDeleteQualifierTypeArguments(argumentList);
                break;
            }
            case INVOKE_METHOD: {
                this.setInvokeMethodArguments(argumentList);
            }
        }
        argumentResult = this.getArguments(pArguments, argumentList);
        return MessageFormat.format(this.mResourceBundleHandle.loadString(TEXT_FORMAT), operation, argumentResult.toString());
    }

    private void setAssociatorArguments(ArrayList<String> pArgsList) {
        pArgsList.add("CIM_OBJECTPATH");
        pArgsList.add("ASSOCIATION_CLASS");
        pArgsList.add("RESULT_CLASS");
        pArgsList.add("ROLE");
        pArgsList.add("RESULT_ROLE");
        pArgsList.add("INCLUDE_QUALIFIERS");
        pArgsList.add("INCLUDE_CLASS_ORIGIN");
        pArgsList.add("PROPERTY_LIST");
    }

    private void setAssociatorNamesArguments(ArrayList<String> pArgsList) {
        pArgsList.add("CIM_OBJECTPATH");
        pArgsList.add("ASSOCIATION_CLASS");
        pArgsList.add("RESULT_CLASS");
        pArgsList.add("ROLE");
        pArgsList.add("RESULT_ROLE");
    }

    private void setReferencesArguments(ArrayList<String> pArgsList) {
        pArgsList.add("CIM_OBJECTPATH");
        pArgsList.add("RESULT_CLASS");
        pArgsList.add("ROLE");
        pArgsList.add("INCLUDE_QUALIFIERS");
        pArgsList.add("INCLUDE_CLASS_ORIGIN");
        pArgsList.add("PROPERTY_LIST");
    }

    private void setReferenceNamesArguments(ArrayList<String> pArgsList) {
        pArgsList.add("CIM_OBJECTPATH");
        pArgsList.add("RESULT_CLASS");
        pArgsList.add("ROLE");
    }

    private void setEnumerateInstanceNamesArguments(ArrayList<String> pArgsList) {
        pArgsList.add("CIM_OBJECTPATH");
    }

    private void setEnumerateInstancesArguments(ArrayList<String> pArgsList) {
        pArgsList.add("CIM_OBJECTPATH");
        pArgsList.add("DEEP_INHERITANCE");
        pArgsList.add("LOCALONLY");
        pArgsList.add("INCLUDE_CLASS_ORIGIN");
        pArgsList.add("PROPERTY_LIST");
    }

    private void setEnumerateClassesArguments(ArrayList<String> pArgsList) {
        pArgsList.add("CIM_OBJECTPATH");
        pArgsList.add("DEEP_INHERITANCE");
        pArgsList.add("LOCALONLY");
        pArgsList.add("INCLUDE_QUALIFIERS");
        pArgsList.add("INCLUDE_CLASS_ORIGIN");
    }

    private void setEnumerateClassNamesArguments(ArrayList<String> pArgsList) {
        pArgsList.add("CIM_OBJECTPATH");
        pArgsList.add("DEEP_INHERITANCE");
    }

    private void setEnumerateQualifierTypesArguments(ArrayList<String> pArgsList) {
        pArgsList.add("CIM_OBJECTPATH");
    }

    private void setExecQueryArguments(ArrayList<String> pArgsList) {
        pArgsList.add("CIM_OBJECTPATH");
        pArgsList.add("QUERY");
        pArgsList.add("QUERY_LANGUAGE");
    }

    private void setGetClassArguments(ArrayList<String> pArgsList) {
        pArgsList.add("CIM_OBJECTPATH");
        pArgsList.add("LOCALONLY");
        pArgsList.add("INCLUDE_QUALIFIERS");
        pArgsList.add("INCLUDE_CLASS_ORIGIN");
        pArgsList.add("PROPERTY_LIST");
    }

    private void setGetInstanceArguments(ArrayList<String> pArgsList) {
        pArgsList.add("CIM_OBJECTPATH");
        pArgsList.add("LOCALONLY");
        pArgsList.add("INCLUDE_CLASS_ORIGIN");
        pArgsList.add("PROPERTY_LIST");
    }

    private void setGetQualifierTypeArguments(ArrayList<String> pArgsList) {
        pArgsList.add("CIM_OBJECTPATH");
    }

    private void setModifyInstanceArguments(ArrayList<String> pArgsList) {
        pArgsList.add("CIM_INSTANCE");
        pArgsList.add("PROPERTY_LIST");
    }

    private void setCreateInstanceArguments(ArrayList<String> pArgsList) {
        pArgsList.add("CIM_INSTANCE");
    }

    private void setDeleteClassArguments(ArrayList<String> pArgsList) {
        pArgsList.add("CIM_OBJECTPATH");
    }

    private void setDeleteInstanceArguments(ArrayList<String> pArgsList) {
        pArgsList.add("CIM_OBJECTPATH");
    }

    private void setDeleteQualifierTypeArguments(ArrayList<String> pArgsList) {
        pArgsList.add("CIM_OBJECTPATH");
    }

    private void setInvokeMethodArguments(ArrayList<String> pArgsList) {
        pArgsList.add("CIM_OBJECTPATH");
        pArgsList.add("METHOD_NAME");
        pArgsList.add("INPUT_ARGUMENT");
        pArgsList.add("OUTPUT_ARGUMENT");
    }

    private String getArguments(WBEMArguments pArguments, ArrayList<String> pArgsList) {
        StringBuilder argumentString = new StringBuilder();
        for (String key : pArgsList) {
            CIMArgument[] cArguments;
            Object objValue = pArguments.getArgument(key);
            if (objValue == null) {
                objValue = pArguments.getArgument(key);
            }
            if (key.equals("PROPERTY_LIST") && objValue != null) {
                String[] strObj = (String[])objValue;
                if (strObj.length == 0) {
                    objValue = EMPTY;
                } else {
                    StringBuilder PropList = new StringBuilder();
                    for (int index = 0; index < strObj.length; ++index) {
                        PropList.append(strObj[index]);
                        if (index >= strObj.length - 1) continue;
                        PropList.append(COMMA_SPACE);
                    }
                    objValue = PropList.toString();
                }
            } else if ((key.equals("INPUT_ARGUMENT") || key.equals("OUTPUT_ARGUMENT")) && (cArguments = (CIMArgument[])pArguments.getArgument(key)) != null) {
                objValue = this.translateCIMArguments(cArguments, key);
            }
            argumentString.append(MessageFormat.format(this.mResourceBundleHandle.loadString(key), objValue));
        }
        return argumentString.toString();
    }

    private String translateCIMArguments(CIMArgument<?>[] pCIMArgumentArray, String pArgsType) {
        StringBuilder strCIMArguments = new StringBuilder();
        int index = 0;
        if ("INPUT_ARGUMENT".equals(pArgsType)) {
            for (CIMArgument<?> cimArg : pCIMArgumentArray) {
                strCIMArguments.append(cimArg.getName() + EQUAL_OPERATOR + cimArg.getValue());
                if (index >= pCIMArgumentArray.length - 1) continue;
                strCIMArguments.append(COMMA_SPACE);
                ++index;
            }
        } else {
            for (CIMArgument<?> cimArg : pCIMArgumentArray) {
                if (null == cimArg) continue;
                strCIMArguments.append(cimArg.getName());
                if (index >= pCIMArgumentArray.length - 1) continue;
                strCIMArguments.append(COMMA_SPACE);
                ++index;
            }
        }
        return strCIMArguments.toString();
    }
}

