/*
 * Decompiled with CFR 0.152.
 */
package com.ws.utilities.commandgenerator;

import com.ws.utilities.Resources;
import com.ws.utilities.commandgenerator.CommandGenerator;
import com.ws.utilities.commandgenerator.WBEMArguments;
import com.ws.utilities.commandgenerator.WBEMOperation;
import java.text.MessageFormat;
import java.util.Set;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;

public class WBEMOpCommandGenerator
implements CommandGenerator {
    private static final String BUNDLE = "com.ws.utilities.commandgenerator.WBEMOpCommandGenerator";
    private static final String COMMAND_FORMAT = "COMMAND_FORMAT";
    private static final String ERROR_OPERATION = "ERROR_OPERATION";
    private static final String EQUAL_OPERATOR = "=";
    private static final String DOT = ".";
    private static final String NULL = "null";
    private static final String SEMICOLON = ";";
    private static final String CLOSE_CURLY_BRACE = "}";
    private static final String OPEN_CURLY_BRACE = "{";
    private static final String COMMA = ",";
    private static final String DOUBLE_QUOT = "\"";
    private final Resources mResourceBundleHandle = new Resources("com.ws.utilities.commandgenerator.WBEMOpCommandGenerator");

    @Override
    public String getCommand(WBEMArguments pArguments) {
        if (this.isValidOperation(pArguments.getOperation()).booleanValue()) {
            return this.generateEquivalent(pArguments);
        }
        throw new IllegalArgumentException(MessageFormat.format(this.mResourceBundleHandle.loadString(ERROR_OPERATION), new Object[]{pArguments.getOperation()}));
    }

    private String generateEquivalent(WBEMArguments pArgs) {
        CIMObjectPath objPath = this.retrieveObjectPath(pArgs);
        String options = "";
        String objName = "";
        String command = "";
        if (objPath != null) {
            options = this.arrangeOptions(pArgs, objPath);
            objName = this.retrieveModelPath(objPath, pArgs.getOperation());
            command = this.commandEquivalent(objPath, pArgs);
        }
        return MessageFormat.format(this.mResourceBundleHandle.loadString(COMMAND_FORMAT), options, objName, command);
    }

    private CIMObjectPath retrieveObjectPath(WBEMArguments pArgs) {
        CIMInstance instance;
        CIMObjectPath objPath = (CIMObjectPath)pArgs.getArgument("CIM_OBJECTPATH");
        if (objPath == null && (instance = (CIMInstance)pArgs.getArgument("CIM_INSTANCE")) != null) {
            objPath = instance.getObjectPath();
        }
        return objPath;
    }

    private String commandEquivalent(CIMObjectPath pObjPath, WBEMArguments pArgs) {
        WBEMOperation operation = pArgs.getOperation();
        String opString = operation.toString();
        if (operation == WBEMOperation.CREATE_INSTANCE) {
            String keyProperties = this.retrieveKeyProperties(pObjPath.getKeys());
            if (keyProperties != null && keyProperties.length() > 0) {
                keyProperties = DOUBLE_QUOT + keyProperties + DOUBLE_QUOT;
            }
            return MessageFormat.format(this.mResourceBundleHandle.loadString(opString), keyProperties);
        }
        if (operation == WBEMOperation.MODIFY_INSTANCE) {
            String attributes = (String)pArgs.getArgument("ATTRIBUTES");
            if (attributes == null || attributes.length() <= 0) {
                attributes = "";
            }
            return MessageFormat.format(this.mResourceBundleHandle.loadString(opString), attributes);
        }
        if (operation == WBEMOperation.EXECUTE_QUERY) {
            String query = (String)pArgs.getArgument("QUERY");
            String queryLanguage = (String)pArgs.getArgument("QUERY_LANGUAGE");
            String sqlStatement = this.evaluateQuery(query, queryLanguage);
            return MessageFormat.format(this.mResourceBundleHandle.loadString(opString), sqlStatement);
        }
        return this.mResourceBundleHandle.loadString(opString);
    }

    private String arrangeOptions(WBEMArguments pArgs, CIMObjectPath pOP) {
        StringBuilder optionsStr = new StringBuilder();
        StringBuffer serverInfo = new StringBuffer().append(pOP.getScheme()).append("://").append(pOP.getHost()).append("/").append(pOP.getNamespace()).append(" ");
        pArgs.addArgument("SERVER", serverInfo);
        String server = this.retrieveOptionValue("SERVER", pArgs);
        String pricipal = this.retrieveOptionValue("PRINCIPAL", pArgs);
        String otherOptions = this.getOtherOptions(pArgs);
        optionsStr.append(pricipal);
        optionsStr.append(server);
        optionsStr.append(otherOptions);
        return optionsStr.toString();
    }

    private String getOtherOptions(WBEMArguments pArgs) {
        StringBuilder otherOptions = new StringBuilder();
        Set<String> keys = pArgs.getArgumentKeys();
        for (String key : keys) {
            if (!this.isOptionValid(key).booleanValue()) continue;
            String option = "";
            if ("DISPLAY_XML_DEBUG_INFO".equals(key) || "PRINT_USAGE_STATEMENT".equals(key) || "LOCALONLY".equals(key) || "PRINT_VERSION".equals(key) || "PRINT_RESULT_IN_XML".equals(key)) {
                if (((Boolean)pArgs.getArgument(key)).booleanValue()) {
                    option = this.mResourceBundleHandle.loadString(key);
                }
            } else if ("INCLUDE_CLASS_ORIGIN".equals(key) || "INCLUDE_QUALIFIERS".equals(key) || "DEEP_INHERITANCE".equals(key) || "LOCALONLY".equals(key)) {
                if (!((Boolean)pArgs.getArgument(key)).booleanValue()) {
                    option = this.mResourceBundleHandle.loadString(key);
                }
            } else if (key.equals("PROPERTY_LIST")) {
                String[] strObj = (String[])pArgs.getArgument(key);
                if (strObj != null && strObj.length > 0) {
                    StringBuilder PropList = new StringBuilder();
                    for (int index = 0; index < strObj.length; ++index) {
                        PropList.append(strObj[index]);
                        if (index >= strObj.length - 1) continue;
                        PropList.append(COMMA);
                    }
                    option = MessageFormat.format(this.mResourceBundleHandle.loadString(key), PropList.toString());
                }
            } else {
                option = MessageFormat.format(this.mResourceBundleHandle.loadString(key), pArgs.getArgument(key));
            }
            otherOptions.append(option);
        }
        return otherOptions.toString();
    }

    private String retrieveOptionValue(String pKey, WBEMArguments pArgs) {
        Object result = pArgs.getArgument(pKey);
        if (result != null) {
            return MessageFormat.format(this.mResourceBundleHandle.loadString(pKey), pArgs.getArgument(pKey));
        }
        return "";
    }

    private String retrieveModelPath(CIMObjectPath pObjPath, WBEMOperation pOperation) {
        if (pOperation == WBEMOperation.CREATE_INSTANCE || pOperation == WBEMOperation.ENUMERATE_INSTANCE_NAMES) {
            return pObjPath.getObjectName();
        }
        CIMProperty[] keyProps = pObjPath.getKeys();
        String strKeyProps = this.retrieveKeyProperties(keyProps);
        if (strKeyProps != null && strKeyProps.length() > 0) {
            return pObjPath.getObjectName() + DOT + strKeyProps;
        }
        return pObjPath.getObjectName();
    }

    private String retrieveKeyProperties(CIMProperty<?>[] pPropArray) {
        StringBuilder strKeyProps = new StringBuilder("");
        int index = 0;
        if (pPropArray != null && pPropArray.length > 0) {
            for (CIMProperty<?> kProp : pPropArray) {
                strKeyProps.append(kProp.getName());
                strKeyProps.append(EQUAL_OPERATOR);
                if (kProp.getValue() != null) {
                    if (kProp.getDataType().getType() == 14) {
                        strKeyProps.append(kProp.getDataType().getRefClassName());
                    } else if (kProp.getDataType().isArray()) {
                        Object[] arr = (Object[])kProp.getValue();
                        strKeyProps.append(OPEN_CURLY_BRACE);
                        for (int j = 0; j < arr.length; ++j) {
                            strKeyProps.append(arr[j].toString());
                            if (j >= arr.length - 1) continue;
                            strKeyProps.append(SEMICOLON);
                        }
                        strKeyProps.append(CLOSE_CURLY_BRACE);
                    } else {
                        strKeyProps.append(kProp.getValue().toString());
                    }
                } else {
                    strKeyProps.append(NULL);
                }
                if (index >= pPropArray.length - 1) continue;
                strKeyProps.append(COMMA);
                ++index;
            }
        }
        return strKeyProps.toString();
    }

    private String evaluateQuery(String pQuery, String pQueryLanguage) {
        StringBuilder sqlStatement = new StringBuilder("");
        if (pQuery != null && pQuery.length() > 0 && pQueryLanguage != null && pQueryLanguage.length() > 0) {
            sqlStatement.append(DOUBLE_QUOT + pQuery + DOUBLE_QUOT);
            sqlStatement.append(COMMA);
            sqlStatement.append(DOUBLE_QUOT + pQueryLanguage + DOUBLE_QUOT);
        } else if (pQuery != null && pQuery.length() > 0) {
            sqlStatement.append(DOUBLE_QUOT + pQuery + DOUBLE_QUOT);
        } else if (pQueryLanguage != null && pQueryLanguage.length() > 0) {
            sqlStatement.append(DOUBLE_QUOT + pQueryLanguage + DOUBLE_QUOT);
        }
        return sqlStatement.toString();
    }

    private Boolean isOptionValid(String pOption) {
        if ("ASSOCIATION_CLASS".equals(pOption) || "ASSOCIATION_ROLE".equals(pOption) || "INCLUDE_CLASS_ORIGIN".equals(pOption) || "DISPLAY_XML_DEBUG_INFO".equals(pOption) || "DEEP_INHERITANCE".equals(pOption) || "FILTER".equals(pOption) || "PRINT_USAGE_STATEMENT".equals(pOption) || "KEYSTORE_FILE".equals(pOption) || "KEYSTORE_PASSWORD".equals(pOption) || "LOCALE_LIST".equals(pOption) || "LOCALONLY".equals(pOption) || "INCLUDE_QUALIFIERS".equals(pOption) || "HTTP_PROXY_HOST".equals(pOption) || "PROPERTY_LIST".equals(pOption) || "HTTP_PROXY_PORT".equals(pOption) || "QUERY_LANGUAGE".equals(pOption) || "RESULT_CLASS".equals(pOption) || "WBEM_SERVER_ROLE_CREDENTIAL".equals(pOption) || "WBEM_SERVER_ROLE_PRINCIPAL".equals(pOption) || "RESULT_ROLE".equals(pOption) || "TRUSTSTRORE_FILE".equals(pOption) || "PRINT_VERSION".equals(pOption) || "WBEM_PROTOCOL".equals(pOption) || "PRINT_RESULT_IN_XML".equals(pOption) || "DISPLAY_METHODS".equals(pOption)) {
            return true;
        }
        return false;
    }

    private Boolean isValidOperation(WBEMOperation pOperation) {
        boolean ret = true;
        if (pOperation == WBEMOperation.INVOKE_METHOD) {
            ret = true;
        }
        return ret;
    }
}

