/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem;

import com.ws.wbem.CloseableLinkedBlockingQueue;
import com.ws.wbem.jserver.JServerProperties;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;

public class CloseableAddableIterator<E>
implements CloseableIterator<E> {
    private static final long NUM_BYTES_IN_MB = 0x100000L;
    private int MAX_OBJECTS_DEFAULT;
    private static final int MAX_OBJECTS_MAX = Integer.MAX_VALUE;
    private static final int MAX_OBJECTS_MIN = 100;
    private static final long FREE_MEMORY_THRESHOLD_DEFAULT = 10L;
    private static final long FREE_MEMORY_THRESHOLD_MAX = 20L;
    private static final long FREE_MEMORY_THRESHOLD_MIN = 4L;
    private static final int MAX_SECONDS_TO_WAIT_DEFAULT = 30;
    private static final int MAX_SECONDS_TO_WAIT_MIN = 3;
    private static final Logger mLogger = Logger.getLogger("com.ws.wbem.jserver");
    private final int mMaxObjects;
    private final int mMaxSecondsToWait;
    private long minMegaBytesFreeAllowed;
    private final CloseableLinkedBlockingQueue<E> mQueue = new CloseableLinkedBlockingQueue();

    public CloseableAddableIterator() {
        this(10L, -1, 30);
    }

    public CloseableAddableIterator(Collection<E> collection) {
        this(10L, collection.size(), 30);
        this.mQueue.addAll(collection);
        this.done();
    }

    @Deprecated
    public CloseableAddableIterator(Iterator<E> anIter) {
        this(10L, Integer.MAX_VALUE, 30);
        if (anIter instanceof List) {
            this.mQueue.addAll((List)((Object)anIter));
        } else if (anIter != null) {
            while (anIter.hasNext()) {
                this.mQueue.add(anIter.next());
            }
        }
        this.mQueue.done();
    }

    public CloseableAddableIterator(long memoryThreshold) {
        this(memoryThreshold, -1, 30);
    }

    public CloseableAddableIterator(long memoryThreshold, int maxObjects) {
        this(memoryThreshold, maxObjects, 30);
    }

    public CloseableAddableIterator(long memoryThreshold, int maxObjects, int maxSecondsToWait) {
        if (memoryThreshold < 4L) {
            mLogger.log(Level.WARNING, "Memory threshold ({0}mb) is too small, defaulting to {1}", new Object[]{memoryThreshold, 4L});
            this.minMegaBytesFreeAllowed = 4L;
        } else if (memoryThreshold > 20L) {
            mLogger.log(Level.WARNING, "Memory threshold ({0}mb) is too big, defaulting to {1}", new Object[]{memoryThreshold, 20L});
            this.minMegaBytesFreeAllowed = 20L;
        } else {
            mLogger.log(Level.FINE, "Memory threshold ({0}mb) will be used", memoryThreshold);
            this.minMegaBytesFreeAllowed = memoryThreshold;
        }
        this.minMegaBytesFreeAllowed *= 0x100000L;
        try {
            this.MAX_OBJECTS_DEFAULT = JServerProperties.getMaxObjectsPerPullRequest();
        }
        catch (NoClassDefFoundError ncf) {
            mLogger.log(Level.FINEST, ncf + ", this is OK on a client", ncf);
            this.MAX_OBJECTS_DEFAULT = 5000;
        }
        catch (Throwable t) {
            mLogger.log(Level.SEVERE, "Unexpected Exception: " + t, t);
            this.MAX_OBJECTS_DEFAULT = 5000;
        }
        this.mMaxObjects = maxObjects < 100 || maxObjects > Integer.MAX_VALUE ? this.MAX_OBJECTS_DEFAULT : maxObjects;
        this.mMaxSecondsToWait = maxSecondsToWait < 3 ? 30 : maxSecondsToWait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(E o) {
        if (this.isDone()) {
            Exception e = new Exception("Add called on iterator marked done");
            mLogger.log(Level.WARNING, "", e);
            return;
        }
        this.doThrottle();
        if (null == this.mQueue.getException()) {
            CloseableLinkedBlockingQueue<E> closeableLinkedBlockingQueue = this.mQueue;
            synchronized (closeableLinkedBlockingQueue) {
                this.mQueue.add(o);
                this.mQueue.notifyAll();
            }
        }
    }

    private boolean checkAvailMem(long[] availableMemory) {
        Runtime rt = Runtime.getRuntime();
        long totalMem = rt.totalMemory();
        long freeMem = rt.freeMemory();
        long maxMem = rt.maxMemory();
        long availMem = freeMem + maxMem - totalMem;
        if (null != availableMemory && availableMemory.length > 0) {
            availableMemory[0] = availMem / 0x100000L;
        }
        return this.minMegaBytesFreeAllowed <= availMem;
    }

    public void close() {
        this.mQueue.clear();
        this.mQueue.close();
        this.mQueue.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        this.mQueue.done();
        CloseableLinkedBlockingQueue<E> closeableLinkedBlockingQueue = this.mQueue;
        synchronized (closeableLinkedBlockingQueue) {
            this.mQueue.notifyAll();
        }
    }

    private void doThrottle() {
        long[] availableMemory = new long[]{0L};
        long count = 0L;
        boolean memoryAvail = this.checkAvailMem(availableMemory);
        int numSecondsToWait = 0;
        while (!(this.isClosed() || memoryAvail && this.mQueue.size() < this.mMaxObjects)) {
            if (++numSecondsToWait > this.mMaxSecondsToWait) {
                String msg = String.format("Timeout while waiting to add to Queue! MaxObjects=%d, Min Available Memory= %dMB, MaxWait= %d, Size of Queue= %d, Available memory= %d", this.mMaxObjects, this.minMegaBytesFreeAllowed, this.mMaxSecondsToWait, this.mQueue.size(), availableMemory[0]);
                this.setException(new WBEMException(1, msg));
                continue;
            }
            if (!memoryAvail && count++ % 10L == 0L) {
                System.gc();
            }
            try {
                mLogger.log(Level.FINE, "CAI Queue size ({0}) or free memory ({1}MB) is insufficent to insert into iterator, will try again in a moment", new Object[]{this.mQueue.size(), availableMemory[0]});
                Thread.sleep(1000L);
            }
            catch (Throwable t) {
                mLogger.log(Level.WARNING, "Caught exception waiting on queue add - this is informational only", t);
            }
            memoryAvail = this.checkAvailMem(availableMemory);
        }
    }

    public WBEMException getWBEMException() {
        return this.mQueue.getException();
    }

    public boolean hasNext() {
        boolean ret = false;
        boolean exitLoop = false;
        while (!exitLoop) {
            try {
                ret = this.hasNext(1000L);
                exitLoop = true;
            }
            catch (TimeoutException e) {
                exitLoop = false;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext(long timeoutMillis) throws TimeoutException {
        boolean ret = true;
        int loop = 0;
        do {
            if (null == this.mQueue.getException()) {
                if (0 != this.mQueue.size()) continue;
                if (!this.mQueue.isDone()) {
                    if (0 == loop) {
                        CloseableLinkedBlockingQueue<E> closeableLinkedBlockingQueue = this.mQueue;
                        synchronized (closeableLinkedBlockingQueue) {
                            try {
                                this.mQueue.wait(timeoutMillis);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    throw new TimeoutException("hasNext timed out");
                }
                if (0 == this.mQueue.size()) {
                    ret = false;
                    continue;
                }
                ret = true;
                continue;
            }
            throw new RuntimeException(this.mQueue.getException().getMessage(), this.mQueue.getException());
        } while (0 == loop++);
        return ret;
    }

    public boolean isClosed() {
        return this.mQueue.isClosed();
    }

    public boolean isDone() {
        return this.mQueue.isDone();
    }

    public E next() {
        try {
            Object ret = this.mQueue.take();
            return ret;
        }
        catch (InterruptedException e) {
            this.mQueue.close();
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void remove() {
    }

    public void setException(WBEMException we) {
        this.mQueue.setException(we);
        this.mQueue.close();
    }

    public String toString() {
        return "CloseableAddableIterator [Done=" + this.mQueue.isDone() + ", Closed=" + this.mQueue.isClosed() + ", Size=" + this.mQueue.size() + ", mMaxObjects=" + this.mMaxObjects + ", mMaxSecondsToWait=" + this.mMaxSecondsToWait + ", minMegaBytesFreeAllowed=" + this.minMegaBytesFreeAllowed + ", Hash=" + this.hashCode() + "]";
    }
}

