/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.query;

import com.ws.wbem.query.WBEMQuery;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class WBEMQueryLanguageFactory {
    private static final String FILE_NAME = "com.ws.wbem.query.WBEMQueryLanguageFactory";
    private static final String NAME_KEY = "query.name.";
    private static final String CLASS_KEY = "query.class.";
    private static final String ERR_QUERY_INVALID = "Invalid Query Language name.";
    private static final String ERR_QL_NOT_SUPPORTED = "Query Language not supported";
    private static final String ERR_QL_NOT_LOADED = "Query Language class could not be loaded";

    public static WBEMQuery getQuery(String name) {
        String protocol_key;
        if (null == name || name.trim().length() == 0) {
            throw new IllegalArgumentException(ERR_QUERY_INVALID);
        }
        Properties properties = WBEMQueryLanguageFactory.loadProperties(FILE_NAME);
        String protocol_value = properties.getProperty(protocol_key = NAME_KEY + name.toLowerCase().replace(":", "_"));
        if (protocol_value == null) {
            throw new IllegalArgumentException(ERR_QL_NOT_SUPPORTED);
        }
        String classname = properties.getProperty(CLASS_KEY + name.toLowerCase().replace(":", "_"));
        Class<?> cl = null;
        try {
            cl = Class.forName(classname);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Query Language class could not be loaded:" + classname);
        }
        WBEMQuery cc = null;
        try {
            Class[] paramTypes = new Class[]{};
            Object[] paramList = new Object[]{};
            Constructor<?> ctr = cl.getConstructor(paramTypes);
            cc = (WBEMQuery)ctr.newInstance(paramList);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        return cc;
    }

    public static String[] getQueryLanguageNames() {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            Properties properties = WBEMQueryLanguageFactory.loadProperties(FILE_NAME);
            Enumeration<Object> e = properties.keys();
            while (e.hasMoreElements()) {
                String k = (String)e.nextElement();
                if (!k.startsWith(NAME_KEY)) continue;
                String value = properties.getProperty(k);
                ret.add(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret.toArray(new String[ret.size()]);
    }

    private static Properties loadProperties(String bundle) {
        Properties props = new Properties();
        PropertyResourceBundle prb = (PropertyResourceBundle)ResourceBundle.getBundle(bundle, new Locale("", ""));
        if (prb != null) {
            Enumeration<String> en = prb.getKeys();
            while (en.hasMoreElements()) {
                String key = en.nextElement();
                if (key == null) continue;
                try {
                    String val = prb.getString(key);
                    props.setProperty(key, val);
                }
                catch (Exception exception) {}
            }
        }
        return props;
    }
}

