/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.query.fql;

import com.ws.utilities.wbem.ValueHelper;
import com.ws.wbem.query.fql.ArrayOperator;
import com.ws.wbem.query.fql.FQLExpression;
import com.ws.wbem.query.fql.ScalarOperator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTime;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.cim.UnsignedInteger8;

public class FQLPropertyCompareExpression
implements FQLExpression {
    protected final String mPropertyName;
    protected final int mPropertyIndex;
    protected final String mValue;
    protected final ScalarOperator mScalarOperator;
    protected final ArrayOperator mArrayOperator;
    protected final boolean mLike;
    protected final boolean mNot;
    protected final boolean mIsArrayProp;
    protected final boolean mIsValuePropertyName;
    protected final Pattern mPattern;
    private final String NULL = "NULL";
    private final String TRUE = "TRUE";
    private final String FALSE = "FALSE";

    public FQLPropertyCompareExpression(String propertyName, String value, ScalarOperator operator, ArrayOperator arrayOperator, boolean like, boolean not) {
        this.mScalarOperator = operator;
        this.mArrayOperator = arrayOperator;
        this.mLike = like;
        this.mNot = not;
        this.mPropertyName = this.getPropertyName(propertyName);
        this.mPropertyIndex = this.getPropertyIndex(propertyName);
        this.mIsArrayProp = null != arrayOperator || this.mPropertyIndex != -1 || value.charAt(0) == '{';
        char startChar = value.trim().charAt(0);
        this.mIsValuePropertyName = !value.equalsIgnoreCase("NULL") && !Character.isDigit(startChar) && startChar != '\"' && startChar != '\'' && startChar != '{' && !value.equalsIgnoreCase("TRUE") && !value.equalsIgnoreCase("FALSE");
        this.mValue = this.cleanValue(value);
        this.mPattern = like ? Pattern.compile(this.mValue) : null;
    }

    private String cleanValue(String value) {
        String ret = value;
        if (value.startsWith("'") || value.startsWith("\"")) {
            ret = ret.substring(1);
        }
        if (value.endsWith("'") || value.endsWith("\"")) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    private String getPropertyName(String propertyName) {
        String ret = null;
        if (null != propertyName) {
            int index = propertyName.indexOf(91);
            ret = index > 0 ? propertyName.substring(0, index) : propertyName;
        }
        return ret;
    }

    private int getPropertyIndex(String propertyName) {
        int endIndex;
        int startIndex;
        int ret = -1;
        if (null != propertyName && (startIndex = propertyName.indexOf(91)) > 0 && (endIndex = propertyName.indexOf(93)) > startIndex) {
            String val = propertyName.substring(startIndex + 1, endIndex);
            try {
                ret = Integer.parseInt(val);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException();
            }
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean evaluate(CIMInstance ci) {
        boolean ret = false;
        if (null == ci) return ret;
        CIMProperty prop = ci.getProperty(this.mPropertyName);
        if (null == prop) return ret;
        CIMDataType cdt = prop.getDataType();
        if (cdt.isArray()) {
            Object[] propValue = (Object[])prop.getValue();
            if (this.mArrayOperator != null) {
                return this.doArrayCompareExpression(ci, propValue, cdt);
            }
            if (this.mPropertyIndex != -1) {
                if (propValue.length <= this.mPropertyIndex) {
                    return false;
                }
                if (this.mLike) {
                    Matcher matcher = this.mPattern.matcher(propValue[this.mPropertyIndex].toString());
                    ret = matcher.find();
                    if (!this.mNot) return ret;
                    if (ret) return false;
                    return true;
                }
                Object compareValue = this.getScalarPropertyValue(ci, cdt);
                return this.compareValues(propValue[this.mPropertyIndex], compareValue, cdt, this.mScalarOperator);
            }
            Object[] compareValue = null;
            if (!this.mIsValuePropertyName) {
                if (!this.mValue.equalsIgnoreCase("NULL")) {
                    compareValue = this.parseArrayString(cdt, this.mValue);
                }
            } else {
                compareValue = (Object[])ci.getPropertyValue(this.mValue);
            }
            ret = this.arraysEqualNoOrder(propValue, compareValue);
            if (ScalarOperator.NotEquals != this.mScalarOperator) return ret;
            if (ret) return false;
            return true;
        }
        if (this.mIsArrayProp) {
            throw new IllegalArgumentException();
        }
        Object propValue = prop.getValue();
        if (this.mLike) {
            try {
                Pattern pattern = Pattern.compile(this.mValue);
                Matcher matcher = pattern.matcher(propValue.toString());
                ret = matcher.find();
                if (!this.mNot) return ret;
                if (ret) return false;
                return true;
            }
            catch (PatternSyntaxException pse) {
                throw new IllegalArgumentException("Invalid Query:" + pse.getMessage());
            }
        }
        Object compareValue = this.getScalarPropertyValue(ci, cdt);
        return this.compareValues(propValue, compareValue, cdt, this.mScalarOperator);
    }

    private Object[] parseArrayString(CIMDataType cdt, String arrayString) {
        ArrayList<Object> objList = new ArrayList<Object>();
        if (arrayString.startsWith("{") && arrayString.endsWith("}")) {
            StringTokenizer stt = new StringTokenizer(arrayString.substring(1, arrayString.length() - 1), ",");
            while (stt.hasMoreTokens()) {
                objList.add(ValueHelper.typeConvert(this.getDataType(cdt), stt.nextToken()));
            }
        } else {
            throw new IllegalArgumentException();
        }
        return objList.toArray(new Object[objList.size()]);
    }

    public boolean doArrayCompareExpression(CIMInstance ci, Object[] propertyArrayValue, CIMDataType cdt) {
        boolean ret = false;
        Object compareValue = this.getScalarPropertyValue(ci, cdt);
        ret = this.mArrayOperator == ArrayOperator.EVERY;
        for (Object propValue : propertyArrayValue) {
            boolean compare = this.compareValues(propValue, compareValue, cdt, this.mScalarOperator);
            if (!compare) {
                if (this.mArrayOperator != ArrayOperator.EVERY) continue;
                ret = false;
                break;
            }
            if (this.mArrayOperator != ArrayOperator.ANY) continue;
            ret = true;
            break;
        }
        if (this.mNot) {
            ret = !ret;
        }
        return ret;
    }

    private Object getScalarPropertyValue(CIMInstance ci, CIMDataType cdt) {
        Object ret = null;
        if (!this.mIsValuePropertyName) {
            if (!this.mValue.equalsIgnoreCase("NULL")) {
                ret = ValueHelper.typeConvert(this.getDataType(cdt), this.mValue);
            }
        } else {
            String valuePropertyName = this.getPropertyName(this.mValue);
            int valuePropertyIndex = this.getPropertyIndex(this.mValue);
            if (valuePropertyIndex == -1) {
                ret = ci.getPropertyValue(valuePropertyName);
            } else {
                Object[] arrayVal = (Object[])ci.getPropertyValue(valuePropertyName);
                if (null == arrayVal || arrayVal.length <= valuePropertyIndex) {
                    return false;
                }
                ret = arrayVal[valuePropertyIndex];
            }
        }
        return ret;
    }

    private boolean compareValues(Object propValue, Object compareValue, CIMDataType dataType, ScalarOperator operator) {
        boolean ret = false;
        try {
            if (null != propValue) {
                int compare = this.compareTo(propValue, compareValue, dataType);
                switch (operator) {
                    case Equals: {
                        ret = compare == 0;
                        break;
                    }
                    case NotEquals: {
                        ret = compare != 0;
                        break;
                    }
                    case GreaterThen: {
                        ret = compare > 0;
                        break;
                    }
                    case LessThen: {
                        ret = compare < 0;
                        break;
                    }
                    case GreaterThenOrEqual: {
                        ret = compare >= 0;
                        break;
                    }
                    case LessThenOrEqual: {
                        ret = compare <= 0;
                    }
                }
            } else {
                switch (operator) {
                    case Equals: {
                        ret = null == compareValue;
                        break;
                    }
                    case NotEquals: {
                        ret = null != compareValue;
                        break;
                    }
                    default: {
                        ret = false;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    private int compareTo(Object value1, Object value2, CIMDataType dataType) {
        int compareTo = 0;
        switch (dataType.getType()) {
            case 12: {
                compareTo = ((CIMDateTime)value1).compareTo((Object)((CIMDateTime)value2));
                break;
            }
            case 0: {
                compareTo = ((UnsignedInteger8)value1).compareTo((UnsignedInteger8)value2);
                break;
            }
            case 2: {
                compareTo = ((UnsignedInteger16)value1).compareTo((UnsignedInteger16)value2);
                break;
            }
            case 4: {
                compareTo = ((UnsignedInteger32)value1).compareTo((UnsignedInteger32)value2);
                break;
            }
            case 6: {
                compareTo = ((UnsignedInteger64)value1).compareTo((UnsignedInteger64)value2);
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                compareTo = value1.equals(value2) ? 0 : -1;
                break;
            }
            case 10: {
                compareTo = ((Float)value1).compareTo((Float)value2);
                break;
            }
            case 11: {
                compareTo = ((Double)value1).compareTo((Double)value2);
                break;
            }
            case 1: {
                compareTo = ((Byte)value1).compareTo((Byte)value2);
                break;
            }
            case 3: {
                compareTo = ((Short)value1).compareTo((Short)value2);
                break;
            }
            case 5: {
                compareTo = ((Byte)value1).compareTo((Byte)value2);
                break;
            }
            case 7: {
                compareTo = ((Byte)value1).compareTo((Byte)value2);
                break;
            }
            case 14: {
                compareTo = ((CIMObjectPath)value1).equalsModelPath((CIMObjectPath)value2) ? 0 : -1;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return compareTo;
    }

    private boolean arraysEqualNoOrder(Object[] array1, Object[] array2) {
        boolean ret = false;
        if (null != array1 && null != array2 && array1.length == array2.length) {
            Arrays.sort(array1);
            Arrays.sort(array2);
            ret = Arrays.equals(array1, array2);
        } else if (null == array1 && null == array2) {
            ret = true;
        }
        return ret;
    }

    private CIMDataType getDataType(CIMDataType cdt) throws IllegalArgumentException {
        if (cdt == null) {
            throw new IllegalArgumentException();
        }
        switch (cdt.getType()) {
            case 9: {
                return CIMDataType.BOOLEAN_T;
            }
            case 13: {
                return CIMDataType.CHAR16_T;
            }
            case 12: {
                return CIMDataType.DATETIME_T;
            }
            case 10: {
                return CIMDataType.REAL32_T;
            }
            case 11: {
                return CIMDataType.REAL64_T;
            }
            case 3: {
                return CIMDataType.SINT16_T;
            }
            case 5: {
                return CIMDataType.SINT32_T;
            }
            case 7: {
                return CIMDataType.SINT64_T;
            }
            case 1: {
                return CIMDataType.SINT8_T;
            }
            case 8: {
                return CIMDataType.STRING_T;
            }
            case 2: {
                return CIMDataType.UINT16_T;
            }
            case 4: {
                return CIMDataType.UINT32_T;
            }
            case 6: {
                return CIMDataType.UINT64_T;
            }
            case 0: {
                return CIMDataType.UINT8_T;
            }
        }
        return CIMDataType.STRING_T;
    }
}

