/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com.restoreview.light;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sanproject.client.com.restoreview.TableComponentParser;
import sanproject.client.com.restoreview.UnsupportedComponentException;
import sanproject.client.com.restoreview.light.LightTableViewRestorer;
import sanproject.client.com.restoreview.utility.CollectionUtilities;

public class LightTableComponentParser
implements TableComponentParser {
    private JTable analysisComponent = null;
    private Map analysisRowMap = new HashMap(0);
    private Map analysisColumnMap = new HashMap(0);

    public synchronized int searchTableRow(Object[] objectArray) {
        String string;
        JTable jTable;
        int n = -1;
        if (objectArray != null && (jTable = (JTable)this.getAnalysisComponent()) != null && this.analysisRowMap.containsKey(string = this.createRowMapKey(objectArray))) {
            Integer n2 = (Integer)this.analysisRowMap.get(string);
            n = n2;
        }
        return n;
    }

    public synchronized TableColumn findColumn(Object object) {
        String string;
        JTable jTable;
        TableColumn tableColumn = null;
        if (object != null && (jTable = (JTable)this.getAnalysisComponent()) != null && this.analysisColumnMap.containsKey(string = this.createColumnMapKey(object))) {
            tableColumn = (TableColumn)this.analysisColumnMap.get(string);
        }
        return tableColumn;
    }

    public synchronized void setAnalysisComponent(Component component) throws UnsupportedComponentException {
        int n;
        if (component != null && !(component instanceof JTable)) {
            String string = "Any components other than 'javax.swing.JTable' are not supported.";
            throw new UnsupportedComponentException(string);
        }
        this.analysisComponent = (JTable)component;
        long l = System.currentTimeMillis();
        Map map = this.createRowMap(this.analysisComponent);
        if (map == null || map.isEmpty()) {
            this.analysisRowMap.clear();
            n = 0;
        } else {
            this.analysisRowMap = new HashMap(map);
            n = map.size();
        }
        this.debugPrint("row map : create time=" + (System.currentTimeMillis() - l) + "ms. " + "size=" + n);
        l = System.currentTimeMillis();
        map = this.createColumnMap(this.analysisComponent);
        if (map == null || map.isEmpty()) {
            this.analysisColumnMap.clear();
            n = 0;
        } else {
            this.analysisColumnMap = new HashMap(map);
            n = map.size();
        }
        this.debugPrint("column map : create time=" + (System.currentTimeMillis() - l) + "ms. " + "size=" + n);
    }

    protected synchronized Component getAnalysisComponent() {
        JTable jTable = this.analysisComponent;
        return jTable;
    }

    protected Map createRowMap(JTable jTable) {
        HashMap<String, Integer> hashMap = null;
        if (jTable != null) {
            int n = jTable.getRowCount();
            int n2 = jTable.getColumnCount();
            int n3 = CollectionUtilities.getHashModerateSize(n);
            hashMap = new HashMap<String, Integer>(n3);
            for (int i = 0; i < n; ++i) {
                Object[] objectArray = new Object[n2];
                for (int j = 0; j < n2; ++j) {
                    int n4 = jTable.convertColumnIndexToModel(j);
                    objectArray[n4] = jTable.getValueAt(i, j);
                }
                String string = this.createRowMapKey(objectArray);
                Integer n5 = new Integer(i);
                if (hashMap.containsKey(string)) {
                    System.err.println("found overlapping key [" + string + "].");
                    continue;
                }
                hashMap.put(string, n5);
            }
        }
        return hashMap;
    }

    protected Map createColumnMap(JTable jTable) {
        HashMap<String, TableColumn> hashMap = null;
        if (jTable != null) {
            int n = jTable.getColumnCount();
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            int n2 = CollectionUtilities.getHashModerateSize(n);
            hashMap = new HashMap<String, TableColumn>(n2);
            for (int i = 0; i < n; ++i) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                Object object = tableColumn.getIdentifier();
                String string = this.createColumnMapKey(object);
                if (hashMap.containsKey(string)) {
                    System.err.println("found overlapping key [" + string + "].");
                    continue;
                }
                hashMap.put(string, tableColumn);
            }
        }
        return hashMap;
    }

    protected String createRowMapKey(Object[] objectArray) {
        StringBuffer stringBuffer = null;
        if (objectArray != null) {
            stringBuffer = new StringBuffer();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                String string = object.toString();
                stringBuffer.append(string);
                stringBuffer.append(", ");
            }
        }
        String string = null;
        if (stringBuffer != null) {
            string = stringBuffer.toString();
        }
        return string;
    }

    protected String createColumnMapKey(Object object) {
        String string = null;
        if (object != null) {
            string = object.toString();
        }
        return string;
    }

    protected void debugPrint(String string) {
        String string2 = this.getClass().getName();
        LightTableViewRestorer.debugPrint("<" + string2 + ">" + string);
    }
}

