/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataException;
import sanproject.client.data.RJDataLDEVPart;
import sanproject.client.exdevice.data.CuIndexComparator;
import sanproject.client.exdevice.data.EXDException;
import sanproject.client.exdevice.data.LprManager;
import sanproject.client.exdevice.data.Singleton;
import sanproject.client.exdevice.data.SingletonManager;
import sanproject.client.exdevice.data.SsidInfo;
import sanproject.common.Robj_interface_RJiCUIndex;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.common.Robj_interface_RJiLDEVInfoDetail;
import sanproject.common.Robj_interface_RJiSSIDInfo;
import sanproject.common.Robj_interface_RJiSSIDInfoDetail;
import sanproject.serverux.dataimpl.RJiSSIDInfo;

public class SsidManager
implements Singleton {
    private static final String LOG_NAME = "SsidManager";
    static int SSID_BOUNDARY;
    static int SSID_BOUNDARY_MASK;
    private int SSID_BOUNDAY_IN_CU;
    private static Comparator mCuIndexComparator;
    ArrayList mUsableSsidList = new ArrayList();
    ArrayList mSsidInfoList = new ArrayList();
    private SsidInfo mCacheGetSsidInfo = null;
    static /* synthetic */ Class class$sanproject$client$exdevice$data$SsidManager;

    SsidManager() {
    }

    public static synchronized SsidManager getInstance() {
        return (SsidManager)SingletonManager.getInstance(class$sanproject$client$exdevice$data$SsidManager == null ? (class$sanproject$client$exdevice$data$SsidManager = SsidManager.class$("sanproject.client.exdevice.data.SsidManager")) : class$sanproject$client$exdevice$data$SsidManager);
    }

    public void destroy() {
    }

    void initialize() throws EXDException {
        Robj_interface_RJiSSIDInfoDetail robj_interface_RJiSSIDInfoDetail;
        Robj_interface_RJiSSIDInfo[] robj_interface_RJiSSIDInfoArray;
        this.mCacheGetSsidInfo = null;
        this.mSsidInfoList.clear();
        RJDataControl rJDataControl = RJDataControl.getDataControl();
        RJDataLDEVPart rJDataLDEVPart = rJDataControl.getLDEVPart();
        this.mUsableSsidList = new ArrayList(SsidInfo.SSID_MAX - SsidInfo.SSID_MIN + 1);
        for (int i = SsidInfo.SSID_MIN; i <= SsidInfo.SSID_MAX; ++i) {
            robj_interface_RJiSSIDInfoArray = new Integer(i);
            this.mUsableSsidList.add(robj_interface_RJiSSIDInfoArray);
        }
        try {
            robj_interface_RJiSSIDInfoDetail = rJDataLDEVPart.getSSIDInfoDetail();
        }
        catch (RJDataException rJDataException) {
            throw new EXDException(rJDataException.getErrPart(), rJDataException.getErrCode());
        }
        SSID_BOUNDARY = robj_interface_RJiSSIDInfoDetail.getSSSIDBoundary();
        SSID_BOUNDARY_MASK = ~(SSID_BOUNDARY - 1);
        this.SSID_BOUNDAY_IN_CU = 256 / SSID_BOUNDARY;
        robj_interface_RJiSSIDInfoArray = robj_interface_RJiSSIDInfoDetail.getObjSSID();
        if (robj_interface_RJiSSIDInfoArray == null) {
            robj_interface_RJiSSIDInfoArray = new Robj_interface_RJiSSIDInfo[]{};
        }
        int n = 0;
        int n2 = robj_interface_RJiSSIDInfoDetail.getSMaxCUCount();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < n2; ++i) {
            int n3 = i / 64;
            int n4 = i % 64;
            for (int j = 0; j < this.SSID_BOUNDAY_IN_CU; ++j) {
                RJiSSIDInfo rJiSSIDInfo;
                SsidInfo ssidInfo = null;
                int n5 = SSID_BOUNDARY * j;
                short s = (short)(SSID_BOUNDARY * j + SSID_BOUNDARY - 1);
                if (n < robj_interface_RJiSSIDInfoArray.length) {
                    rJiSSIDInfo = (RJiSSIDInfo)robj_interface_RJiSSIDInfoArray[n];
                    short s2 = rJiSSIDInfo.getSLDKC();
                    short s3 = rJiSSIDInfo.getSCU();
                    short s4 = rJiSSIDInfo.getSStartLDEV();
                    if (n3 == s2 && n4 == s3 && n5 == s4) {
                        ssidInfo = new SsidInfo(rJiSSIDInfo);
                        int n6 = rJiSSIDInfo.getISSID();
                        arrayList.add(new Integer(n6));
                        ++n;
                    }
                }
                if (ssidInfo == null) {
                    rJiSSIDInfo = new RJiSSIDInfo();
                    rJiSSIDInfo.iSSID = SsidInfo.NO_VALUE;
                    rJiSSIDInfo.sLDKC = (short)n3;
                    rJiSSIDInfo.sCU = (short)n4;
                    rJiSSIDInfo.sStartLDEV = (short)n5;
                    rJiSSIDInfo.sEndLDEV = s;
                    ssidInfo = new SsidInfo(rJiSSIDInfo);
                }
                this.mSsidInfoList.add(ssidInfo);
            }
        }
        this.mUsableSsidList.removeAll(arrayList);
    }

    public SsidInfo[] getSsidInfoList(int n, boolean bl) {
        ArrayList<SsidInfo> arrayList;
        SsidInfo[] ssidInfoArray;
        if (bl) {
            ssidInfoArray = LprManager.getInstance();
            Robj_interface_RJiCUIndex[] robj_interface_RJiCUIndexArray = ssidInfoArray.getCuListAtSlpr(n);
            arrayList = new ArrayList<SsidInfo>(robj_interface_RJiCUIndexArray.length * this.SSID_BOUNDAY_IN_CU);
            int n2 = 0;
            int n3 = 0;
            while (n2 < robj_interface_RJiCUIndexArray.length && n3 < this.mSsidInfoList.size()) {
                Robj_interface_RJiCUIndex robj_interface_RJiCUIndex = robj_interface_RJiCUIndexArray[n2];
                SsidInfo ssidInfo = (SsidInfo)this.mSsidInfoList.get(n3);
                Robj_interface_RJiCUIndex robj_interface_RJiCUIndex2 = ssidInfo.getCuIndex();
                int n4 = mCuIndexComparator.compare(robj_interface_RJiCUIndex, robj_interface_RJiCUIndex2);
                if (n4 >= 0) {
                    if (n4 == 0) {
                        arrayList.add(ssidInfo);
                    }
                    ++n3;
                    continue;
                }
                ++n2;
            }
        } else {
            arrayList = this.mSsidInfoList;
        }
        ssidInfoArray = new SsidInfo[]{};
        return arrayList.toArray(ssidInfoArray);
    }

    public Collection getUsableSsid(int n, boolean bl) {
        ArrayList<Integer> arrayList;
        if (bl) {
            arrayList = new ArrayList<Integer>(this.mUsableSsidList.size());
            LprManager lprManager = LprManager.getInstance();
            int[] nArray = lprManager.getSsidList(n);
            int n2 = 0;
            int n3 = 0;
            while (n2 < nArray.length && n3 < this.mUsableSsidList.size()) {
                int n4 = nArray[n2];
                Integer n5 = (Integer)this.mUsableSsidList.get(n3);
                int n6 = n5;
                if (n4 == n6) {
                    arrayList.add(n5);
                    ++n3;
                    ++n2;
                    continue;
                }
                if (n4 > n6) {
                    ++n3;
                    continue;
                }
                ++n2;
            }
        } else {
            arrayList = (ArrayList<Integer>)this.mUsableSsidList.clone();
        }
        return arrayList;
    }

    SsidInfo getSsidInfo(Robj_interface_RJiLDEVIndex robj_interface_RJiLDEVIndex) {
        if (this.mCacheGetSsidInfo != null && this.mCacheGetSsidInfo.compareTo(robj_interface_RJiLDEVIndex) == 0) {
            return this.mCacheGetSsidInfo;
        }
        int n = Collections.binarySearch(this.mSsidInfoList, robj_interface_RJiLDEVIndex);
        this.mCacheGetSsidInfo = n >= 0 ? (SsidInfo)this.mSsidInfoList.get(n) : null;
        return this.mCacheGetSsidInfo;
    }

    void setLdev(Robj_interface_RJiLDEVInfoDetail[] robj_interface_RJiLDEVInfoDetailArray) {
        int n = robj_interface_RJiLDEVInfoDetailArray.length;
        for (int i = 0; i < n; ++i) {
            SsidInfo ssidInfo = this.getSsidInfo((Robj_interface_RJiLDEVIndex)robj_interface_RJiLDEVInfoDetailArray[i]);
            if (ssidInfo == null) continue;
            ssidInfo.addLdev((Robj_interface_RJiLDEVIndex)robj_interface_RJiLDEVInfoDetailArray[i]);
        }
    }

    void removeLdev(Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray) {
        int n = robj_interface_RJiLDEVIndexArray.length;
        for (int i = 0; i < n; ++i) {
            SsidInfo ssidInfo = this.getSsidInfo(robj_interface_RJiLDEVIndexArray[i]);
            if (ssidInfo == null) continue;
            ssidInfo.removeLdev(robj_interface_RJiLDEVIndexArray[i]);
        }
    }

    boolean reserveSsid(int n) {
        return this.mUsableSsidList.remove(new Integer(n));
    }

    void releaseSsid(int n) {
        Integer n2 = new Integer(n);
        int n3 = Collections.binarySearch(this.mUsableSsidList, n2);
        if (n3 < 0) {
            this.mUsableSsidList.add(-(n3 + 1), n2);
        }
    }

    void applyComplete(Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray) {
        int n = robj_interface_RJiLDEVIndexArray.length;
        for (int i = 0; i < n; ++i) {
            SsidInfo ssidInfo = this.getSsidInfo(robj_interface_RJiLDEVIndexArray[i]);
            if (ssidInfo == null) continue;
            ssidInfo.applyComplete();
        }
    }

    public boolean chkSsidCompRequest() {
        for (int i = 0; i < this.mSsidInfoList.size(); ++i) {
            int n;
            SsidInfo ssidInfo = (SsidInfo)this.mSsidInfoList.get(i);
            if (!ssidInfo.canSetSsid() || SsidInfo.chkSsid(n = ssidInfo.getSsid())) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        mCuIndexComparator = new CuIndexComparator();
    }
}

