/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.com;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import sanproject.client.com.RJcAbsGuideConst;
import sanproject.client.com.RJcConst;
import sanproject.client.com.abs.RJaChangeListener;
import sanproject.client.monitor.com.RJHihDateFormat;

public class RJHihSpinDateField
extends JPanel
implements FocusListener {
    private static final RJHihDateFormat yyyyMMddHHmmForm = new RJHihDateFormat("yyyy/MM/dd HH:mm");
    private static final RJHihDateFormat yyyyForm = new RJHihDateFormat("yyyy");
    private static final RJHihDateFormat MMForm = new RJHihDateFormat("MM");
    private static final RJHihDateFormat ddForm = new RJHihDateFormat("dd");
    private static final RJHihDateFormat HHForm = new RJHihDateFormat("HH");
    private static final RJHihDateFormat mmForm = new RJHihDateFormat("mm");
    private static final long MSEC_MINUTE = 60000L;
    private static final Color backSelColor = RJcAbsGuideConst.backSelColor;
    private static final Color backColor = new Color(160, 160, 160);
    private static final KeyStroke vk_UP = KeyStroke.getKeyStroke(38, 0, false);
    private static final KeyStroke vk_DOWN = KeyStroke.getKeyStroke(40, 0, false);
    private static final KeyStroke vk_RIGHT = KeyStroke.getKeyStroke(39, 0, false);
    private static final KeyStroke vk_LEFT = KeyStroke.getKeyStroke(37, 0, false);
    private int[] units = new int[]{1, 2, 5, 10, 12};
    private Calendar calendar = new GregorianCalendar(RJcConst.tz);
    private GridBagLayout thisLayout = new GridBagLayout();
    private JPanel fieldPanel = new JPanel();
    private Border fieldPanelBorder;
    private GridBagLayout fieldPanelLayout = new GridBagLayout();
    private Border fieldBorder;
    private ItemField yearField = new ItemField();
    private JLabel separateField = new JLabel("/");
    private ItemField monthField = new ItemField();
    private JLabel separateField2 = new JLabel("/");
    private ItemField dayField = new ItemField();
    private JLabel spaceField = new JLabel(" ");
    private ItemField hourField = new ItemField();
    private JLabel separateField3 = new JLabel(":");
    private ItemField minuteField = new ItemField();
    private SpinButton upButton = new SpinButton();
    private SpinButton downBotton = new SpinButton();
    private FieldManager manager = new FieldManager(this);
    private Date startTime = null;
    private Date endTime = null;
    private Date displayTime = null;
    private Date initTime = null;
    private int tickSpacing = 1;
    private RJaChangeListener changeListener = null;
    private boolean enableListener = false;

    public RJHihSpinDateField() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.thisLayout);
        this.setMinimumSize(new Dimension(140, 21));
        this.setPreferredSize(new Dimension(140, 21));
        this.addFocusListener(this);
        ActionRight actionRight = new ActionRight();
        ActionLeft actionLeft = new ActionLeft();
        ActionUp actionUp = new ActionUp();
        ActionDown actionDown = new ActionDown();
        this.getInputMap(0).put(vk_RIGHT, actionRight.getValue("Name"));
        this.getActionMap().put(actionRight.getValue("Name"), actionRight);
        this.getInputMap(0).put(vk_LEFT, actionLeft.getValue("Name"));
        this.getActionMap().put(actionLeft.getValue("Name"), actionLeft);
        this.getInputMap(0).put(vk_UP, actionUp.getValue("Name"));
        this.getActionMap().put(actionUp.getValue("Name"), actionUp);
        this.getInputMap(0).put(vk_DOWN, actionDown.getValue("Name"));
        this.getActionMap().put(actionDown.getValue("Name"), actionDown);
        this.fieldPanelBorder = BorderFactory.createBevelBorder(1, Color.white, Color.lightGray, Color.black, Color.gray);
        this.fieldPanel.setLayout(this.fieldPanelLayout);
        this.fieldPanel.setBackground(Color.white);
        this.fieldPanel.setBorder(this.fieldPanelBorder);
        this.manager.add(this.yearField);
        this.manager.add(this.monthField);
        this.manager.add(this.dayField);
        this.manager.add(this.hourField);
        this.manager.add(this.minuteField);
        this.upButton.setFont(new Font("Dialog", 0, 4));
        this.upButton.setMargin(new Insets(0, 0, 0, 0));
        this.upButton.setText("\u25b2");
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJHihSpinDateField.this.upButton_actionPerformed(actionEvent);
            }
        });
        this.downBotton.setFont(new Font("Dialog", 0, 4));
        this.downBotton.setMargin(new Insets(0, 0, 0, 0));
        this.downBotton.setText("\u25bc");
        this.downBotton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJHihSpinDateField.this.downBotton_actionPerformed(actionEvent);
            }
        });
        this.fieldPanel.add((Component)this.yearField, new GridBagConstraints(0, 0, 1, 1, 2.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.fieldPanel.add((Component)this.separateField, new GridBagConstraints(1, 0, 1, 1, 0.1, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.fieldPanel.add((Component)this.monthField, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.fieldPanel.add((Component)this.separateField2, new GridBagConstraints(3, 0, 1, 1, 0.1, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.fieldPanel.add((Component)this.dayField, new GridBagConstraints(4, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.fieldPanel.add((Component)this.spaceField, new GridBagConstraints(5, 0, 1, 1, 0.1, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.fieldPanel.add((Component)this.hourField, new GridBagConstraints(6, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.fieldPanel.add((Component)this.separateField3, new GridBagConstraints(7, 0, 1, 1, 0.1, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.fieldPanel.add((Component)this.minuteField, new GridBagConstraints(8, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.fieldPanel, new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.upButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.downBotton, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void init(Date date, Date date2, Date date3, int n) {
        if (date != null && date2 != null) {
            this.startTime = (Date)date.clone();
            this.endTime = (Date)date2.clone();
            this.displayTime = (Date)date.clone();
            this.tickSpacing = n;
            this.enableListener = false;
            this.initTime = date3;
            this.setTime(date3);
            this.enableListener = true;
            this.setFieldData();
        } else {
            this.yearField.setText("0000");
            this.monthField.setText("00");
            this.dayField.setText("00");
            this.hourField.setText("00");
            this.minuteField.setText("00");
            this.setEnabled(false);
        }
        this.manager.init();
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getTime() {
        return this.displayTime;
    }

    public void setTime(Date date) {
        if ((date = (Date)date.clone()).compareTo(this.startTime) < 0) {
            date.setTime(this.startTime.getTime());
        }
        if (date.compareTo(this.endTime) > 0) {
            date.setTime(this.endTime.getTime());
        }
        if (this.enableListener && this.changeListener != null) {
            this.changeListener.valueChanged(date);
        }
        this.displayTime = date;
        this.setFieldData();
        this.setFixed(date.equals(this.initTime));
    }

    private void setFieldData() {
        this.yearField.setText(yyyyForm.format(this.displayTime));
        this.monthField.setText(MMForm.format(this.displayTime));
        this.dayField.setText(ddForm.format(this.displayTime));
        this.hourField.setText(HHForm.format(this.displayTime));
        this.minuteField.setText(mmForm.format(this.displayTime));
    }

    private void upButton_actionPerformed(ActionEvent actionEvent) {
        this.tickActionPerformed(this.tickSpacing, 1);
    }

    private void downBotton_actionPerformed(ActionEvent actionEvent) {
        this.tickActionPerformed(-this.tickSpacing, -1);
    }

    private void tickActionPerformed(int n, int n2) {
        this.calendar.setTime(this.displayTime);
        this.manager.setSelection(true);
        int n3 = n;
        int n4 = this.units[this.manager.getSelection()];
        if (n4 != 12) {
            n3 = n2;
        }
        this.calendar.add(n4, n3);
        this.setTime(this.calendar.getTime());
    }

    public void addChangeListener(RJaChangeListener rJaChangeListener) {
        this.changeListener = rJaChangeListener;
        this.enableListener = true;
    }

    public void setEnabled(boolean bl) {
        this.manager.setEnabled(bl);
        this.separateField.setEnabled(bl);
        this.separateField2.setEnabled(bl);
        this.spaceField.setEnabled(bl);
        this.separateField3.setEnabled(bl);
        this.upButton.setEnabled(bl);
        this.downBotton.setEnabled(bl);
        super.setEnabled(bl);
    }

    public void setFixed(boolean bl) {
        this.manager.setFixed(bl);
        if (bl) {
            this.initTime = this.displayTime;
        }
    }

    public void right() {
        this.manager.right();
    }

    public void left() {
        this.manager.left();
    }

    public void focusGained(FocusEvent focusEvent) {
        this.manager.setSelection(true);
    }

    public void focusLost(FocusEvent focusEvent) {
        this.manager.lostFocus();
    }

    public boolean isFocusable() {
        return true;
    }

    class ActionDown
    extends AbstractAction {
        ActionDown() {
            super("actionDown");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RJHihSpinDateField rJHihSpinDateField = (RJHihSpinDateField)actionEvent.getSource();
            rJHihSpinDateField.downBotton_actionPerformed(null);
        }
    }

    class ActionUp
    extends AbstractAction {
        ActionUp() {
            super("actionUp");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RJHihSpinDateField rJHihSpinDateField = (RJHihSpinDateField)actionEvent.getSource();
            rJHihSpinDateField.upButton_actionPerformed(null);
        }
    }

    class ActionLeft
    extends AbstractAction {
        ActionLeft() {
            super("actionLeft");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RJHihSpinDateField rJHihSpinDateField = (RJHihSpinDateField)actionEvent.getSource();
            rJHihSpinDateField.left();
        }
    }

    class ActionRight
    extends AbstractAction {
        ActionRight() {
            super("actionRight");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RJHihSpinDateField rJHihSpinDateField = (RJHihSpinDateField)actionEvent.getSource();
            rJHihSpinDateField.right();
        }
    }

    class SpinButton
    extends JButton {
        SpinButton() {
            this.setRequestFocusEnabled(false);
        }

        public boolean isFocusable() {
            return false;
        }
    }

    class ItemField
    extends JTextField
    implements MouseListener {
        private int number = -1;
        private FieldManager manager = null;
        private boolean selection = false;
        private boolean focus = false;
        private boolean fixed = true;

        ItemField() {
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setFont(RJcConst.normalFont);
            this.setEditable(false);
            this.setBackground(Color.white);
            this.setHorizontalAlignment(0);
            this.setRequestFocusEnabled(false);
            this.addMouseListener(this);
        }

        public void init(int n, FieldManager fieldManager) {
            this.number = n;
            this.manager = fieldManager;
        }

        public void setSelection(boolean bl) {
            if (this.isEnabled()) {
                this.selection = bl;
                if (bl) {
                    this.focus = true;
                    this.manager.setSelection(this.number);
                    this.manager.getParent().requestFocus();
                    this.setForeground(Color.white);
                    this.setBackground(backSelColor);
                } else {
                    this.setForeground(this.fixed ? Color.black : Color.blue);
                    this.setBackground(Color.white);
                }
            }
        }

        public void lostFocus() {
            if (this.isEnabled()) {
                this.focus = false;
                this.setSelection(false);
            }
        }

        public void setFixed(boolean bl) {
            this.fixed = bl;
            Font font = this.getFont();
            int n = bl ? 0 : 3;
            this.setFont(font.deriveFont(n));
            if (!this.selection || !this.focus) {
                this.setForeground(bl ? Color.black : Color.blue);
            }
        }

        public boolean isFocusable() {
            return false;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getModifiers() == 16) {
                this.manager.setSelection(false);
                this.manager.setSelection(this.number);
                this.manager.setSelection(true);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void copy() {
        }

        public void paste() {
        }
    }

    class FieldManager {
        private RJHihSpinDateField parent;
        private ArrayList group = new ArrayList();
        private int bottom = -1;
        private int selection = 0;

        FieldManager(RJHihSpinDateField rJHihSpinDateField2) {
            this.parent = rJHihSpinDateField2;
        }

        public boolean add(ItemField itemField) {
            boolean bl = this.group.add(itemField);
            ++this.bottom;
            itemField.init(this.bottom, this);
            this.selection = this.bottom;
            return bl;
        }

        public void init() {
            this.setFixed(true);
            this.setSelection(false);
            this.selection = this.bottom;
            this.lostFocus();
        }

        public RJHihSpinDateField getParent() {
            return this.parent;
        }

        public int getSelection() {
            return this.selection;
        }

        public void setSelection(int n) {
            this.selection = n;
        }

        public void setSelection(boolean bl) {
            ItemField itemField = (ItemField)this.group.get(this.selection);
            itemField.setSelection(bl);
        }

        public void lostFocus() {
            ItemField itemField = (ItemField)this.group.get(this.selection);
            itemField.lostFocus();
            this.selection = this.bottom;
        }

        public void right() {
            if (this.selection + 1 <= this.bottom) {
                this.setSelection(false);
                ++this.selection;
                this.setSelection(true);
            }
        }

        public void left() {
            if (this.selection - 1 >= 0) {
                this.setSelection(false);
                --this.selection;
                this.setSelection(true);
            }
        }

        public void setEnabled(boolean bl) {
            Iterator iterator = this.group.iterator();
            while (iterator.hasNext()) {
                ItemField itemField = (ItemField)iterator.next();
                itemField.setEnabled(bl);
            }
        }

        public void setFixed(boolean bl) {
            Iterator iterator = this.group.iterator();
            while (iterator.hasNext()) {
                ItemField itemField = (ItemField)iterator.next();
                itemField.setFixed(bl);
            }
        }
    }
}

