/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.option;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import sanproject.client.com.abs.RJaDataModelEntry;
import sanproject.client.com.abs.RJaRowHeaderTableUI;
import sanproject.client.com.abs.RJaTable;
import sanproject.client.com.abs.RJaTableColumn;
import sanproject.client.com.abs.RJaTablePushCellRenderer;
import sanproject.client.com.abs.RJaTablePushMouseAdapter;
import sanproject.client.monitor.com.RJHihDataSupplier;
import sanproject.client.monitor.com.RJHihMonitoringOptionInfo;
import sanproject.client.monitor.com.RJHihTableModel;
import sanproject.client.monitor.option.RJHihCUTableCellRenderer;
import sanproject.client.monitor.option.RJHihMoCUElement;
import sanproject.common.Robj_interface_MonMonitoringCU;
import sanproject.common.Robj_interface_RJiCUIndex;
import sanproject.serversx.data.RJiCUIndex;

public class RJHihCUTableModel
extends RJHihTableModel {
    private static final int DKCMAX = 1;
    private RJHihMoCUElement[][] cuModel = new RJHihMoCUElement[16][16];
    private boolean cellSetMode = false;

    public RJHihCUTableModel(RJHihDataSupplier rJHihDataSupplier) {
        super(rJHihDataSupplier);
    }

    protected void defineTable() {
        RJaTablePushCellRenderer rJaTablePushCellRenderer = new RJaTablePushCellRenderer();
        rJaTablePushCellRenderer.setRowSpan(16);
        rJaTablePushCellRenderer.setPushMode(true);
        this.addRHColumnInfo("DKC#", "LDKC#", 56, new String(""), false, 0, rJaTablePushCellRenderer);
        RJaTableColumn rJaTableColumn = this.getTableColumn("DKC#");
        rJaTableColumn.setRowSpan(16);
        rJaTablePushCellRenderer = new RJaTablePushCellRenderer();
        rJaTablePushCellRenderer.setPushMode(true);
        this.addRHColumnInfo("CU", "CU", 40, new String(""), false, 0, rJaTablePushCellRenderer);
        for (int i = 0; i < 16; ++i) {
            String string = "CLM" + i;
            String string2 = Integer.toHexString(i).toUpperCase();
            string2 = "+" + string2.substring(string2.length() - 1);
            this.addColumnInfo(string, string2, 40, new String(""), false, 0);
        }
        this.setHeaderPush(false);
    }

    protected void addColumnInfo(String string, Object object, int n, Object object2, boolean bl, int n2) {
        RJHihCUTableCellRenderer rJHihCUTableCellRenderer = new RJHihCUTableCellRenderer();
        this.addColumnInfo(string, object, n, object2, bl, n2, rJHihCUTableCellRenderer);
    }

    public void initialize() {
        RJaTable rJaTable = this.manager.getRHTable();
        rJaTable.setRowSelectionAllowed(false);
        rJaTable.setUI(new RJaRowHeaderTableUI());
        RJaTablePushMouseAdapter rJaTablePushMouseAdapter = new RJaTablePushMouseAdapter();
        rJaTable.addMouseListener(rJaTablePushMouseAdapter);
        rJaTable.addMouseMotionListener(rJaTablePushMouseAdapter);
        RJaTable rJaTable2 = this.manager.getVPTable();
        rJaTable2.setRowSelectionAllowed(false);
        rJaTable2.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                RJHihCUTableModel.this.reverseCell(mouseEvent, true);
            }
        });
        rJaTable2.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent mouseEvent) {
                RJHihCUTableModel.this.reverseCell(mouseEvent, false);
            }

            public void mouseMoved(MouseEvent mouseEvent) {
            }
        });
        this.initializeData();
        this.setData();
    }

    private void initializeData() {
        for (int i = 0; i < 1; ++i) {
            RhDKC rhDKC = new RhDKC(i);
            for (int j = 0; j < 16; ++j) {
                RJaDataModelEntry rJaDataModelEntry = this.newEntry();
                rJaDataModelEntry.put("DKC#", rhDKC);
                RhCU rhCU = new RhCU(j);
                rhDKC.addCU(rhCU);
                rJaDataModelEntry.put("CU", rhCU);
                for (int k = 0; k < 16; ++k) {
                    RJHihMoCUElement rJHihMoCUElement;
                    int n = j * 16 + k;
                    this.cuModel[i * 16 + j][k] = rJHihMoCUElement = new RJHihMoCUElement(i, n);
                    String string = "CLM" + k;
                    rJaDataModelEntry.put(string, rJHihMoCUElement.getElementForm());
                }
                this.addRow(rJaDataModelEntry);
            }
        }
    }

    private void setData() {
        RJHihMonitoringOptionInfo rJHihMonitoringOptionInfo = this.supplier.getMonitoringOption();
        this.supplier.putLog("[Monitor]", "[Option]", "RJHihCUTableModel.setData targetCU =" + rJHihMonitoringOptionInfo.getTargetCU().length);
        if (rJHihMonitoringOptionInfo != null) {
            Robj_interface_RJiCUIndex[] robj_interface_RJiCUIndexArray;
            short s;
            int n;
            Robj_interface_MonMonitoringCU[] robj_interface_MonMonitoringCUArray = rJHihMonitoringOptionInfo.getTargetCU();
            if (robj_interface_MonMonitoringCUArray != null) {
                for (int i = 0; i < robj_interface_MonMonitoringCUArray.length; ++i) {
                    n = robj_interface_MonMonitoringCUArray[i].getSLDKC();
                    if (n > 0) continue;
                    s = robj_interface_MonMonitoringCUArray[i].getSCU();
                    RJHihMoCUElement rJHihMoCUElement = this.cuModel[n * 16 + s / 16][s % 16];
                    this.supplier.putLog("[Monitor]", "[Option]", "RJHihCUTableModel.setData target:ldkc=" + n + ":cu=" + s);
                    rJHihMoCUElement.initDetail(robj_interface_MonMonitoringCUArray[i].isTarget());
                }
            }
            if ((robj_interface_RJiCUIndexArray = rJHihMonitoringOptionInfo.getExistCU()) != null) {
                for (n = 0; n < robj_interface_RJiCUIndexArray.length; ++n) {
                    s = robj_interface_RJiCUIndexArray[n].getSLDKC();
                    if (s > 0) continue;
                    short s2 = robj_interface_RJiCUIndexArray[n].getSCU();
                    RJHihMoCUElement rJHihMoCUElement = this.cuModel[s * 16 + s2 / 16][s2 % 16];
                    rJHihMoCUElement.setEnabled(true);
                }
            }
        }
    }

    public void reverseCell(MouseEvent mouseEvent, boolean bl) {
        JTable jTable = (JTable)mouseEvent.getSource();
        int n = jTable.rowAtPoint(mouseEvent.getPoint());
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n2 = tableColumnModel.getColumnIndexAtX(mouseEvent.getPoint().x);
        if (n >= 0 && n2 >= 0) {
            if (bl) {
                this.cellSetMode = !this.cuModel[n][n2].isSelectCU();
            }
            this.cuModel[n][n2].setSelectCU(this.cellSetMode);
        }
        jTable.repaint();
    }

    protected void tbMouseClicked(MouseEvent mouseEvent, Object object) {
        if (object != null && (object.equals("DKC#") || object.equals("CU"))) {
            int n = object.equals("DKC#") ? 16 : 1;
            RJaTable rJaTable = this.manager.getVPTable();
            int n2 = rJaTable.rowAtPoint(mouseEvent.getPoint());
            n2 = n2 / n * n;
            RhItem rhItem = (RhItem)this.getValueAt(n2, object);
            rhItem.reverseSelect();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < 16; ++j) {
                    this.cuModel[n2 + i][j].setSelectCU(rhItem.isSelect());
                }
            }
            rJaTable.repaint();
        }
    }

    public int getTargetCount() {
        int n = 0;
        for (int i = 0; i < this.cuModel.length; ++i) {
            for (int j = 0; j < this.cuModel[0].length; ++j) {
                if (!this.cuModel[i][j].isTarget()) continue;
                ++n;
            }
        }
        return n;
    }

    public int getTargetInitCount() {
        int n = 0;
        for (int i = 0; i < this.cuModel.length; ++i) {
            for (int j = 0; j < this.cuModel[0].length; ++j) {
                if (!this.cuModel[i][j].isTargetInit()) continue;
                ++n;
            }
        }
        return n;
    }

    public void setTarget(boolean bl) {
        for (int i = 0; i < this.cuModel.length; ++i) {
            for (int j = 0; j < this.cuModel[0].length; ++j) {
                if (!this.cuModel[i][j].isSelect()) continue;
                this.cuModel[i][j].setTarget(bl);
                this.cuModel[i][j].clearSelect();
            }
        }
        this.resetRhItems();
    }

    private void resetRhItems() {
        Enumeration enumeration = this.rows.elements();
        while (enumeration.hasMoreElements()) {
            RJaDataModelEntry rJaDataModelEntry = (RJaDataModelEntry)enumeration.nextElement();
            RhDKC rhDKC = (RhDKC)rJaDataModelEntry.get("DKC#");
            rhDKC.setSelect(false);
            RhCU rhCU = (RhCU)rJaDataModelEntry.get("CU");
            rhCU.setSelect(false);
        }
    }

    public RJHihMoCUElement[][] getCUModel() {
        return this.cuModel;
    }

    public boolean isChange() {
        boolean bl = false;
        block0: for (int i = 0; i < this.cuModel.length; ++i) {
            for (int j = 0; j < this.cuModel[0].length; ++j) {
                RJHihMoCUElement rJHihMoCUElement = this.cuModel[i][j];
                if (!rJHihMoCUElement.isModify()) continue;
                bl = true;
                break block0;
            }
        }
        return bl;
    }

    public Robj_interface_RJiCUIndex[] getTagetCUs() {
        ArrayList<RJiCUIndex> arrayList = new ArrayList<RJiCUIndex>();
        for (int i = 0; i < this.cuModel.length; ++i) {
            for (int j = 0; j < this.cuModel[0].length; ++j) {
                RJHihMoCUElement rJHihMoCUElement = this.cuModel[i][j];
                if (!rJHihMoCUElement.isTarget()) continue;
                RJiCUIndex rJiCUIndex = new RJiCUIndex();
                rJiCUIndex.setCUIndex((short)rJHihMoCUElement.getLDKC(), (short)rJHihMoCUElement.getCU());
                arrayList.add(rJiCUIndex);
            }
        }
        RJiCUIndex[] rJiCUIndexArray = arrayList.toArray(new RJiCUIndex[0]);
        return rJiCUIndexArray;
    }

    class RhCU
    extends RhItem {
        RhCU(int n) {
            super(n);
        }

        public String toString() {
            String string = Integer.toHexString(this.no).toUpperCase();
            return string + "0";
        }
    }

    class RhDKC
    extends RhItem {
        private ArrayList cuList = new ArrayList();

        RhDKC(int n) {
            super(n);
        }

        public void addCU(RhCU rhCU) {
            this.cuList.add(rhCU);
        }

        public void reverseSelect() {
            this.select = !this.select;
            Iterator iterator = this.cuList.iterator();
            while (iterator.hasNext()) {
                RhCU rhCU = (RhCU)iterator.next();
                rhCU.setSelect(this.select);
            }
        }

        public String toString() {
            return "0" + this.no;
        }
    }

    class RhItem {
        protected int no;
        protected boolean select = false;

        RhItem(int n) {
            this.no = n;
        }

        public boolean isSelect() {
            return this.select;
        }

        public void setSelect(boolean bl) {
            this.select = bl;
        }

        public void reverseSelect() {
            this.select = !this.select;
        }
    }
}

