/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.ondemand.dialog;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.MouseInputAdapter;
import sanproject.client.com.RJComFont;
import sanproject.client.ondemand.RJOnDmdGuidance;

public class RJOnDmdExtCacheSlider
extends JSlider {
    private static final String CLASSNAME = "RJOnDmdExtCacheSlider";
    private RJOnDmdGuidance m_Guid = null;

    public RJOnDmdExtCacheSlider(RJOnDmdGuidance rJOnDmdGuidance) {
        try {
            this.m_Guid = rJOnDmdGuidance;
            this.initInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initInstance() throws Exception {
        this.setSnapToTicks(true);
        this.setPaintTicks(true);
        this.setPaintLabels(true);
        this.addMouseListener(new MouseInputAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                RJOnDmdExtCacheSlider.this.SliderMousePressed(mouseEvent);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                RJOnDmdExtCacheSlider.this.SliderKeyPressed(keyEvent);
            }
        });
    }

    public void initialize(int n, int n2, int n3) {
        this.setValue(0);
        this.setMaximum(n);
        this.setMinimum(-n2);
        this.setMinorTickSpacing(n3);
        Hashtable hashtable = new Hashtable();
        this.putLabel(hashtable, 0, null);
        this.putLabel(hashtable, n, this.m_Guid.CAPGB.getGuidance());
        this.putLabel(hashtable, -n2, this.m_Guid.CAPGB.getGuidance());
        this.setLabelTable(hashtable);
    }

    private void putLabel(Hashtable hashtable, int n, String string) {
        JLabel jLabel = null;
        if (string == null) {
            jLabel = new JLabel(new String(Integer.toString(n)));
        } else {
            String string2 = null;
            string2 = n > 0 ? "" + new String("+" + Integer.toString(n)) : "" + new String(Integer.toString(n));
            jLabel = new JLabel("" + new String(string2) + string);
        }
        jLabel.setFont(RJComFont.itemFont);
        hashtable.put(new Integer(n), jLabel);
    }

    public void SliderMousePressed(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        int n = this.getMinorTickSpacing();
        int n2 = mouseEvent.getX();
        int n3 = this.getWidth();
        int n4 = (this.getMaximum() - this.getMinimum()) / n;
        int n5 = (n4 * n2 * 10 + n3 * 5) / (n3 * 10);
        int n6 = n * n5 + this.getMinimum();
        this.setValue(n6);
    }

    public void SliderKeyPressed(KeyEvent keyEvent) {
        int n = this.getValue();
        int n2 = this.getMinorTickSpacing();
        switch (keyEvent.getKeyCode()) {
            case 39: {
                break;
            }
            case 37: {
                if (n != this.getMinimum()) {
                    n -= n2;
                }
                this.setValue(n);
                break;
            }
        }
    }
}

