/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import sanproject.client.openldevguard.color.ColorManager;
import sanproject.client.openldevguard.com.ComponentConstants;
import sanproject.client.openldevguard.font.FontManager;
import sanproject.client.openldevguard.gui.ClickableTableHeaderRenderer;
import sanproject.client.openldevguard.gui.ComponentFactory;

public final class ComponentUtilities {
    private ComponentUtilities() {
    }

    public static Rectangle getClickableRectangle(Rectangle rectangle) {
        int n = 3;
        Rectangle rectangle2 = new Rectangle(rectangle.x + n, rectangle.y, rectangle.width - n * 2, rectangle.height);
        return rectangle2;
    }

    public static JPanel buildTitlePanel(String string) {
        ComponentFactory componentFactory = ComponentFactory.getDefaultFactory();
        JPanel jPanel = ComponentUtilities.buildTitlePanel(componentFactory, string);
        return jPanel;
    }

    public static JPanel buildTitlePanel(ComponentFactory componentFactory, String string) {
        ColorManager colorManager = ColorManager.getInstance();
        Serializable serializable = new Dimension(12, 24);
        Object object = colorManager.getInputAreaTitleBackground();
        JPanel jPanel = componentFactory.createPanel();
        jPanel.setOpaque(true);
        jPanel.setBackground((Color)object);
        jPanel.setPreferredSize((Dimension)serializable);
        object = FontManager.getInstance();
        Serializable serializable2 = ((FontManager)object).getTitleFont();
        Serializable serializable3 = colorManager.getDefaultCharacterColor();
        serializable = componentFactory.createLabel(string);
        ((JComponent)serializable).setFont((Font)serializable2);
        ((JComponent)serializable).setForeground((Color)serializable3);
        object = colorManager.getPanelBackground();
        serializable2 = new BorderLayout(8, 4);
        serializable3 = componentFactory.createPanel();
        ((Container)serializable3).setLayout((LayoutManager)((Object)serializable2));
        ((JComponent)serializable3).setOpaque(true);
        ((JComponent)serializable3).setBackground((Color)object);
        ((Container)serializable3).add(jPanel, "West");
        ((Container)serializable3).add((Component)serializable, "Center");
        return serializable3;
    }

    public static JComponent buildListTitleComponent(String string) {
        ComponentFactory componentFactory = ComponentFactory.getDefaultFactory();
        JComponent jComponent = ComponentUtilities.buildListTitleComponent(componentFactory, string);
        return jComponent;
    }

    public static JComponent buildListTitleComponent(ComponentFactory componentFactory, String string) {
        ColorManager colorManager = ColorManager.getInstance();
        Color color = colorManager.getInputAreaTitleBackground();
        Color color2 = colorManager.getInputAreaTitleForeground();
        Border border = BorderFactory.createEmptyBorder(0, 8, 0, 8);
        JLabel jLabel = componentFactory.createLabel(string);
        jLabel.setOpaque(true);
        jLabel.setBackground(color);
        jLabel.setForeground(color2);
        jLabel.setBorder(border);
        Dimension dimension = ComponentConstants.MINIMUM_LISTTITLE_SIZE;
        Dimension dimension2 = jLabel.getPreferredSize();
        if (dimension2.width < dimension.width) {
            dimension2.width = dimension.width;
        }
        if (dimension2.height < dimension.height) {
            dimension2.height = dimension.height;
        }
        jLabel.setPreferredSize(dimension2);
        return jLabel;
    }

    public static JComponent buildListValueComponent(String string) {
        ComponentFactory componentFactory = ComponentFactory.getDefaultFactory();
        JComponent jComponent = ComponentUtilities.buildListValueComponent(componentFactory, string);
        return jComponent;
    }

    public static JComponent buildListValueComponent(ComponentFactory componentFactory, String string) {
        JLabel jLabel = componentFactory.createLabel(string);
        JComponent jComponent = ComponentUtilities.buildListValueComponent(componentFactory, jLabel);
        return jComponent;
    }

    public static JComponent buildListValueComponent(JComponent jComponent) {
        ComponentFactory componentFactory = ComponentFactory.getDefaultFactory();
        JComponent jComponent2 = ComponentUtilities.buildListValueComponent(componentFactory, jComponent);
        return jComponent2;
    }

    public static JComponent buildListValueComponent(ComponentFactory componentFactory, JComponent jComponent) {
        ColorManager colorManager = ColorManager.getInstance();
        Color color = colorManager.getInputAreaBackground();
        Color color2 = colorManager.getInputAreaForeground();
        int n = 2;
        int n2 = 2;
        Object object = ComponentConstants.MINIMUM_LISTTITLE_SIZE;
        Serializable serializable = jComponent.getPreferredSize();
        if (serializable.height + n + n2 < ((Dimension)object).height) {
            int n3 = ((Dimension)object).height - serializable.height;
            n = n3 / 2;
            n2 = n3 - n;
        }
        object = BorderFactory.createEmptyBorder(n, 4, n2, 4);
        serializable = new BorderLayout();
        JPanel jPanel = componentFactory.createPanel();
        jPanel.setLayout((LayoutManager)((Object)serializable));
        jPanel.setOpaque(true);
        jPanel.setBackground(color);
        jPanel.setForeground(color2);
        jPanel.setBorder((Border)object);
        jPanel.add((Component)jComponent, "Center");
        return jPanel;
    }

    public static void decoratePanelAreaMarginBorder(JComponent jComponent) {
        Border border = jComponent.getBorder();
        Border border2 = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border2, border);
        jComponent.setBorder(compoundBorder);
    }

    public static void decoratePanelAreaMarginBorder(JComponent jComponent, Color color) {
        Border border = jComponent.getBorder();
        MatteBorder matteBorder = BorderFactory.createMatteBorder(4, 4, 4, 4, color);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(matteBorder, border);
        jComponent.setBorder(compoundBorder);
    }

    public static void decorateInputAreaMarginBorder(JComponent jComponent) {
        Border border = jComponent.getBorder();
        Border border2 = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border2, border);
        jComponent.setBorder(compoundBorder);
    }

    public static void decorateInputAreaBorder(JComponent jComponent) {
        Border border = jComponent.getBorder();
        ColorManager colorManager = ColorManager.getInstance();
        Color color = colorManager.getInputAreaBackground();
        MatteBorder matteBorder = BorderFactory.createMatteBorder(4, 4, 4, 4, color);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(matteBorder, border);
        jComponent.setBorder(compoundBorder);
    }

    public static void decorateInformationAreaBorder(JComponent jComponent) {
        ComponentUtilities.decoratePanelAreaMarginBorder(jComponent);
        Border border = jComponent.getBorder();
        ColorManager colorManager = ColorManager.getInstance();
        Color color = colorManager.getLineBorderColor();
        Border border2 = BorderFactory.createLineBorder(color, 1);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border2, border);
        jComponent.setBorder(compoundBorder);
    }

    public static void decorateTransparentViewport(JScrollPane jScrollPane) {
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setOpaque(false);
    }

    public static void supportRightClickSelection(JTable jTable) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                JTable jTable = (JTable)mouseEvent.getSource();
                jTable.requestFocus();
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    int n;
                    boolean bl;
                    int n2 = jTable.getRowCount();
                    Point point = mouseEvent.getPoint();
                    int n3 = jTable.rowAtPoint(point);
                    if (n3 != -1 && n2 > n3 && !(bl = jTable.isCellSelected(n3, n = jTable.columnAtPoint(point)))) {
                        jTable.setRowSelectionInterval(n3, n3);
                        jTable.setColumnSelectionInterval(n, n);
                    }
                }
            }
        };
        jTable.addMouseListener(mouseAdapter);
    }

    public static void supportRightClickSelection(JTree jTree) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                boolean bl;
                int n;
                int n2;
                int n3;
                JTree jTree = (JTree)mouseEvent.getSource();
                jTree.requestFocus();
                if (SwingUtilities.isRightMouseButton(mouseEvent) && (n3 = jTree.getRowForLocation(n2 = mouseEvent.getX(), n = mouseEvent.getY())) != -1 && !(bl = jTree.isRowSelected(n3))) {
                    jTree.setSelectionRow(n3);
                }
            }
        };
        jTree.addMouseListener(mouseAdapter);
    }

    public static void supportRepaintWhenFocusMoved(JComponent jComponent) {
        FocusListener focusListener = new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                JComponent jComponent = (JComponent)focusEvent.getSource();
                jComponent.repaint();
            }

            public void focusLost(FocusEvent focusEvent) {
                JComponent jComponent = (JComponent)focusEvent.getSource();
                jComponent.repaint();
            }
        };
        jComponent.addFocusListener(focusListener);
    }

    public static void supportMouseClick(JTableHeader jTableHeader) {
        TableCellRenderer tableCellRenderer = jTableHeader.getDefaultRenderer();
        final ClickableTableHeaderRenderer clickableTableHeaderRenderer = new ClickableTableHeaderRenderer(tableCellRenderer);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Point point;
                int n;
                JTableHeader jTableHeader;
                Rectangle rectangle;
                Rectangle rectangle2;
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && (rectangle2 = ComponentUtilities.getClickableRectangle(rectangle = (jTableHeader = (JTableHeader)mouseEvent.getSource()).getHeaderRect(n = jTableHeader.columnAtPoint(point = mouseEvent.getPoint())))).contains(point)) {
                    clickableTableHeaderRenderer.setPressing(true);
                    jTableHeader.repaint();
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                clickableTableHeaderRenderer.setPressing(false);
                if (!jTableHeader.getReorderingAllowed()) {
                    jTableHeader.resizeAndRepaint();
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                int n = -1;
                clickableTableHeaderRenderer.setPointingIndex(n);
            }
        };
        MouseMotionListener mouseMotionListener = new MouseMotionListener(){

            public void mouseDragged(MouseEvent mouseEvent) {
                clickableTableHeaderRenderer.setPressing(false);
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                Point point;
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                int n = jTableHeader.columnAtPoint(point = mouseEvent.getPoint());
                if (n == -1) {
                    n = -1;
                }
                clickableTableHeaderRenderer.setPointingIndex(n);
            }
        };
        jTableHeader.addMouseListener(mouseAdapter);
        jTableHeader.addMouseMotionListener(mouseMotionListener);
        jTableHeader.setDefaultRenderer(clickableTableHeaderRenderer);
    }
}

