/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.pool;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import sanproject.client.com.RJcConst;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcPanel;
import sanproject.client.pool.RJPoolGuideDef;
import sanproject.client.pool.RJPoolPoolElement;

public class RJPoolInfomationPanel
extends RJcPanel
implements RJPoolGuideDef {
    private static final int LABEL_WIDTH = 112;
    private static final int LABEL_HIGHT = 20;
    private JPanel centerPanel = new JPanel(new GridBagLayout());
    private JLabel poolIdField = null;
    private JLabel statusField = null;
    private JLabel totalCapaField = null;
    private JLabel usedCapaField = null;
    private JLabel usedPercentField = null;
    private JLabel thresholdField = null;
    private JLabel threshold2Field = null;
    private JLabel attributeField = null;
    private JLabel clprField = null;
    private int compIndex = 0;
    private RJPoolPoolElement element = null;

    public RJPoolInfomationPanel() {
        String string = RJcGuide.text("Pool/InfoTitleLbl");
        Color color = RJcGuide.color("Pool/InfoTitleLbl");
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createLineBorder(color, 2), string);
        titledBorder.setTitleColor(color);
        titledBorder.setTitleFont(RJcConst.boldFont);
        this.setBorder(titledBorder);
        this.setDebugGraphicsOptions(0);
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        Border border = BorderFactory.createEmptyBorder(0, 16, 8, 4);
        this.centerPanel.setBorder(border);
        this.centerPanel.setOpaque(false);
        JLabel jLabel = this.createLabel("Pool/InfoPoolIdLbl");
        JLabel jLabel2 = this.createLabel("Pool/InfoStatusLbl");
        JLabel jLabel3 = this.createLabel("Pool/InfoTotalCapacityLbl");
        JLabel jLabel4 = this.createLabel("Pool/InfoUsedCapacityLbl");
        JLabel jLabel5 = this.createLabel("Pool/InfoUsedPercentLbl");
        JLabel jLabel6 = this.createLabel("Pool/InfoThresholdLbl");
        JLabel jLabel7 = this.createLabel("Pool/InfoThreshold2Lbl");
        JLabel jLabel8 = this.createLabel("Pool/InfoAttributeLbl");
        JLabel jLabel9 = this.createLabel("Pool/InfoClprLbl");
        this.poolIdField = this.createField("Pool/InfoPoolIdField");
        this.statusField = this.createField("Pool/InfoStatusField");
        this.totalCapaField = this.createField("Pool/InfoTotalCapacityField");
        this.usedCapaField = this.createField("Pool/InfoUsedCapacityField");
        this.usedPercentField = this.createField("Pool/InfoUsedPercentField");
        this.thresholdField = this.createField("Pool/InfoThresholdField");
        this.threshold2Field = this.createField("Pool/InfoThreshold2Field");
        this.attributeField = this.createField("Pool/InfoAttributeField");
        this.clprField = this.createField("Pool/InfoClprField");
        this.add((Component)this.centerPanel, "Center");
        this.addCenterPanel(jLabel, this.poolIdField);
        this.addCenterPanel(jLabel2, this.statusField);
        this.addCenterPanel(jLabel3, this.totalCapaField);
        this.addCenterPanel(jLabel4, this.usedCapaField);
        this.addCenterPanel(jLabel5, this.usedPercentField);
        this.addCenterPanel(jLabel6, this.thresholdField);
        this.addCenterPanel(jLabel7, this.threshold2Field);
        this.addCenterPanel(jLabel8, this.attributeField);
        this.addCenterPanel(jLabel9, this.clprField);
        this.centerPanel.add((Component)new JLabel(), new GridBagConstraints(0, this.compIndex, 3, 1, 0.1, 0.1, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(RJcGuide.text(string));
        jLabel.setForeground(RJcGuide.color(string));
        jLabel.setPreferredSize(new Dimension(112, 20));
        jLabel.setMinimumSize(new Dimension(112, 20));
        jLabel.setFont(RJcConst.boldFont);
        return jLabel;
    }

    private JLabel createField(String string) {
        JLabel jLabel = new JLabel();
        jLabel.setForeground(RJcGuide.color(string));
        jLabel.setPreferredSize(new Dimension(112, 20));
        jLabel.setMinimumSize(new Dimension(112, 20));
        jLabel.setFont(RJcConst.boldFont);
        return jLabel;
    }

    private void addCenterPanel(JLabel jLabel, JLabel jLabel2) {
        JLabel jLabel3 = new JLabel(RJcGuide.text("Pool/InfoDlmLbl"));
        jLabel3.setForeground(RJcGuide.color("Pool/InfoDlmLbl"));
        jLabel3.setFont(RJcConst.boldFont);
        this.centerPanel.add((Component)jLabel, new GridBagConstraints(0, this.compIndex, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.centerPanel.add((Component)jLabel3, new GridBagConstraints(1, this.compIndex, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.centerPanel.add((Component)jLabel2, new GridBagConstraints(2, this.compIndex, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 4, 0, 0), 0, 0));
        ++this.compIndex;
    }

    public void setElement(RJPoolPoolElement rJPoolPoolElement) {
        this.element = rJPoolPoolElement;
        this.initField(this.poolIdField);
        this.initField(this.statusField);
        this.initField(this.totalCapaField);
        this.initField(this.usedCapaField);
        this.initField(this.usedPercentField);
        this.initField(this.thresholdField);
        this.initField(this.threshold2Field);
        this.initField(this.attributeField);
        this.initField(this.clprField);
        if (rJPoolPoolElement != null) {
            this.poolIdField.setText(rJPoolPoolElement.getName());
            this.setModifyFont(this.poolIdField);
            String string = "Pool/InfoStatusNormal";
            if (rJPoolPoolElement.isBlocked()) {
                string = "Pool/InfoStatusBlocked";
            } else if (rJPoolPoolElement.isTopVOLWarning()) {
                string = "Pool/InfoStatusWarning";
            }
            if (rJPoolPoolElement.isModifyBlocked()) {
                string = "Pool/InfoStatusBlockedNormal";
            }
            this.statusField.setText(RJcGuide.text(string));
            this.setModifyFont(this.statusField, rJPoolPoolElement.isModifyBlocked());
            this.totalCapaField.setText(rJPoolPoolElement.toCapacityString());
            this.setModifyFont(this.totalCapaField, rJPoolPoolElement.isModifyPoolVolCount());
            this.usedCapaField.setText(rJPoolPoolElement.toUsedString());
            this.setModifyFont(this.usedCapaField);
            int n = rJPoolPoolElement.getThreshold();
            int n2 = rJPoolPoolElement.getThreshold2();
            int n3 = rJPoolPoolElement.getUsedPercent();
            String string2 = "Pool/InfoUsedPercentNormal";
            int n4 = n;
            if (rJPoolPoolElement.getPoolKind() == 2) {
                int n5 = n4 = n < n2 ? n : n2;
            }
            if (n3 >= n4) {
                string2 = "Pool/InfoUsedPercentWarning";
            }
            if (n3 >= 100) {
                string2 = "Pool/InfoUsedPercentError";
            }
            this.usedPercentField.setText(this.info(string2, n3));
            this.setModifyFont(this.usedPercentField, rJPoolPoolElement.isModifyPoolVolCount());
            this.thresholdField.setText(this.info("Pool/InfoThreshold", n));
            this.setModifyFont(this.thresholdField, rJPoolPoolElement.isModifyThreshold());
            if (rJPoolPoolElement.getPoolKind() == 1) {
                this.threshold2Field.setText(RJcGuide.text("Pool/InfoThreshold2None"));
            } else {
                this.threshold2Field.setText(this.info("Pool/InfoThreshold2", n2));
            }
            this.setModifyFont(this.threshold2Field);
            String string3 = null;
            switch (rJPoolPoolElement.getPoolKind()) {
                case 1: {
                    string3 = RJcGuide.text("Pool/InfoAttrQuickShadow");
                    break;
                }
                case 2: {
                    string3 = RJcGuide.text("Pool/InfoAttrAOU");
                    break;
                }
                default: {
                    string3 = "";
                }
            }
            this.attributeField.setText(string3);
            this.setModifyFont(this.attributeField, rJPoolPoolElement.isModifyPoolKind());
            String string4 = rJPoolPoolElement.toClprString();
            if (string4 != null && string4.length() > 0) {
                this.clprField.setText(string4);
                this.clprField.setToolTipText(string4);
            }
            this.setModifyFont(this.clprField);
        }
    }

    private void initField(JLabel jLabel) {
        jLabel.setText(null);
        jLabel.setToolTipText(null);
        jLabel.setFont(RJcConst.boldFont);
    }

    private void setModifyFont(JLabel jLabel) {
        this.setModifyFont(jLabel, false);
    }

    private void setModifyFont(JLabel jLabel, boolean bl) {
        if (this.element.isNewPool() || this.element.isDeletePool() || bl) {
            Font font = jLabel.getFont();
            Font font2 = font.deriveFont(font.getStyle() + 2);
            jLabel.setFont(font2);
        }
    }

    public String info(String string, int n) {
        String string2 = RJcGuide.text(string);
        Object[] objectArray = new Object[]{new Integer(n)};
        MessageFormat messageFormat = new MessageFormat(string2);
        String string3 = messageFormat.format(objectArray);
        return string3;
    }
}

