/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.ppkey;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;

public class GZIPCompressor {
    public static final String GZIP_EXTENSION = ".gz";
    private static final int BUFFER_SIZE = 65536;
    private File targetFile;
    private File outputFile;
    private int bufferSize;

    public GZIPCompressor(File file) throws IOException {
        this(file, null);
    }

    public GZIPCompressor(File file, File file2) throws IOException {
        if (file == null || file.isDirectory()) {
            String string = "An illegal target was specified.";
            IOException iOException = new IOException(string);
            throw iOException;
        }
        this.targetFile = file;
        this.outputFile = file2 == null ? GZIPCompressor.correctedOutputFileName(this.targetFile) : GZIPCompressor.correctedOutputFileName(file2);
        this.bufferSize = 65536;
    }

    public File getTargetFile() {
        File file = this.targetFile;
        return file;
    }

    public File getOutputFile() {
        File file = this.outputFile;
        return file;
    }

    public int getBufferSize() {
        int n = this.bufferSize;
        return n;
    }

    public synchronized void setBufferSize(int n) {
        this.bufferSize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void compress() throws IOException {
        FileInputStream fileInputStream = null;
        GZIPOutputStream gZIPOutputStream = null;
        try {
            if (!this.outputFile.exists()) {
                this.outputFile.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.outputFile);
            fileInputStream = new FileInputStream(this.targetFile);
            gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
            byte[] byArray = new byte[this.bufferSize];
            int n = fileInputStream.read(byArray);
            while (n != -1) {
                gZIPOutputStream.write(byArray, 0, n);
                n = fileInputStream.read(byArray);
            }
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            }
            if (gZIPOutputStream != null) {
                try {
                    gZIPOutputStream.finish();
                    gZIPOutputStream.flush();
                    gZIPOutputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            }
        }
    }

    public static File correctedOutputFileName(File file) {
        File file2 = null;
        if (file != null) {
            File file3 = file.getParentFile();
            String string = file.getName();
            if (!string.endsWith(GZIP_EXTENSION)) {
                string = string.concat(GZIP_EXTENSION);
            }
            file2 = new File(file3, string);
        }
        return file2;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            throw new RuntimeException("\u5727\u7e2e\u5bfe\u8c61\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        File file = new File(stringArray[0]);
        File file2 = stringArray.length > 1 ? new File(stringArray[1]) : null;
        try {
            GZIPCompressor gZIPCompressor = new GZIPCompressor(file, file2);
            System.out.println("\u5727\u7e2e\u5bfe\u8c61:" + gZIPCompressor.getTargetFile());
            System.out.println("  \u51fa\u529b\u5148:" + gZIPCompressor.getOutputFile());
            System.out.println("\u30d0\u30c3\u30d5\u30a1\u30b5\u30a4\u30ba:" + gZIPCompressor.getBufferSize());
            gZIPCompressor.compress();
            System.out.println();
            System.out.println("compress completed.");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

