/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.profiles.dmtf.indications;

import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerSettings;
import com.ws.wbem.jserver.profiles.common.BaseInstanceProvider;
import com.ws.wbem.profiles.dmtf.indications.IndicationsBackupStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.provider.ProviderHandle;

public class IndicationFilterProvider
extends BaseInstanceProvider {
    private static boolean filterCreationEnabled = true;
    private String mCSName;

    public void close() {
    }

    public CIMObjectPath createInstance(CIMInstance cIMInstance) throws WBEMException {
        if (!filterCreationEnabled) {
            throw new WBEMException(7, "Indication service does not allow dynamic filter creation");
        }
        CIMObjectPath cIMObjectPath = this.findMatchingInstance(cIMInstance);
        if (null != cIMObjectPath) {
            cIMObjectPath = this.fixSystemName(cIMObjectPath);
        } else {
            String string;
            String string2 = cIMInstance.getObjectPath().getNamespace();
            CIMProperty[] cIMPropertyArray = cIMInstance.getProperties();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("SystemCreationClassName");
            arrayList.add("SystemName");
            arrayList.add("CreationClassName");
            arrayList.add("Name");
            arrayList.add("SourceNamespaces");
            arrayList.add("InstanceID");
            ArrayList<CIMProperty> arrayList2 = new ArrayList<CIMProperty>();
            for (int i = 0; i < cIMPropertyArray.length; ++i) {
                if (arrayList.contains(cIMPropertyArray[i].getName())) continue;
                arrayList2.add(cIMPropertyArray[i]);
            }
            CIMProperty cIMProperty = new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)this.mCSName, true);
            arrayList2.add(cIMProperty);
            CIMProperty cIMProperty2 = new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)"unknown", true);
            arrayList2.add(cIMProperty2);
            CIMProperty cIMProperty3 = new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)this.mClassName, true);
            arrayList2.add(cIMProperty3);
            String string3 = (String)cIMInstance.getPropertyValue("Name");
            if (string3 == null) {
                string3 = JServerProperties.getSchemaName() + ":" + UUID.randomUUID().toString();
            }
            CIMProperty cIMProperty4 = new CIMProperty("Name", CIMDataType.STRING_T, (Object)string3, true);
            arrayList2.add(cIMProperty4);
            CIMProperty cIMProperty5 = cIMInstance.getProperty("InstanceID");
            if (null == cIMProperty5 || null == cIMProperty5.getValue()) {
                cIMProperty5 = new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)string3, false);
            }
            arrayList2.add(cIMProperty5);
            CIMProperty cIMProperty6 = cIMInstance.getProperty("SourceNamespaces");
            String[] stringArray = this.getSourceNamespaces(cIMInstance);
            if (null == stringArray) {
                cIMProperty6 = cIMInstance.getProperty("SourceNamespaces");
            } else {
                string = (String)cIMInstance.getPropertyValue("SourceNamespace");
                if (null != string && !Arrays.asList(stringArray).contains(string)) {
                    throw new WBEMException(4, "SourceNamespace property has value that is not in String array value of SourceNamespaces property");
                }
                cIMProperty6 = new CIMProperty("SourceNamespaces", CIMDataType.STRING_ARRAY_T, (Object)stringArray, false);
            }
            arrayList2.add(cIMProperty6);
            string = cIMInstance.getObjectPath();
            CIMProperty[] cIMPropertyArray2 = new CIMProperty[]{cIMProperty4, cIMProperty2, cIMProperty, cIMProperty3};
            string = new CIMObjectPath(string.getScheme(), string.getHost(), string.getPort(), JServerProperties.getInteropNamespace(), this.mClassName, cIMPropertyArray2);
            cIMInstance = new CIMInstance((CIMObjectPath)string, arrayList2.toArray(new CIMProperty[arrayList2.size()]));
            cIMObjectPath = this.fixSystemName(mInternalProvider.createInstance(cIMInstance));
            if (!JServerProperties.getInteropNamespace().equals(string.getNamespace())) {
                return this.setNamespace(cIMObjectPath, string2);
            }
        }
        IndicationsBackupStore.storeData(mHandle);
        return cIMObjectPath;
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws WBEMException {
        mInternalProvider.deleteInstance(this.setInteropNamespace(this.cleanSystemName(cIMObjectPath)));
        IndicationsBackupStore.storeData(mHandle);
    }

    public CloseableIterator<CIMInstance> enumerateInstances(CIMObjectPath cIMObjectPath, String[] stringArray, String string, String string2, boolean bl) throws WBEMException {
        this.checkArguments(cIMObjectPath, WBEMOperation.OPENENUMERATEINSTANCES, string, string2, bl);
        CloseableIterator closeableIterator = mInternalProvider.enumerateInstances(this.setInteropNamespace(cIMObjectPath), stringArray, string, string2, bl);
        CloseableAddableIterator closeableAddableIterator = new CloseableAddableIterator();
        while (closeableIterator.hasNext()) {
            CIMInstance cIMInstance = this.fixSystemName((CIMInstance)closeableIterator.next());
            closeableAddableIterator.add((Object)this.cleanInstance(cIMObjectPath, cIMInstance));
        }
        closeableAddableIterator.done();
        return closeableAddableIterator;
    }

    private CIMObjectPath findMatchingInstance(CIMInstance cIMInstance) {
        CIMObjectPath cIMObjectPath;
        block5: {
            cIMObjectPath = null;
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath(null, null, null, JServerProperties.getInteropNamespace(), this.mClassName, null);
            try {
                CloseableIterator closeableIterator = mInternalProvider.enumerateInstances(cIMObjectPath2, null, null, null, false);
                if (!closeableIterator.hasNext()) break block5;
                String string = (String)cIMInstance.getPropertyValue("Query");
                String string2 = (String)cIMInstance.getPropertyValue("QueryLanguage");
                if (null == string || string.length() <= 0 || null == string2 || string2.length() <= 0) break block5;
                Object[] objectArray = this.getSourceNamespaces(cIMInstance);
                Boolean bl = cIMInstance.getPropertyValue("IndividualSubscriptionSupported") == null ? Boolean.TRUE : (Boolean)cIMInstance.getPropertyValue("IndividualSubscriptionSupported");
                String string3 = (String)cIMInstance.getPropertyValue("ElementName");
                while (closeableIterator.hasNext()) {
                    Boolean bl2;
                    CIMInstance cIMInstance2 = (CIMInstance)closeableIterator.next();
                    Object[] objectArray2 = this.getSourceNamespaces(cIMInstance2);
                    String string4 = (String)cIMInstance2.getPropertyValue("Query");
                    String string5 = (String)cIMInstance2.getPropertyValue("QueryLanguage");
                    String string6 = (String)cIMInstance2.getPropertyValue("ElementName");
                    Boolean bl3 = bl2 = cIMInstance2.getPropertyValue("IndividualSubscriptionSupported") == null ? Boolean.TRUE : (Boolean)cIMInstance2.getPropertyValue("IndividualSubscriptionSupported");
                    if (null == objectArray2 && null != objectArray || null != objectArray2 && null == objectArray || null == string6 && null != string3 || null != string6 && (null == string3 || !string6.equals(string3)) || !bl2.equals(bl) || !string.equalsIgnoreCase(string4) || !string2.equalsIgnoreCase(string5)) continue;
                    if (null == objectArray2) {
                        cIMObjectPath = cIMInstance2.getObjectPath();
                    } else {
                        Arrays.sort(objectArray2);
                        Arrays.sort(objectArray);
                        if (!Arrays.equals(objectArray2, objectArray)) continue;
                        cIMObjectPath = cIMInstance2.getObjectPath();
                    }
                    break;
                }
            }
            catch (WBEMException wBEMException) {
                // empty catch block
            }
        }
        return cIMObjectPath;
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, String[] stringArray) throws WBEMException {
        CIMObjectPath cIMObjectPath2 = this.cleanSystemName(cIMObjectPath);
        CIMInstance cIMInstance = mInternalProvider.getInstance(this.setInteropNamespace(cIMObjectPath2), stringArray);
        cIMInstance = this.fixSystemName(cIMInstance);
        return this.cleanInstance(cIMObjectPath, cIMInstance);
    }

    private String[] getSourceNamespaces(CIMInstance cIMInstance) {
        String[] stringArray = null;
        if (null != cIMInstance) {
            String string = cIMInstance.getObjectPath().getNamespace();
            CIMProperty cIMProperty = cIMInstance.getProperty("SourceNamespaces");
            String[] stringArray2 = null == cIMProperty ? new String[]{} : (String[])cIMProperty.getValue();
            boolean bl = string.equalsIgnoreCase(JServerProperties.getInteropNamespace());
            if (!bl) {
                for (String string2 : stringArray2) {
                    if (!string.equalsIgnoreCase(string2)) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray2));
                if (!bl) {
                    arrayList.add(string);
                }
                stringArray2 = arrayList.toArray(new String[arrayList.size()]);
            }
            stringArray = null == stringArray2 || stringArray2.length == 0 ? null : stringArray2;
        }
        return stringArray;
    }

    public void initialize(ProviderHandle providerHandle) throws WBEMException {
        super.initialize(providerHandle);
        this.mCSName = JServerSettings.replaceSchemaClassName((String)"WS_WBEMServerSystem");
        try {
            CIMInstance cIMInstance;
            String string = JServerProperties.getInteropNamespace();
            CloseableIterator closeableIterator = providerHandle.enumerateInstances(new CIMObjectPath(null, null, null, string, JServerSettings.replaceSchemaClassName((String)"WS_IndicationService"), null), null);
            if (closeableIterator.hasNext() && null != (cIMInstance = (CIMInstance)closeableIterator.next())) {
                Boolean bl = (Boolean)cIMInstance.getPropertyValue("FilterCreationEnabled");
                filterCreationEnabled = null == bl ? false : bl;
            }
        }
        catch (WBEMException wBEMException) {
            filterCreationEnabled = false;
            mLogger.log(Level.SEVERE, "Could not load instance of Indication Service, will use a value of false for FilterCreationEnabled", wBEMException);
        }
    }
}

