/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.profiles.dmtf.indications;

import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.jserver.IndicationHandler;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerSettings;
import com.ws.wbem.jserver.profiles.common.BaseInstanceProvider;
import com.ws.wbem.jserver.services.ObjectManagerAdapterService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.provider.ProviderHandle;

public class IndicationServiceProvider
extends BaseInstanceProvider {
    private static final String ERR_CANNOT_MODIFY_INSTANCE = "Cannot modify instance because the property \"%s\" in the IndicationService capabilities instance has a value of FALSE. This means the property \"%s\" cannot be modified.";
    private boolean mDeliveryRetryAttemptsIsSettable = false;
    private boolean mDeliveryRetryIntervalIsSettable = false;
    private boolean mSubscriptionRemovalActionIsSettable = false;
    private boolean mSubscriptionRemovalTimeIntervalIsSettable = false;

    public CloseableIterator<CIMInstance> enumerateInstances(CIMObjectPath cIMObjectPath, String[] stringArray, String string, String string2, boolean bl) throws WBEMException {
        CloseableAddableIterator closeableAddableIterator = new CloseableAddableIterator();
        CloseableIterator closeableIterator = mInternalProvider.enumerateInstances(cIMObjectPath, stringArray, string, string2, bl);
        while (closeableIterator.hasNext()) {
            CIMInstance cIMInstance = (CIMInstance)closeableIterator.next();
            cIMInstance = this.verifyInstance(cIMInstance);
            closeableAddableIterator.add((Object)cIMInstance);
        }
        closeableAddableIterator.done();
        return closeableAddableIterator;
    }

    public synchronized CIMInstance getInstance(CIMObjectPath cIMObjectPath, String[] stringArray) throws WBEMException {
        CIMObjectPath cIMObjectPath2 = this.cleanSystemName(cIMObjectPath);
        CIMInstance cIMInstance = mInternalProvider.getInstance(cIMObjectPath2, stringArray);
        cIMInstance = this.verifyInstance(cIMInstance);
        return this.cleanInstance(cIMObjectPath, cIMInstance);
    }

    public void initialize(ProviderHandle providerHandle) throws WBEMException {
        super.initialize(providerHandle);
        this.mClassName = JServerSettings.replaceSchemaClassName((String)"WS_IndicationService");
        try {
            CIMInstance cIMInstance;
            String string = JServerProperties.getInteropNamespace();
            CloseableIterator closeableIterator = providerHandle.enumerateInstances(new CIMObjectPath(null, null, null, string, JServerSettings.replaceSchemaClassName((String)"WS_IndicationServiceCapabilities"), null), null);
            if (closeableIterator.hasNext() && null != (cIMInstance = (CIMInstance)closeableIterator.next())) {
                Boolean bl = (Boolean)cIMInstance.getPropertyValue("DeliveryRetryAttemptsIsSettable");
                this.mDeliveryRetryAttemptsIsSettable = null == bl ? false : bl;
                Boolean bl2 = (Boolean)cIMInstance.getPropertyValue("DeliveryRetryIntervalIsSettable");
                this.mDeliveryRetryIntervalIsSettable = null == bl2 ? false : bl2;
                Boolean bl3 = (Boolean)cIMInstance.getPropertyValue("SubscriptionRemovalActionIsSettable");
                this.mSubscriptionRemovalActionIsSettable = null == bl3 ? false : bl3;
                Boolean bl4 = (Boolean)cIMInstance.getPropertyValue("SubscriptionRemovalTimeIntervalIsSettable");
                this.mSubscriptionRemovalTimeIntervalIsSettable = null == bl4 ? false : bl4;
            }
        }
        catch (WBEMException wBEMException) {
            mLogger.log(Level.SEVERE, "Could not load instance of Indication Service, will use a value of false for FilterCreationEnabled", wBEMException);
        }
    }

    public void modifyInstance(CIMInstance cIMInstance, String[] stringArray) throws WBEMException {
        IndicationHandler[] indicationHandlerArray;
        HashSet<String> hashSet = new HashSet<String>();
        if (null != stringArray) {
            for (String indicationHandlerArray2 : stringArray) {
                hashSet.add(indicationHandlerArray2);
            }
        }
        Object[] objectArray = null;
        if (!this.mDeliveryRetryAttemptsIsSettable && (null == stringArray || hashSet.contains("DeliveryRetryAttempts"))) {
            objectArray = new String[]{"DeliveryRetryAttemptsIsSettable", "DeliveryRetryAttempts"};
        } else if (!this.mDeliveryRetryIntervalIsSettable && (null == stringArray || hashSet.contains("DeliveryRetryInterval"))) {
            objectArray = new String[]{"DeliveryRetryIntervalIsSettable", "DeliveryRetryInterval"};
        } else if (!this.mSubscriptionRemovalActionIsSettable && (null == stringArray || hashSet.contains("SubscriptionRemovalAction"))) {
            objectArray = new String[]{"SubscriptionRemovalActionIsSettable", "SubscriptionRemovalAction"};
        } else if (!this.mSubscriptionRemovalTimeIntervalIsSettable && (null == stringArray || hashSet.contains("SubscriptionRemovalTimeInterval"))) {
            objectArray = new String[]{"SubscriptionRemovalTimeIntervalIsSettable", "SubscriptionRemovalTimeInterval"};
        }
        if (null != objectArray) {
            String string = String.format(ERR_CANNOT_MODIFY_INSTANCE, objectArray);
            throw new WBEMException(1, string);
        }
        CIMInstance cIMInstance2 = this.cleanSystemName(cIMInstance);
        mInternalProvider.modifyInstance(cIMInstance2, stringArray);
        for (IndicationHandler indicationHandler : indicationHandlerArray = ObjectManagerAdapterService.getIHAHandles()) {
            indicationHandler.refreshIndicationServiceValues(cIMInstance);
        }
    }

    public CIMInstance verifyInstance(CIMInstance cIMInstance) {
        CIMInstance cIMInstance2 = cIMInstance.deriveInstance(this.verifyObjectPath(cIMInstance.getObjectPath()));
        CIMProperty cIMProperty = new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)this.getHostName(), true);
        cIMInstance2 = cIMInstance2.deriveInstance(new CIMProperty[]{cIMProperty});
        return cIMInstance2;
    }

    public CIMObjectPath verifyObjectPath(CIMObjectPath cIMObjectPath) {
        CIMProperty[] cIMPropertyArray;
        ArrayList<CIMProperty> arrayList = new ArrayList<CIMProperty>();
        for (CIMProperty cIMProperty : cIMPropertyArray = cIMObjectPath.getKeys()) {
            if (cIMProperty.getName().equalsIgnoreCase("SystemName")) {
                arrayList.add(new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)this.getHostName(), true));
                continue;
            }
            arrayList.add(cIMProperty);
        }
        return new CIMObjectPath(cIMObjectPath.getScheme(), cIMObjectPath.getHost(), cIMObjectPath.getPort(), cIMObjectPath.getNamespace(), cIMObjectPath.getObjectName(), arrayList.toArray(new CIMProperty[arrayList.size()]));
    }
}

