/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.profiles.snia.indications;

import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerSettings;
import com.ws.wbem.jserver.profiles.common.BaseInstanceProvider;
import java.text.MessageFormat;
import java.util.UUID;
import java.util.logging.Level;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;
import javax.wbem.provider.ProviderHandle;

public class IndicationConfigurationServiceProvider
extends BaseInstanceProvider {
    private final int TESTLISTENER_RESULT_SUCCESS = 0;
    private final int TESTLISTENER_RESULT_INVALIDPARAMETER = 5;
    private static final String CCN_SUBSCRIPTION = "WS_IndicationSubscription";
    private static final String CCN_CAPABILITIES = "SNIA_IndicationConfigurationCapabilities";
    private static final String TESTINDICATION_DESC = "Test Alert Indication";
    private static final String OTHER_ALERTTYPE = "Destination Test";
    private final String OTHER = "Other";
    private final String CIM_XML = "CIM-XML";
    private final String WS_MAN = "WS-Management";
    private static final String TEST_MESSAGE = "A test of the listener destination {0} was invoked with the URL {1} using the {2} Protocol.";

    public void initialize(ProviderHandle providerHandle) throws WBEMException {
        super.initialize(providerHandle);
        this.mClassName = JServerSettings.replaceSchemaClassName((String)"SNIA_IndicationConfigurationService");
        try {
            CIMInstance cIMInstance;
            String string = JServerProperties.getInteropNamespace();
            CloseableIterator closeableIterator = providerHandle.enumerateInstances(new CIMObjectPath(null, null, null, string, JServerSettings.replaceSchemaClassName((String)CCN_CAPABILITIES), null), null);
            if (closeableIterator.hasNext() && null != (cIMInstance = (CIMInstance)closeableIterator.next())) {
                UnsignedInteger16[] unsignedInteger16Array = (UnsignedInteger16[])cIMInstance.getPropertyValue("SupportedSynchronousActions");
            }
        }
        catch (WBEMException wBEMException) {
            mLogger.log(Level.SEVERE, "Could not load instance of IndicationConfigurationCapabilities, ", wBEMException);
        }
    }

    public Object invokeMethod(CIMObjectPath cIMObjectPath, String string, CIMArgument<?>[] cIMArgumentArray, CIMArgument<?>[] cIMArgumentArray2) throws WBEMException {
        int n = 5;
        if ("TestListener".equals(string)) {
            CIMObjectPath cIMObjectPath2 = null;
            for (CIMArgument<?> cIMArgument : cIMArgumentArray) {
                if (!"Destination".equals(cIMArgument.getName())) continue;
                cIMObjectPath2 = (CIMObjectPath)cIMArgument.getValue();
                if (null != cIMObjectPath2) {
                    CIMInstance cIMInstance = this.createTestSubscription(cIMObjectPath2);
                    CIMInstance cIMInstance2 = this.createTestIndicationInstance(cIMObjectPath2);
                    Object[] objectArray = new Object[]{cIMObjectPath2};
                    mLogger.log(Level.INFO, "Delivering test indication to listener: {0}", objectArray);
                    mHandle.deliverEvent(cIMInstance2, new CIMInstance[]{cIMInstance});
                    n = 0;
                    continue;
                }
                mLogger.log(Level.WARNING, "Could not deliver test indication because specified listener is null");
            }
        } else {
            throw WBEMOperationErrors.getMethodNotSupportedException((CIMObjectPath)cIMObjectPath, (String)string, (WBEMOperation)WBEMOperation.INVOKEMETHOD);
        }
        return new UnsignedInteger32((long)n);
    }

    private CIMInstance createTestIndicationInstance(CIMObjectPath cIMObjectPath) throws WBEMException {
        CIMInstance cIMInstance = mHandle.getInstance(cIMObjectPath, null);
        String string = (String)cIMInstance.getPropertyValue("Destination");
        String string2 = (String)cIMInstance.getPropertyValue("ElementName");
        UnsignedInteger16 unsignedInteger16 = (UnsignedInteger16)cIMInstance.getPropertyValue("Protocol");
        String string3 = "Other";
        if (null != unsignedInteger16) {
            switch (unsignedInteger16.intValue()) {
                case 2: {
                    string3 = "CIM-XML";
                    break;
                }
                case 4: {
                    string3 = "WS-Management";
                    break;
                }
                default: {
                    string3 = "Other";
                }
            }
        }
        Object[] objectArray = new Object[]{string2, string, string3};
        MessageFormat messageFormat = new MessageFormat(TEST_MESSAGE);
        String string4 = messageFormat.format(objectArray);
        CIMProperty[] cIMPropertyArray = new CIMProperty[]{new CIMProperty("Description", CIMDataType.STRING_T, (Object)TESTINDICATION_DESC, false), new CIMProperty("AlertingManagedElement", CIMDataType.STRING_T, (Object)TESTINDICATION_DESC, false), new CIMProperty("AlertingElementFormat", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(1), false), new CIMProperty("AlertType", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(1), false), new CIMProperty("OtherAlertType", CIMDataType.STRING_T, (Object)OTHER_ALERTTYPE, false), new CIMProperty("PerceivedSeverity", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(2), false), new CIMProperty("ProbableCause", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(1), false), new CIMProperty("Trending", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(1), false), new CIMProperty("EventTime", CIMDataType.DATETIME_T, (Object)new CIMDateTimeAbsolute(), false), new CIMProperty("EventID", CIMDataType.STRING_T, (Object)UUID.randomUUID().toString(), false), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"CIM_AlertIndication", false), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)this.getHostName(), false), new CIMProperty("ProviderName", CIMDataType.STRING_T, (Object)(this.mClassName + " Provider"), false), new CIMProperty("Message", CIMDataType.STRING_T, (Object)string4, false), new CIMProperty("MessageID", CIMDataType.STRING_T, (Object)"MP22", false), new CIMProperty("OwningEntity", CIMDataType.STRING_T, (Object)"SNIA", false)};
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath(null, null, null, JServerProperties.getInteropNamespace(), "CIM_AlertIndication", null);
        return new CIMInstance(cIMObjectPath2, cIMPropertyArray);
    }

    private CIMInstance createTestSubscription(CIMObjectPath cIMObjectPath) {
        CIMProperty[] cIMPropertyArray = new CIMProperty[]{new CIMProperty("Handler", new CIMDataType("CIM_ListenerDestination"), (Object)cIMObjectPath, true), new CIMProperty("Filter", new CIMDataType("WS_IndicationFilter"), null, true)};
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath(null, null, null, JServerProperties.getInteropNamespace(), CCN_SUBSCRIPTION, cIMPropertyArray);
        return new CIMInstance(cIMObjectPath2, cIMPropertyArray);
    }

    public CloseableIterator<CIMInstance> enumerateInstances(CIMObjectPath cIMObjectPath, String[] stringArray, String string, String string2, boolean bl) throws WBEMException {
        CloseableAddableIterator closeableAddableIterator = new CloseableAddableIterator();
        CloseableIterator closeableIterator = mInternalProvider.enumerateInstances(cIMObjectPath, stringArray, string, string2, bl);
        while (closeableIterator.hasNext()) {
            CIMInstance cIMInstance = (CIMInstance)closeableIterator.next();
            cIMInstance = this.fixSystemName(cIMInstance);
            closeableAddableIterator.add((Object)this.cleanInstance(cIMObjectPath, cIMInstance));
        }
        closeableAddableIterator.done();
        return closeableAddableIterator;
    }

    public synchronized CIMInstance getInstance(CIMObjectPath cIMObjectPath, String[] stringArray) throws WBEMException {
        CIMObjectPath cIMObjectPath2 = this.cleanSystemName(cIMObjectPath);
        CIMInstance cIMInstance = mInternalProvider.getInstance(cIMObjectPath2, stringArray);
        cIMInstance = this.fixSystemName(cIMInstance);
        return this.cleanInstance(cIMObjectPath, cIMInstance);
    }
}

