/*
 * Decompiled with CFR 0.152.
 */
package sanproject.snctrl.thread;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import sanproject.portmanager.SJsncPortManager;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.snctrl.com.SJsnctrlSnConst;
import sanproject.snctrl.com.utility.SJcExecCmdUty;
import sanproject.snctrl.com.utility.SJcSleepUty;

public class SJsnctrlSnWebAppThread
extends Thread {
    private static final String LOG_FUNCTION = "Jetty";
    private final String LOG_TITLE = this.getClass().getSimpleName();
    final SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
    protected String dkcpath = null;
    protected static long SN_WAIT = 1000L;

    protected void waitSNService() {
        String LOG_SUBTITLE = "waitSNService";
        this.STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "waitSNService", "Start.");
        boolean isAlive = this.isAliveSN();
        while (isAlive) {
            this.STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "waitSNService", "SN2 Service is still alive.");
            if (!SJcSleepUty.sleepSchedule(SN_WAIT)) break;
            isAlive = this.isAliveSN();
            if (isAlive) continue;
            this.STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "waitSNService", "SN2 Service stopped.");
        }
        this.STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "waitSNService", "End.");
    }

    protected boolean isAliveSN() {
        String LOG_SUBTITLE = "isAliveSN";
        this.STD_LOGGER.trace(LOG_FUNCTION, this.LOG_TITLE, "isAliveSN", "Start.");
        boolean result = false;
        String dkcid = this.getDKCID();
        String batFilePath = this.dkcpath + SJsnctrlSnConst.BAT_GET_SN_SERVICE;
        ArrayList<String> execBatcmd = SJcExecCmdUty.createStrcmd("CSCRIPT", "//NOLOGO", batFilePath, dkcid, "SN2Service");
        HashMap<String, ArrayList<String>> mapStdErr = SJcExecCmdUty.execCmd(execBatcmd);
        ArrayList<String> stdOutList = mapStdErr.get(SJcExecCmdUty.KEY_STDOUT);
        for (String stdOut : stdOutList) {
            if (stdOut.trim().length() == 0) continue;
            this.STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "isAliveSN", "Process ID = " + stdOut);
            result = true;
        }
        ArrayList<String> stdErrList = mapStdErr.get(SJcExecCmdUty.KEY_STDERR);
        for (String stdErr : stdErrList) {
            this.STD_LOGGER.warn(LOG_FUNCTION, this.LOG_TITLE, "isAliveSN", stdErr);
        }
        this.STD_LOGGER.trace(LOG_FUNCTION, this.LOG_TITLE, "isAliveSN", "End.");
        return result;
    }

    protected void releasePortNo() {
        String LOG_SUBTITLE = "releasePortNo";
        this.STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "releasePortNo", "Start.");
        String dkcid = this.getDKCID();
        int result = 0;
        String key = null;
        key = "DeviceJettyStart";
        result = SJsncPortManager.releasePortNo((String)key, (String)dkcid);
        this.STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "releasePortNo", "KEY = " + key + ", DKCID = " + dkcid + ", result = " + result);
        key = "DeviceJettyStop";
        result = SJsncPortManager.releasePortNo((String)key, (String)dkcid);
        this.STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "releasePortNo", "KEY = " + key + ", DKCID = " + dkcid + ", result = " + result);
        this.STD_LOGGER.info(LOG_FUNCTION, this.LOG_TITLE, "releasePortNo", "End.");
    }

    protected String getDKCID() {
        File file = new File(this.dkcpath);
        String dkcid = file.getName();
        return dkcid;
    }
}

