/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.report;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import sanproject.sn2.rptdt.exception.SJdtRPTDTException;
import sanproject.sn2.rptdt.report.generator.SJdtReportGeneratorBase;

public class SJdtReportGeneratorManager {
    private static Logger logger = Logger.getLogger(SJdtReportGeneratorManager.class.getName());
    public static String devinfo = null;
    public static String outputDir = null;
    private static Properties guidanceProc = null;
    public static final String TEMPLATE_BASE_DIR = "/sanproject/sn2/rptdt/template";
    public static final String FILE_EXTENSION = ".html";

    public static void setOutputDir(String dir) {
        outputDir = dir;
    }

    public static void setGuidanceData(Properties proc) {
        guidanceProc = proc;
    }

    public static String getGuidanceValue(String key) {
        return guidanceProc.getProperty(key);
    }

    public static boolean generateDir(String dirPath) {
        boolean result = false;
        File dir = new File(dirPath);
        dir.mkdirs();
        result = dir.exists();
        if (!result) {
            logger.severe("Directory not found [" + dirPath + "]");
        }
        return result;
    }

    public static void copyFile(String originalFilePath, String destFilePath) throws SJdtRPTDTException {
        int BUFFER_SIZE = 1024;
        byte[] buff = new byte[1024];
        InputStream is = null;
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int length;
            is = SJdtReportGeneratorManager.class.getClass().getResourceAsStream(originalFilePath);
            bis = new BufferedInputStream(is);
            File destFile = new File(destFilePath);
            bos = new BufferedOutputStream(new FileOutputStream(destFile));
            while ((length = bis.read(buff)) >= 0) {
                ((BufferedOutputStream)bos).write(buff, 0, length);
            }
        }
        catch (FileNotFoundException e) {
            logger.severe("originalFilePath=[" + originalFilePath + "], destFilePath=[" + destFilePath + "]");
            throw new SJdtRPTDTException(e);
        }
        catch (IOException e) {
            logger.severe("originalFilePath=[" + originalFilePath + "], destFilePath=[" + destFilePath + "]");
            throw new SJdtRPTDTException(e);
        }
        catch (Exception e) {
            logger.severe("originalFilePath=[" + originalFilePath + "], destFilePath=[" + destFilePath + "]");
            throw new SJdtRPTDTException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.warning(e.getMessage());
                }
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    logger.warning(e.getMessage());
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    logger.warning(e.getMessage());
                }
            }
        }
    }

    public static VelocityContext getVelocityContext() {
        VelocityContext context = new VelocityContext();
        context.put("encoding", (Object)"utf-8");
        return context;
    }

    public static void generateFile(List<String[]> tableDataList, String generateFilePath) throws SJdtRPTDTException {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(generateFilePath, false));
            for (Object[] objectArray : tableDataList) {
                bw.append(StringUtils.join((Object[])objectArray, (String)","));
                bw.newLine();
            }
            bw.flush();
        }
        catch (IOException e) {
            logger.severe("generateFilePath=[" + generateFilePath + "]");
            throw new SJdtRPTDTException(e);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    logger.warning(e.getMessage());
                }
            }
        }
    }

    public static void generateFile(VelocityContext context, String templateFilePath, String generateFilePath) throws SJdtRPTDTException {
        Template template = SJdtReportGeneratorManager.getTemplate(templateFilePath);
        StringWriter sw = new StringWriter();
        try {
            template.merge((Context)context, (Writer)sw);
        }
        catch (ResourceNotFoundException e) {
            logger.severe("templateFilePath=[" + templateFilePath + "]");
            throw new SJdtRPTDTException(e);
        }
        catch (ParseErrorException e) {
            logger.severe("templateFilePath=[" + templateFilePath + "]");
            throw new SJdtRPTDTException(e);
        }
        catch (MethodInvocationException e) {
            logger.severe("templateFilePath=[" + templateFilePath + "]");
            throw new SJdtRPTDTException(e);
        }
        catch (IOException e) {
            logger.severe("templateFilePath=[" + templateFilePath + "]");
            throw new SJdtRPTDTException(e);
        }
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(generateFilePath, false));
            bw.write(sw.toString());
            bw.flush();
        }
        catch (IOException e) {
            logger.severe("generateFilePath=[" + generateFilePath + "]");
            throw new SJdtRPTDTException(e);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    logger.warning(e.getMessage());
                }
            }
        }
    }

    private static Template getTemplate(String templateFilePath) throws SJdtRPTDTException {
        Template template = null;
        try {
            template = Velocity.getTemplate((String)templateFilePath);
        }
        catch (ResourceNotFoundException e) {
            logger.severe("templateFilePath=[" + templateFilePath + "]");
            throw new SJdtRPTDTException(e);
        }
        catch (ParseErrorException e) {
            logger.severe("templateFilePath=[" + templateFilePath + "]");
            throw new SJdtRPTDTException(e);
        }
        catch (Exception e) {
            logger.severe("templateFilePath=[" + templateFilePath + "]");
            throw new SJdtRPTDTException(e);
        }
        return template;
    }

    public static void copyAllFile(SJdtReportGeneratorBase generator, String inputDir, String outputDir) throws SJdtRPTDTException {
        Class<?> c = generator.getClass();
        URL url = c.getResource(c.getSimpleName() + ".class");
        String jarClassPath = url.toExternalForm();
        int start = jarClassPath.indexOf("/") + 1;
        String classPath = c.getName().replace(".", "/");
        int end = jarClassPath.indexOf(classPath) - 2;
        String jarFilePath = null;
        try {
            jarFilePath = URLDecoder.decode(jarClassPath.substring(start, end), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.severe("inputDir=[" + inputDir + "], outputImgDir=[" + outputDir + "], " + "jarClassPathBeforeDecode=[" + jarClassPath.substring(start, end) + "]");
            throw new SJdtRPTDTException(e);
        }
        String inputDirPath = "sanproject/sn2/rptdt/template" + inputDir;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jarFilePath);
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry zipEntry = e.nextElement();
                String filePath = zipEntry.getName();
                if (zipEntry.isDirectory() || !filePath.startsWith(inputDirPath)) continue;
                String fileName = filePath.substring(filePath.lastIndexOf("/") + 1);
                String originalFilePath = TEMPLATE_BASE_DIR + inputDir + fileName;
                String destFilePath = outputDir + fileName;
                SJdtReportGeneratorManager.copyFile(originalFilePath, destFilePath);
            }
        }
        catch (IOException e) {
            logger.severe("inputDir=[" + inputDir + "], outputImgDir=[" + outputDir + "], " + "jarFilePath=[" + jarFilePath + "]");
            throw new SJdtRPTDTException(e);
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException e) {
                logger.warning(e.getMessage());
            }
        }
    }
}

