/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.report.generator;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import sanproject.sn2.rptdt.csv.SJdtCSVWrapperManager;
import sanproject.sn2.rptdt.csv.wrapper.SJdtChaStatusCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtMpPcbStatusCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtPkInfoCSVWrapper;
import sanproject.sn2.rptdt.exception.SJdtRPTDTException;
import sanproject.sn2.rptdt.report.SJdtReportGeneratorManager;
import sanproject.sn2.rptdt.report.generator.Cha;
import sanproject.sn2.rptdt.report.generator.SJdtReportGeneratorBase;

public class SJdtChaReportGenerator
extends SJdtReportGeneratorBase {
    private static final String REPORT_NAME = "Cha";
    private static final boolean IS_GRAPHIC_REPORT = true;
    private static final boolean USE_TABLE_SORT = false;
    private static final boolean USE_CONTENTS_FOOTER = true;
    private static final String MENU_LINK_VIEW_KEY = "Common.menu.Cha";
    private static final String EXPLANATION_KEY = "Common.explanation.Cha";
    private static final String VM_LIBLARY_PATH = "/sanproject/sn2/rptdt/template/cha/vm/VM_cha_library.vm";
    private static final String CONTENTS_BODY_VM_FILE_PATH = "/sanproject/sn2/rptdt/template/cha/vm/contentsBody_Cha.vm";
    private static final String CONTENTS_FOOTER_VM_FILE_PATH = "/sanproject/sn2/rptdt/template/cha/vm/contentsFooter_Cha.vm";
    private static final String REPORT_FRAMESET_HTML_FILE_NAME = "Cha.html";
    private static final String MENU_FRAMESET_HTML_FILE_NAME = "menuFrameset_Cha.html";
    private static final String MENU_BODY_HTML_FILE_NAME = "menuBody_Cha.html";
    private static final String CONTENTS_FRAMESET_HTML_FILE_NAME = "contentsFrameset_Cha.html";
    private static final String CONTENTS_TITLE_HTML_FILE_NAME = "contentsTitle_Cha.html";
    private static final String CONTENTS_FOOTER_HTML_FILE_NAME = "contentsFooter_Cha.html";
    private static final String CONTENTS_BODY_HTML_FILE_NAME = "contentsBody_Cha.html";
    private static final int lcpFcpColumnSize = 8;

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    @Override
    public boolean isGraphicReport() {
        return true;
    }

    @Override
    public boolean useTableSort() {
        return false;
    }

    @Override
    public boolean useContentsFooter() {
        return true;
    }

    @Override
    public String getMenuLinkViewKey() {
        return MENU_LINK_VIEW_KEY;
    }

    @Override
    public String getExplanationKey() {
        return EXPLANATION_KEY;
    }

    @Override
    public String getReportFramesetHtmlFileName() {
        return REPORT_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuFramesetHtmlFileName() {
        return MENU_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuBodyHtmlFileName() {
        return MENU_BODY_HTML_FILE_NAME;
    }

    @Override
    public String getContentsFramesetHtmlFileName() {
        return CONTENTS_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getContentsTitleHtmlFileName() {
        return CONTENTS_TITLE_HTML_FILE_NAME;
    }

    @Override
    public String getContentsBodyHtmlFileName() {
        return CONTENTS_BODY_HTML_FILE_NAME;
    }

    @Override
    public void generateReportDir() {
        super.generateReportDir();
        SJdtReportGeneratorManager.generateDir(this.OUTPUT_CSS_DIR);
        SJdtReportGeneratorManager.generateDir(this.OUTPUT_IMG_DIR);
    }

    @Override
    public void generateContentsFrameset() throws SJdtRPTDTException {
        super.generateContentsFrameset3pane();
    }

    @Override
    public void generateContentsFooter() throws SJdtRPTDTException {
        try {
            VelocityContext context = SJdtReportGeneratorManager.getVelocityContext();
            context.put("installed", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.legend.installed"));
            context.put("notInstalled", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.legend.notInstalled"));
            String generateFrontFilePath = this.OUTPUT_HTML_DIR + CONTENTS_FOOTER_HTML_FILE_NAME;
            SJdtReportGeneratorManager.generateFile(context, CONTENTS_FOOTER_VM_FILE_PATH, generateFrontFilePath);
        }
        catch (SJdtRPTDTException e) {
            e.setReportStatus(this.getReportFramesetHtmlFileName(), "20520-107106");
            throw e;
        }
    }

    @Override
    public void generateContentsBody() throws SJdtRPTDTException {
        VelocityContext context = SJdtReportGeneratorManager.getVelocityContext();
        context.put("libraryPath", (Object)VM_LIBLARY_PATH);
        this.setFixedStr(context);
        this.setVariableStr(context);
        String generateFilePath = this.OUTPUT_HTML_DIR + this.getContentsBodyHtmlFileName();
        SJdtReportGeneratorManager.generateFile(context, CONTENTS_BODY_VM_FILE_PATH, generateFilePath);
        String cssFileName = "contentsBody_Cha.css";
        String originalFilePath = "/sanproject/sn2/rptdt/template/cha/css/" + cssFileName;
        String destFilePath = this.OUTPUT_CSS_DIR + cssFileName;
        SJdtReportGeneratorManager.copyFile(originalFilePath, destFilePath);
        SJdtReportGeneratorManager.copyAllFile(this, "/cha/img/", this.OUTPUT_IMG_DIR);
    }

    private void setFixedStr(VelocityContext context) {
        context.put("dkc", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.dkc"));
        context.put("numbersOfPorts", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.numbersOfPorts"));
        context.put("cha1pa", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha1pa"));
        context.put("cha1pb", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha1pb"));
        context.put("cha1pc", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha1pc"));
        context.put("cha1pd", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha1pd"));
        context.put("cha1pe", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha1pe"));
        context.put("cha1pf", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha1pf"));
        context.put("cha2pa", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha2pa"));
        context.put("cha2pb", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha2pb"));
        context.put("cha2pc", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha2pc"));
        context.put("cha2pd", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha2pd"));
        context.put("cha2pe", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha2pe"));
        context.put("cha2pf", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha2pf"));
        context.put("cha1pg", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha1pg"));
        context.put("cha1ph", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha1ph"));
        context.put("cha1pj", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha1pj"));
        context.put("cha1pk", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha1pk"));
        context.put("cha1pl", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha1pl"));
        context.put("cha1pm", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha1pm"));
        context.put("cha2pg", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha2pg"));
        context.put("cha2ph", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha2ph"));
        context.put("cha2pj", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha2pj"));
        context.put("cha2pk", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha2pk"));
        context.put("cha2pl", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha2pl"));
        context.put("cha2pm", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.cha2pm"));
        context.put("notInstalled", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cha.notInstalled"));
    }

    private void setVariableStr(VelocityContext context) {
        SJdtMpPcbStatusCSVWrapper mpPcbStatus = (SJdtMpPcbStatusCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("MpPcbStatus.csv");
        boolean useDkc1Flg = mpPcbStatus.existsModule1Data();
        context.put("useDkc1Flg", (Object)useDkc1Flg);
        this.setChaInfo(context);
    }

    private void setChaInfo(VelocityContext context) {
        SJdtChaStatusCSVWrapper chaStatus = (SJdtChaStatusCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("ChaStatus.csv");
        SJdtPkInfoCSVWrapper pkInfo = (SJdtPkInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("PkInfo.csv");
        HashMap<String, Cha> chaMap = new HashMap<String, Cha>();
        int dkc0NumberOfPorts = 0;
        int dkc1NumberOfPorts = 0;
        List<String[]> csvDataList = chaStatus.getCsvDataList();
        for (String[] chaStatusRecord : csvDataList) {
            Cha cha = new Cha();
            String chaLocation = chaStatus.getValue(chaStatusRecord, "CHA Location");
            String chaLocationLowerCace = chaLocation.replaceFirst("-", "").toLowerCase();
            String packageType = pkInfo.getMatchedOneRecordColumnValue(chaLocation, "CHA Location", "Package Type");
            cha.setPackageType(packageType);
            int numberOfPort = 0;
            Boolean[] portInstalledArray = new Boolean[8];
            for (int i = 0; i < 8; ++i) {
                String lcpFcpColumn = "Port#0" + i;
                String lcpFcp = chaStatus.getValue(chaStatusRecord, lcpFcpColumn);
                if (StringUtils.isNotEmpty((String)lcpFcp)) {
                    ++numberOfPort;
                    portInstalledArray[i] = Boolean.TRUE;
                    continue;
                }
                portInstalledArray[i] = Boolean.FALSE;
            }
            cha.setPortInstalledArray(portInstalledArray);
            if ("0".equals(chaStatus.getValue(chaStatusRecord, "Module#"))) {
                dkc0NumberOfPorts += numberOfPort;
            } else {
                dkc1NumberOfPorts += numberOfPort;
            }
            chaMap.put(chaLocationLowerCace, cha);
        }
        context.put("chaMap", chaMap);
        context.put("valueOfDkc0NumberOfPorts", (Object)String.valueOf(dkc0NumberOfPorts));
        context.put("valueOfDkc1NumberOfPorts", (Object)String.valueOf(dkc1NumberOfPorts));
    }
}

