/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.report.generator;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Logger;
import org.apache.velocity.VelocityContext;
import sanproject.sn2.rptdt.csv.SJdtCSVWrapperManager;
import sanproject.sn2.rptdt.csv.wrapper.SJdtChaStatusCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtDkaStatusCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtDkcInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtHduInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtMicroVersionCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtMpPcbStatusCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtPTMInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtPdevInfoCSVWrapper;
import sanproject.sn2.rptdt.exception.SJdtRPTDTException;
import sanproject.sn2.rptdt.report.SJdtReportGeneratorManager;
import sanproject.sn2.rptdt.report.generator.Pdev;
import sanproject.sn2.rptdt.report.generator.SJdtPhysicalReportGenerator;
import sanproject.sn2.rptdt.util.SJdtRPTDTDevice;

public class SJdtHMPhysicalReportGenerator
extends SJdtPhysicalReportGenerator {
    private static Logger logger = Logger.getLogger(SJdtPhysicalReportGenerator.class.getName());
    private static final String REPORT_NAME = "Physical";
    private static final String VM_LIBLARY_PATH = "/sanproject/sn2/rptdt/template/physical/vm/VM_HMphysical_library.vm";
    private static final String COMMON_DIR = SJdtReportGeneratorManager.outputDir + "common" + File.separator;
    private static final String COMMON_CSS_DIR = COMMON_DIR + "css" + File.separator;
    private static final String CONTENTS_TITLE_VM_FILE_PATH = "/sanproject/sn2/rptdt/template/physical/vm/contentsTitle_HMPhysical.vm";
    private static final String CONTENTS_BODY_VM_FILE_PATH = "/sanproject/sn2/rptdt/template/physical/vm/contentsBody_HMPhysical.vm";
    private static final String CONTENTS_MENU_VM_FILE_PATH = "/sanproject/sn2/rptdt/template/physical/vm/contentsMenu_HMPhysical.vm";
    private static final String CONTENTS_FOOTER_VM_FILE_PATH = "/sanproject/sn2/rptdt/template/physical/vm/contentsFooter_Physical.vm";
    private static final String CONTENTS_FOOTER_HTML_FILE_NAME = "contentsFooter_Physical.html";
    private static final String CONTENTS_BODY_HTML_FILE_NAME = "contentsBody_Physical.html";
    private static final String CONTENTS_MENU_HTML_FILE_NAME = "contentsMenu_Physical.html";
    private static final String[] pdevLocationSuffixArray12 = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11"};
    private static final String[] pdevLocationSuffixArray24 = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};
    private static final String[] pdevLocationSuffixArray60 = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59"};
    protected static final String CONTENTS_FRAMESET_4PANE_VM_FILE_PATH = "/sanproject/sn2/rptdt/template/common/vm/contentsFrameset_4pane.vm";
    private static final int DB_TOP_SIZE_DBS = 80;
    private static final int DB_TOP_SIZE_DBL = 80;
    private static final int DB_TOP_SIZE_DBF = 93;
    private static final int DB_TOP_SIZE_DB60 = 261;
    private static final int DB_TOP_SIZE_DBF2 = 93;
    private static final String DB_TYPE_DBS = "DBS";
    private static final String DB_TYPE_DBL = "DBL";
    private static final String DB_TYPE_DBF = "DBF";
    private static final String DB_TYPE_DB60 = "DB60";
    private static final String DB_TYPE_DBF2 = "DBF2";
    private static final String DB_TYPE_DB60S = "DB60S";

    @Override
    public String getContentsMenuHtmlFileName() {
        return CONTENTS_MENU_HTML_FILE_NAME;
    }

    @Override
    public void generateContentsFrameset() throws SJdtRPTDTException {
        try {
            VelocityContext context = SJdtReportGeneratorManager.getVelocityContext();
            context.put("contentsTitleName", (Object)this.getReportName());
            context.put("contentsBodyName", (Object)this.getReportName());
            context.put("contentsFooterName", (Object)this.getReportName());
            String generateFrontFilePath = this.OUTPUT_HTML_DIR + this.getContentsFramesetHtmlFileName();
            SJdtReportGeneratorManager.generateFile(context, CONTENTS_FRAMESET_4PANE_VM_FILE_PATH, generateFrontFilePath);
        }
        catch (SJdtRPTDTException e) {
            e.setReportStatus(this.getReportFramesetHtmlFileName(), "20520-107104");
            throw e;
        }
    }

    @Override
    public void generateContentsTitle() throws SJdtRPTDTException {
        try {
            VelocityContext context = SJdtReportGeneratorManager.getVelocityContext();
            context.put("libraryPath", (Object)VM_LIBLARY_PATH);
            context.put("contensTitle", (Object)SJdtReportGeneratorManager.getGuidanceValue(this.getMenuLinkViewKey()));
            context.put("explanation", (Object)SJdtReportGeneratorManager.getGuidanceValue(this.getExplanationKey()));
            String generateFrontFilePath = this.OUTPUT_HTML_DIR + this.getContentsTitleHtmlFileName();
            SJdtReportGeneratorManager.generateFile(context, CONTENTS_TITLE_VM_FILE_PATH, generateFrontFilePath);
        }
        catch (SJdtRPTDTException e) {
            e.setReportStatus(this.getReportFramesetHtmlFileName(), "20520-107105");
            throw e;
        }
    }

    @Override
    public void generateContentsFooter() throws SJdtRPTDTException {
        try {
            VelocityContext context = SJdtReportGeneratorManager.getVelocityContext();
            context.put("sas", (Object)SJdtReportGeneratorManager.getGuidanceValue("Physical.legend.sas"));
            context.put("sata", (Object)SJdtReportGeneratorManager.getGuidanceValue("Physical.legend.sata"));
            context.put("ssd", (Object)SJdtReportGeneratorManager.getGuidanceValue("Physical.legend.ssd"));
            context.put("spare", (Object)SJdtReportGeneratorManager.getGuidanceValue("Physical.legend.spare"));
            context.put("free", (Object)SJdtReportGeneratorManager.getGuidanceValue("Physical.legend.free"));
            context.put("notInstalled", (Object)SJdtReportGeneratorManager.getGuidanceValue("Physical.legend.notInstalled"));
            String generateFrontFilePath = this.OUTPUT_HTML_DIR + CONTENTS_FOOTER_HTML_FILE_NAME;
            SJdtReportGeneratorManager.generateFile(context, CONTENTS_FOOTER_VM_FILE_PATH, generateFrontFilePath);
        }
        catch (SJdtRPTDTException e) {
            e.setReportStatus(this.getReportFramesetHtmlFileName(), "20520-107106");
            throw e;
        }
    }

    @Override
    public void generateContentsBody() throws SJdtRPTDTException {
        VelocityContext context = SJdtReportGeneratorManager.getVelocityContext();
        context.put("libraryPath", (Object)VM_LIBLARY_PATH);
        this.setFixedStr(context);
        this.setVariableStr(context);
        String generateFrontFilePath = this.OUTPUT_HTML_DIR + this.getContentsBodyHtmlFileName();
        SJdtReportGeneratorManager.generateFile(context, CONTENTS_BODY_VM_FILE_PATH, generateFrontFilePath);
        String cssFileName = "contentsBody_Physical.css";
        String originalFilePath = "/sanproject/sn2/rptdt/template/physical/css/" + cssFileName;
        String destFilePath = this.OUTPUT_CSS_DIR + cssFileName;
        SJdtReportGeneratorManager.copyFile(originalFilePath, destFilePath);
        SJdtReportGeneratorManager.copyAllFile(this, "/physical/img/", this.OUTPUT_IMG_DIR);
    }

    @Override
    public void generateContentsMenu() throws SJdtRPTDTException {
        VelocityContext context = SJdtReportGeneratorManager.getVelocityContext();
        context.put("libraryPath", (Object)VM_LIBLARY_PATH);
        context.put("targetHtmlName", (Object)CONTENTS_BODY_HTML_FILE_NAME);
        String cssFileName = "contentsMenu.css";
        String originalCssFilePath = "/sanproject/sn2/rptdt/template/common/css/" + cssFileName;
        String destCssFilePath = COMMON_CSS_DIR + cssFileName;
        SJdtReportGeneratorManager.copyFile(originalCssFilePath, destCssFilePath);
        this.setCntentsMnueHduInfo(context);
        String generateFrontFilePath = this.OUTPUT_HTML_DIR + this.getContentsMenuHtmlFileName();
        SJdtReportGeneratorManager.generateFile(context, CONTENTS_MENU_VM_FILE_PATH, generateFrontFilePath);
    }

    @Override
    public void setFixedStr(VelocityContext context) {
        context.put("drivebox", (Object)SJdtReportGeneratorManager.getGuidanceValue("Physical.drivebox"));
        context.put("storageSystemType", (Object)SJdtReportGeneratorManager.getGuidanceValue("Physical.storageSystemType"));
        context.put("microcodeVersion", (Object)SJdtReportGeneratorManager.getGuidanceValue("Physical.microcodeVersion"));
        context.put("dkc", (Object)SJdtReportGeneratorManager.getGuidanceValue("Physical.dkc"));
        context.put("chbb", (Object)SJdtReportGeneratorManager.getGuidanceValue("Physical.chbb"));
        context.put("notInstalled", (Object)SJdtReportGeneratorManager.getGuidanceValue("Physical.notInstalled"));
    }

    @Override
    public void setVariableStr(VelocityContext context) {
        this.setSummaryInfo(context);
        SJdtMpPcbStatusCSVWrapper mpPcbStatus = (SJdtMpPcbStatusCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("MpPcbStatus.csv");
        boolean useDkc1Flg = mpPcbStatus.existsModule1Data();
        context.put("useDkc1Flg", (Object)useDkc1Flg);
        String model = SJdtRPTDTDevice.getModel(SJdtRPTDTDevice.getModelInfo());
        context.put("modelInfo", (Object)model);
        this.setDkcInfo(context, useDkc1Flg);
        this.setChbbInfo(context);
        this.setHduInfo(context);
    }

    @Override
    public void setSummaryInfo(VelocityContext context) {
        SJdtMicroVersionCSVWrapper microVersion = (SJdtMicroVersionCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("MicroVersion.csv");
        SJdtDkcInfoCSVWrapper dkcInfo = (SJdtDkcInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("DkcInfo.csv");
        String[] dkcInfoRecord = dkcInfo.getRecord(0);
        String storageSystemType = dkcInfo.getValue(dkcInfoRecord, "Storage System Type");
        context.put("valueOfFrontStorageSystemType", (Object)storageSystemType);
        context.put("valueOfBackStorageSystemType", (Object)storageSystemType);
        String serialNumber = dkcInfo.getValue(dkcInfoRecord, "Serial Number#");
        context.put("serialNumber", (Object)SJdtReportGeneratorManager.getGuidanceValue("Physical.serialNumber"));
        context.put("valueOfFrontSerialNumber", (Object)serialNumber);
        context.put("valueOfBackSerialNumber", (Object)serialNumber);
        String[] microVersionRecord = microVersion.getRecord(0);
        String dkcmain = microVersion.getValue(microVersionRecord, "DKCMAIN");
        context.put("valueOfFrontMicrocodeVersion", (Object)dkcmain);
        context.put("valueOfBackMicrocodeVersion", (Object)dkcmain);
    }

    @Override
    public void setDkcInfo(VelocityContext context, boolean useDkc1Flg) {
        SJdtChaStatusCSVWrapper chaStatus = (SJdtChaStatusCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("ChaStatus.csv");
        SJdtDkaStatusCSVWrapper dkaStatus = (SJdtDkaStatusCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("DkaStatus.csv");
        HashMap<String, Boolean> dkcAllMap = new HashMap<String, Boolean>();
        List<String> chaLocationList = chaStatus.getAllRecordColumnValueSet("CHB Location");
        for (String chaLocation : chaLocationList) {
            dkcAllMap.put(chaLocation, Boolean.TRUE);
        }
        List<String> dkaLocationList = dkaStatus.getAllRecordColumnValueSet("DKB Location");
        for (String dkaLocation : dkaLocationList) {
            dkcAllMap.put(dkaLocation, Boolean.TRUE);
        }
        context.put("dkcAllMap", dkcAllMap);
    }

    public void setChbbInfo(VelocityContext context) {
        SJdtPTMInfoCSVWrapper ptmInfo = (SJdtPTMInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("PECBInfo.csv");
        HashMap<String, Boolean> chbbInstalledAllMap = new HashMap<String, Boolean>();
        boolean chbbInstallFlg = ptmInfo.isPTMForChbAll();
        if (chbbInstallFlg) {
            List<String[]> csvDataList = ptmInfo.getCsvDataList();
            for (String[] ptmInfoRecord : csvDataList) {
                String location = ptmInfo.getValue(ptmInfoRecord, "Location");
                String status = ptmInfo.getValue(ptmInfoRecord, "Status");
                if ("Installed".equals(status)) {
                    chbbInstalledAllMap.put(location, Boolean.TRUE);
                    continue;
                }
                chbbInstalledAllMap.put(location, Boolean.FALSE);
            }
        }
        context.put("chbbInstallFlg", (Object)chbbInstallFlg);
        context.put("chbbInstalledAllMap", chbbInstalledAllMap);
    }

    public void setHduInfo(VelocityContext context) {
        boolean AFA_flag = false;
        SJdtHduInfoCSVWrapper hduInfo = (SJdtHduInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("HduInfo.csv");
        SJdtPdevInfoCSVWrapper pdevInfo = (SJdtPdevInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("PdevInfo.csv");
        HashMap<String, Boolean> hduNotInstalledAllMap = new HashMap<String, Boolean>();
        HashMap hduAllMap = new HashMap();
        LinkedHashMap<String, String> dbTypeMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, Integer> dbTopSizeMap = new LinkedHashMap<String, Integer>();
        List<String[]> hduInfoRecordList = hduInfo.getPrefixMatchedAllRecord("DB", "DB Location");
        for (String[] hduInfoRecord : hduInfoRecordList) {
            String hduLocation = hduInfo.getValue(hduInfoRecord, "DB Location");
            String hduLocationAsLowerCase = hduLocation.toLowerCase();
            String hduStatus = hduInfo.getValue(hduInfoRecord, "DB Status");
            String dbType = hduInfo.getValue(hduInfoRecord, "DB Type");
            if (dbType.equals(DB_TYPE_DBS)) {
                dbTypeMap.put(hduLocationAsLowerCase, dbType);
                dbTopSizeMap.put(hduLocationAsLowerCase, 80);
            } else if (dbType.equals(DB_TYPE_DBL)) {
                dbTypeMap.put(hduLocationAsLowerCase, dbType);
                dbTopSizeMap.put(hduLocationAsLowerCase, 80);
            } else if (dbType.equals(DB_TYPE_DBF)) {
                dbTypeMap.put(hduLocationAsLowerCase, dbType);
                dbTopSizeMap.put(hduLocationAsLowerCase, 93);
            } else if (dbType.equals(DB_TYPE_DB60) || dbType.equals(DB_TYPE_DB60S)) {
                dbTypeMap.put(hduLocationAsLowerCase, dbType);
                dbTopSizeMap.put(hduLocationAsLowerCase, 261);
            } else if (dbType.equals(DB_TYPE_DBF2)) {
                if (AFA_flag) {
                    AFA_flag = false;
                    continue;
                }
                AFA_flag = true;
                dbTypeMap.put(hduLocationAsLowerCase, dbType);
                dbTopSizeMap.put(hduLocationAsLowerCase, 93);
            } else if (dbType.equals("")) {
                dbTypeMap.put(hduLocationAsLowerCase, dbType);
                dbTopSizeMap.put(hduLocationAsLowerCase, 80);
            } else {
                logger.warning("DB Type:" + dbType);
                dbTypeMap.put(hduLocationAsLowerCase, dbType);
                dbTopSizeMap.put(hduLocationAsLowerCase, 80);
            }
            if (!hduStatus.equals("Installed")) {
                hduNotInstalledAllMap.put(hduLocationAsLowerCase + "NotInstalledFlg", Boolean.TRUE);
                continue;
            }
            HashMap<String, Pdev> hduMap = new HashMap<String, Pdev>();
            String[] pdevLocationSuffixArray = this.getPdevLocationSuffixArray(dbType);
            if (!dbType.equals(DB_TYPE_DBF2)) {
                for (String pdevLocationSuffix : pdevLocationSuffixArray) {
                    String location = hduLocation.replaceFirst("DB", "");
                    String pdevLocation = "HDD" + location + "-" + pdevLocationSuffix;
                    String[] pdevInfoRecord = pdevInfo.getMatchedExistsOneRecord(pdevLocation, "PDEV Location");
                    if (pdevInfoRecord == null) {
                        hduMap.put(pdevLocationSuffix, new Pdev());
                        continue;
                    }
                    String deviceType = pdevInfo.getValue(pdevInfoRecord, "Device Type");
                    String deviceCapacity = pdevInfo.getValue(pdevInfoRecord, "Device Capacity");
                    String eccGroup = pdevInfo.getValue(pdevInfoRecord, "ECC Group");
                    Pdev pdev = new Pdev();
                    pdev.setDeviceType(deviceType);
                    pdev.setDeviceCapacity(this.getDeviceCapacityAsCharArray(deviceCapacity));
                    pdev.setEccGroup(eccGroup);
                    pdev.setSpareFlg(eccGroup);
                    pdev.setFreeFlg(eccGroup);
                    pdev.setDeviceCapacityRaw(this.getDeviceCapacityRawAsCharArray(deviceCapacity));
                    hduMap.put(pdevLocationSuffix, pdev);
                }
            } else {
                for (int i = 0; i < pdevLocationSuffixArray.length; ++i) {
                    String location = hduLocation.replaceFirst("DB", "");
                    String[] location1 = location.split("&");
                    String pdevLocation = "HDD" + location1[i / 6] + "-" + pdevLocationSuffixArray[i % 6];
                    String[] pdevInfoRecord = pdevInfo.getMatchedExistsOneRecord(pdevLocation, "PDEV Location");
                    if (pdevInfoRecord == null) {
                        hduMap.put(pdevLocationSuffixArray[i], new Pdev());
                        continue;
                    }
                    String deviceType = pdevInfo.getValue(pdevInfoRecord, "Device Type");
                    String deviceCapacity = pdevInfo.getValue(pdevInfoRecord, "Device Capacity");
                    String eccGroup = pdevInfo.getValue(pdevInfoRecord, "ECC Group");
                    Pdev pdev = new Pdev();
                    pdev.setDeviceType(deviceType);
                    pdev.setDeviceCapacity(this.getDeviceCapacityAsCharArray(deviceCapacity));
                    pdev.setEccGroup(eccGroup);
                    pdev.setSpareFlg(eccGroup);
                    pdev.setFreeFlg(eccGroup);
                    pdev.setDeviceCapacityRaw(this.getDeviceCapacityRawAsCharArray(deviceCapacity));
                    hduMap.put(pdevLocationSuffixArray[i], pdev);
                }
            }
            hduAllMap.put(hduLocationAsLowerCase, hduMap);
        }
        context.put("hduNotInstalledAllMap", hduNotInstalledAllMap);
        context.put("hduAllMap", hduAllMap);
        context.put("dbTypeMap", dbTypeMap);
        context.put("dbTopSizeMap", dbTopSizeMap);
    }

    @Override
    public String[] getPdevLocationSuffixArray(String dbType) {
        String[] pdevLocationSuffixArray = null;
        if (dbType.equals(DB_TYPE_DBS)) {
            pdevLocationSuffixArray = pdevLocationSuffixArray24;
        } else if (dbType.equals(DB_TYPE_DBL)) {
            pdevLocationSuffixArray = pdevLocationSuffixArray12;
        } else if (dbType.equals(DB_TYPE_DBF)) {
            pdevLocationSuffixArray = pdevLocationSuffixArray12;
        } else if (dbType.equals(DB_TYPE_DB60) || dbType.equals(DB_TYPE_DB60S)) {
            pdevLocationSuffixArray = pdevLocationSuffixArray60;
        } else if (dbType.equals(DB_TYPE_DBF2)) {
            pdevLocationSuffixArray = pdevLocationSuffixArray12;
        } else {
            logger.warning("DB Type:" + dbType);
            pdevLocationSuffixArray = pdevLocationSuffixArray24;
        }
        return pdevLocationSuffixArray;
    }

    public void setCntentsMnueHduInfo(VelocityContext context) {
        boolean Afa_flg = false;
        SJdtHduInfoCSVWrapper hduInfo = (SJdtHduInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("HduInfo.csv");
        SJdtPTMInfoCSVWrapper ptmInfo = (SJdtPTMInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("PECBInfo.csv");
        HashMap<String, Boolean> hduNotInstAllMap = new HashMap<String, Boolean>();
        LinkedHashMap<String, String> dbTypeMapForMenuLink = new LinkedHashMap<String, String>();
        List<String[]> hduInfoRecordList = hduInfo.getPrefixMatchedAllRecord("DB", "DB Location");
        boolean chbbInstallFlg = ptmInfo.isPTMForChbAll();
        for (String[] hduInfoRecord : hduInfoRecordList) {
            String hduLocation = hduInfo.getValue(hduInfoRecord, "DB Location");
            String hduLocationAsLowerCase = hduLocation.toLowerCase();
            String hduStatus = hduInfo.getValue(hduInfoRecord, "DB Status");
            String hduType = hduInfo.getValue(hduInfoRecord, "DB Type");
            if (hduType.equals(DB_TYPE_DBF2)) {
                if (!Afa_flg) {
                    Afa_flg = true;
                } else {
                    Afa_flg = false;
                    continue;
                }
            }
            if (!hduStatus.equals("Installed")) {
                hduNotInstAllMap.put(hduLocationAsLowerCase + "NotInstalledFlg", Boolean.TRUE);
            } else {
                hduNotInstAllMap.put(hduLocationAsLowerCase + "NotInstalledFlg", Boolean.FALSE);
            }
            dbTypeMapForMenuLink.put(hduLocationAsLowerCase, hduType);
        }
        context.put("chbbInstallFlg", (Object)chbbInstallFlg);
        context.put("hduNotInstAllMap", hduNotInstAllMap);
        context.put("dbTypeMapForMenuLink", dbTypeMapForMenuLink);
    }
}

