/*
 * Decompiled with CFR 0.152.
 */
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import sanproject.client.data.RJDataCULDEV;
import sanproject.client.data.RJDataControl;
import sanproject.server.data.DGDgetGuardFile;
import sanproject.server.data.DGDgetLdevGuard;
import sanproject.server.data.DGDgetVtocArea;
import sanproject.server.data.DGDsetGuardFile;
import sanproject.server.data.DGDsetLdevGuard;
import sanproject.server.data.DGDsetVtocArea;

public class RJDGDDataControl {
    private static int ERP_CLIENT = 9210;
    private static int ERP_HIC = 9205;
    private static int ERP_JNI = 9207;
    private static int ERC_NORMAL = 0;
    private final String logName = this.getClass().getName();
    private RJDataControl _dctl = null;
    private ArrayList _errList = null;
    private ArrayList _applyEndListener = null;
    private ArrayList _guardFiles = null;
    private RJDGDGuardPattern _guardDkc = null;
    private RJDGDGuardPattern _guardSetup = null;
    private boolean inhNoMfVolMsg = false;

    public RJDGDDataControl(RJDataControl rJDataControl) throws RJDGDException {
        this._dctl = rJDataControl;
        this._errList = new ArrayList();
        this._applyEndListener = new ArrayList();
        this._guardFiles = new ArrayList();
        this._guardDkc = new RJDGDGuardPatternOfDkc(this);
        RJDGDErrInfo.msgCacheClear();
    }

    public void initStructure() throws RJDGDException {
        RJDGDLogManager.putLog(this.logName, "Initialize start");
        try {
            this._guardSetup = null;
            this._guardFiles.clear();
            this._guardDkc = new RJDGDGuardPatternOfDkc(this);
            this._guardDkc = new RJDGDGuardPatternOfDkc(this, this.getLdevGuard(), this.getCULDEV(), this.getVtocArea());
            this.enterSetupToDkc(this._guardDkc);
            String[] stringArray = this.getGuardFileList();
            int n = 0;
            while (n < stringArray.length) {
                this.addGuardPattern(new RJDGDGuardPatternOfFile(this, stringArray[n]));
                ++n;
            }
            Collections.sort(this._guardFiles);
        }
        catch (RJDGDException rJDGDException) {
            RJDGDLogManager.putLog(this.logName, rJDGDException.getMessage());
            RJDGDLogManager.putLog(this.logName, "Initialize abnormal end");
            throw rJDGDException;
        }
        catch (Exception exception) {
            RJDGDLogManager.putLog(this.logName, exception.getMessage());
            exception.printStackTrace();
            throw new RJDGDException(ERP_CLIENT, 7060);
        }
        if (!((RJDGDGuardPatternOfDkc)this._guardDkc).hasMfVol() && !this.inhNoMfVolMsg) {
            this.inhNoMfVolMsg = true;
            throw new RJDGDException(9210, 8112);
        }
        RJDGDLogManager.putLog(this.logName, "Initialize end");
    }

    public boolean addApplyEndListener(RJDGDApplyEndListener rJDGDApplyEndListener) {
        return this._applyEndListener.add(rJDGDApplyEndListener);
    }

    public boolean removeApplyEndListener(RJDGDApplyEndListener rJDGDApplyEndListener) {
        return ((AbstractCollection)this._applyEndListener).remove(rJDGDApplyEndListener);
    }

    public List getApplyEndListener() {
        return this._applyEndListener;
    }

    public List getApplyData() {
        ArrayList arrayList = new ArrayList();
        ArrayList<RJDGDGuardPattern> arrayList2 = new ArrayList<RJDGDGuardPattern>();
        arrayList2.add(this._guardDkc);
        arrayList2.addAll(this._guardFiles);
        Iterator iterator = ((AbstractList)arrayList2).iterator();
        while (iterator.hasNext()) {
            RJDGDGuardPattern rJDGDGuardPattern = (RJDGDGuardPattern)iterator.next();
            if (!rJDGDGuardPattern.isModify()) continue;
            arrayList.addAll(rJDGDGuardPattern.getSetupData());
        }
        return arrayList;
    }

    public void applyStart() throws RJDGDException {
        this._errList.clear();
        RJDGDApplyThread rJDGDApplyThread = new RJDGDApplyThread(this._dctl, this);
        rJDGDApplyThread.start();
    }

    private static ArrayList createLdevGuardErrInfo(DGDsetLdevGuard dGDsetLdevGuard) {
        ArrayList<RJDGDErrInfo> arrayList = new ArrayList<RJDGDErrInfo>();
        int n = 0;
        while (n < dGDsetLdevGuard.error.length) {
            int n2 = 0;
            while (n2 < dGDsetLdevGuard.error[n].length) {
                if (dGDsetLdevGuard.error[n][n2] != ERC_NORMAL) {
                    arrayList.add(new RJDGDErrInfo(n, n2, ERP_HIC, dGDsetLdevGuard.error[n][n2]));
                }
                ++n2;
            }
            ++n;
        }
        return arrayList;
    }

    private static ArrayList createGuardFileErrInfo(DGDsetGuardFile dGDsetGuardFile) {
        ArrayList<RJDGDErrInfo> arrayList = new ArrayList<RJDGDErrInfo>();
        if (dGDsetGuardFile.error != ERC_NORMAL) {
            arrayList.add(new RJDGDErrInfo(dGDsetGuardFile.name, ERP_HIC, dGDsetGuardFile.error));
        }
        return arrayList;
    }

    private static ArrayList createVtocAreaErrInfo(DGDsetVtocArea[] dGDsetVtocAreaArray) {
        ArrayList<RJDGDErrInfo> arrayList = new ArrayList<RJDGDErrInfo>();
        int n = 0;
        while (n < dGDsetVtocAreaArray.length) {
            if (dGDsetVtocAreaArray[n].error != ERC_NORMAL) {
                arrayList.add(new RJDGDErrInfo(dGDsetVtocAreaArray[n].cu, dGDsetVtocAreaArray[n].ldev, ERP_HIC, dGDsetVtocAreaArray[n].error));
            }
            ++n;
        }
        return arrayList;
    }

    public void createErrInfo(Object[] objectArray) throws ClassCastException {
        this._errList = new ArrayList();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof DGDsetLdevGuard) {
                this._errList.addAll(RJDGDDataControl.createLdevGuardErrInfo((DGDsetLdevGuard)objectArray[n]));
            } else if (objectArray[n] instanceof DGDsetGuardFile) {
                this._errList.addAll(RJDGDDataControl.createGuardFileErrInfo((DGDsetGuardFile)objectArray[n]));
            } else if (objectArray[n] instanceof DGDsetVtocArea[]) {
                this._errList.addAll(RJDGDDataControl.createVtocAreaErrInfo((DGDsetVtocArea[])objectArray[n]));
            } else {
                throw new ClassCastException(objectArray[n].getClass().toString());
            }
            ++n;
        }
        RJDGDLogManager.putLog(this.logName, this._errList.size() + "errors created.");
    }

    public RJDGDErrInfo[] getErrInfo() {
        RJDGDErrInfo[] rJDGDErrInfoArray = new RJDGDErrInfo[this._errList.size()];
        int n = 0;
        while (n < rJDGDErrInfoArray.length) {
            rJDGDErrInfoArray[n] = (RJDGDErrInfo)this._errList.get(n);
            ++n;
        }
        return rJDGDErrInfoArray;
    }

    public RJDGDGuardPattern getGuardPatternOfDkc() {
        return this._guardDkc;
    }

    public void updateGuardPatternOfDkc() throws RJDGDException {
        try {
            DGDgetGuardFile dGDgetGuardFile = this.getUploadFile();
            int n = 0;
            while (n < dGDgetGuardFile.guard.length) {
                int n2 = 0;
                while (n2 < dGDgetGuardFile.guard[n].length) {
                    this._guardDkc.setGuardStatus(n, n2, dGDgetGuardFile.guard[n][n2]);
                    ++n2;
                }
                ++n;
            }
        }
        catch (RJDGDException rJDGDException) {
            throw rJDGDException;
        }
        catch (Exception exception) {
            throw new RJDGDException(ERP_CLIENT, 7060, exception.getMessage());
        }
    }

    public void addUploadFilesToPatternList() throws RJDGDException {
        try {
            this._errList.clear();
            DGDgetGuardFile[] dGDgetGuardFileArray = this.getUploadFiles();
            int n = 0;
            while (n < dGDgetGuardFileArray.length) {
                try {
                    RJDGDGuardPatternOfFile rJDGDGuardPatternOfFile = new RJDGDGuardPatternOfFile(this, dGDgetGuardFileArray[n]);
                    this.addGuardPattern(rJDGDGuardPatternOfFile.getCopy());
                    rJDGDGuardPatternOfFile = null;
                }
                catch (RJDGDException rJDGDException) {
                    this._errList.add(new RJDGDErrInfo(dGDgetGuardFileArray[n].name, rJDGDException.getPosition(), rJDGDException.getCode()));
                }
                ++n;
            }
        }
        catch (RJDGDException rJDGDException) {
            throw rJDGDException;
        }
        catch (Exception exception) {
            throw new RJDGDException(ERP_CLIENT, 7060, exception.getMessage());
        }
    }

    public int getGuardPatternSize() {
        int n = 0;
        RJDGDGuardPattern[] rJDGDGuardPatternArray = this.getGuardPattern();
        int n2 = 0;
        while (n2 < rJDGDGuardPatternArray.length) {
            if (!rJDGDGuardPatternArray[n2].isDelete()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public RJDGDGuardPattern[] getGuardPattern() {
        RJDGDGuardPattern[] rJDGDGuardPatternArray = new RJDGDGuardPattern[this._guardFiles.size()];
        int n = 0;
        while (n < rJDGDGuardPatternArray.length) {
            rJDGDGuardPatternArray[n] = (RJDGDGuardPattern)this._guardFiles.get(n);
            ++n;
        }
        return rJDGDGuardPatternArray;
    }

    public String[] getGuardNameList() {
        String[] stringArray = new String[this._guardFiles.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = ((RJDGDGuardPattern)this._guardFiles.get(n)).getName();
            ++n;
        }
        return stringArray;
    }

    public boolean addGuardPattern(RJDGDGuardPattern rJDGDGuardPattern) {
        boolean bl = true;
        if (this.getGuardPatternSize() >= 32) {
            bl = false;
        }
        if (bl) {
            Iterator iterator = ((AbstractList)this._guardFiles).iterator();
            while (iterator.hasNext()) {
                RJDGDGuardPattern rJDGDGuardPattern2 = (RJDGDGuardPattern)iterator.next();
                if (!rJDGDGuardPattern2.toString().equals(rJDGDGuardPattern.toString())) continue;
                bl = false;
                break;
            }
        }
        if (bl) {
            this._guardFiles.add(rJDGDGuardPattern);
        }
        return bl;
    }

    public void deleteGuardPattern(RJDGDGuardPattern rJDGDGuardPattern) {
        if (((RJDGDGuardPatternCom)rJDGDGuardPattern).isCopy()) {
            int n = this._guardFiles.indexOf(rJDGDGuardPattern);
            if (n > -1) {
                this._guardFiles.remove(n);
            }
        } else {
            ((RJDGDGuardPatternCom)rJDGDGuardPattern).delete();
        }
    }

    public void enterSetupToDkc(RJDGDGuardPattern rJDGDGuardPattern) {
        if (this.canEnterSetupToDkc()) {
            this._guardSetup = rJDGDGuardPattern;
        }
    }

    public RJDGDGuardPattern getSetupToDkc() {
        return this._guardSetup;
    }

    public boolean canEnterSetupToDkc() {
        boolean bl = true;
        if (this._guardSetup instanceof RJDGDGuardPatternOfDkc && ((RJDGDGuardPatternOfDkc)this._guardSetup).isModify()) {
            bl = false;
        }
        return bl;
    }

    public boolean getPpStat() {
        boolean bl = this._dctl.getPPKeyData().CheckPP("419");
        if (!bl) {
            bl = this._dctl.getStartParamClass().getVenderID() == 99;
        }
        return bl;
    }

    private void chkDCResult() throws RJDGDException {
        int n = 0;
        int n2 = 0;
        while (!this._dctl.EndData) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ArrayList arrayList = this._dctl.getEndStatus();
        n = (Integer)arrayList.get(0);
        n2 = (Integer)arrayList.get(1);
        if (n != 0) {
            throw new RJDGDException(n, n2);
        }
    }

    private void waitDataControl() {
        while (this._dctl.getControlDoing().getDoing()) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public RJDataCULDEV getCULDEV() throws RJDGDException {
        this.waitDataControl();
        this._dctl.getCULDEV();
        try {
            this.chkDCResult();
        }
        catch (RJDGDException rJDGDException) {
            RJDGDLogManager.putLog(this.logName, "RJDGDException occurred : getCULDEV()");
            throw rJDGDException;
        }
        RJDGDLogManager.putLog(this.logName, "Get CULDEV Data");
        return this._dctl.getCULDEVClass();
    }

    public DGDgetLdevGuard getLdevGuard() throws RJDGDException {
        this.waitDataControl();
        this._dctl.getLdevGuard();
        try {
            this.chkDCResult();
        }
        catch (RJDGDException rJDGDException) {
            RJDGDLogManager.putLog(this.logName, "RJDGDException occurred : getLdevGuard()");
            throw rJDGDException;
        }
        RJDGDLogManager.putLog(this.logName, "Get DKC LDEV Guard Data");
        return this._dctl.getLdevGuardData();
    }

    public String[] getGuardFileList() throws RJDGDException {
        this.waitDataControl();
        this._dctl.getGuardFileList();
        try {
            this.chkDCResult();
        }
        catch (RJDGDException rJDGDException) {
            RJDGDLogManager.putLog(this.logName, "RJDGDException occurred : getGuardFileList()");
            throw rJDGDException;
        }
        String[] stringArray = this._dctl.getGuardFileListData();
        RJDGDLogManager.putLog(this.logName, "Get Guard File List. (" + stringArray.length + " files)");
        return stringArray;
    }

    public DGDgetGuardFile getGuardFile(String string) throws RJDGDException {
        this.waitDataControl();
        this._dctl.getGuardFile(string);
        try {
            this.chkDCResult();
        }
        catch (RJDGDException rJDGDException) {
            RJDGDLogManager.putLog(this.logName, "RJDGDException occurred : getGuardFile()");
            throw rJDGDException;
        }
        RJDGDLogManager.putLog(this.logName, "Get Guard File Data. (" + string + ")");
        DGDgetGuardFile dGDgetGuardFile = this._dctl.getGuardFileData();
        if (dGDgetGuardFile.error != ERC_NORMAL) {
            RJDGDLogManager.putLog(this.logName, "Get File Error occurred : (" + ERP_HIC + ":" + dGDgetGuardFile.error + ")");
            throw new RJDGDException(ERP_HIC, dGDgetGuardFile.error);
        }
        return dGDgetGuardFile;
    }

    public DGDgetVtocArea[] getVtocArea() throws RJDGDException {
        this.waitDataControl();
        this._dctl.getVtocArea();
        try {
            this.chkDCResult();
        }
        catch (RJDGDException rJDGDException) {
            RJDGDLogManager.putLog(this.logName, "RJDGDException occurred : getVtocArea()");
            throw rJDGDException;
        }
        RJDGDLogManager.putLog(this.logName, "Get VTOC Data.");
        return this._dctl.getVtocAreaData();
    }

    public DGDgetGuardFile getUploadFile() throws RJDGDException {
        this.waitDataControl();
        this._dctl.getDGDUploadFile();
        try {
            this.chkDCResult();
        }
        catch (RJDGDException rJDGDException) {
            RJDGDLogManager.putLog(this.logName, "RJDGDException occurred : getUploadFile()");
            throw rJDGDException;
        }
        DGDgetGuardFile dGDgetGuardFile = this._dctl.getDGDUploadFileData();
        if (dGDgetGuardFile == null) {
            RJDGDLogManager.putLog(this.logName, "Get Upload Guard File Data is null!");
            throw new RJDGDException(ERP_CLIENT, 7444);
        }
        RJDGDLogManager.putLog(this.logName, "Get Upload Guard File Data. (" + dGDgetGuardFile.name + ")");
        if (dGDgetGuardFile.error != ERC_NORMAL) {
            RJDGDLogManager.putLog(this.logName, "Get Upload Guard File Data Error occurred : (" + ERP_JNI + ":" + dGDgetGuardFile.error + ")");
            throw new RJDGDException(ERP_JNI, dGDgetGuardFile.error);
        }
        return dGDgetGuardFile;
    }

    public DGDgetGuardFile[] getUploadFiles() throws RJDGDException {
        this.waitDataControl();
        this._dctl.getDGDUploadFiles();
        try {
            this.chkDCResult();
        }
        catch (RJDGDException rJDGDException) {
            RJDGDLogManager.putLog(this.logName, "RJDGDException occurred : getUploadFiles()");
            throw rJDGDException;
        }
        DGDgetGuardFile[] dGDgetGuardFileArray = this._dctl.getDGDUploadFilesData();
        RJDGDLogManager.putLog(this.logName, "Get Upload Guard File Data. (" + dGDgetGuardFileArray.length + " files)");
        return dGDgetGuardFileArray;
    }

    public void setFOStatus(int n, int n2) throws RJDGDException {
        this.waitDataControl();
        this._dctl.setDGDFOStatus(n, n2);
        try {
            this.chkDCResult();
        }
        catch (RJDGDException rJDGDException) {
            RJDGDLogManager.putLog(this.logName, "RJDGDException occurred : setFOStatus()");
            throw rJDGDException;
        }
        RJDGDLogManager.putLog(this.logName, "Set File Operator Status(ID:" + n + ", St:" + n2 + ")");
    }

    public int getFOStatus(int n) throws RJDGDException {
        int n2 = 0;
        this.waitDataControl();
        this._dctl.getDGDFOStatus(n);
        try {
            this.chkDCResult();
        }
        catch (RJDGDException rJDGDException) {
            RJDGDLogManager.putLog(this.logName, "RJDGDException occurred : getFOStatus()");
            throw rJDGDException;
        }
        n2 = this._dctl.getDGDFOStatusData();
        RJDGDLogManager.putLog(this.logName, "Get File Operator Status(ID:" + n + ", St:" + n2 + ")");
        return n2;
    }

    public static String toPrefixString(int n, char c, String string) {
        String string2 = new String();
        int n2 = string.length();
        while (n2 < n) {
            string2 = string2 + c;
            ++n2;
        }
        string2 = string2 + string;
        return string2;
    }

    public static String toPreHexString(int n, int n2) {
        String string = new String();
        String string2 = Integer.toHexString(n2);
        int n3 = string2.length();
        while (n3 < n) {
            string = string + "0";
            ++n3;
        }
        string = string + string2;
        return string;
    }
}

