/*
 * Decompiled with CFR 0.152.
 */
package sanproject.server.data;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.AlreadyBoundException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import sanproject.server.data.ActiveUserInfo;
import sanproject.server.data.GetRmiException;
import sanproject.server.data.RmiConObjUserCert;
import sanproject.server.data.RmiControlObjImpl;
import sanproject.server.data.RmiLoginInfo;
import sanproject.server.data.RmiObjImpl;
import sanproject.server.data.RmiObjUserInfo;
import sanproject.server.data.SANRmiException;
import sanproject.server.data.SyncException;

public class RmiConObjSync {
    final int HP = 0;
    final int HiCommand = 1;
    final int ADD_TABLE = 0;
    final int REMOVE_TABLE = 1;
    private final int LIMIT_MIN = 5;
    private String HPInfomation = new String();
    private Random rand = new Random();
    private LinkedList loginTable = new LinkedList();
    private LinkedList ForHpTable = new LinkedList();
    private LinkedList HicTable = new LinkedList();
    private RmiConObjUserCert userCert;

    private String makeBindName(String string) {
        String string2 = Integer.toString(Math.abs(this.rand.nextInt()), 16).toUpperCase();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        int n = string2.length();
        while (n < 8) {
            stringBuffer.append('0');
            ++n;
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    private String makeUrl(String string) throws SyncException {
        String string2;
        try {
            string2 = new String("rmi://" + InetAddress.getLocalHost().getHostAddress() + "/" + string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new SyncException(4006, "RmiConObjSync: URL Generation Failure");
        }
        return string2;
    }

    private RmiObjImpl makeRmiObj(String string, String string2) throws SyncException {
        RmiObjImpl rmiObjImpl;
        try {
            rmiObjImpl = new RmiObjImpl(string, string2);
        }
        catch (RemoteException remoteException) {
            throw new SyncException(4007, ": makeRmiObj Failed" + remoteException.getMessage());
        }
        catch (GetRmiException getRmiException) {
            throw new SyncException(getRmiException.nErrData, ": makeRmiObj Failed" + getRmiException.getMessage());
        }
        catch (IllegalStateException illegalStateException) {
            throw new SyncException(4001, ": makeRmiObj Failed" + illegalStateException.getMessage());
        }
        return rmiObjImpl;
    }

    private RmiObjImpl makeRmiObj(String string, String string2, int n) throws SyncException {
        RmiObjImpl rmiObjImpl = null;
        try {
            if (n != 0) {
                int n2 = 60000 * RmiControlObjImpl.getEnvInfo().getSocketTimeOut();
                rmiObjImpl = new RmiObjImpl(string, string2, n2);
            } else {
                rmiObjImpl = new RmiObjImpl(string, string2);
            }
        }
        catch (RemoteException remoteException) {
            throw new SyncException(4007, ": makeRmiObj Failed" + remoteException.getMessage());
        }
        catch (GetRmiException getRmiException) {
            throw new SyncException(getRmiException.nErrData, ": makeRmiObj Failed" + getRmiException.getMessage());
        }
        catch (IllegalStateException illegalStateException) {
            throw new SyncException(4001, ": makeRmiObj Failed" + illegalStateException.getMessage());
        }
        return rmiObjImpl;
    }

    private void doBind(String string, Remote remote) throws SyncException {
        try {
            Naming.bind(string, remote);
        }
        catch (RemoteException remoteException) {
            throw new SyncException(4007, "RmiConObjSync: RMI Object Registration Failure : " + string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new SyncException(4008, "RmiConObjSync: RMI Object Registration Failure : " + string);
        }
        catch (AlreadyBoundException alreadyBoundException) {
            throw new SyncException(4009, "RmiConObjSync: RMI Object Registration Failure : " + string);
        }
    }

    private void doUnbind(String string) throws SyncException {
        try {
            Naming.unbind(string);
        }
        catch (RemoteException remoteException) {
            throw new SyncException(4007, "RmiConObjSync: Object Registration Failure : " + string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new SyncException(4008, "RmiConObjSync: Object Registration Failure : " + string);
        }
        catch (NotBoundException notBoundException) {
            throw new SyncException(4010, "RmiConObjSync: Object Registration Failure : " + string);
        }
    }

    private LoginInfo getLoginInfoByUserID(String string) {
        Iterator iterator = this.loginTable.iterator();
        while (iterator.hasNext()) {
            LoginInfo loginInfo = (LoginInfo)iterator.next();
            if (!loginInfo.getUserID().equals(string)) continue;
            return loginInfo;
        }
        return null;
    }

    private LoginInfo getLoginInfoByBindName(String string) {
        Iterator iterator = this.loginTable.iterator();
        while (iterator.hasNext()) {
            LoginInfo loginInfo = (LoginInfo)iterator.next();
            if (!loginInfo.getBindName().equals(string)) continue;
            return loginInfo;
        }
        return null;
    }

    ArrayList getLoginInfoByVenderFlag(int n) {
        Iterator iterator = this.loginTable.iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            LoginInfo loginInfo = (LoginInfo)iterator.next();
            if (loginInfo.getVenderFlag() != n) continue;
            arrayList.add(loginInfo.getUserID());
        }
        return arrayList;
    }

    private boolean getHPLoginIDInfo(String string) {
        Iterator iterator = this.ForHpTable.iterator();
        return this.ForHpTable.contains(string);
    }

    int getHPUserInfoSize() {
        return this.ForHpTable.size();
    }

    int getHiCUserInfoSize() {
        return this.HicTable.size();
    }

    private HPLoginIDInfo getHPInfoByUserID(String string) {
        Iterator iterator = this.ForHpTable.iterator();
        while (iterator.hasNext()) {
            HPLoginIDInfo hPLoginIDInfo = (HPLoginIDInfo)iterator.next();
            if (!hPLoginIDInfo.getUserID().equals(string)) continue;
            return hPLoginIDInfo;
        }
        return null;
    }

    private LinkedList getUserListbyVender(int n) {
        LinkedList linkedList = null;
        switch (n) {
            case 0: {
                linkedList = this.ForHpTable;
                break;
            }
            case 1: {
                linkedList = this.HicTable;
                break;
            }
        }
        return linkedList;
    }

    synchronized IDInfo getIDInfoByUserID(int n, String string) {
        LinkedList linkedList = this.getUserListbyVender(n);
        IDInfo iDInfo = null;
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            iDInfo = (IDInfo)iterator.next();
            if (iDInfo.getUserID().equals(string)) break;
            iDInfo = null;
        }
        return iDInfo;
    }

    private void addLoginUser(String string, String string2, RmiObjImpl rmiObjImpl) {
        this.loginTable.add(new LoginInfo(string, string2, rmiObjImpl));
    }

    private void addLoginUser_Vender(String string, String string2, RmiObjImpl rmiObjImpl, int n) {
        this.loginTable.add(new LoginInfo(string, string2, rmiObjImpl, n));
    }

    private String delLoginUserByBindName(String string) {
        LoginInfo loginInfo = this.getLoginInfoByBindName(string);
        if (loginInfo != null) {
            String string2 = loginInfo.getUserID();
            loginInfo.getRmiObj().vanish();
            this.loginTable.remove(loginInfo);
            return string2;
        }
        return null;
    }

    RmiConObjSync(RmiConObjUserCert rmiConObjUserCert) {
        this.userCert = rmiConObjUserCert;
    }

    synchronized void notifyTrap(String string) {
        Iterator iterator = this.loginTable.iterator();
        while (iterator.hasNext()) {
            LoginInfo loginInfo = (LoginInfo)iterator.next();
            loginInfo.getRmiObj().strTrapRefCode = string;
        }
    }

    synchronized void notifyUnlock() {
        Iterator iterator = this.loginTable.iterator();
        while (iterator.hasNext()) {
            LoginInfo loginInfo = (LoginInfo)iterator.next();
            loginInfo.getRmiObj().nNotifyUnlockFlag = 1;
            loginInfo.getRmiObj().nLockFlag = 0;
            loginInfo.getRmiObj().info.unlock();
            loginInfo.getRmiObj().nSequenceNow = 0;
            loginInfo.rmiObj._CallFTFileDataClear();
        }
    }

    synchronized RmiLoginInfo login(String string) throws SyncException {
        if (this.getLoginInfoByUserID(string) != null) {
            throw new SyncException(5132, "RmiConObjSync: Already Login: " + string);
        }
        String string2 = this.makeBindName(string);
        RmiObjImpl rmiObjImpl = this.makeRmiObj(string2, string);
        RmiObjImpl.strRMIServerVersion = RmiControlObjImpl.getEnvInfo().getServerVersion();
        rmiObjImpl.dateSVP = new Date();
        String string3 = this.makeUrl(string2);
        this.doBind(string2, rmiObjImpl);
        this.addLoginUser(string, string2, rmiObjImpl);
        return new RmiLoginInfo(string3, string2);
    }

    synchronized RmiLoginInfo forcedLogin(String string) throws SyncException {
        LoginInfo loginInfo = this.getLoginInfoByUserID(string);
        String string2 = this.makeBindName(string);
        RmiObjImpl rmiObjImpl = this.makeRmiObj(string2, string);
        RmiObjImpl.strRMIServerVersion = RmiControlObjImpl.getEnvInfo().getServerVersion();
        rmiObjImpl.dateSVP = new Date();
        String string3 = this.makeUrl(string2);
        this.doBind(string2, rmiObjImpl);
        this.addLoginUser(string, string2, rmiObjImpl);
        if (loginInfo != null) {
            loginInfo.getRmiObj().vanish();
            this.loginTable.remove(loginInfo);
        }
        return new RmiLoginInfo(string3, string2);
    }

    protected synchronized RmiLoginInfo login(String string, String string2, int n, int n2) throws SyncException {
        if (this.getLoginInfoByUserID(string) != null) {
            throw new SyncException(5132, "RmiConObjSync: Already Log-in: " + string);
        }
        String string3 = null;
        string3 = string.length() > 16 ? this.makeBindName(string.substring(0, 16)) : this.makeBindName(string);
        RmiObjImpl rmiObjImpl = this.makeRmiObj(string3, string, n2);
        RmiObjImpl.strRMIServerVersion = RmiControlObjImpl.getEnvInfo().getServerVersion();
        rmiObjImpl.dateSVP = new Date();
        rmiObjImpl.strHPInfo = this.HPInfomation;
        rmiObjImpl.strIPAddress = string2;
        rmiObjImpl.nVenderFlag = n;
        String string4 = this.makeUrl(string3);
        rmiObjImpl.info.setInfo(RmiControlObjImpl.getEnvInfo().getServerVersion(), string4, string3, string, n, new Date(), string2, this.HPInfomation);
        rmiObjImpl._preProc();
        this.HPInfomation = "";
        this.doBind(string3, rmiObjImpl);
        this.addLoginUser_Vender(string, string3, rmiObjImpl, n);
        return new RmiLoginInfo(string4, string3);
    }

    synchronized String logOff(String string) throws SyncException {
        String string2 = this.delLoginUserByBindName(string);
        try {
            this.doUnbind(string);
        }
        catch (SyncException syncException) {
            if (4007 == syncException.getErrData()) {
                while (true) {
                    try {
                        Thread.sleep(10000L);
                        this.doUnbind(string);
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
            throw syncException;
        }
        return string2;
    }

    synchronized ArrayList getUserIDList() {
        Iterator iterator = this.loginTable.iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            LoginInfo loginInfo = (LoginInfo)iterator.next();
            arrayList.add(loginInfo.getUserID());
        }
        return arrayList;
    }

    protected synchronized String getLoginKey(String string, String string2) {
        String string3 = Integer.toString(Math.abs(this.rand.nextInt()), 16).toUpperCase();
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = new String();
        int n = string3.length();
        while (n < 10) {
            stringBuffer.append('0');
            ++n;
        }
        string4 = string3 + stringBuffer.toString();
        this.setHPUserInfo(string, string4, string2, 0);
        RunTimeTask runTimeTask = new RunTimeTask(0, string, string4, 5);
        runTimeTask.start();
        return string4;
    }

    protected synchronized void setUserID(String string, String string2) throws SANRmiException {
        this.setHiCommandInfo(string, string2, 0);
        RunTimeTask runTimeTask = new RunTimeTask(1, string, string2, 5);
        runTimeTask.start();
    }

    protected synchronized boolean setHPUserInfo(String string, String string2, String string3, int n) {
        boolean bl = false;
        if (n == 0) {
            bl = this.ForHpTable.add(new HPLoginIDInfo(string, string2, string3));
        } else if (n == 1) {
            Iterator iterator = this.ForHpTable.iterator();
            while (iterator.hasNext()) {
                HPLoginIDInfo hPLoginIDInfo = (HPLoginIDInfo)iterator.next();
                if (!hPLoginIDInfo.getUserID().equals(string) || !hPLoginIDInfo.getLoginID().equals(string2)) continue;
                this.HPInfomation = hPLoginIDInfo.HPInfo;
                bl = this.ForHpTable.remove(hPLoginIDInfo);
                break;
            }
        }
        return bl;
    }

    protected synchronized boolean setHiCommandInfo(String string, String string2, int n) {
        boolean bl = false;
        if (n == 0) {
            bl = this.HicTable.add(new IDInfo(string, string2));
        } else if (n == 1) {
            Iterator iterator = this.HicTable.iterator();
            while (iterator.hasNext()) {
                IDInfo iDInfo = (IDInfo)iterator.next();
                if (!iDInfo.userID.equals(string) || !iDInfo.LoginID.equals(string2)) continue;
                bl = this.HicTable.remove(iDInfo);
                System.out.println(string);
                System.out.println(string2);
                break;
            }
        }
        return bl;
    }

    protected synchronized boolean HPcertificationInfo(String string, String string2) {
        boolean bl = false;
        Iterator iterator = this.ForHpTable.iterator();
        while (iterator.hasNext()) {
            HPLoginIDInfo hPLoginIDInfo = (HPLoginIDInfo)iterator.next();
            if (!hPLoginIDInfo.getUserID().equals(string) || !hPLoginIDInfo.getLoginID().equals(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected synchronized boolean certificationInfo(int n, String string, String string2) {
        boolean bl = false;
        LinkedList linkedList = this.getUserListbyVender(n);
        if (linkedList != null) {
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                IDInfo iDInfo = (IDInfo)iterator.next();
                if (!iDInfo.userID.equals(string) || !iDInfo.LoginID.equals(string2)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    protected ActiveUserInfo[] getActiveUserinfoClass() {
        Iterator iterator = this.loginTable.iterator();
        ActiveUserInfo[] activeUserInfoArray = new ActiveUserInfo[this.loginTable.size()];
        int n = 0;
        while (iterator.hasNext()) {
            LoginInfo loginInfo = (LoginInfo)iterator.next();
            activeUserInfoArray[n] = new ActiveUserInfo();
            activeUserInfoArray[n] = loginInfo.getRmiObj().getUserInfo();
            ++n;
        }
        return activeUserInfoArray;
    }

    protected ActiveUserInfo[] getActiveUserinfoClass(int n) {
        Iterator iterator = this.loginTable.iterator();
        ActiveUserInfo[] activeUserInfoArray = new ActiveUserInfo[this.getLoginInfoByVenderFlag(n).size()];
        int n2 = 0;
        while (iterator.hasNext()) {
            LoginInfo loginInfo = (LoginInfo)iterator.next();
            if (loginInfo.getRmiObj().nVenderFlag != n) continue;
            activeUserInfoArray[n2] = new ActiveUserInfo();
            activeUserInfoArray[n2] = loginInfo.getRmiObj().getUserInfo();
            ++n2;
        }
        return activeUserInfoArray;
    }

    protected RmiObjUserInfo[] getUserInfo() {
        Iterator iterator = this.loginTable.iterator();
        RmiObjUserInfo[] rmiObjUserInfoArray = new RmiObjUserInfo[this.loginTable.size()];
        int n = 0;
        while (iterator.hasNext()) {
            LoginInfo loginInfo = (LoginInfo)iterator.next();
            rmiObjUserInfoArray[n] = loginInfo.getRmiObj().getUserAllInfo();
            ++n;
        }
        return rmiObjUserInfoArray;
    }

    protected RmiObjUserInfo[] getUserInfo(int n) {
        Iterator iterator = this.loginTable.iterator();
        RmiObjUserInfo[] rmiObjUserInfoArray = new RmiObjUserInfo[this.getLoginInfoByVenderFlag(n).size()];
        int n2 = 0;
        while (iterator.hasNext()) {
            LoginInfo loginInfo = (LoginInfo)iterator.next();
            if (loginInfo.getRmiObj().nVenderFlag != n) continue;
            rmiObjUserInfoArray[n2] = loginInfo.getRmiObj().getUserAllInfo();
            ++n2;
        }
        return rmiObjUserInfoArray;
    }

    protected void forceLogoff(String string, String string2) {
        Iterator iterator = this.loginTable.iterator();
        while (iterator.hasNext()) {
            LoginInfo loginInfo = (LoginInfo)iterator.next();
            try {
                if (!loginInfo.getBindName().equals(string2)) continue;
                loginInfo.getRmiObj().DontBe(string);
                break;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void forceUnlock(String string, String string2) {
        Iterator iterator = this.loginTable.iterator();
        while (iterator.hasNext()) {
            LoginInfo loginInfo = (LoginInfo)iterator.next();
            try {
                if (!loginInfo.getBindName().equals(string2)) continue;
                loginInfo.getRmiObj().Dontlock(string);
                break;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private class LimitTimeTask
    extends TimerTask {
        String userID;
        String LoginID;
        int Vender;

        LimitTimeTask(int n, String string, String string2) {
            this.Vender = n;
            this.userID = string;
            this.LoginID = string2;
        }

        public void run() {
            if (RmiConObjSync.this.certificationInfo(this.Vender, this.userID, this.LoginID)) {
                switch (this.Vender) {
                    case 0: {
                        RmiConObjSync.this.setHPUserInfo(this.userID, this.LoginID, "Remove", 1);
                        break;
                    }
                    case 1: {
                        RmiConObjSync.this.setHiCommandInfo(this.userID, this.LoginID, 1);
                        break;
                    }
                }
            }
        }
    }

    private class RunTimeTask
    extends Thread {
        String userID;
        String LoginID;
        int LimitTime;
        int Vender;

        RunTimeTask(int n, String string, String string2, int n2) {
            this.Vender = n;
            this.userID = string;
            this.LoginID = string2;
            this.LimitTime = n2;
        }

        public void run() {
            Timer timer = new Timer();
            LimitTimeTask limitTimeTask = new LimitTimeTask(this.Vender, this.userID, this.LoginID);
            timer.schedule((TimerTask)limitTimeTask, this.LimitTime * 60000);
        }
    }

    private static class HPLoginIDInfo
    extends IDInfo {
        private String HPInfo;

        HPLoginIDInfo(String string, String string2, String string3) {
            super(string, string2);
            this.HPInfo = string3;
        }

        String getHPInfo() {
            return this.HPInfo;
        }
    }

    private static class IDInfo {
        private String userID;
        private String LoginID;

        IDInfo(String string, String string2) {
            this.userID = string;
            this.LoginID = string2;
        }

        String getUserID() {
            return this.userID;
        }

        String getLoginID() {
            return this.LoginID;
        }
    }

    private static class LoginInfo {
        private String userID;
        private String bindName;
        private RmiObjImpl rmiObj;
        private int nVenderFlag = 0;

        LoginInfo(String string, String string2, RmiObjImpl rmiObjImpl) {
            this.userID = string;
            this.bindName = string2;
            this.rmiObj = rmiObjImpl;
        }

        LoginInfo(String string, String string2, RmiObjImpl rmiObjImpl, int n) {
            this.userID = string;
            this.bindName = string2;
            this.rmiObj = rmiObjImpl;
            this.nVenderFlag = n;
        }

        String getUserID() {
            return this.userID;
        }

        String getBindName() {
            return this.bindName;
        }

        RmiObjImpl getRmiObj() {
            return this.rmiObj;
        }

        int getVenderFlag() {
            return this.nVenderFlag;
        }
    }
}

