/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat;

import java.io.IOException;
import java.io.PrintStream;
import java.text.ParseException;
import sanproject.getmondat.com.RJMdCmdParser;
import sanproject.getmondat.com.RJMdExecParameter;
import sanproject.getmondat.com.RJMdMessage;
import sanproject.getmondat.com.RJMdMsgID;
import sanproject.getmondat.com.RJMdRangeException;
import sanproject.getmondat.com.RJMdRmiException;
import sanproject.getmondat.data.RJMdDataControl;
import sanproject.getmondat.group.RJMdGroupData;
import sanproject.getmondat.group.RJMdGroupLDEV;
import sanproject.getmondat.group.RJMdGroupLDEVEachOfCU;
import sanproject.getmondat.group.RJMdGroupLU;
import sanproject.getmondat.group.RJMdGroupMFPort;
import sanproject.getmondat.group.RJMdGroupPG;
import sanproject.getmondat.group.RJMdGroupPPCGWWN;
import sanproject.getmondat.group.RJMdGroupPhyCMPK;
import sanproject.getmondat.group.RJMdGroupPhyExG;
import sanproject.getmondat.group.RJMdGroupPhyExLDEV;
import sanproject.getmondat.group.RJMdGroupPhyLDEV;
import sanproject.getmondat.group.RJMdGroupPhyMPPK;
import sanproject.getmondat.group.RJMdGroupPhyMainPK;
import sanproject.getmondat.group.RJMdGroupPhyPG;
import sanproject.getmondat.group.RJMdGroupPhyProc;
import sanproject.getmondat.group.RJMdGroupPort;
import sanproject.getmondat.group.RJMdGroupPortWWN;
import sanproject.getmondat.group.RJMdGroupRCLDEV;
import sanproject.getmondat.group.RJMdGroupRCLU;
import sanproject.getmondat.group.RJMdGroupRemoteCopy;
import sanproject.getmondat.group.RJMdGroupUR;
import sanproject.getmondat.group.RJMdGroupURJNL;
import sanproject.getmondat.group.RJMdGroupURLDEV;
import sanproject.getmondat.group.RJMdGroupURLU;

public class RJMdGroupManager
implements RJMdMsgID {
    private RJMdDataControl controller;
    private RJMdExecParameter parameter;
    private RJMdGroupData[] groupDatas;

    public RJMdGroupManager(RJMdDataControl rJMdDataControl) {
        this.controller = rJMdDataControl;
        this.parameter = rJMdDataControl.getExecParameter();
    }

    public void init() {
        this.groupDatas = this.controller.isHM() ? new RJMdGroupData[]{new RJMdGroupPort(this.controller), new RJMdGroupPortWWN(this.controller), new RJMdGroupPPCGWWN(this.controller), new RJMdGroupPG(this.controller), new RJMdGroupLDEV(this.controller), new RJMdGroupLU(this.controller), new RJMdGroupPhyPG(this.controller), new RJMdGroupPhyProc(this.controller), new RJMdGroupPhyLDEV(this.controller), new RJMdGroupRemoteCopy(this.controller), new RJMdGroupPhyExG(this.controller), new RJMdGroupPhyExLDEV(this.controller), new RJMdGroupRCLU(this.controller), new RJMdGroupRCLDEV(this.controller), new RJMdGroupUR(this.controller), new RJMdGroupURLU(this.controller), new RJMdGroupURLDEV(this.controller), new RJMdGroupURJNL(this.controller), new RJMdGroupLDEVEachOfCU(this.controller), new RJMdGroupPhyMainPK(this.controller)} : new RJMdGroupData[]{new RJMdGroupPort(this.controller), new RJMdGroupMFPort(this.controller), new RJMdGroupPortWWN(this.controller), new RJMdGroupPPCGWWN(this.controller), new RJMdGroupPG(this.controller), new RJMdGroupLDEV(this.controller), new RJMdGroupLU(this.controller), new RJMdGroupPhyPG(this.controller), new RJMdGroupPhyProc(this.controller), new RJMdGroupPhyCMPK(this.controller), new RJMdGroupPhyMPPK(this.controller), new RJMdGroupPhyLDEV(this.controller), new RJMdGroupRemoteCopy(this.controller), new RJMdGroupPhyExG(this.controller), new RJMdGroupPhyExLDEV(this.controller), new RJMdGroupRCLU(this.controller), new RJMdGroupRCLDEV(this.controller), new RJMdGroupUR(this.controller), new RJMdGroupURLU(this.controller), new RJMdGroupURLDEV(this.controller), new RJMdGroupURJNL(this.controller), new RJMdGroupLDEVEachOfCU(this.controller)};
    }

    public void apply() throws ParseException {
        try {
            RJMdGroupData rJMdGroupData;
            int n;
            int n2 = this.parameter.getClearMode();
            for (n = 0; n < this.groupDatas.length; ++n) {
                rJMdGroupData = this.groupDatas[n];
                rJMdGroupData.init();
                n2 = rJMdGroupData.checkClear(n2);
                if (n2 == 1) {
                    rJMdGroupData.deleteGroup();
                    continue;
                }
                if (n2 == 3) break;
            }
            if (n2 != 3) {
                for (n = 0; n < this.groupDatas.length; ++n) {
                    rJMdGroupData = this.groupDatas[n];
                    if (!rJMdGroupData.isAllowCreate()) continue;
                    rJMdGroupData.createGroup();
                }
                for (n = 0; n < this.groupDatas.length; ++n) {
                    rJMdGroupData = this.groupDatas[n];
                    rJMdGroupData.setActive(false);
                }
            }
        }
        catch (RJMdRmiException rJMdRmiException) {
            this.controller.putMessage(rJMdRmiException.getMessage());
            RJMdGroupManager rJMdGroupManager = this;
            PrintStream printStream = rJMdGroupManager.controller.getLogStream();
            if (printStream != null) {
                rJMdRmiException.printStackTrace(printStream);
            }
            throw new ParseException(null, 0);
        }
        catch (IOException iOException) {
            this.controller.putMessage(iOException.getMessage());
            RJMdGroupManager rJMdGroupManager = this;
            PrintStream printStream = rJMdGroupManager.controller.getLogStream();
            if (printStream != null) {
                iOException.printStackTrace(printStream);
            }
            throw new ParseException(null, 0);
        }
    }

    public void analyze(RJMdCmdParser rJMdCmdParser) throws ParseException {
        String string = rJMdCmdParser.getToken();
        for (int i = 0; i < this.groupDatas.length; ++i) {
            RJMdGroupData rJMdGroupData = this.groupDatas[i];
            if (!this.isGroupID(string, rJMdGroupData)) continue;
            if (!this.controller.isAdministrator() && !rJMdGroupData.isAllowPSA()) {
                throw RJMdMessage.parseException("MSG027", string);
            }
            rJMdGroupData.setActive(true);
            rJMdCmdParser.nextToken();
            try {
                rJMdGroupData.analyzeOperand(rJMdCmdParser);
                break;
            }
            catch (RJMdRangeException rJMdRangeException) {
                throw RJMdMessage.parseException("MSG015", rJMdRangeException.getMessage());
            }
        }
    }

    private boolean isGroupID(String string, RJMdGroupData rJMdGroupData) {
        boolean bl = true;
        if (!string.equals(rJMdGroupData.getGroupID())) {
            bl = false;
            String[] stringArray = rJMdGroupData.getGroupAlias();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }
}

