/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat.com;

import java.util.Date;
import sanproject.getmondat.com.RJMdDateFormat;
import sanproject.getmondat.com.RJMdRange;
import sanproject.getmondat.com.RJMdRangeException;

public class RJMdTimeRange
extends RJMdRange {
    private static final RJMdDateFormat dateFormat = new RJMdDateFormat("yyyy/MM/dd");
    private static final RJMdDateFormat timeFormat = new RJMdDateFormat("HH:mm:ss");
    private static final RJMdDateFormat rangeFormat = new RJMdDateFormat("[yyyy/MM/dd HH:mm:ss]");
    private static final RJMdDateFormat dateTimeFormat = new RJMdDateFormat("yyyy/MM/dd HH:mm");
    public static final long MSEC = 60000L;
    private int intervalTime;

    public RJMdTimeRange() {
        this(null, null);
    }

    public RJMdTimeRange(Date date, Date date2) {
        super(date, date2);
    }

    public RJMdTimeRange(Date date, Date date2, int n) {
        super(date, date2);
        this.setIntervalTime(n);
    }

    public void setValue(Comparable comparable, Comparable comparable2) {
        if (comparable != null && comparable2 != null && comparable.compareTo(comparable2) >= 0) {
            throw new RJMdRangeException(rangeFormat.format(comparable) + ":" + rangeFormat.format(comparable2));
        }
        super.setValue(comparable, comparable2);
    }

    public Date getFromTime() {
        Date date = (Date)this.getFromValue();
        if (date != null) {
            date = new Date(date.getTime());
        }
        return date;
    }

    public Date getToTime() {
        Date date = (Date)this.getToValue();
        if (date != null) {
            date = new Date(date.getTime());
        }
        return date;
    }

    public Object clone() {
        return new RJMdTimeRange(this.getFromTime(), this.getToTime(), this.getIntervalTime());
    }

    public String toFromDateString() {
        return dateFormat.format(this.getFromTime());
    }

    public String toFromTimeString() {
        return timeFormat.format(this.getFromTime());
    }

    public String toToDateString() {
        return dateFormat.format(this.getToTime());
    }

    public String toToTimeString() {
        return timeFormat.format(this.getToTime());
    }

    public int getCount() {
        int n = 0;
        Date date = this.getFromTime();
        Date date2 = this.getToTime();
        if (date != null && date2 != null) {
            n = (int)((date2.getTime() - date.getTime()) / this.getUnitTime());
        }
        return n;
    }

    private void setIntervalTime(int n) {
        this.intervalTime = n;
    }

    public int getIntervalTime() {
        return this.intervalTime;
    }

    public long getUnitTime() {
        return (long)this.intervalTime * 60000L;
    }

    public String toTickString(int n) {
        Date date = new Date(this.getFromTime().getTime() + (long)n * this.getUnitTime());
        return dateTimeFormat.format(date);
    }

    public String toFromString() {
        return dateTimeFormat.format(this.getFromTime());
    }

    public String toToString() {
        return dateTimeFormat.format(this.getToTime());
    }

    public String toString() {
        String string = "";
        Date date = this.getFromTime();
        if (date != null) {
            string = string + rangeFormat.format(date);
        }
        string = string + ":";
        Date date2 = this.getToTime();
        if (date2 != null) {
            string = string + rangeFormat.format(date2);
        }
        return string;
    }

    public void adjustTime(RJMdTimeRange rJMdTimeRange) {
        long l;
        Date date = this.getFromTime();
        Date date2 = this.getToTime();
        Date date3 = rJMdTimeRange.getFromTime();
        Date date4 = rJMdTimeRange.getToTime();
        if (date != null) {
            l = (date.getTime() - date3.getTime()) / this.getUnitTime() * this.getUnitTime();
            date3.setTime(date3.getTime() + l);
        }
        if (date2 != null) {
            l = (date4.getTime() - date2.getTime()) / this.getUnitTime() * this.getUnitTime();
            date4.setTime(date4.getTime() - l);
        }
        super.setValue(date3, date4);
    }
}

