/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat.group;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import sanproject.getmondat.com.RJMdCmdParser;
import sanproject.getmondat.com.RJMdRange;
import sanproject.getmondat.com.RJMdRmiException;
import sanproject.getmondat.data.RJMdDataControl;
import sanproject.getmondat.data.RJMdDataPG;
import sanproject.getmondat.group.RJMdColumn;
import sanproject.getmondat.group.RJMdGroupPhyData;
import sanproject.serverux.arg.monitor.HIHsmPGUseRateArgInfo;
import sanproject.serverux.arg.monitor.HIHsmPhysicalPGUseRateArgInfo;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.HIHsmPGUseRate;
import sanproject.serverux.data.HIHsmPhysicalPGUseRate;
import sanproject.serverux.data.MonitorInfoCollection;

public class RJMdGroupPhyPG
extends RJMdGroupPhyData {
    private static final String groupID = "PhyPG";
    private static final String[] groupAlias = new String[0];
    private static final String groupName = "PhyPG_dat";
    private static final String groupInfoS = " data of physical range";
    private static final String groupInfoL = " data of physical long range";
    private String DLM = ".";
    public static final int LIMIT_PARAMS_PhyPG = 128;
    private static final String PHY_Long_AG = "PHY_Long_PG";
    private static final String PHY_Short_AG = "PHY_PG";
    private String rangeName = null;
    public int judge = 0;

    public RJMdGroupPhyPG(RJMdDataControl rJMdDataControl) {
        super(rJMdDataControl);
    }

    protected boolean isGroupExists() {
        boolean bl = this.stream.exists();
        return bl;
    }

    public void deleteGroup() {
        this.stream.deleteAll();
    }

    public void createGroup(int n) throws RJMdRmiException, IOException {
        this.putInfomation("INF006", "parity group" + this.getGroupInfo(n));
        if (n == 0) {
            this.stream.createEntry(PHY_Short_AG, this.getTimeRange(n));
        } else if (n == 1) {
            this.stream.createEntry(PHY_Long_AG, this.getTimeRange(n));
        }
        ArrayList arrayList = this.controller.getPG(4);
        int n2 = this.initProgressPG(arrayList);
        int n3 = 0;
        HIHsmPGUseRateArgInfo hIHsmPGUseRateArgInfo = this.createArgument(n, n2);
        n2 -= hIHsmPGUseRateArgInfo.getCount();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataPG rJMdDataPG = (RJMdDataPG)iterator.next();
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataPG)) continue;
            if (n3 >= 128) {
                this.collect(hIHsmPGUseRateArgInfo, n);
                this.addProgress(n3);
                n3 = 0;
                hIHsmPGUseRateArgInfo = this.createArgument(n, n2);
                n2 -= hIHsmPGUseRateArgInfo.getCount();
            }
            hIHsmPGUseRateArgInfo.setAllParam(n3, rJMdDataPG.getFB4(), rJMdDataPG.getPG());
            ++n3;
        }
        this.collect(hIHsmPGUseRateArgInfo, n);
        this.addProgress(n3);
        this.closeProgress();
        this.stream.closeEntry();
        this.putInfomation("INF007", this.getGroupInfo(n));
    }

    public HIHsmPGUseRateArgInfo createArgument(int n, int n2) {
        HIHsmPhysicalPGUseRateArgInfo hIHsmPhysicalPGUseRateArgInfo = null;
        int n3 = n2;
        if (n2 >= 128) {
            n3 = 128;
        }
        if (n == 0) {
            hIHsmPhysicalPGUseRateArgInfo = new HIHsmPhysicalPGUseRateArgInfo(1, this.parameter.getShortRange().getFromTime(), this.parameter.getShortRange().getToTime(), n3);
        } else if (n == 1) {
            hIHsmPhysicalPGUseRateArgInfo = new HIHsmPGUseRateArgInfo(1, this.parameter.getLongRange().getFromTime(), this.parameter.getLongRange().getToTime(), n3);
        }
        return hIHsmPhysicalPGUseRateArgInfo;
    }

    public void collect(HIHsmPGUseRateArgInfo hIHsmPGUseRateArgInfo, int n) throws RJMdRmiException, IOException {
        if (hIHsmPGUseRateArgInfo.getCount() > 0) {
            MonitorInfoCollection monitorInfoCollection = (MonitorInfoCollection)this.controller.getMonitorInfo((MonArg)hIHsmPGUseRateArgInfo);
            for (int i = 0; i < monitorInfoCollection.size(); ++i) {
                String string;
                HIHsmPhysicalPGUseRate hIHsmPhysicalPGUseRate;
                if (n == 0) {
                    hIHsmPhysicalPGUseRate = (HIHsmPhysicalPGUseRate)monitorInfoCollection.get(i);
                    string = hIHsmPhysicalPGUseRate.getFb4() + "-" + hIHsmPhysicalPGUseRate.getPg();
                    this.stream.write(new RJMdColumn(string, hIHsmPhysicalPGUseRate.getUseRate()));
                    continue;
                }
                if (n != 1) continue;
                hIHsmPhysicalPGUseRate = (HIHsmPGUseRate)monitorInfoCollection.get(i);
                string = hIHsmPhysicalPGUseRate.getFb4() + "-" + hIHsmPhysicalPGUseRate.getPg();
                this.stream.write(new RJMdColumn(string, hIHsmPhysicalPGUseRate.getUseRate()));
            }
        }
    }

    private int initProgressPG(ArrayList arrayList) {
        int n = arrayList.size();
        int n2 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataPG rJMdDataPG = (RJMdDataPG)iterator.next();
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataPG)) continue;
            ++n2;
        }
        super.initProgress(n2, n);
        return n2;
    }

    public String[] getGroupAlias() {
        return groupAlias;
    }

    public String getGroupID() {
        return groupID;
    }

    public String getGroupName() {
        return groupName;
    }

    public String getGroupInfo(int n) {
        String string = "";
        string = n == 0 ? groupInfoS : groupInfoL;
        return string;
    }

    public void analyzeOperand(RJMdCmdParser rJMdCmdParser) throws ParseException {
        RJMdRange rJMdRange = null;
        this.analyzeTimeRange(rJMdCmdParser);
        char c = rJMdCmdParser.getKind();
        while ((rJMdRange = this.analyzePGrpRange(rJMdCmdParser)) != null) {
            RJMdDataControl.trace("\tPG =  " + rJMdRange);
            this.parameter.addGroupRange(this.getGroupID(), rJMdRange);
            if (rJMdCmdParser.getKind() != ' ') break;
            rJMdCmdParser.nextToken();
        }
    }
}

