/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.repository;

import com.ws.utilities.WSIStandardMessages;
import java.io.Serializable;
import java.util.ArrayList;
import javax.cim.CIMClass;
import javax.cim.CIMClassProperty;
import javax.wbem.WBEMException;
import org.wbemservices.wbem.repository.CIMClassRlogEntry;
import org.wbemservices.wbem.repository.CIMNameSpaceRlogEntry;

class CIMAssocClassRlogEntry
extends CIMClassRlogEntry {
    private static final long serialVersionUID = -5517300490476497950L;
    private AssocRole[] roles = new AssocRole[0];

    public CIMAssocClassRlogEntry(CIMNameSpaceRlogEntry nsentry, String name, String supercc) {
        super(nsentry, name, supercc);
    }

    public void createAssciations(CIMClass cc) throws WBEMException {
        this.roles = this.createAssociationClassPropList(cc);
        this.addClassAssociations();
    }

    @Override
    public void addSubClass(CIMClassRlogEntry cs) throws WBEMException {
        if (!(cs instanceof CIMAssocClassRlogEntry)) {
            throw new WBEMException(5, cs.getName());
        }
        super.addSubClass(cs);
    }

    private AssocRole[] createAssociationClassPropList(CIMClass cc) {
        ArrayList<AssocRole> al = new ArrayList<AssocRole>();
        for (int i = 0; i < cc.getProperties().length; ++i) {
            CIMClassProperty pe = cc.getProperties()[i];
            if (pe.getDataType().getType() != 14) continue;
            al.add(new AssocRole(pe.getDataType().getRefClassName(), pe.getName()));
        }
        return al.toArray(new AssocRole[al.size()]);
    }

    public void validateClassAsociations() throws WBEMException {
        for (int i = 0; i < this.roles.length; ++i) {
            CIMClassRlogEntry cctemp = this.nsentry.getClass(this.roles[i].cc);
            if (cctemp != null) continue;
            Object[] o = new Object[]{this.roles[i].role, this.roles[i].cc, this.name};
            throw new WBEMException(1, WSIStandardMessages.getMessage((String)"ERROR_ASSOCIATION_INVALID_REF", (Object[])o));
        }
    }

    private void addClassAssociations() throws WBEMException {
        this.validateClassAsociations();
        for (int i = 0; i < this.roles.length; ++i) {
            CIMClassRlogEntry cctemp = this.nsentry.getClass(this.roles[i].cc);
            cctemp.addAssociation(this);
        }
    }

    public void removeClassAssociations() throws WBEMException {
        this.validateClassAsociations();
        for (int i = 0; i < this.roles.length; ++i) {
            CIMClassRlogEntry cctemp = this.nsentry.getClass(this.roles[i].cc);
            cctemp.removeAssociation(this.getName());
        }
    }

    public ArrayList<String> matchRole(String cname, String role, String resultRole) {
        ArrayList<String> v = new ArrayList<String>();
        boolean match = false;
        boolean rolematch = false;
        boolean isReflective = false;
        for (int k = 0; k < this.roles.length; ++k) {
            if (!this.roles[k].cc.equalsIgnoreCase(cname)) continue;
            if (role != null && role.length() != 0) {
                if (this.roles[k].role.equalsIgnoreCase(role)) {
                    rolematch = true;
                }
            } else {
                rolematch = true;
            }
            if (match) {
                isReflective = true;
            }
            match = true;
        }
        if (!match || !rolematch) {
            return v;
        }
        for (int i = 0; i < this.roles.length; ++i) {
            if (!isReflective && this.roles[i].cc.equalsIgnoreCase(cname) || resultRole != null && resultRole.length() != 0 && !this.roles[i].role.equalsIgnoreCase(resultRole)) continue;
            boolean exist = false;
            for (int k = 0; k < v.size(); ++k) {
                if (!this.roles[i].cc.equalsIgnoreCase(v.get(k))) continue;
                exist = true;
            }
            if (exist) continue;
            v.add(this.roles[i].cc);
        }
        return v;
    }

    private static class AssocRole
    implements Serializable {
        private static final long serialVersionUID = 2757035817028854526L;
        public String cc;
        public String role;

        public AssocRole(String cc, String role) {
            this.cc = cc;
            this.role = role;
        }
    }
}

