/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.repository;

import com.ws.utilities.WSIStandardMessages;
import com.ws.wbem.jserver.CIMRepository;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.cim.CIMClass;
import javax.cim.CIMClassProperty;
import javax.cim.CIMDataType;
import javax.cim.CIMObjectPath;
import javax.cim.CIMQualifiedElementInterface;
import javax.cim.CIMQualifier;
import javax.cim.CIMQualifierType;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;

class CIMOMUtils {
    private static final String ARRAYTYPE_ORDERED = "Ordered";
    private static final String ARRAYTYPE_INDEXED = "Indexed";
    private static final String ARRAYTYPE_BAG = "Bag";
    private final CIMRepository mProviderHandle;

    private static boolean isTypeOf(String className, String parentClassName, CIMRepository cimom, String pNamespace) throws WBEMException {
        if (cimom == null) {
            return false;
        }
        if (className.equalsIgnoreCase(parentClassName)) {
            return true;
        }
        try {
            CloseableIterator e = cimom.enumerateClassNames(new CIMObjectPath(null, null, null, pNamespace, parentClassName, null), true);
            while (e.hasNext()) {
                CIMObjectPath cop = (CIMObjectPath)e.next();
                if (!className.equalsIgnoreCase(cop.getObjectName())) continue;
                return true;
            }
        }
        catch (WBEMException e) {
            return false;
        }
        return false;
    }

    CIMOMUtils(CIMRepository ps) {
        this.mProviderHandle = ps;
    }

    private CIMQualifier<?>[] addQualifier(CIMQualifier<?>[] pArray, CIMQualifier<?> pQualifier) {
        ArrayList l = new ArrayList();
        for (CIMQualifier<?> element : pArray) {
            l.add(element);
        }
        l.add(pQualifier);
        return l.toArray(new CIMQualifier[l.size()]);
    }

    CIMQualifier<?>[] assignInheritedQualifiers(CIMQualifier<?>[] pQualifiers, CIMQualifier<?>[] pInheritedQualifiers) {
        for (CIMQualifier<?> pInheritedQualifier : pInheritedQualifiers) {
            CIMQualifier<?> pos = pInheritedQualifier;
            if ((pos.getFlavor() & 2) == 2) continue;
            if (this.hasQualifier(pQualifiers, pos.getName())) {
                if ((pos.getFlavor() & 1) != 1) continue;
                pQualifiers = this.replaceQualifier(pQualifiers, pos);
                continue;
            }
            pQualifiers = this.addQualifier(pQualifiers, new CIMQualifier(pos.getName(), pos.getDataType(), pos.getValue(), pos.getFlavor(), true));
        }
        return pQualifiers;
    }

    protected CIMQualifier<?> checkQualifier(String namespace, CIMQualifier<?> cq) throws WBEMException, IllegalArgumentException {
        CIMQualifierType cqt = this.mProviderHandle.getQualifierType(new CIMObjectPath(null, null, null, namespace, cq.getName(), null));
        if (cqt == null) {
            Object[] o = new Object[]{cq.getName()};
            String message = WSIStandardMessages.getMessage((String)"ERROR_QUALIFIER_INVALID", (Object[])o);
            throw new WBEMException(1, message);
        }
        Object cv = null;
        cv = cq.getValue() != null && cqt.getDataType().getType() == 9 ? Boolean.TRUE : cq.getValue();
        return new CIMQualifier(cq.getName(), cqt.getDataType(), cv, cq.getFlavor() == 0 ? cqt.getFlavor() : 0);
    }

    protected CIMQualifier<?> createDefaultQualifier(String namespace, String qName) throws WBEMException {
        CIMQualifierType cqt = this.mProviderHandle.getQualifierType(new CIMObjectPath(null, null, null, namespace, qName, null));
        if (cqt == null) {
            Object[] o = new Object[]{qName};
            String message = WSIStandardMessages.getMessage((String)"ERROR_QUALIFIER_INVALID", (Object[])o);
            throw new WBEMException(1, message);
        }
        return new CIMQualifier(qName, cqt.getDataType(), cqt.getValue(), cqt.getFlavor());
    }

    protected CIMQualifier<?>[] doCommonQualifierChecks(String namespace, String elementName, CIMQualifier<?>[] qualifiers, int scope) throws WBEMException, IllegalArgumentException {
        if (qualifiers == null) {
            return qualifiers;
        }
        Hashtable<String, String> ht = new Hashtable<String, String>();
        for (int i = 0; i < qualifiers.length; ++i) {
            CIMQualifier<?> cq = qualifiers[i];
            String tlc = cq.getName().toLowerCase();
            if (ht.get(tlc) != null) {
                Object[] o = new Object[]{tlc, elementName};
                String message = WSIStandardMessages.getMessage((String)"ERROR_QUALIFIER_DUPLICATE", (Object[])o);
                throw new WBEMException(1, message);
            }
            ht.put(tlc, tlc);
            CIMObjectPath p = new CIMObjectPath(null, null, null, namespace, tlc, null);
            CIMQualifierType cqt = this.mProviderHandle.getQualifierType(p);
            if (cqt == null) {
                Object[] o = new Object[]{cq.getName()};
                String message = WSIStandardMessages.getMessage((String)"ERROR_QUALIFIER_INVALID", (Object[])o);
                throw new WBEMException(1, message);
            }
            Object value = cq.getValue();
            int flavors = cq.getFlavor();
            if (cq.getValue() == null && cqt.getDataType().getType() == 9) {
                value = Boolean.TRUE;
            }
            if (flavors == 0) {
                flavors = cqt.getFlavor();
            }
            qualifiers[i] = new CIMQualifier(cq.getName(), cqt.getDataType(), value, flavors);
            if ((cqt.getScope() & scope) == scope) continue;
            Object[] o = new Object[]{elementName, cq.getName(), new Integer(scope)};
            String message = WSIStandardMessages.getMessage((String)"ERROR_QUALIFIER_MISMATCH", (Object[])o);
            throw new IllegalArgumentException(message);
        }
        return qualifiers;
    }

    private boolean hasQualifier(CIMQualifier<?>[] pArray, String pName) {
        if (pArray == null) {
            return false;
        }
        for (CIMQualifier<?> element : pArray) {
            if (!pName.equalsIgnoreCase(element.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isNumber(int type) {
        return type == 0 || type == 2 || type == 4 || type == 6 || type == 1 || type == 3 || type == 5 || type == 7 || type == 10 || type == 11;
    }

    private boolean isUnsigned(int type) {
        return type == 0 || type == 2 || type == 4 || type == 6;
    }

    private CIMQualifier<?>[] replaceQualifier(CIMQualifier<?>[] pArray, CIMQualifier<?> pQualifier) {
        ArrayList<Object> l = new ArrayList<Object>();
        for (CIMQualifier<?> element : pArray) {
            if (element.getName() != null && element.getName().equalsIgnoreCase(pQualifier.getName())) {
                CIMQualifier t = new CIMQualifier(pQualifier.getName(), pQualifier.getDataType(), pQualifier.getValue(), pQualifier.getFlavor(), false);
                l.add(t);
                continue;
            }
            l.add(element);
        }
        return l.toArray(new CIMQualifier[l.size()]);
    }

    private void verifyArrayType(CIMDataType dt, String value, String className, String elementName) throws WBEMException {
        if (!dt.isArray()) {
            Object[] o = new Object[]{className, elementName};
            throw new WBEMException(1, WSIStandardMessages.getMessage((String)"ERROR_QUALIFIER_ARRAYTYPE_APPLIED_TO_NONARRAY", (Object[])o));
        }
        if (!(value.equalsIgnoreCase(ARRAYTYPE_BAG) || value.equalsIgnoreCase(ARRAYTYPE_INDEXED) || value.equalsIgnoreCase(ARRAYTYPE_ORDERED))) {
            Object[] o = new Object[]{className, elementName};
            throw new WBEMException(1, WSIStandardMessages.getMessage((String)"ERROR_QUALIFIER_ARRAYTYPE_INVALID_VALUE", (Object[])o));
        }
    }

    void verifyQualifiers(CIMQualifiedElementInterface cp, String mClassName, String mNamespace, CIMClass mSuperClass, String mElementName, CIMDataType dt, boolean isKey) throws WBEMException {
        Object[] o;
        CIMQualifier[] v;
        boolean hasValue = false;
        boolean hasValuemap = false;
        int numValues = -1;
        int numValuemaps = 0;
        boolean hasBitValue = false;
        boolean hasBitmap = false;
        int numBitValues = -1;
        int numBitmaps = 0;
        for (CIMQualifier cq : v = cp.getQualifiers()) {
            Object[] o2;
            int type;
            if (cq.getName().equalsIgnoreCase("ArrayType")) {
                this.verifyArrayType(dt, (String)cq.getValue(), mClassName, mElementName);
            }
            if ((cq.getName().equalsIgnoreCase("Counter") || cq.getName().equalsIgnoreCase("Gauge")) && !this.isUnsigned(type = dt.getType())) {
                Object[] o3 = new Object[]{cq.getName(), mClassName, mElementName};
                throw new WBEMException(1, WSIStandardMessages.getMessage((String)"ERROR_QUALIFIER_TYPE_NOT_UINT", (Object[])o3));
            }
            if ((cq.getName().equalsIgnoreCase("EmbeddedObject") || cq.getName().equalsIgnoreCase("MaxLen") || cq.getName().equalsIgnoreCase("MinLen")) && (type = dt.getType()) != 8) {
                Object[] o4 = new Object[]{cq.getName(), mClassName, mElementName};
                throw new WBEMException(1, WSIStandardMessages.getMessage((String)"ERROR_QUALIFIER_TYPE_NOT_STRING", (Object[])o4));
            }
            if (cq.getName().equalsIgnoreCase("EmbeddedInstance")) {
                if (cq.getValue() != null) {
                    String value = (String)cq.getValue();
                    try {
                        CIMObjectPath path = new CIMObjectPath(null, null, null, mNamespace, value, null);
                        this.mProviderHandle.getClass(path, false, false);
                    }
                    catch (WBEMException ex) {
                        o2 = new Object[]{cq.getName(), value};
                        throw new WBEMException(1, WSIStandardMessages.getMessage((String)"ERROR_QUALIFIER_CLASS_VALUE_NOT_FOUND", (Object[])o2));
                    }
                } else {
                    Object[] o5 = new Object[]{cq.getName()};
                    throw new WBEMException(1, WSIStandardMessages.getMessage((String)"ERROR_QUALIFIER_VALUE_NULL", (Object[])o5));
                }
            }
            if (cq.getName().equalsIgnoreCase("key") && dt.isArray()) {
                Object[] o6 = new Object[]{cq.getName()};
                throw new WBEMException(1, WSIStandardMessages.getMessage((String)"ERROR_QUALIFIER_APPLIED_TO_ARRAY", (Object[])o6));
            }
            if (cq.getName().equalsIgnoreCase("Override")) {
                if (cq.getValue() != null) {
                    String value = (String)cq.getValue();
                    if (!value.equalsIgnoreCase(mElementName)) {
                        Object[] o7 = new Object[]{mClassName, mElementName};
                        throw new WBEMException(1, WSIStandardMessages.getMessage((String)"ERROR_QUALIFIER_OVERRIDE_NAME_MISMATCH", (Object[])o7));
                    }
                    if (mSuperClass != null) {
                        CIMClassProperty superProp = mSuperClass.getProperty(mElementName);
                        if (superProp == null) {
                            o2 = new Object[]{mClassName, mElementName};
                            throw new WBEMException(1, WSIStandardMessages.getMessage((String)"ERROR_QUALIFIER_OVERRIDE_PROPERTY_NOT_FOUND", (Object[])o2));
                        }
                        CIMDataType cdt = dt;
                        if (dt.getType() == 14) {
                            String cName = cdt.getRefClassName();
                            String pName = superProp.getDataType().getRefClassName();
                            try {
                                CIMObjectPath path = new CIMObjectPath(null, null, null, mNamespace, cName, null);
                                this.mProviderHandle.getClass(path, false, false);
                            }
                            catch (WBEMException e) {
                                Object[] o8 = new Object[]{cName, mElementName, mClassName};
                                throw new WBEMException(1, WSIStandardMessages.getMessage((String)"ERROR_ASSOCIATION_INVALID_REF", (Object[])o8));
                            }
                            if (!CIMOMUtils.isTypeOf(cName, pName, this.mProviderHandle, mNamespace)) {
                                Object[] o9 = new Object[]{mClassName, mElementName};
                                throw new WBEMException(1, WSIStandardMessages.getMessage((String)"ERROR_QUALIFIER_OVERRIDE_REFERENCE_NOT_SUBCLASS", (Object[])o9));
                            }
                        } else if (!cdt.equals((Object)superProp.getDataType())) {
                            Object[] o10 = new Object[]{mClassName, mElementName, dt, mSuperClass.getName(), superProp.getName(), superProp.getDataType()};
                            throw new WBEMException(1, WSIStandardMessages.getMessage((String)"ERROR_QUALIFIER_OVERRIDE_TYPE_MISMATCH", (Object[])o10));
                        }
                    }
                } else {
                    Object[] o11 = new Object[]{cq.getName()};
                    throw new WBEMException(1, WSIStandardMessages.getMessage((String)"ERROR_QUALIFIER_VALUE_NULL", (Object[])o11));
                }
            }
            if (cq.getName().equalsIgnoreCase("Propagated") && !isKey) {
                throw new WBEMException(1, WSIStandardMessages.getMessage((String)"ERROR_QUALIFIER_PROPAGATED_NOT_KEY", null));
            }
            if (cq.getName().equalsIgnoreCase("Values")) {
                hasValue = true;
                String[] cv = (String[])cq.getValue();
                numValues = cv.length;
            }
            if (cq.getName().equalsIgnoreCase("ValueMap")) {
                hasValuemap = true;
                String[] cv = (String[])cq.getValue();
                numValuemaps = cv.length;
                if (this.isNumber(dt.getType())) {
                    for (int ctr = 0; ctr < cv.length; ++ctr) {
                        if (cv[ctr].equals("..")) continue;
                        if (cv[ctr].startsWith("..") && ctr != 0) {
                            o2 = new Object[]{cv[ctr], mClassName, mElementName};
                            throw new WBEMException(1, WSIStandardMessages.getMessage((String)"ERROR_QUALIFIER_VALUEMAP_VALUE_ILLEGAL_FRONT", (Object[])o2));
                        }
                        if (!cv[ctr].endsWith("..") || ctr == cv.length - 1) continue;
                        o2 = new Object[]{cv[ctr], mClassName, mElementName};
                        throw new WBEMException(1, WSIStandardMessages.getMessage((String)"ERROR_QUALIFIER_VALUEMAP_VALUE_ILLEGAL_BACK", (Object[])o2));
                    }
                } else if (dt.getType() != 8) {
                    Object[] o12 = new Object[]{mClassName, mElementName};
                    throw new WBEMException(1, WSIStandardMessages.getMessage((String)"ERROR_QUALIFIER_VALUEMAP_VALUES_TYPE", (Object[])o12));
                }
            }
            if ((cq.getName().equalsIgnoreCase("Weak") || cq.getName().equalsIgnoreCase("Min") || cq.getName().equalsIgnoreCase("Max") || cq.getName().equalsIgnoreCase("Aggregate")) && dt.getType() != 14) {
                Object[] o13 = new Object[]{cq.getName()};
                throw new WBEMException(1, WSIStandardMessages.getMessage((String)"ERROR_QUALIFIER_TYPE_NOT_REF", (Object[])o13));
            }
            if (cq.getName().equalsIgnoreCase("BitMap")) {
                hasBitValue = true;
                String[] cv = (String[])cq.getValue();
                numBitValues = cv.length;
            }
            if (!cq.getName().equalsIgnoreCase("BitValues")) continue;
            hasBitmap = true;
            String[] cv = (String[])cq.getValue();
            numBitmaps = cv.length;
        }
        if (hasValue && hasValuemap && numValues != numValuemaps) {
            o = new Object[]{mClassName, mElementName, String.valueOf(numValues), String.valueOf(numValuemaps)};
            throw new WBEMException(1, WSIStandardMessages.getMessage((String)"ERROR_QUALIFIER_VALUEMAP_VALUES_MISMATCH", (Object[])o));
        }
        if (hasBitValue && hasBitmap && numBitValues != numBitmaps) {
            o = new Object[]{mClassName, mElementName, new Integer(numBitValues), new Integer(numBitmaps)};
            throw new WBEMException(1, WSIStandardMessages.getMessage((String)"ERROR_QUALIFIER_BITMAP_BITVALUES_MISMATCH", (Object[])o));
        }
    }
}

