/*
 * Decompiled with CFR 0.152.
 */
package com.ws.utilities;

import com.ws.utilities.WSIStandardMessages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.wbem.WBEMException;

public class FileEncrypt {
    private final String mPublicKeyName;
    final int ENCRYPT_BUFFER_LENGTH = 245;
    public static final int AES_Key_Size = 128;
    private static final String TRANSFORMATION = "RSA";

    public FileEncrypt(String publicKeyName) {
        this.mPublicKeyName = publicKeyName;
    }

    public void encryptFile(String unencryptedFileName, String encryptedFileName) throws WBEMException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            try {
                fis = new FileInputStream(unencryptedFileName);
            }
            catch (FileNotFoundException exc) {
                Object[] o = new Object[]{unencryptedFileName};
                throw new WBEMException(1, WSIStandardMessages.getMessage("ERROR_FILE_NOT_FOUND", o));
            }
            try {
                fos = new FileOutputStream(encryptedFileName);
            }
            catch (FileNotFoundException exc) {
                Object[] o = new Object[]{encryptedFileName};
                throw new WBEMException(1, WSIStandardMessages.getMessage("ERROR_FILE_NOT_FOUND", o));
            }
            PublicKey publicKey = this.getPublicKey(this.mPublicKeyName);
            byte[] buffer = new byte[245];
            int read = 0;
            while (read >= 0) {
                read = fis.read(buffer, 0, 245);
                if (read <= 0) continue;
                byte[] newArray = Arrays.copyOf(buffer, read);
                byte[] encryptedData = FileEncrypt.encrypt(newArray, publicKey);
                fos.write(encryptedData);
                buffer = new byte[245];
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Exception exp) {
            Object[] o = new Object[]{exp.getMessage()};
            throw new WBEMException(1, WSIStandardMessages.getMessage("ERROR_ENCRYPT_FILE", o));
        }
        finally {
            try {
                if (null != fis) {
                    fis.close();
                }
                if (null != fos) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private PublicKey getPublicKey(String publicKeyName) throws WBEMException {
        PublicKey ret = null;
        FileInputStream isPublicKey = null;
        try {
            File publicKeyFile = new File(publicKeyName);
            byte[] encodedKey = new byte[(int)publicKeyFile.length()];
            isPublicKey = new FileInputStream(publicKeyFile);
            isPublicKey.read(encodedKey);
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(encodedKey);
            KeyFactory kf = KeyFactory.getInstance(TRANSFORMATION);
            ret = kf.generatePublic(publicKeySpec);
        }
        catch (Exception exp) {
            Object[] o = new Object[]{publicKeyName, exp.getMessage()};
            throw new WBEMException(1, WSIStandardMessages.getMessage("ERROR_PUBLIC_KEY_LOADING", o));
        }
        finally {
            if (null != isPublicKey) {
                try {
                    isPublicKey.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ret;
    }

    private static byte[] encrypt(byte[] inpBytes, PublicKey key) throws WBEMException {
        try {
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            cipher.init(1, key);
            return cipher.doFinal(inpBytes);
        }
        catch (Exception exp) {
            Object[] o = new Object[]{exp.getMessage()};
            throw new WBEMException(1, WSIStandardMessages.getMessage("ERROR_ENCRYPT_FILE", o));
        }
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println(WSIStandardMessages.getMessage("USAGE_FILEENCRYPT", null));
        } else {
            try {
                FileEncrypt fileEncrypt = new FileEncrypt(args[0]);
                fileEncrypt.encryptFile(args[1], args[2]);
            }
            catch (WBEMException we) {
                System.out.println(we.toString());
            }
        }
    }
}

