/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem;

import com.ws.wbem.IndicationType;
import com.ws.wbem.jserver.JServerProperties;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.cim.CIMClass;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.provider.ProviderHandle;
import org.wbemservices.wbem.query.AndQueryExp;
import org.wbemservices.wbem.query.BinaryRelQueryExp;
import org.wbemservices.wbem.query.NonJoinExp;
import org.wbemservices.wbem.query.QueryExp;
import org.wbemservices.wbem.query.SelectExp;
import org.wbemservices.wbem.query.SelectList;

class IndicationFilterParser {
    private static final String QUERYPROP = "Query";
    final String mQuery;
    SelectExp mParsedExp;
    String mEventClassname;
    final String mNamespace;
    List<List<BinaryRelQueryExp>> mBinaryRelQueryExpList;
    public IndicationType mIndicationType;
    final ProviderHandle mProviderHandle;

    public IndicationFilterParser(ProviderHandle providerHandle, String query) {
        this.mProviderHandle = providerHandle;
        this.mQuery = query;
        this.mNamespace = JServerProperties.getInteropNamespace();
        if (null == this.mQuery) {
            // empty if block
        }
        this.processQuery();
    }

    public IndicationFilterParser(ProviderHandle providerHandle, CIMInstance filterInstance) {
        if (null == filterInstance) {
            throw new IllegalArgumentException("param filterInstance can not be null");
        }
        this.mProviderHandle = providerHandle;
        this.mQuery = (String)filterInstance.getProperty(QUERYPROP).getValue();
        this.mNamespace = null != filterInstance.getObjectPath() ? filterInstance.getObjectPath().getNamespace() : null;
        this.processQuery();
    }

    private void processQuery() {
        this.mParsedExp = new SelectExp(this.mQuery);
        this.mEventClassname = ((NonJoinExp)this.mParsedExp.getFromClause()).getAttribute().getAttrClassName().toLowerCase();
        QueryExp whereClause = this.mParsedExp.getWhereClause();
        this.mBinaryRelQueryExpList = null;
        if (whereClause != null) {
            this.mBinaryRelQueryExpList = whereClause.canonizeDOC();
        } else {
            this.mIndicationType = IndicationType.Process;
            this.mBinaryRelQueryExpList = new ArrayList<List<BinaryRelQueryExp>>();
            this.mBinaryRelQueryExpList.add(new ArrayList());
        }
        Iterator<List<BinaryRelQueryExp>> iterBinaryRelQueryExpList = this.mBinaryRelQueryExpList.iterator();
        boolean queryHasISA = false;
        while (iterBinaryRelQueryExpList.hasNext()) {
            List<BinaryRelQueryExp> subExpression = iterBinaryRelQueryExpList.next();
            if (!this.hasISA(subExpression)) continue;
            queryHasISA = true;
        }
        this.mIndicationType = !queryHasISA ? IndicationType.Process : this.determineIndicationType(this.mProviderHandle, this.mNamespace, this.mEventClassname);
    }

    public String getEventClassname() {
        return this.mEventClassname;
    }

    public String getQueryString() {
        return this.mQuery;
    }

    public IndicationType getIndicationType() {
        return this.mIndicationType;
    }

    public boolean matchIndication(CIMInstance instIndication) {
        boolean ret;
        block4: {
            ret = false;
            try {
                SelectList sl = this.mParsedExp.getSelectList();
                Iterator<List<BinaryRelQueryExp>> i = this.mBinaryRelQueryExpList.iterator();
                CIMInstance selectedIndication = null;
                if (sl != null) {
                    selectedIndication = sl.apply(instIndication);
                }
                if (null == selectedIndication) break block4;
                ret = true;
                while (i.hasNext()) {
                    List<BinaryRelQueryExp> subExpression = i.next();
                    QueryExp subQueryExp = this.toQueryExp(subExpression = this.removeIsas(subExpression));
                    if (null == subQueryExp || subQueryExp.apply(selectedIndication)) continue;
                    ret = false;
                    break;
                }
            }
            catch (WBEMException wBEMException) {
                // empty catch block
            }
        }
        return ret;
    }

    private List<BinaryRelQueryExp> removeIsas(List<BinaryRelQueryExp> listQueryExpr) {
        ArrayList<BinaryRelQueryExp> output = new ArrayList<BinaryRelQueryExp>();
        for (BinaryRelQueryExp queryExp : listQueryExpr) {
            int operator = queryExp.getOperator();
            if (operator == 8 || operator == 9) continue;
            output.add(queryExp);
        }
        return output;
    }

    private boolean hasISA(List<BinaryRelQueryExp> listQueryExpr) {
        boolean ret = false;
        for (BinaryRelQueryExp queryExp : listQueryExpr) {
            int operator = queryExp.getOperator();
            if (operator != 8 && operator != 9) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private QueryExp toQueryExp(List<BinaryRelQueryExp> listQueryExp) {
        AndQueryExp ret = null;
        if (!listQueryExp.isEmpty()) {
            Iterator<BinaryRelQueryExp> i = listQueryExp.iterator();
            if (listQueryExp.size() == 1) {
                return (QueryExp)i.next();
            }
            QueryExp lexp = (QueryExp)i.next();
            QueryExp rexp = (QueryExp)i.next();
            ret = new AndQueryExp(lexp, rexp);
            while (i.hasNext()) {
                ret = new AndQueryExp((QueryExp)ret, (QueryExp)i.next());
            }
        }
        return ret;
    }

    private IndicationType determineIndicationType(ProviderHandle providerHandle, String namespace, String classname) {
        IndicationType ret = IndicationType.getIndicationTypeByClassName(classname);
        if (null == ret) {
            ret = IndicationType.Process;
            if (this.isTypeOf(providerHandle, namespace, classname, IndicationType.InstanceModification.getClassName())) {
                ret = IndicationType.InstanceModification;
            } else if (this.isTypeOf(providerHandle, namespace, classname, IndicationType.InstanceDeletion.getClassName())) {
                ret = IndicationType.InstanceDeletion;
            } else if (this.isTypeOf(providerHandle, namespace, classname, IndicationType.InstanceCreation.getClassName())) {
                ret = IndicationType.InstanceCreation;
            } else if (this.isTypeOf(providerHandle, namespace, classname, IndicationType.InstanceMethodCall.getClassName())) {
                ret = IndicationType.InstanceMethodCall;
            } else if (this.isTypeOf(providerHandle, namespace, classname, IndicationType.InstanceRead.getClassName())) {
                ret = IndicationType.InstanceRead;
            } else if (this.isTypeOf(providerHandle, namespace, classname, IndicationType.ClassCreation.getClassName())) {
                ret = IndicationType.ClassCreation;
            } else if (this.isTypeOf(providerHandle, namespace, classname, IndicationType.ClassDeletion.getClassName())) {
                ret = IndicationType.ClassDeletion;
            } else if (this.isTypeOf(providerHandle, namespace, classname, IndicationType.ClassModification.getClassName())) {
                ret = IndicationType.ClassModification;
            }
        }
        return ret;
    }

    private boolean isTypeOf(ProviderHandle providerHandle, String namespace, String className, String parentClassName) {
        if (className.equalsIgnoreCase(parentClassName)) {
            return true;
        }
        try {
            CloseableIterator iCOP = providerHandle.enumerateClasses(new CIMObjectPath(null, null, null, namespace, parentClassName, null), true, false, true);
            while (iCOP.hasNext()) {
                CIMObjectPath cop = ((CIMClass)iCOP.next()).getObjectPath();
                if (!className.equalsIgnoreCase(cop.getObjectName())) continue;
                return true;
            }
        }
        catch (WBEMException e) {
            return false;
        }
        return false;
    }
}

