/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.client.adapter.common;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class WSSSLSocketFactory
extends SSLSocketFactory {
    static TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }};
    private final SSLSocketFactory parentFactory;
    private final String[] ciphers;
    private final String[] protocols;
    private final LocalHostnameVerifier localHostVerifier;

    protected WSSSLSocketFactory(String ciphers, String protocols) throws KeyManagementException, NoSuchAlgorithmException {
        this(null, null, null, ciphers, protocols);
    }

    protected WSSSLSocketFactory(String keystore, String keystorePassword, String truststore, String ciphers, String protocols) throws KeyManagementException, NoSuchAlgorithmException {
        this(keystore, keystorePassword, truststore, null != ciphers ? ciphers.split("\\s*,\\s*") : null, null != protocols ? protocols.split("\\s*,\\s*") : null);
    }

    protected WSSSLSocketFactory(String keystore, String keystorePassword, String truststore, String[] ciphers, String[] protocols) throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext ctx = SSLContext.getInstance("TLS");
        KeyManager[] keyMgr = null;
        TrustManager[] trustMgrArray = trustAllCerts;
        if (null != keystore) {
            keyMgr = this.getKeyManagerArray(keystore, keystorePassword);
            if (null != truststore) {
                trustMgrArray = this.getTrustManagerArray(truststore);
            }
        }
        this.localHostVerifier = new LocalHostnameVerifier(trustMgrArray == trustAllCerts);
        ctx.init(keyMgr, trustMgrArray, null);
        this.parentFactory = ctx.getSocketFactory();
        this.ciphers = ciphers;
        this.protocols = protocols;
    }

    protected WSSSLSocketFactory(String[] ciphers, String[] protocols) throws KeyManagementException, NoSuchAlgorithmException {
        this(null, null, null, ciphers, protocols);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocket sock = (SSLSocket)this.parentFactory.createSocket(host, port);
        this.setCiphers(sock);
        this.setProtocols(sock);
        return sock;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocket sock = (SSLSocket)this.parentFactory.createSocket(address, port, localAddress, localPort);
        this.setCiphers(sock);
        this.setProtocols(sock);
        return sock;
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        SSLSocket sock = (SSLSocket)this.parentFactory.createSocket(s, host, port, autoClose);
        this.setCiphers(sock);
        this.setProtocols(sock);
        return sock;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocket sock = (SSLSocket)this.parentFactory.createSocket(host, port);
        this.setCiphers(sock);
        this.setProtocols(sock);
        return sock;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        SSLSocket sock = (SSLSocket)this.parentFactory.createSocket(host, port, localHost, localPort);
        this.setCiphers(sock);
        this.setProtocols(sock);
        return sock;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.parentFactory.getDefaultCipherSuites();
    }

    private KeyManager[] getKeyManagerArray(String keystore, String keystorePasswd) {
        KeyManager[] ret = null;
        try {
            if (keystore != null && keystorePasswd != null) {
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                KeyStore ks = KeyStore.getInstance("JKS");
                ks.load(new FileInputStream(keystore), null);
                kmf.init(ks, keystorePasswd.toCharArray());
                ret = kmf.getKeyManagers();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    protected LocalHostnameVerifier getLocalHostnameVerifier() {
        return this.localHostVerifier;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.parentFactory.getSupportedCipherSuites();
    }

    private TrustManager[] getTrustManagerArray(String truststore) {
        TrustManager[] ret = null;
        try {
            if (truststore != null) {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                KeyStore ts = KeyStore.getInstance("JKS");
                ts.load(new FileInputStream(truststore), null);
                tmf.init(ts);
                ret = tmf.getTrustManagers();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private void setCiphers(SSLSocket sock) {
        if (sock != null && null != this.ciphers) {
            sock.setEnabledCipherSuites(this.ciphers);
        }
    }

    private void setProtocols(SSLSocket sock) {
        if (sock != null && null != this.protocols) {
            sock.setEnabledProtocols(this.protocols);
        }
    }

    static class LocalHostnameVerifier
    implements HostnameVerifier {
        private final HostnameVerifier defaultVerifier;
        private final boolean trustAll;

        private LocalHostnameVerifier(boolean trustAll) {
            this.trustAll = trustAll;
            this.defaultVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
            HttpsURLConnection.setDefaultHostnameVerifier(this);
        }

        @Override
        public boolean verify(String hostname, SSLSession sslSession) {
            if (hostname.equals("localhost")) {
                return true;
            }
            if (!this.trustAll) {
                return this.defaultVerifier.verify(hostname, sslSession);
            }
            return true;
        }
    }
}

