/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.plugin;

import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.X509TrustManager;
import sanproject.sn2.base.authentication.plugin.SJbaseHCSHttpsManager;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJbaseHCSExpirationCheckTrustManager
implements X509TrustManager {
    private static final String LOG_FUNCTION = "HCS";
    private static final String LOG_TITLE = SJbaseHCSHttpsManager.class.getSimpleName();
    private static final SJcLoggerInterface LOGGER = SJcLogUty.getLogger("SN_HCS.log");
    private X509TrustManager trustManager;

    public SJbaseHCSExpirationCheckTrustManager(X509TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException, IllegalArgumentException {
        String LOG_SUBTITLE = "checkClientTrusted";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "checkClientTrusted", "Start.");
        this.checkExpiration(chain);
        this.trustManager.checkClientTrusted(chain, authType);
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "checkClientTrusted", "End.");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException, IllegalArgumentException {
        String LOG_SUBTITLE = "checkServerTrusted";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "checkServerTrusted", "Start.");
        this.checkExpiration(chain);
        this.trustManager.checkServerTrusted(chain, authType);
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "checkServerTrusted", "End.");
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    private void checkExpiration(X509Certificate[] chain) throws CertificateExpiredException, CertificateNotYetValidException {
        String LOG_SUBTITLE = "checkExpiration";
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "checkExpiration", "Start.");
        Date currentDate = new Date();
        for (X509Certificate cert : chain) {
            try {
                cert.checkValidity(currentDate);
            }
            catch (CertificateExpiredException ceex) {
                LOGGER.error(LOG_FUNCTION, LOG_TITLE, "checkExpiration", "DN:" + cert.getSubjectDN().getName() + " NotAfter:" + String.valueOf(cert.getNotAfter()) + " currentDate:" + currentDate);
                throw ceex;
            }
            catch (CertificateNotYetValidException cnyvex) {
                LOGGER.error(LOG_FUNCTION, LOG_TITLE, "checkExpiration", "DN:" + cert.getSubjectDN().getName() + " NotBefore:" + String.valueOf(cert.getNotBefore()) + " currentDate:" + currentDate);
                throw cnyvex;
            }
        }
        LOGGER.info(LOG_FUNCTION, LOG_TITLE, "checkExpiration", "End.");
    }
}

