/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.plugin;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJbaseHCSXMLUtility {
    private static final String LOG_FUNCTION = "HCS";
    private static final String LOG_TITLE = SJbaseHCSXMLUtility.class.getSimpleName();
    private static final String ENCODE = "UTF-8";
    private static final String[][] TNS = new String[][]{{"<RAIDSVPServerMessage", "http://svp.generated.sn2.sanproject"}, {"<HiCommandServerMessage", "http://hcs.generated.sn2.sanproject"}};

    public static Object xml2Java(InputStream inputStream, Class<?> classObject) throws Exception {
        String LOG_SUBTITLE = "xml2Java";
        Object objXML = null;
        try {
            String xml = SJbaseHCSXMLUtility.setNameSpace(inputStream);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{classObject});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            objXML = unmarshaller.unmarshal((Reader)new StringReader(xml));
        }
        catch (Exception ex) {
            SJcLogUty.getLogger("SN_HCS.log").error(LOG_FUNCTION, LOG_TITLE, "xml2Java", "unmarshal error.", ex);
            throw ex;
        }
        return objXML;
    }

    public static void java2Xml(Object xmlObj, OutputStream outputStream) throws Exception {
        String LOG_SUBTITLE = "java2Xml";
        ByteArrayOutputStream bArrayStream = null;
        try {
            bArrayStream = new ByteArrayOutputStream();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{xmlObj.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)ENCODE);
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(xmlObj, (OutputStream)bArrayStream);
            byte[] xmlArray = SJbaseHCSXMLUtility.removeNameSpace(bArrayStream.toString(ENCODE));
            outputStream.write(xmlArray);
        }
        catch (Exception ex) {
            SJcLogUty.getLogger("SN_HCS.log").error(LOG_FUNCTION, LOG_TITLE, "java2Xml", "marshal error.", ex);
            throw ex;
        }
    }

    private static String setNameSpace(InputStream inputStream) throws Exception {
        String LOG_SUBTITLE = "setNameSpace";
        String xml = null;
        try {
            String msg;
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, ENCODE));
            StringBuffer buf = new StringBuffer();
            while ((msg = br.readLine()) != null) {
                buf.append(msg + "\n");
            }
            xml = buf.toString();
            for (String[] tns : TNS) {
                if (!xml.contains(tns[0])) continue;
                xml = xml.replace(tns[0], tns[0] + " xmlns=\"" + tns[1] + "\"");
                break;
            }
        }
        catch (Exception ex) {
            SJcLogUty.getLogger("SN_HCS.log").error(LOG_FUNCTION, LOG_TITLE, "setNameSpace", "XML read error.", ex);
            throw ex;
        }
        return xml;
    }

    private static byte[] removeNameSpace(String xml) throws Exception {
        for (String[] tns : TNS) {
            if (!xml.contains(tns[0])) continue;
            xml = xml.replace(tns[0] + " xmlns=\"" + tns[1] + "\"", tns[0]);
            break;
        }
        byte[] xmlArray = xml.getBytes(ENCODE);
        return xmlArray;
    }
}

