/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.controller.SJctrControllerManager;
import sanproject.sn2.controller.com.SJctrChaUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.model.SJmoDataChange;
import sanproject.sn2.model.SJmoGetAgent;
import sanproject.sn2.model.SJmoModelMgr;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.kind.SJmoGetChaDetail;
import sanproject.sn2.model.data.device.SJmoChaDetail;

public class SJctrSystemParamContainer {
    boolean existPkgOpen = false;
    boolean existPkgMF = false;
    private String loginType;
    private int oemType;
    public static final int OEM_TYPE_HP = 1;
    public static final int OEM_TYPE_HITACHI = 2;
    private static final int CHK_OEM_TYPE = 147456;

    public SJctrSystemParamContainer(SJctrUserController userCtr) {
        SJmoGetAgent agent = userCtr.getModelAgent();
        ArrayList<SJmoGetDirect> inputList = new ArrayList<SJmoGetDirect>();
        SJmoGetDirect direct = new SJmoGetDirect();
        direct.setGetKind(new SJmoGetChaDetail());
        inputList.add(direct);
        List outputList = agent.getDataInf(inputList);
        List chaList = (List)outputList.get(0);
        for (SJmoChaDetail chaDetail : chaList) {
            if (SJctrChaUtility.isPkgMF(chaDetail)) {
                this.existPkgMF = true;
                continue;
            }
            this.existPkgOpen = true;
        }
        SJbaseUserSessionInterface session = userCtr.getUserSession();
        this.loginType = session.getLoginType();
        SJmoDataChange dataChg = SJmoModelMgr.getModelMgr().getDataChange();
        boolean chkRslt = dataChg.isOemType(147456);
        this.oemType = chkRslt ? 1 : 2;
    }

    public boolean isLocalHost() {
        return "SVP".equals(this.loginType);
    }

    public int getOemType() {
        return this.oemType;
    }

    public boolean isExist3390_3() {
        boolean result = false;
        return result;
    }

    public boolean isExist3390_3R() {
        boolean result = false;
        return result;
    }

    public boolean isExistPkgOpen() {
        return this.existPkgOpen;
    }

    public boolean isExistPkgMF() {
        return this.existPkgMF;
    }

    public boolean isLaunchHiCommand() {
        return "HIC".equals(this.loginType);
    }

    public boolean isLaunchHPSIM() {
        return "HSSO".equals(this.loginType);
    }

    public boolean isHM() {
        return SJctrControllerManager.isHM();
    }

    public boolean isRAID() {
        return SJctrControllerManager.isRAID();
    }

    public boolean isNorBasic() {
        return "NOR_BASIC".equals(this.loginType);
    }

    public boolean isNorEm() {
        return "NOR_EM".equals(this.loginType);
    }
}

