/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import sanproject.serversx.data.RJiLDEVIndex;
import sanproject.serverux.dataimpl.MRCFgetTiCtgPairInfo_IN;
import sanproject.serverux.dataimpl.MRCFgetTiCtgPairInfo_OUT;
import sanproject.serverux.dataimpl.MRCFgetTiCtgPairList;
import sanproject.serverux.dataimpl.MRCFgetTiCtgPairParam;
import sanproject.serverux.dataimpl.MRCFgetTiPairInfo;
import sanproject.serverux.dataimpl.MRCFgetTiPairList;
import sanproject.serverux.dataimpl.MRCFgetTiPvolMu;
import sanproject.serverux.dataimpl.MRCFgetTiPvolMuPairInfo_IN;
import sanproject.serverux.dataimpl.MRCFgetTiPvolMuPairInfo_OUT;
import sanproject.serverux.dataimpl.MRCFgetTiPvolMuParam;
import sanproject.serverux.dataimpl.MRCFgetTiPvolPairInfo_IN;
import sanproject.serverux.dataimpl.MRCFgetTiPvolPairInfo_OUT;
import sanproject.serverux.dataimpl.MRCFgetTiPvolPairParam;
import sanproject.serverux.dataimpl.MRCFsetQSPairDetail;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceHandleInterface;
import sanproject.sn2.com.utility.message.inf.SJcMessageHandleInterface;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidIdDefinition;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrStringUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.com.column.thinimage.SJctrPVolCapacityColumnFromTiPvolInfo;
import sanproject.sn2.controller.com.column.thinimage.SJctrSVolCapacityColumnFromTiPairInfo;
import sanproject.sn2.controller.com.comparator.SJctrLdevIndexComparator;
import sanproject.sn2.controller.com.comparator.replication.SJctrLocalReplicationTiPairComparator;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.replication.com.SJctrGetMRCFgetTiCtgPairInfo;
import sanproject.sn2.controller.wizard.replication.com.SJctrGetMRCFgetTiPvolMuParam;
import sanproject.sn2.controller.wizard.replication.com.SJctrGetMRCFgetTiPvolPairParam;
import sanproject.sn2.controller.wizard.replication.com.SJctrGetThroughRmiDataTiTreePairs;
import sanproject.sn2.controller.wizard.replication.com.SJctrReplicationDataMacro;
import sanproject.sn2.controller.wizard.replication.com.SJctrTIPVolSSGInfo;
import sanproject.sn2.controller.wizard.replication.local.createpairs.SJctrCreatePairUtility;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.SJctrCreateSnapshotDataInfo;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.SJctrCreateTIPairInfo;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.SJctrCreateTIPairUtility;
import sanproject.sn2.controller.wizard.replication.local.operatepairs.SJctrGetThroughRmiDataDpSluId;
import sanproject.sn2.controller.wizard.replication.local.operatepairs.SJctrGetThroughRmiDataSsSluId;
import sanproject.sn2.controller.wizard.replication.local.viewpairsyncrate.SJctrViewPairSyncRateInfo;
import sanproject.sn2.model.SJmoDataChange;
import sanproject.sn2.model.SJmoGetAgent;
import sanproject.sn2.model.SJmoModelMgr;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetThroughRmiData;
import sanproject.sn2.model.connector.kind.SJmoGetTiSnapshotPairList;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.group.SJmoPoolNameInfo;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationTiPairVolInfo;
import sanproject.sn2.model.data.replication.local.SJmoSnapshotSetInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolMu;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolStatus;
import sanproject.sn2.model.data.replication.local.SJmoTiSnapshotPair;
import sanproject.sn2.model.data.replication.local.SJmoTiSnapshotPairList;
import sanproject.sn2.model.data.replication.local.manager.SJmoLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrTiReplicationUtility
extends SJctrStringUtility
implements SJctrGuidIdDefinition {
    public static final short TIPAIR_STATUS_SMPL = 0;
    public static final short TIPAIR_STATUS_SMPL_PD = 97;
    public static final short TIPAIR_STATUS_COPY_PD = 1;
    public static final short TIPAIR_STATUS_PAIR = 2;
    public static final short TIPAIR_STATUS_PSUS = 4;
    public static final short TIPAIR_STATUS_PSUE = 6;
    public static final short[] EFFECTIVE_STATUS_OF_VIEW_SYNC_RATE_TI = new short[]{1, 2, 4, 6};
    public static final int[] DELETE_PAIR_STATUS_PASS_TI = new int[]{1, 4, 6};
    public static final int MAX_SELECT_PVOL_NUM = 32;
    public static final int SLU_ID_MAX_REQUEST_NUMBER = 1024;
    public static final int LDEV_ID_SET_NUMBER = 3;
    public static final int SET_POSITION_LDKC_NUMBER = 0;
    public static final int SET_POSITION_CU_NUMBER = 1;
    public static final int SET_POSITION_LDEV_NUMBER = 2;
    public static final int LDEV_ID_DEFAULT = -1;
    public static final String STR_SPACE = " ";
    public static final String STR_DEFAULT = "";
    public static final int HEX_DISPLAY_DIGIT = 1;
    public static final int MU_HEX_DISPLAY_DIGIT = 4;
    public static final int MASK_CHANGE_SHORT = 255;
    private static final int ERROR_PART_DIGIT = 100;
    private static final int ERROR_FUNCTION_EXIST_NUMBER = 0;
    private static final int ERRORCODE_EXIST_NUMBER = 1;

    public SJctrTiReplicationUtility(SJmoDataChange dc, SJcGuidanceHandleInterface ghi, SJcMessageHandleInterface mhi) {
        super(dc, ghi, mhi);
    }

    public static void checkRSGInfoFromSelectedTiPairPairVolInfoList(SJctrDataController dc, SJctrUserController uc, List<? extends SJmoLdevIndex> selectedPairsList) {
        SJmoGetRSGgetAllRsgs kind = new SJmoGetRSGgetAllRsgs();
        List<Object> allRsgsList = SJctrReplicationUtility.getModelInfoNotUsedCache(dc, kind);
        SJmoRSGgetAllRsgs allRsg = SJctrReplicationUtility.checkSJmoRSGgetAllRsgsInfo(dc, allRsgsList);
        SJctrResourceGroupUtility rsgUty = new SJctrResourceGroupUtility(uc, allRsg);
        if (!SJctrTiReplicationUtility.checkLocalVolListResourcePrimaryVol(selectedPairsList, rsgUty)) {
            uc.getLogUty().putlog("checkRSGInfoFromSelectedTiPairPairVolInfoList", "Selected pairs cannot use.");
            SJctrError err = new SJctrError(209, 22, 106144);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    public static void checkRSGInfoFromSelectedTiPairVolInfoList(SJctrDataController dc, SJctrUserController uc, List<SJmoLocalReplicationTiPairVolInfo> checkPairsList) {
        if (dc == null || uc == null || checkPairsList == null) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "checkRSGInfoFromSelectedTiPairVolInfoList", "argument is invalid.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        SJmoGetRSGgetAllRsgs kind = new SJmoGetRSGgetAllRsgs();
        List<Object> allRsgsList = SJctrReplicationUtility.getModelInfoNotUsedCache(dc, kind);
        SJmoRSGgetAllRsgs allRsg = SJctrReplicationUtility.checkSJmoRSGgetAllRsgsInfo(dc, allRsgsList);
        SJctrResourceGroupUtility rsgUty = new SJctrResourceGroupUtility(uc, allRsg);
        List<SJmoLdevIndex> enableResourceLdevList = SJctrTiReplicationUtility.getEnableResourceLdevList(rsgUty);
        for (SJmoLocalReplicationTiPairVolInfo pairInfo : checkPairsList) {
            SJmoLdevIndex sVol;
            SJmoLdevIndex pVol = pairInfo.getPVolIndex();
            if (SJctrTiReplicationUtility.checkPairVolResourceAuthority(pVol, enableResourceLdevList) || SJctrTiReplicationUtility.checkPairVolResourceAuthority(sVol = pairInfo.getsVolIndex(), enableResourceLdevList)) continue;
            uc.getLogUty().putlog("checkRSGInfoFromSelectedTiPairVolInfoList", "Selected pairs can not use.");
            SJctrError err = new SJctrError(209, 22, 106144);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    private static boolean checkPairVolResourceAuthority(SJmoLdevIndex pairVol, List<SJmoLdevIndex> enableResourceLdevList) {
        boolean ret = false;
        if (SJctrReplicationUtility.checkLocalPairResource(pairVol, enableResourceLdevList)) {
            ret = true;
        }
        return ret;
    }

    public static boolean isAllCascadePair(List<SJmoLocalReplicationTiPairVolInfo> checkPairsList) {
        if (checkPairsList == null) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "isAllCascadePair", "checkPairsList is null.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        boolean ret = true;
        for (SJmoLocalReplicationTiPairVolInfo pair : checkPairsList) {
            if (pair.isBCascade()) continue;
            ret = false;
            break;
        }
        return ret;
    }

    public static boolean isNotAllCascadePair(List<SJmoLocalReplicationTiPairVolInfo> checkPairsList) {
        if (checkPairsList == null) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "isNotAllCascadePair", "checkPairsList is null.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        boolean ret = true;
        for (SJmoLocalReplicationTiPairVolInfo pair : checkPairsList) {
            if (!pair.isBCascade()) continue;
            ret = false;
            break;
        }
        return ret;
    }

    public static void checkRSGInfoFromSelectedTiPairList(SJctrDataController dc, SJctrUserController uc, List<SJmoSnapshotSetInfo> selectedSnapshotList) {
        SJmoGetKind_IF kind = new SJmoGetRSGgetAllRsgs();
        List<Object> allRsgsList = SJctrReplicationUtility.getModelInfoNotUsedCache(dc, kind);
        SJmoRSGgetAllRsgs allRsg = SJctrReplicationUtility.checkSJmoRSGgetAllRsgsInfo(dc, allRsgsList);
        SJctrResourceGroupUtility rsgUty = new SJctrResourceGroupUtility(uc, allRsg);
        ArrayList<SJmoTiPvolMu> targetInfo = new ArrayList<SJmoTiPvolMu>();
        kind = new SJmoGetTiSnapshotPairList();
        List<Object> allTiSnapshotPairList = SJctrReplicationUtility.getModelInfoNotUsedCache(dc, kind);
        SJmoTiSnapshotPairList list = (SJmoTiSnapshotPairList)allTiSnapshotPairList.get(0);
        block0: for (SJmoSnapshotSetInfo setInfo : selectedSnapshotList) {
            for (SJmoTiSnapshotPair snapshot : list.getSnapshotPair()) {
                if (setInfo == null || snapshot == null || setInfo.getISnapshotSetId() != (int)snapshot.getSnapshotID()) continue;
                for (SJmoTiPvolMu pair : snapshot.getPvolMu()) {
                    targetInfo.add(pair);
                }
                continue block0;
            }
        }
        if (!SJctrTiReplicationUtility.checkLocalVolListResourcePrimaryVol(targetInfo, rsgUty)) {
            uc.getLogUty().putlog("checkRSGInfoFromSelectedTiPairList", "Selected pairs cannot use.");
            SJctrError err = new SJctrError(209, 22, 106144);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    private static boolean checkLocalVolListResourcePrimaryVol(List<? extends SJmoLdevIndex> pairInfoList, SJctrResourceGroupUtility rsgUty) {
        boolean ret = true;
        List<SJmoLdevIndex> enableResourceLdevList = SJctrTiReplicationUtility.getEnableResourceLdevList(rsgUty);
        if (pairInfoList == null || rsgUty == null) {
            ret = false;
        } else {
            for (SJmoLdevIndex sJmoLdevIndex : pairInfoList) {
                if (SJctrTiReplicationUtility.checkLocalPairResourcePrimaryVol(sJmoLdevIndex, enableResourceLdevList)) continue;
                ret = false;
                break;
            }
        }
        return ret;
    }

    private static List<SJmoLdevIndex> getEnableResourceLdevList(SJctrResourceGroupUtility rsgUty) {
        ArrayList<SJmoLdevIndex> enableLdevs = new ArrayList<SJmoLdevIndex>();
        if (rsgUty != null) {
            List<SJmoRSGgetRsg> enableRsgList = rsgUty.extractRsg();
            for (SJmoRSGgetRsg rsgInfo : enableRsgList) {
                enableLdevs.addAll(rsgInfo.getLdevs());
            }
            Collections.sort(enableLdevs, new SJctrLdevIndexComparator());
        }
        return enableLdevs;
    }

    private static boolean checkLocalPairResourcePrimaryVol(SJmoLdevIndex pairVolInfo, List<SJmoLdevIndex> resourceLdevs) {
        boolean ret = false;
        if (pairVolInfo != null && resourceLdevs != null) {
            ret = SJctrReplicationUtility.checkLocalPairResource(pairVolInfo, resourceLdevs);
        }
        return ret;
    }

    public static void makeLocalPairCapacityUnit(SJctrTableDataModel table, List<? extends SJmoLocalReplicationTiPairVolInfo> basicDataList) {
        boolean isPvolCheck = false;
        boolean isSvolCheck = false;
        Set<String> keySet = table.getAllColumnKeySet();
        for (String key : keySet) {
            SJctrColumn sJctrColumn = table.getColumnInfo(key);
            if (sJctrColumn instanceof SJctrPVolCapacityColumnFromTiPvolInfo) {
                isPvolCheck = true;
            } else if (sJctrColumn instanceof SJctrSVolCapacityColumnFromTiPairInfo) {
                isSvolCheck = true;
            }
            if (!isPvolCheck || !isSvolCheck) continue;
            break;
        }
        if (isSvolCheck || isPvolCheck) {
            List<SJmoLdevDetail> ldevDetails = table.getBasicDataMap().get(SJmoGetLdevDetail.class);
            if (ldevDetails == null) {
                SJctrLogUty.info("SJctrReplicationUtility", "makeLocalPairCapacityUnit", "SJmoLdevDetail is null.");
                return;
            }
            table.setCapacityFlg(true);
            table.setDpVolumeFlg(false);
            table.setOpenVolumeFlg(false);
            table.setMainframeVolumeFlg(false);
            for (SJmoLocalReplicationTiPairVolInfo sJmoLocalReplicationTiPairVolInfo : basicDataList) {
                SJmoLdevIndex pvolIndex;
                if (isSvolCheck) {
                    SJctrReplicationUtility.checkLdevEmuType(table, sJmoLocalReplicationTiPairVolInfo, ldevDetails);
                }
                if (isPvolCheck && (pvolIndex = sJmoLocalReplicationTiPairVolInfo.getPVolIndex()) != null) {
                    SJctrReplicationUtility.checkLdevEmuType(table, pvolIndex, ldevDetails);
                }
                if (!table.hasMainframeVolume() || !table.hasOpenVolume()) continue;
                break;
            }
        }
    }

    public static MRCFsetQSPairDetail[] createRemoveSecondaryVolumeApplyDataDetail(List<SJmoLocalReplicationTiPairVolInfo> pairInfoList, short cmdKind, short cmdOpt, short pairKind) {
        MRCFsetQSPairDetail[] applyParamArr = new MRCFsetQSPairDetail[pairInfoList.size()];
        for (int i = 0; i < pairInfoList.size(); ++i) {
            SJmoLocalReplicationTiPairVolInfo rowInfo = pairInfoList.get(i);
            MRCFsetQSPairDetail applyParam = new MRCFsetQSPairDetail();
            applyParam.setSCmdKind(cmdKind);
            applyParam.setSSnapshotKind((short)1);
            applyParam.setSCmdOpt(cmdOpt);
            applyParam.setSPairKind(pairKind);
            applyParam.setSMuNum(rowInfo.getMu());
            RJiLDEVIndex index = new RJiLDEVIndex();
            index.setLDEVIndex(rowInfo.getsVolIndex().getSLdkc(), rowInfo.getsVolIndex().getSCu(), rowInfo.getsVolIndex().getSLdev());
            applyParam.setSVolIndex(index);
            applyParamArr[i] = applyParam;
        }
        return applyParamArr;
    }

    public static String getPoolNameIdStringFromLocalRepTiPairVolInfo(SJmoLocalReplicationTiPairVolInfo pairVolInfo, SJmoPoolNameInfo poolNameInfo) {
        String ret = "?";
        if (pairVolInfo != null && poolNameInfo != null) {
            ret = poolNameInfo.getStrName() + "(" + pairVolInfo.getsVolPoolId() + ")";
        }
        return ret;
    }

    public static String getPoolNameIdStringFromTiPVolInfo(SJmoTiPvolInfo pairVolInfo, SJmoPoolNameInfo poolNameInfo) {
        String ret = "?";
        if (pairVolInfo != null && poolNameInfo != null) {
            ret = poolNameInfo.getStrName() + "(" + pairVolInfo.getPoolid() + ")";
        }
        return ret;
    }

    public static List<SJmoLocalReplicationPairVolInfo> generatetLocalReplicationPairVolInfoListFromTiPvol(List<SJmoLdevIndex> pvolIndexList, SJmoTiSnapshotPairList snapshotPairList, SJmoTiPvolInfo[] pvolInfoList) {
        ArrayList<SJmoLdevIndex> ldevList = new ArrayList<SJmoLdevIndex>(pvolIndexList);
        MRCFgetTiPairList rmiTiPvolList = SJctrTiReplicationUtility.getTiPairListFromPvolViaRMI(ldevList);
        List<SJmoLocalReplicationPairVolInfo> retList = SJctrTiReplicationUtility.generatetLocalReplicationPairVolInfo(rmiTiPvolList.getTiPairInfo(), snapshotPairList, pvolInfoList);
        return retList;
    }

    public static List<SJmoTiPvolInfo> checkAndGetExistRootLdevInfo(List<SJmoLdevIndex> checkList, SJmoTiPvolInfo[] allRootLdevInfo) throws SJcException {
        if (null == checkList || null == allRootLdevInfo) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "checkAndGetExistRootLdevInfo", "Check data is invalid");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        ArrayList<SJmoTiPvolInfo> retList = new ArrayList<SJmoTiPvolInfo>();
        Arrays.sort(allRootLdevInfo);
        for (SJmoLdevIndex selectedLdev : checkList) {
            int index = Arrays.binarySearch(allRootLdevInfo, selectedLdev);
            if (0 <= index) {
                retList.add(allRootLdevInfo[index]);
                continue;
            }
            SJctrLogUty.error("SJctrTiReplicationUtility", "checkAndGetExistRootLdevInfo", "Check list data is different from local LDEV list.");
            throw SJctrTiReplicationUtility.makeException(206525);
        }
        return retList;
    }

    public static List<SJmoLocalReplicationPairVolInfo> getTiTreePairInfoListFromModelThrough(List<SJmoTiPvolInfo> pvolIndexList, SJctrDataController dc, SJmoTiSnapshotPairList snapshotPairList) {
        ArrayList<SJmoLocalReplicationPairVolInfo> retList = new ArrayList();
        try {
            SanRequest sanRequest = SJctrTiReplicationUtility.getTreePairsSanRequestFromTiPvolInfo(pvolIndexList, dc);
            SanResponse sanResponse = SJctrTiReplicationUtility.getTreePairSanResponseFromTiPvolInfo(sanRequest, dc);
            retList = SJctrTiReplicationUtility.getTiTreePairsFromRMI(sanResponse, pvolIndexList, snapshotPairList);
        }
        catch (SanDataException sdex) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "getTiTreePairInfoListFromModelThrough", sdex.getMessage());
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        return retList;
    }

    public static SanRequest getTreePairsSanRequestFromTiPvolInfo(List<SJmoTiPvolInfo> tiPvolInfoList, SJctrDataController dc) throws SanDataException {
        if (tiPvolInfoList == null || tiPvolInfoList.size() == 0 || dc == null) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "getTreePairsSanRequestFromTiPvolInfo", "Input data is invalid");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        SJmoGetAgent modelAgent = dc.getOwner().getModelAgent();
        SanRequest sanRequest = modelAgent.newRequest("MRCFreadSnapshotTreePairs");
        SanList reqLdevList = sanRequest.newList("RootLdevs");
        for (SJmoTiPvolInfo ldev : tiPvolInfoList) {
            int[] setLdev = new int[]{ldev.getSLdkc(), ldev.getSCu(), ldev.getSLdev()};
            SanObject id = reqLdevList.addObj();
            id.putIntArray("Id", setLdev);
        }
        return sanRequest;
    }

    public static SanResponse getTreePairSanResponseFromTiPvolInfo(SanRequest sanRequest, SJctrDataController dc) throws SanDataException {
        if (sanRequest == null || dc == null) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "getTreePairSanResponseFromTiPvolInfo", "Input data is invalid");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        SJctrGetThroughRmiDataTiTreePairs requestKind = new SJctrGetThroughRmiDataTiTreePairs(sanRequest);
        SanResponse rmiData = SJctrTiReplicationUtility.getSJmoThroughRmiData(requestKind, dc);
        SJctrTiReplicationUtility.checkErrorSanResponse((SanObject)rmiData);
        return rmiData;
    }

    public static List<SJmoLocalReplicationPairVolInfo> getTiTreePairsFromRMI(SanResponse rmiData, List<SJmoTiPvolInfo> pvolInfoList, SJmoTiSnapshotPairList snapshotPairList) throws SanDataException {
        if (rmiData == null || pvolInfoList == null || pvolInfoList.size() == 0) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "getTiTreePairsFromRMI", "Input data is invalid");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        ArrayList<SJmoLocalReplicationPairVolInfo> pairList = new ArrayList<SJmoLocalReplicationPairVolInfo>();
        Collections.sort(pvolInfoList);
        List<SJctrTIPVolSSGInfo> tiPVolMuSSGrpInfo = SJctrTIPVolSSGInfo.createData(snapshotPairList);
        SanList rootLdevList = rmiData.getList("RootLdevs");
        for (SanObject rootLdev : rootLdevList) {
            int[] rootLdevId = rootLdev.getIntArray("Id");
            SJmoLdevIndex rootLdevIndex = new SJmoLdevIndex();
            rootLdevIndex.setLdevIndex((short)rootLdevId[0], (short)rootLdevId[1], (short)rootLdevId[2]);
            if (rootLdev.getMember("TiPairs") == null) continue;
            SanList treePairList = rootLdev.getList("TiPairs");
            for (SanObject pair : treePairList) {
                SJmoLocalReplicationPairVolInfo pairInfo = new SJmoLocalReplicationPairVolInfo(2);
                SanObject sanObjPvolLdevInf = pair.getObj("PrimaryVolume").getObj("Ldev");
                int[] pvol = sanObjPvolLdevInf.getIntArray("Id");
                SJmoLdevIndex pVolIndex = new SJmoLdevIndex();
                pVolIndex.setLdevIndex((short)pvol[0], (short)pvol[1], (short)pvol[2]);
                ArrayList<SJmoLdevIndex> alPvolIndex = new ArrayList<SJmoLdevIndex>();
                alPvolIndex.add(pVolIndex);
                pairInfo.setAlPVolIndex(alPvolIndex);
                int[] svol = new int[]{-1, -1, -1};
                short svolWriteHist = -1;
                if (pair.getMember("SecondaryVolume") != null) {
                    SanObject sanObjSvolInf = pair.getObj("SecondaryVolume");
                    svol = sanObjSvolInf.getObj("Ldev").getIntArray("Id");
                    svolWriteHist = (short)sanObjSvolInf.getInt("WriteHistory");
                }
                pairInfo.setLdevIndex((short)svol[0], (short)svol[1], (short)svol[2]);
                pairInfo.setSWriteHist(svolWriteHist);
                pairInfo.setSMuNum((short)pair.getInt("MirrorUnit"));
                short pairStatus = (short)pair.getInt("Status");
                pairInfo.setSPairStatus(pairStatus);
                if (560 == pairStatus) {
                    int[] snapDate = pair.getIntArray("SnapshotDate");
                    Calendar calSnap = Calendar.getInstance();
                    calSnap.setTimeZone(TimeZone.getTimeZone("GMT"));
                    calSnap.set(snapDate[0], snapDate[1] - 1, snapDate[2], snapDate[3], snapDate[4], snapDate[5]);
                    pairInfo.setSnapShotDate(calSnap.getTime());
                } else {
                    pairInfo.setSnapShotDate(null);
                }
                SJmoTiPvolMu pvolMu = SJctrTiReplicationUtility.createTiPVolMuInfo(pVolIndex.getSLdkc(), pVolIndex.getSCu(), pVolIndex.getSLdev(), pairInfo.getSMuNum());
                SJctrTIPVolSSGInfo pVolMuSSGrpInfo = SJctrTiReplicationUtility.findPVolMuSSGrpInfo(tiPVolMuSSGrpInfo, pvolMu);
                int ssGrpId = -1;
                if (pVolMuSSGrpInfo != null) {
                    SJmoTiSnapshotPair ssGrpPairInfo = pVolMuSSGrpInfo.getTiSSPairInfo();
                    ssGrpId = (int)ssGrpPairInfo.getSnapshotID();
                }
                pairInfo.setISnapshotSetId(ssGrpId);
                pairInfo.setSPairRate((short)pair.getInt("SynchronousRate"));
                if (pair.getMember("Ctg") != null) {
                    SanObject sanObjCtgInf = pair.getObj("Ctg");
                    pairInfo.setSCtgId((short)sanObjCtgInf.getInt("Id"));
                }
                pairInfo.setBCascade(pair.getBoolean("Cascade"));
                pairInfo.setBClone(pair.getBoolean("Clone"));
                pairInfo.setSCopyPace((short)pair.getInt("CopyPace"));
                int index = Collections.binarySearch(pvolInfoList, rootLdevIndex);
                if (index < 0) {
                    SJctrLogUty.error("SJctrTiReplicationUtility", "getTiTreePairsFromRMI", "rootLdevIndex:" + index + " doesn't contain of SJmoTiPvolInfo.");
                    throw SJctrTiReplicationUtility.makeException(107001);
                }
                pairInfo.setISVolPoolId(pvolInfoList.get(index).getPoolid());
                pairInfo.setRootLdev(rootLdevIndex);
                pairInfo.setIPairVolPos(0x800000);
                pairInfo.setISnapshotInfo(1);
                pairList.add(pairInfo);
            }
        }
        return pairList;
    }

    public static List<SJmoLocalReplicationPairVolInfo> generatetLocalReplicationPairVolInfoListFromTiPairVolInfo(List<SJmoLocalReplicationTiPairVolInfo> tiPairVolInfoList, SJmoTiSnapshotPairList snapshotPairList, SJmoTiPvolInfo[] pvolInfoList) {
        MRCFgetTiPairList rmiTiPvolList = SJctrTiReplicationUtility.getTiPairListFromPvolMuViaRMI(tiPairVolInfoList);
        List<SJmoLocalReplicationPairVolInfo> retList = SJctrTiReplicationUtility.generatetLocalReplicationPairVolInfo(rmiTiPvolList.getTiPairInfo(), snapshotPairList, pvolInfoList);
        return retList;
    }

    public static List<SJmoLocalReplicationPairVolInfo> generatetLocalReplicationPairVolInfoListFromTiPvolMu(List<SJmoTiPvolMu> tiPvolMuList, SJmoTiSnapshotPairList snapshotPairList, SJmoTiPvolInfo[] pvolInfoList) {
        MRCFgetTiPairList rmiTiPvolList = SJctrTiReplicationUtility.getTiPairListFromTiPvolMuViaRMI(tiPvolMuList);
        List<SJmoLocalReplicationPairVolInfo> retList = SJctrTiReplicationUtility.generatetLocalReplicationPairVolInfo(rmiTiPvolList.getTiPairInfo(), snapshotPairList, pvolInfoList);
        return retList;
    }

    public static List<SJmoLocalReplicationPairVolInfo> generatetLocalReplicationPairVolInfoListFromCtgId(int ctgId, SJmoTiSnapshotPairList snapshotPairList, SJmoTiPvolInfo[] pvolInfoList) {
        MRCFgetTiCtgPairList rmiTiPvolList = SJctrTiReplicationUtility.getTiPairListFromCtgIdViaRMI(ctgId);
        List<SJmoLocalReplicationPairVolInfo> retList = SJctrTiReplicationUtility.generatetLocalReplicationPairVolInfo(rmiTiPvolList.getTiPairInfo(), snapshotPairList, pvolInfoList);
        return retList;
    }

    private static List<SJmoLocalReplicationPairVolInfo> generatetLocalReplicationPairVolInfo(MRCFgetTiPairInfo[] rmiTiPairInfoList, SJmoTiSnapshotPairList snapshotPairList, SJmoTiPvolInfo[] pvolInfoList) {
        ArrayList<SJmoLocalReplicationPairVolInfo> retList = new ArrayList<SJmoLocalReplicationPairVolInfo>();
        List<SJctrTIPVolSSGInfo> tiPVolMuSSGrpInfo = SJctrTIPVolSSGInfo.createData(snapshotPairList);
        HashMap<Integer, Integer> pVolPoolMap = new HashMap<Integer, Integer>(rmiTiPairInfoList.length);
        for (MRCFgetTiPairInfo temp_MRCFgetTiPairInfo : rmiTiPairInfoList) {
            SJmoLocalReplicationPairVolInfo pairInfo;
            SJmoLdevIndex pvolIndex = new SJmoLdevIndex();
            pvolIndex.setSLdkc(temp_MRCFgetTiPairInfo.getPvol().getSLDKC());
            pvolIndex.setSCu(temp_MRCFgetTiPairInfo.getPvol().getSCU());
            pvolIndex.setSLdev(temp_MRCFgetTiPairInfo.getPvol().getSLDEV());
            int pVolIndex = pvolIndex.getIndex();
            short muNum = temp_MRCFgetTiPairInfo.getMu();
            short ldkc = (short)((pVolIndex & 0xFF0000) >>> 16);
            short cu = (short)((pVolIndex & 0xFF00) >>> 8);
            short ldev = (short)(pVolIndex & 0xFF);
            SJmoTiPvolMu pVolMu = SJctrTiReplicationUtility.createTiPVolMuInfo(ldkc, cu, ldev, muNum);
            SJctrTIPVolSSGInfo pVolMuSSGrpInfo = SJctrTiReplicationUtility.findPVolMuSSGrpInfo(tiPVolMuSSGrpInfo, pVolMu);
            int poolId = -1;
            Integer poolIdValue = (Integer)pVolPoolMap.get(pVolIndex);
            if (poolIdValue == null) {
                SJmoLdevIndex rootLdev = new SJmoLdevIndex();
                if (SJctrTiReplicationUtility.isRootVol(pvolInfoList, pVolMu)) {
                    rootLdev = pVolMu;
                } else {
                    RJiLDEVIndex rootVol = temp_MRCFgetTiPairInfo.getRootLdev();
                    rootLdev.setLdevIndex(rootVol.getSLDKC(), rootVol.getSCU(), rootVol.getSLDEV());
                }
                poolId = SJctrTiReplicationUtility.findUsedPoolId(pvolInfoList, rootLdev);
                if (poolId == -1) continue;
                pVolPoolMap.put(pVolIndex, poolId);
            } else {
                poolId = poolIdValue;
            }
            int ssGrpId = -1;
            if (pVolMuSSGrpInfo != null) {
                SJmoTiSnapshotPair ssGrpPairInfo = pVolMuSSGrpInfo.getTiSSPairInfo();
                ssGrpId = (int)ssGrpPairInfo.getSnapshotID();
            }
            if ((pairInfo = SJctrTiReplicationUtility.createLocalReplicationPairVolInfo(temp_MRCFgetTiPairInfo, pvolIndex, poolId, muNum, ssGrpId)) == null) continue;
            retList.add(pairInfo);
        }
        return retList;
    }

    public static boolean isRootVol(SJmoTiPvolInfo[] tiRootVolInfoArray, SJmoLdevIndex pVol) {
        if (tiRootVolInfoArray == null || pVol == null) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "isRootVol", "argument is invalid.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        boolean ret = false;
        int index = Arrays.binarySearch(tiRootVolInfoArray, pVol);
        if (index >= 0) {
            ret = true;
        }
        return ret;
    }

    private static SJctrTIPVolSSGInfo findPVolMuSSGrpInfo(List<SJctrTIPVolSSGInfo> tiPVolMuSSGrpInfo, SJmoTiPvolMu pVolMu) {
        SJctrTIPVolSSGInfo ret = null;
        int searchIndex = Collections.binarySearch(tiPVolMuSSGrpInfo, pVolMu);
        if (searchIndex < 0) {
            SJctrLogUty.warn("SJctrTiReplicationUtility", "findPVolMuSSGrpInfo", "TI Pair notFound . PVOL:" + pVolMu.toString());
        } else {
            ret = tiPVolMuSSGrpInfo.get(searchIndex);
        }
        return ret;
    }

    private static int findUsedPoolId(SJmoTiPvolInfo[] tiRootVolInfoArray, SJmoLdevIndex pVol) {
        int poolId = -1;
        int searchIndex = Arrays.binarySearch(tiRootVolInfoArray, pVol);
        if (searchIndex < 0) {
            SJctrLogUty.warn("SJctrTiReplicationUtility", "findUsedPoolId", "RootVOL is notFound. RootVOL:" + pVol.getIndexKey());
        } else {
            SJmoTiPvolInfo tiRootVolInfo = tiRootVolInfoArray[searchIndex];
            poolId = tiRootVolInfo.getPoolid();
        }
        return poolId;
    }

    public static List<SJmoLocalReplicationPairVolInfo> generatetLocalReplicationPairVolInfoListFromSnapshot(List<SJmoTiSnapshotPair> selectedList, SJmoTiSnapshotPairList snapshotPairList, SJmoTiPvolInfo[] pvolInfoList) {
        ArrayList<SJmoTiPvolMu> ldevList = new ArrayList<SJmoTiPvolMu>();
        HashMap checkMap = new HashMap();
        HashSet<Integer> snapshotIdSet = new HashSet<Integer>();
        for (SJmoTiSnapshotPair sJmoTiSnapshotPair : selectedList) {
            SJmoTiPvolMu[] mus;
            snapshotIdSet.add((int)sJmoTiSnapshotPair.getSnapshotID());
            for (SJmoTiPvolMu mu : mus = sJmoTiSnapshotPair.getPvolMu()) {
                ldevList.add(mu);
            }
        }
        ArrayList<SJmoLocalReplicationPairVolInfo> retList = new ArrayList();
        retList = SJctrTiReplicationUtility.generatetLocalReplicationPairVolInfoListFromTiPvolMu(ldevList, snapshotPairList, pvolInfoList);
        return retList;
    }

    private static SJmoLocalReplicationPairVolInfo createLocalReplicationPairVolInfo(MRCFgetTiPairInfo temp_MRCFgetTiPairInfo, SJmoLdevIndex pvolIndex, int poolId, short muNum, int ssGrpId) {
        SJmoLocalReplicationPairVolInfo pairInfo = new SJmoLocalReplicationPairVolInfo(2);
        pairInfo.setIPairVolPos(0x800000);
        if ((temp_MRCFgetTiPairInfo.getVolflg() & 2L) == 0L) {
            SJmoLdevIndex svolIndex = new SJmoLdevIndex();
            svolIndex.setSLdkc(temp_MRCFgetTiPairInfo.getSvol().getSLDKC());
            svolIndex.setSCu(temp_MRCFgetTiPairInfo.getSvol().getSCU());
            svolIndex.setSLdev(temp_MRCFgetTiPairInfo.getSvol().getSLDEV());
            int sVolIndex = svolIndex.getIndex();
            short sVolLdkc = (short)((sVolIndex & 0xFF0000) >>> 16);
            short sVolCu = (short)((sVolIndex & 0xFF00) >>> 8);
            short sVolLdev = (short)(sVolIndex & 0xFF);
            if (sVolLdkc == 255 && sVolCu == 255 && sVolCu == 255) {
                SJctrCreatePairUtility.setInvalidIndex(pairInfo);
            } else {
                pairInfo.setLdevIndex(sVolLdkc, sVolCu, sVolLdev);
            }
        } else {
            SJctrCreatePairUtility.setInvalidIndex(pairInfo);
        }
        ArrayList<SJmoLdevIndex> alPVolIndex = new ArrayList<SJmoLdevIndex>();
        alPVolIndex.add(pvolIndex);
        pairInfo.setAlPVolIndex(alPVolIndex);
        short pairStatus = SJctrTiReplicationUtility.changeTIPairStatus((short)temp_MRCFgetTiPairInfo.getSts(), (short)temp_MRCFgetTiPairInfo.getVolflg());
        pairInfo.setSPairStatus(pairStatus);
        short pairRate = (short)temp_MRCFgetTiPairInfo.getDifpct();
        pairInfo.setSPairRate(pairRate);
        Date ssDate = temp_MRCFgetTiPairInfo.getSnapshotDate();
        pairInfo.setSnapShotDate(ssDate);
        pairInfo.setSMuNum(muNum);
        short ctgId = temp_MRCFgetTiPairInfo.getCtgid();
        pairInfo.setSCtgId(ctgId);
        pairInfo.setISVolPoolId(poolId);
        pairInfo.setISnapshotSetId(ssGrpId);
        pairInfo.setSHideMode((short)0);
        pairInfo.setSWriteHist(temp_MRCFgetTiPairInfo.getWriteHist());
        pairInfo.setSCopyPace(temp_MRCFgetTiPairInfo.getCopyPace());
        pairInfo.setBCascade(temp_MRCFgetTiPairInfo.getCascade());
        pairInfo.setBClone(temp_MRCFgetTiPairInfo.getClone());
        RJiLDEVIndex rootVol = temp_MRCFgetTiPairInfo.getRootLdev();
        SJmoLdevIndex rootLdev = new SJmoLdevIndex();
        rootLdev.setLdevIndex(rootVol.getSLDKC(), rootVol.getSCU(), rootVol.getSLDEV());
        pairInfo.setRootLdev(rootLdev);
        if (pairInfo.getSPairStatus() == 0) {
            SJctrLogUty.warn("SJctrTiReplicationUtility", "generatetLocalReplicationPairVolInfo", "Pair is not exist. P-VOL:" + pairInfo.getPVolIndex() + ", MU:" + pairInfo.getSMuNum() + ", S-VOL:" + pairInfo);
            return null;
        }
        return pairInfo;
    }

    private static SJmoLocalReplicationPairVolInfo createPvolLocalReplicationPairVolInfo(SJmoLdevIndex pvolLdevIdx, int poolId, Long snapshotId, List<MRCFgetTiPairInfo> tiPairInfoList) {
        SJmoLocalReplicationPairVolInfo pairInfo = new SJmoLocalReplicationPairVolInfo(2);
        pairInfo.setIPairVolPos(0x400000);
        ArrayList<SJmoLdevIndex> pvols = new ArrayList<SJmoLdevIndex>();
        pvols.add(pvolLdevIdx);
        pairInfo.setAlPVolIndex(pvols);
        pairInfo.setLdevIndex(pvolLdevIdx.getSLdkc(), pvolLdevIdx.getSCu(), pvolLdevIdx.getSLdev());
        pairInfo.setISVolPoolId(poolId);
        ArrayList<SJmoLdevIndex> alSVolIndex = new ArrayList<SJmoLdevIndex>();
        for (MRCFgetTiPairInfo tiPairInfo : tiPairInfoList) {
            RJiLDEVIndex svol = tiPairInfo.getSvol();
            SJmoLdevIndex svolIdx = new SJmoLdevIndex();
            svolIdx.setSLdkc(svol.getSLDKC());
            svolIdx.setSCu(svol.getSCU());
            svolIdx.setSLdev(svol.getSLDEV());
            alSVolIndex.add(svolIdx);
            int ssGrpId = -1;
            if (snapshotId != null) {
                ssGrpId = snapshotId.intValue();
            }
            pairInfo.setISnapshotSetId(ssGrpId);
        }
        pairInfo.setAlSVolIndex(alSVolIndex);
        return pairInfo;
    }

    private static MRCFgetTiPairList getTiPairListFromPvolViaRMI(List<? extends SJmoLdevIndex> selectPVolList) {
        SJmoThroughRmiData getInfo = SJctrTiReplicationUtility.getThroughRmiDataFromPvol(selectPVolList);
        MRCFgetTiPvolPairInfo_OUT outPut = (MRCFgetTiPvolPairInfo_OUT)getInfo.getObjRmi();
        return outPut.getDataInf();
    }

    private static MRCFgetTiPairList getTiPairListFromPvolMuViaRMI(List<SJmoLocalReplicationTiPairVolInfo> selectPVolList) {
        SJmoThroughRmiData getInfo = SJctrTiReplicationUtility.getThroughRmiData(SJctrTiReplicationUtility.createGetInputDataForPvolMu(selectPVolList));
        MRCFgetTiPvolMuPairInfo_OUT outPut = (MRCFgetTiPvolMuPairInfo_OUT)getInfo.getObjRmi();
        return outPut.getDataInf();
    }

    private static MRCFgetTiPairList getTiPairListFromTiPvolMuViaRMI(List<SJmoTiPvolMu> tiPvolMuList) {
        SJmoThroughRmiData getInfo = SJctrTiReplicationUtility.getThroughRmiData(SJctrTiReplicationUtility.createGetInputDataForPvolMuFromTiPvolMu(tiPvolMuList));
        MRCFgetTiPvolMuPairInfo_OUT outPut = (MRCFgetTiPvolMuPairInfo_OUT)getInfo.getObjRmi();
        return outPut.getDataInf();
    }

    private static MRCFgetTiCtgPairList getTiPairListFromCtgIdViaRMI(int ctgId) {
        SJmoThroughRmiData getInfo = SJctrTiReplicationUtility.getThroughRmiData(SJctrTiReplicationUtility.createGetInputDataForCtgIdromTiPvolMu(ctgId));
        MRCFgetTiCtgPairInfo_OUT outPut = (MRCFgetTiCtgPairInfo_OUT)getInfo.getObjRmi();
        return outPut.getDataInf();
    }

    private static SJmoThroughRmiData getThroughRmiDataFromPvol(List<? extends SJmoLdevIndex> selectPVolList) {
        SJmoGetKind_IF kind = SJctrTiReplicationUtility.createGetInputDataForPvol(selectPVolList);
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        try {
            SJmoGetAgent agent = SJmoModelMgr.getModelMgr().getDataAgent();
            ArrayList<SJmoGetDirect> list = new ArrayList<SJmoGetDirect>();
            list.add(direct);
            List object = (List)agent.getDataInf(list).get(0);
            return (SJmoThroughRmiData)object.get(0);
        }
        catch (Exception e) {
            SJctrError err = new SJctrError(209, 22, 207007);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    private static SJmoThroughRmiData getThroughRmiData(SJmoGetKind_IF kind) {
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        try {
            SJmoGetAgent agent = SJmoModelMgr.getModelMgr().getDataAgent();
            ArrayList<SJmoGetDirect> list = new ArrayList<SJmoGetDirect>();
            list.add(direct);
            List object = (List)agent.getDataInf(list).get(0);
            return (SJmoThroughRmiData)object.get(0);
        }
        catch (Exception e) {
            SJctrError err = new SJctrError(209, 22, 207007);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    private static SJmoGetKind_IF createGetInputDataForPvol(List<? extends SJmoLdevIndex> selectPVolList) {
        int getNum = selectPVolList.size();
        MRCFgetTiPvolPairParam param = new MRCFgetTiPvolPairParam();
        param.setPvolNum(getNum);
        RJiLDEVIndex[] getLdevArray = new RJiLDEVIndex[getNum];
        for (int index = 0; index < getNum; ++index) {
            RJiLDEVIndex getLdev = new RJiLDEVIndex();
            SJmoLdevIndex pVolIndex = selectPVolList.get(index);
            getLdev.setLDEVIndex(pVolIndex.getSLdkc(), pVolIndex.getSCu(), pVolIndex.getSLdev());
            getLdevArray[index] = getLdev;
        }
        param.setPvolList(getLdevArray);
        param.setiMaxPair(32768);
        MRCFgetTiPvolPairInfo_IN input = new MRCFgetTiPvolPairInfo_IN();
        input.setTiPvolPairParam(param);
        return new SJctrGetMRCFgetTiPvolPairParam(input);
    }

    private static SJctrGetMRCFgetTiPvolMuParam createGetInputDataForPvolMu(List<SJmoLocalReplicationTiPairVolInfo> selectPVolList) {
        MRCFgetTiPvolMuParam param = new MRCFgetTiPvolMuParam();
        MRCFgetTiPvolMu[] targetPairs = new MRCFgetTiPvolMu[selectPVolList.size()];
        for (int i = 0; i < selectPVolList.size(); ++i) {
            SJmoLocalReplicationTiPairVolInfo pair = selectPVolList.get(i);
            MRCFgetTiPvolMu pvolMu = new MRCFgetTiPvolMu();
            RJiLDEVIndex rjLdevIndex = new RJiLDEVIndex();
            rjLdevIndex.setLDEVIndex(pair.getSLdkc(), pair.getSCu(), pair.getSLdev());
            pvolMu.setPvol(rjLdevIndex);
            pvolMu.setMu(pair.getMu());
            targetPairs[i] = pvolMu;
        }
        param.setTiPvolMu(targetPairs);
        MRCFgetTiPvolMuPairInfo_IN input = new MRCFgetTiPvolMuPairInfo_IN();
        input.setTiPvolMu(param);
        return new SJctrGetMRCFgetTiPvolMuParam(input);
    }

    private static SJctrGetMRCFgetTiPvolMuParam createGetInputDataForPvolMuFromTiPvolMu(List<SJmoTiPvolMu> tiPvolMuList) {
        MRCFgetTiPvolMuParam param = new MRCFgetTiPvolMuParam();
        MRCFgetTiPvolMu[] targetPairs = new MRCFgetTiPvolMu[tiPvolMuList.size()];
        for (int i = 0; i < tiPvolMuList.size(); ++i) {
            SJmoTiPvolMu pair = tiPvolMuList.get(i);
            MRCFgetTiPvolMu pvolMu = new MRCFgetTiPvolMu();
            RJiLDEVIndex rjLdevIndex = new RJiLDEVIndex();
            rjLdevIndex.setLDEVIndex(pair.getSLdkc(), pair.getSCu(), pair.getSLdev());
            pvolMu.setPvol(rjLdevIndex);
            pvolMu.setMu(pair.getMu());
            targetPairs[i] = pvolMu;
        }
        param.setTiPvolMu(targetPairs);
        MRCFgetTiPvolMuPairInfo_IN input = new MRCFgetTiPvolMuPairInfo_IN();
        input.setTiPvolMu(param);
        return new SJctrGetMRCFgetTiPvolMuParam(input);
    }

    private static SJctrGetMRCFgetTiCtgPairInfo createGetInputDataForCtgIdromTiPvolMu(int ctgId) {
        MRCFgetTiCtgPairParam param = new MRCFgetTiCtgPairParam(-1);
        param.setCtgId(ctgId);
        MRCFgetTiCtgPairInfo_IN input = new MRCFgetTiCtgPairInfo_IN(param);
        return new SJctrGetMRCFgetTiCtgPairInfo(input);
    }

    public static SJmoPoolDetail getPoolDetalInfoFromPairVolInfo(SJmoLocalReplicationTiPairVolInfo pairVolInfo, List<SJmoPoolDetail> poolInfoList) {
        SJmoPoolDetail poolInfo = null;
        SJmoPoolIndex poolIndex = new SJmoPoolIndex();
        if (pairVolInfo != null && poolInfoList != null) {
            poolIndex.setPoolId(pairVolInfo.getsVolPoolId());
            int target = Collections.binarySearch(poolInfoList, poolIndex);
            if (0 <= target) {
                poolInfo = poolInfoList.get(target);
            }
        }
        return poolInfo;
    }

    public String getCopyStatusString(SJmoLocalReplicationTiPairVolInfo pairVolInfo, SJmoPoolDetail poolInfo) {
        String ret = "?";
        if (pairVolInfo != null) {
            int status = (int)pairVolInfo.getPairStatus();
            long lPoolStatus = 0L;
            boolean poolThreshold = false;
            if (poolInfo != null) {
                lPoolStatus = poolInfo.getPoolStatus();
            }
            if ((lPoolStatus & 0x80000000L) != 0L) {
                poolThreshold = true;
            }
            switch (status) {
                case 0: {
                    ret = this.guidanceHandle.getGuidance("ST_SMPL");
                    break;
                }
                case 513: {
                    ret = this.guidanceHandle.getGuidance("ST_SMPL_PD");
                    break;
                }
                case 528: {
                    ret = this.guidanceHandle.getGuidance("ST_COPY");
                    break;
                }
                case 544: {
                    if (poolThreshold) {
                        ret = this.guidanceHandle.getGuidance("ST_PFUL");
                        break;
                    }
                    ret = this.guidanceHandle.getGuidance("ST_PAIR");
                    break;
                }
                case 560: {
                    if (poolThreshold) {
                        ret = this.guidanceHandle.getGuidance("ST_PFUS");
                        break;
                    }
                    if (pairVolInfo.isBClone()) {
                        ret = this.guidanceHandle.getGuidance("ST_PSUS_TI");
                        break;
                    }
                    ret = this.guidanceHandle.getGuidance("ST_PSUS");
                    break;
                }
                case 584: {
                    ret = this.guidanceHandle.getGuidance("ST_RCPY");
                    break;
                }
                case 592: {
                    ret = this.guidanceHandle.getGuidance("ST_PSUE");
                    break;
                }
            }
        }
        return ret;
    }

    public static short changeTIPairStatus(short tiPairStatus, short volflg) {
        short ret = tiPairStatus;
        return ret;
    }

    public static String getSnapshotDateString(SJmoLocalReplicationTiPairVolInfo pairVolInfo) {
        String ret = "?";
        if (pairVolInfo != null) {
            if (pairVolInfo.isVolPos(0x800000)) {
                Date snapshotDate = pairVolInfo.getSnapshotDate();
                if (snapshotDate != null) {
                    SimpleDateFormat formatter = (SimpleDateFormat)SJctrReplicationDataMacro.REPLICATION_DATE_FORMAT.clone();
                    formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
                    ret = formatter.format(snapshotDate);
                } else {
                    ret = "-";
                }
            } else {
                ret = "-";
            }
        }
        return ret;
    }

    public static SJmoTiPvolMu createTiPVolMuInfo(short ldkc, short cu, short ldev, short mu) {
        MRCFgetTiPvolMu tipVolMu = new MRCFgetTiPvolMu();
        RJiLDEVIndex pVol = new RJiLDEVIndex();
        pVol.setLDEVIndex(ldkc, cu, ldev);
        tipVolMu.setPvol(pVol);
        tipVolMu.setMu(mu);
        return new SJmoTiPvolMu(tipVolMu);
    }

    public static List<SJmoLocalReplicationTiPairVolInfo> getTiPairVolInfoList(SJctrDataController dc, SJmoTiPvolStatus tiPvolStatus, SJmoTiSnapshotPairList ssPairList, SJmoLocalReplicationPairVolInfoMgr pairMgr, SJctrResourceGroupUtility rsgUtil) {
        ArrayList<SJmoLocalReplicationTiPairVolInfo> ret = new ArrayList<SJmoLocalReplicationTiPairVolInfo>();
        SJmoTiPvolInfo[] pvolInfoList = tiPvolStatus.getTiPvolInfo();
        List<SJmoLdevIndex> cacheList = dc.getProxy().getCache("KEY_SELECTED_TI_PVOL");
        ArrayList<SJmoLocalReplicationPairVolInfo> pairVolInfo = new ArrayList<SJmoLocalReplicationPairVolInfo>();
        if (cacheList == null || cacheList.isEmpty()) {
            List<?> snapshotSetList = dc.getProxy().getCache("KEY_SELECTED_SNAPSHOT");
            if (snapshotSetList == null || snapshotSetList.isEmpty()) {
                List<?> tiPairVols = dc.getProxy().getCache("KEY_SELECTED_TI_PAIR");
                if (tiPairVols == null || tiPairVols.isEmpty()) {
                    SJctrError err = new SJctrError(209, 22, 107002);
                    SJcException exp = err.createException();
                    throw exp;
                }
                ArrayList<SJmoLocalReplicationTiPairVolInfo> retList = new ArrayList<SJmoLocalReplicationTiPairVolInfo>();
                for (SJmoLocalReplicationTiPairVolInfo tiPairVolInfo : tiPairVols) {
                    if (tiPairVolInfo.getPairStatus() == 0L) {
                        SJctrLogUty.warn("SJctrTiReplicationUtility", "generatetLocalReplicationPairVolInfo", "Pair is not exist. P-VOL:" + tiPairVolInfo.getPVolIndex() + ", MU:" + tiPairVolInfo.getMu() + ", S-VOL:" + tiPairVolInfo);
                        continue;
                    }
                    retList.add(tiPairVolInfo);
                }
                return retList;
            }
            ArrayList<SJmoTiPvolMu> pvolMuList = new ArrayList<SJmoTiPvolMu>();
            List<SJmoLdevIndex> resourceLdevs = SJctrReplicationUtility.getEnableResourceLdevList(rsgUtil);
            for (SJmoSnapshotSetInfo sssInfo : snapshotSetList) {
                for (SJmoTiSnapshotPair pair : ssPairList.getSnapshotPair()) {
                    if (pair == null || sssInfo.getISnapshotSetId() != (int)pair.getSnapshotID()) continue;
                    for (SJmoTiPvolMu pvolMu : pair.getPvolMu()) {
                        pvolMuList.add(pvolMu);
                    }
                }
            }
            List<SJmoLocalReplicationPairVolInfo> infosList = SJctrTiReplicationUtility.generatetLocalReplicationPairVolInfoListFromTiPvolMu(pvolMuList, ssPairList, pvolInfoList);
            for (SJmoLocalReplicationPairVolInfo info : infosList) {
                if (SJctrReplicationUtility.checkLocalPairResource(info.getPVolIndex(), resourceLdevs)) {
                    pairVolInfo.add(info);
                    continue;
                }
                if (SJctrTiReplicationUtility.isFloatingDevice(info) || !SJctrReplicationUtility.checkLocalPairResource(info, resourceLdevs)) continue;
                pairVolInfo.add(info);
            }
        } else {
            List<SJmoLdevIndex> tiPvolInfoList = cacheList;
            List<SJmoTiPvolInfo> tiRootVolInfoList = null;
            try {
                tiRootVolInfoList = SJctrTiReplicationUtility.checkAndGetExistRootLdevInfo(tiPvolInfoList, pvolInfoList);
            }
            catch (SJcException ex) {
                if (107001 == Integer.valueOf(ex.getMsg().getMsgID())) {
                    SJctrError err = new SJctrError(209, 22, 107002);
                    throw err.createException();
                }
                throw ex;
            }
            List<SJmoLocalReplicationPairVolInfo> infosList = SJctrTiReplicationUtility.getTiTreePairInfoListFromModelThrough(tiRootVolInfoList, dc, ssPairList);
            pairVolInfo.addAll(infosList);
        }
        ArrayList<SJmoLocalReplicationPairVolInfo> consistentPairList = SJctrTiReplicationUtility.getConsistentTipairInfoList(pairVolInfo, ssPairList, pairMgr);
        for (SJmoLocalReplicationPairVolInfo info : consistentPairList) {
            SJmoLocalReplicationTiPairVolInfo tiInfo = new SJmoLocalReplicationTiPairVolInfo();
            tiInfo.setPvolIndex(info.getPVolIndex());
            tiInfo.setMu(info.getSMuNum());
            tiInfo.setsVolIndex(info);
            tiInfo.setsVolPoolId(info.getISVolPoolId());
            tiInfo.setiSnapshotSetId(info.getISnapshotSetId());
            tiInfo.setSnapshotDate(info.getSnapShotDate());
            tiInfo.setPairStatus(info.getSPairStatus());
            tiInfo.setCtgId(info.getSCtgId());
            tiInfo.setBCascade(info.isBCascade());
            tiInfo.setBClone(info.isBClone());
            tiInfo.setRootLdev(info.getRootLdev());
            ret.add(tiInfo);
        }
        return ret;
    }

    public static ArrayList<SJmoLocalReplicationPairVolInfo> getConsistentTipairInfoList(ArrayList<SJmoLocalReplicationPairVolInfo> pairList, SJmoTiSnapshotPairList ssPairList, SJmoLocalReplicationPairVolInfoMgr pairMgr) {
        if (pairList == null || ssPairList == null || pairMgr == null) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "checkTipairInfoInModelData", "parameter is null.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        ArrayList<SJmoLocalReplicationPairVolInfo> consistentPairList = new ArrayList<SJmoLocalReplicationPairVolInfo>();
        SJmoTiSnapshotPair[] ssGroupArray = ssPairList.getSnapshotPair();
        for (SJmoLocalReplicationPairVolInfo pair : pairList) {
            boolean chkFlg = false;
            int ssID = pair.getISnapshotSetId();
            if (ssID == -1) {
                if (SJctrTiReplicationUtility.isFloatingDevice(pair)) {
                    chkFlg = true;
                } else {
                    SJmoLocalReplicationPairVolInfo modelInfo = pairMgr.getLocalReplicationPairVolInfo(pair);
                    if (modelInfo != null && modelInfo.isVolPos(0x800000)) {
                        chkFlg = true;
                    }
                }
            } else {
                SJmoTiPvolMu checkPvolMu = SJctrTiReplicationUtility.getTiPvolMuFromPairInfo(pair, ssGroupArray);
                if (checkPvolMu != null) {
                    chkFlg = true;
                }
            }
            if (chkFlg) {
                consistentPairList.add(pair);
                continue;
            }
            SJmoLdevIndex pvol = pair.getPVolIndex();
            SJctrLogUty.info("SJctrReplicationUtility", "getConsistentTipairInfoList", "Not found model data. PVol is 0x" + pvol.toString() + "  MU# = " + pair.getSMuNum());
        }
        return consistentPairList;
    }

    public static SJmoTiPvolMu getTiPvolMuFromPairInfo(SJmoLocalReplicationPairVolInfo pair, SJmoTiSnapshotPair[] ssGroupArray) {
        if (pair == null || ssGroupArray == null) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "getTiPvolMuFromPairInfo", "parameter is null.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        SJmoTiPvolMu rtnInfo = null;
        if (pair.isVolPos(0x800000)) {
            int ssID = pair.getISnapshotSetId();
            block0: for (SJmoTiSnapshotPair ssGroup : ssGroupArray) {
                if ((long)ssID != ssGroup.getSnapshotID()) continue;
                for (SJmoTiPvolMu tiPvolMu : ssGroup.getPvolMu()) {
                    if (pair.getPVolIndex().getIndex() != tiPvolMu.getIndex() || pair.getSMuNum() != tiPvolMu.getMu()) continue;
                    rtnInfo = tiPvolMu;
                    break block0;
                }
                break;
            }
        }
        return rtnInfo;
    }

    public static boolean isFloatingDevice(SJmoLocalReplicationPairVolInfo info) {
        return info.getSLdkc() == -1 && info.getSCu() == -1 && info.getSLdev() == -1;
    }

    public static boolean isFloatingDevice(SJmoLocalReplicationTiPairVolInfo info) {
        return info.getsVolIndex().getSLdkc() == -1 && info.getsVolIndex().getSCu() == -1 && info.getsVolIndex().getSLdev() == -1;
    }

    public static void checkLocalPairVolStatus(List<SJmoLocalReplicationPairVolInfo> pairlist, SJmoLocalReplicationPairVolInfoMgr pairMgr, List<SJmoLocalReplicationPairVolInfo> treeData, int[][] statusList, int dispId) {
        if (null == pairlist || null == pairMgr || null == treeData || null == statusList) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkLocalPairVolStatus", "Paramater is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        for (SJmoLocalReplicationPairVolInfo pair : pairlist) {
            SJctrTiReplicationUtility.checkLocalPairVolStatusAll(pair, pairMgr, treeData, statusList, dispId);
        }
    }

    public static void checkLocalPairVolStatusAll(SJmoLocalReplicationPairVolInfo selectPair, SJmoLocalReplicationPairVolInfoMgr pairMgr, List<SJmoLocalReplicationPairVolInfo> treeRmiData, int[][] statusList, int dispId) {
        if (null == selectPair || null == pairMgr || null == statusList) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkLocalPairVolStatusAll", "Parameter is null.");
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (dispId == 17870995 && selectPair.isBClone()) {
            statusList = SJctrReplicationDataMacro.DELETE_CLONE_PAIR_STATUS_PASS;
        }
        SJctrReplicationUtility.checkLocalPairVolStatusFor1x1(selectPair, statusList, 3);
        boolean chkFlg = true;
        switch (dispId) {
            case 0x1101311: {
                SJmoLocalReplicationPairVolInfo highPair = SJctrTiReplicationUtility.getHighTipair(selectPair, pairMgr);
                if (highPair == null || (chkFlg = SJctrReplicationUtility.checkLocalPairVolStatus(highPair, SJctrReplicationDataMacro.SPLIT_TI_PAIR_HIGH_PAIR_SATAUS_PASS))) break;
                SJctrLogUty.error("SJctrTiReplicationUtility", "checkLocalPairVolStatusAll", "TI high pair status is invalid.");
                SJctrCreateTIPairUtility.createError(206320);
                break;
            }
            case 17830689: {
                List<SJmoLocalReplicationPairVolInfo> lowTiPairList = SJctrTiReplicationUtility.getLowTiPairList(selectPair, treeRmiData);
                for (SJmoLocalReplicationPairVolInfo lowInfo : lowTiPairList) {
                    chkFlg = SJctrReplicationUtility.checkLocalPairVolStatus(lowInfo, SJctrReplicationDataMacro.RESYNC_TI_PAIR_LOW_PAIR_SATAUS_PASS);
                    if (chkFlg) continue;
                    SJctrLogUty.error("SJctrTiReplicationUtility", "checkLocalPairVolStatusAll", "TI low pair status is invalid.");
                    SJctrCreateTIPairUtility.createError(206312);
                }
                break;
            }
        }
        SJmoLocalReplicationPairVolInfo pvolPair = pairMgr.getLocalReplicationPairVolInfo(selectPair.getPVolIndex());
        if (pvolPair != null) {
            SJctrTiReplicationUtility.checkLocalPairVolStatusForSsCascadeSi(selectPair, pvolPair, statusList);
            SJctrTiReplicationUtility.checkLocalPairVolStatusForSsSharePvolSi(selectPair, pvolPair, pairMgr, statusList);
        }
    }

    private static void checkLocalPairVolStatusForSsSharePvolSi(SJmoLocalReplicationPairVolInfo svolpair, SJmoLocalReplicationPairVolInfo pvolpair, SJmoLocalReplicationPairVolInfoMgr allpair, int[][] checkStatus) {
        if ((pvolpair.isVolPos(4) || pvolpair.isVolPos(8)) && svolpair.isVolPos(0x800000)) {
            ArrayList<? extends SJmoLdevIndex> sVolList = pvolpair.getAlSVolIndex();
            for (SJmoLdevIndex sJmoLdevIndex : sVolList) {
                boolean bstatus;
                SJmoLocalReplicationPairVolInfo existPairInfo = allpair.getLocalReplicationPairVolInfo(sJmoLdevIndex);
                if (null == existPairInfo || 0 == existPairInfo.compareTo(svolpair) || !existPairInfo.isVolPos(8) || (bstatus = SJctrReplicationUtility.checkLocalPairVolStatus(existPairInfo, checkStatus[9]))) continue;
                SJctrLogUty.error("SJctrReplicationUtility", "checkLocalPairVolStatusForSsSharePvolSi", "Selected pair is invalid status. -svol:" + existPairInfo + " -status:" + existPairInfo.getSPairStatus());
                SJctrError err = new SJctrError(209, 22, 206324);
                SJcException exp = err.createException();
                throw exp;
            }
        }
    }

    public static Map<SJmoTiPvolInfo, SJctrPvolPairCounts> filterTiPVolTableDataList(SJmoTiPvolInfo[] tiPvolInfos, SJctrResourceGroupUtility rsgUtil, List<SJmoLdevDetail> ldevDetails, SJmoLocalReplicationPairVolInfoMgr pairVolInfoMgr) {
        SJmoTiPvolInfo[] tiRootVolInfoCopy;
        HashMap<SJmoTiPvolInfo, SJctrPvolPairCounts> basicDataList = new HashMap<SJmoTiPvolInfo, SJctrPvolPairCounts>();
        List<SJmoLdevIndex> resourceLdevs = SJctrReplicationUtility.getEnableResourceLdevList(rsgUtil);
        Map<Integer, List<SJmoLocalReplicationPairVolInfo>> rootPairMap = SJctrTiReplicationUtility.getMapRootVol_TiPairList(pairVolInfoMgr, tiPvolInfos);
        for (SJmoTiPvolInfo rootVolInfo : tiRootVolInfoCopy = Arrays.copyOf(tiPvolInfos, tiPvolInfos.length)) {
            if (null == rootVolInfo) continue;
            boolean isRsgFlg = false;
            boolean canPvolDisplayed = SJctrReplicationUtility.checkViewPair(rootVolInfo, ldevDetails);
            if (!canPvolDisplayed) continue;
            long snapshotDataCount = 0L;
            long psueCount = 0L;
            isRsgFlg = SJctrTiReplicationUtility.checkTiPairInfoTreePairsResource(rootVolInfo, rootPairMap, resourceLdevs);
            if (!isRsgFlg) continue;
            snapshotDataCount = rootVolInfo.getPairnum();
            psueCount = rootVolInfo.getPsuenum();
            basicDataList.put(rootVolInfo, new SJctrPvolPairCounts(snapshotDataCount, psueCount));
        }
        return basicDataList;
    }

    public static Map<Integer, List<SJmoLocalReplicationPairVolInfo>> getMapRootVol_TiPairList(SJmoLocalReplicationPairVolInfoMgr pairMgr, SJmoTiPvolInfo[] tiPvolInfos) {
        SJmoLocalReplicationPairVolInfo[] allPairs;
        if (pairMgr == null || tiPvolInfos == null) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "getMapRootVol_TiPairList", "parameter is null.");
            SJctrCreateTIPairUtility.createError(107001);
        }
        HashMap<Integer, List<SJmoLocalReplicationPairVolInfo>> rtnMap = new HashMap<Integer, List<SJmoLocalReplicationPairVolInfo>>();
        for (SJmoTiPvolInfo rootInfo : tiPvolInfos) {
            if (rootInfo == null) continue;
            ArrayList tiPairList = new ArrayList();
            rtnMap.put(rootInfo.getIndex(), tiPairList);
        }
        for (SJmoLocalReplicationPairVolInfo pairInfo : allPairs = pairMgr.getLocalReplicationPairVolInfoList()) {
            if (pairInfo == null || !pairInfo.isVolPos(0x800000)) continue;
            SJmoLdevIndex ldev = pairInfo.getRootLdev();
            List tiPairList = (List)rtnMap.get(ldev.getIndex());
            if (tiPairList == null) {
                SJctrLogUty.error("SJctrTiReplicationUtility", "getMapRootVol_TiPairList", "Map is not registered. Mapkey is = " + ldev.getSLdkc() + ":" + ldev.getSCu() + ":" + ldev.getSLdev());
                continue;
            }
            tiPairList.add(pairInfo);
        }
        return rtnMap;
    }

    private static boolean canDisplayed(boolean isPvolInRg, boolean canPvolDisplayed, boolean isSvolInRg, boolean canSvolDisplayed) {
        return (isPvolInRg || isSvolInRg) && canPvolDisplayed && canSvolDisplayed;
    }

    public static List<SJmoLdevIndex> getTreeLdevListUsedCascadePair(SJmoLocalReplicationPairVolInfoMgr pairMgr, SJmoTiPvolInfo rootLdevInfo) {
        ArrayList<? extends SJmoLdevIndex> sVolList;
        List<SJmoLdevIndex> treeLdevList;
        if (pairMgr == null || rootLdevInfo == null) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "getTreeLdevListUsedCascadePair", "parameter is null.");
            SJctrCreateTIPairUtility.createError(107001);
        }
        ArrayList<SJmoLdevIndex> rtnList = new ArrayList<SJmoLdevIndex>();
        rtnList.add(rootLdevInfo);
        SJmoLocalReplicationPairVolInfo pairInfo = pairMgr.getLocalReplicationPairVolInfo(rootLdevInfo);
        if (pairInfo != null && !(treeLdevList = SJctrTiReplicationUtility.getTreeLdevListUsedCascadePairForSvol(rootLdevInfo, sVolList = pairInfo.getAlSVolIndex(), pairMgr)).isEmpty()) {
            rtnList.addAll(treeLdevList);
        }
        return rtnList;
    }

    private static List<SJmoLdevIndex> getTreeLdevListUsedCascadePairForSvol(SJmoLdevIndex rootIndex, List<? extends SJmoLdevIndex> alSVolIndexList, SJmoLocalReplicationPairVolInfoMgr pairMgr) {
        ArrayList<SJmoLdevIndex> rtnList = new ArrayList<SJmoLdevIndex>();
        for (SJmoLdevIndex sJmoLdevIndex : alSVolIndexList) {
            SJmoLocalReplicationPairVolInfo pairInfo = pairMgr.getLocalReplicationPairVolInfo(sJmoLdevIndex);
            if (pairInfo == null || !pairInfo.isVolPos(0x800000) || pairInfo.getRootLdev().getIndex() != rootIndex.getIndex()) continue;
            rtnList.add(pairInfo);
            rtnList.addAll(SJctrTiReplicationUtility.getTreeLdevListUsedCascadePairForSvol(rootIndex, pairInfo.getAlSVolIndex(), pairMgr));
        }
        return rtnList;
    }

    public static boolean checkTiPairInfoTreePairsResource(SJmoTiPvolInfo rootInfo, Map<Integer, List<SJmoLocalReplicationPairVolInfo>> rootPairMap, List<SJmoLdevIndex> resourceLdevs) {
        boolean isRsgFlg;
        block2: {
            SJmoLocalReplicationPairVolInfo tivol;
            List<SJmoLocalReplicationPairVolInfo> treeTiList;
            if (rootInfo == null || rootPairMap == null || resourceLdevs == null) {
                SJctrLogUty.error("SJctrTiReplicationUtility", "checkTiPairInfoTreePairsResource", "parameter is null.");
                throw SJctrTiReplicationUtility.makeException(107001);
            }
            isRsgFlg = SJctrReplicationUtility.checkLocalPairResource(rootInfo, resourceLdevs);
            if (isRsgFlg || (treeTiList = rootPairMap.get(rootInfo.getIndex())) == null) break block2;
            Iterator<SJmoLocalReplicationPairVolInfo> i$ = treeTiList.iterator();
            while (i$.hasNext() && !(isRsgFlg = SJctrReplicationUtility.checkLocalPairResource(tivol = i$.next(), resourceLdevs))) {
            }
        }
        return isRsgFlg;
    }

    public static SJmoLocalReplicationPairVolInfo searchLocalReplicationPairVolInfo(List<SJmoLocalReplicationPairVolInfo> targetList, SJmoLdevIndex pvolIndex, int muNum) {
        if (pvolIndex == null) {
            return null;
        }
        SJmoLocalReplicationPairVolInfo ret = null;
        for (SJmoLocalReplicationPairVolInfo candidate : targetList) {
            SJmoLdevIndex candidatePvolIndex;
            if (candidate == null || (candidatePvolIndex = candidate.getPVolIndex()) == null) continue;
            short candidateMuNum = candidate.getSMuNum();
            if (pvolIndex.compareTo(candidatePvolIndex) != 0 || muNum != candidateMuNum) continue;
            ret = candidate;
            break;
        }
        return ret;
    }

    public static SJctrViewPairSyncRateInfo searchPairSyncRate(List<SJctrViewPairSyncRateInfo> pairSyncRateList, SJmoLdevIndex pVolIndex, short muNum) {
        SJctrViewPairSyncRateInfo ret = null;
        for (SJctrViewPairSyncRateInfo info : pairSyncRateList) {
            SJmoLdevIndex targetPvolIndex = info.getPvolIndex();
            short mu = info.getMuNum();
            if (targetPvolIndex.compareTo(pVolIndex) != 0 || mu != muNum) continue;
            ret = info;
            break;
        }
        return ret;
    }

    public static SJcException makeException(int errCode) {
        return SJctrTiReplicationUtility.makeError(errCode).createException();
    }

    public static SJctrError makeError(int errCode) {
        SJctrError err = new SJctrError(209, 22, errCode);
        return err;
    }

    public static void checkErrorSanResponse(SanObject sanObject) {
        if (sanObject == null) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "checkErrorSanResponse", "parameter is null.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        int[] messageId = SJctrTiReplicationUtility.getMessageId(sanObject);
        if (messageId[1] != 0) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "checkErrorSanResponse", "An error has occurred.");
            int funcCode = messageId[0] / 100;
            int moduleCode = messageId[0] % 100;
            int errorCode = messageId[1];
            SJctrError err = new SJctrError(funcCode, moduleCode, errorCode);
            throw err.createException();
        }
    }

    public static int[] getMessageId(SanObject sanObject) {
        if (sanObject == null) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "getMessageId", "parameter is null.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        int[] messageId = null;
        try {
            SanObject errorInfo = sanObject.getObj("ErrorInfo");
            messageId = errorInfo.getIntArray("MessageId");
        }
        catch (SanDataException e) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "getMessageId", e.getMessage());
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        return messageId;
    }

    public static SanResponse getSJmoThroughRmiData(SJmoGetThroughRmiData kind_IF, SJctrDataController dc) {
        List<Object> rmiData = new ArrayList();
        if (kind_IF == null || dc == null) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "getSJmoThroughRmiData", "parameter is null.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetThroughRmiData kind = kind_IF;
        SJmoGetRange_IF range = null;
        ArrayList filter = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filter);
        SJctrGetDirectWrapper directWrapper = new SJctrGetDirectWrapper(direct, false);
        set.add(directWrapper);
        Map<SJctrGetDirectWrapper, List<?>> map = dc.getProxy().getDataInf(set);
        rmiData = map.get(directWrapper);
        return (SanResponse)rmiData.get(0);
    }

    public static HashMap<String, byte[]> getDpSluIdMap(List<SJmoLdevDetail> ldevDetailList, SJctrDataController dc) {
        if (null == ldevDetailList || null == dc) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "getDpSluIdMap", "parameter is null.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        HashMap<String, byte[]> dpSluLdevMap = new HashMap<String, byte[]>();
        ArrayList<SJmoLdevDetail> targetLdevList = new ArrayList<SJmoLdevDetail>();
        Collections.sort((ArrayList)ldevDetailList);
        for (SJmoLdevDetail checkLdev : ldevDetailList) {
            if (!checkLdev.getBSlu() || targetLdevList.contains(checkLdev)) continue;
            targetLdevList.add(checkLdev);
        }
        try {
            if (targetLdevList.size() > 0) {
                SJmoGetAgent modelAgent = dc.getOwner().getModelAgent();
                SanRequest dpSluIdRequest = modelAgent.newRequest("VVOLreadConglomerateLuId");
                SanList reqLdevsList = dpSluIdRequest.newList("Ldevs");
                for (SJmoLdevDetail targetSluLdev : targetLdevList) {
                    int[] setLdevId = new int[]{targetSluLdev.getSLdkc(), targetSluLdev.getSCu(), targetSluLdev.getSLdev()};
                    SanObject id = reqLdevsList.addObj();
                    id.putIntArray("Id", setLdevId);
                }
                SJctrGetThroughRmiDataDpSluId requestKind = new SJctrGetThroughRmiDataDpSluId(dpSluIdRequest);
                SanResponse dpSluIdResult = SJctrTiReplicationUtility.getSJmoThroughRmiData(requestKind, dc);
                SJctrTiReplicationUtility.checkErrorSanResponse((SanObject)dpSluIdResult);
                SanList resultList = dpSluIdResult.getList("Ldevs");
                for (SanObject resultData : resultList) {
                    int[] ldevIdwork = resultData.getIntArray("Id");
                    SJmoLdevIndex setLdevId = new SJmoLdevIndex();
                    setLdevId.setLdevIndex((short)(ldevIdwork[0] & 0xFF), (short)(ldevIdwork[1] & 0xFF), (short)(ldevIdwork[2] & 0xFF));
                    SanObject sluResultObj = resultData.getObj("Slu");
                    if (null == sluResultObj) continue;
                    byte[] sluId = sluResultObj.getByteArray("Id");
                    dpSluLdevMap.put(setLdevId.toString(), sluId);
                }
            }
        }
        catch (SanDataException ex) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "getDpSluIdMap", ex.getMessage());
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        return dpSluLdevMap;
    }

    public static HashMap<String, byte[]> getSsSluIdMap(List<byte[]> dpSluList, SJctrDataController dc) {
        if (null == dpSluList || null == dc) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "getSsSluIdMap", "parameter is null.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        HashMap<String, byte[]> snapshotSluLdevMap = new HashMap<String, byte[]>();
        ArrayList<byte[]> targetDpSluIdList = new ArrayList<byte[]>();
        for (byte[] checkDpSlu : dpSluList) {
            boolean duplicateflg = false;
            for (byte[] containDpSlu : targetDpSluIdList) {
                if (!Arrays.equals(checkDpSlu, containDpSlu)) continue;
                duplicateflg = true;
                break;
            }
            if (duplicateflg) continue;
            targetDpSluIdList.add(checkDpSlu);
        }
        try {
            if (targetDpSluIdList.size() > 0) {
                ArrayList targetDpSluIdListList = new ArrayList();
                int sizeOfList = targetDpSluIdList.size();
                for (int j = 0; j < sizeOfList; j += 1024) {
                    targetDpSluIdListList.add(new ArrayList(targetDpSluIdList.subList(j, Math.min(sizeOfList, j + 1024))));
                }
                for (List list : targetDpSluIdListList) {
                    SJmoGetAgent modelAgent = dc.getOwner().getModelAgent();
                    SanRequest ssSluIdRequest = modelAgent.newRequest("MRCFreadSnapshotSlus");
                    SanList reqSlusList = ssSluIdRequest.newList("Slus");
                    for (byte[] targetDpSluId : list) {
                        SanObject id = reqSlusList.addObj();
                        id.putByteArray("Id", targetDpSluId);
                    }
                    SJctrGetThroughRmiDataSsSluId requestKind = new SJctrGetThroughRmiDataSsSluId(ssSluIdRequest);
                    SanResponse ssSluIdResult = SJctrTiReplicationUtility.getSJmoThroughRmiData(requestKind, dc);
                    SJctrTiReplicationUtility.checkErrorSanResponse((SanObject)ssSluIdResult);
                    SanList slusList = ssSluIdResult.getList("Slus");
                    for (SanObject slusObject : slusList) {
                        SJctrTiReplicationUtility.checkErrorSanResponse(slusObject);
                        SanList snapshotSlusList = slusObject.getList("SnapshotSlus");
                        if (null == snapshotSlusList) continue;
                        for (SanObject snapshotSlusObject : snapshotSlusList) {
                            byte[] sluId = snapshotSlusObject.getByteArray("Id");
                            SanObject tiPair = snapshotSlusObject.getObj("TiPair");
                            SanObject pVol = tiPair.getObj("PrimaryVolume");
                            SanObject ldev = pVol.getObj("Ldev");
                            int[] ldevId = ldev.getIntArray("Id");
                            SJmoLdevIndex setLdevId = new SJmoLdevIndex();
                            setLdevId.setLdevIndex((short)(ldevId[0] & 0xFF), (short)(ldevId[1] & 0xFF), (short)(ldevId[2] & 0xFF));
                            int mu = tiPair.getInt("MirrorUnit");
                            StringBuffer key = new StringBuffer();
                            key.append(setLdevId.toString());
                            key.append(SJctrComUtility.toHexString(mu, 4, true));
                            snapshotSluLdevMap.put(key.toString(), sluId);
                        }
                    }
                }
            }
        }
        catch (SanDataException ex) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "getSsSluIdMap", ex.getMessage());
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        return snapshotSluLdevMap;
    }

    public static String createAluSluIdString(byte[] idData) {
        String ret = "?";
        if (idData != null) {
            StringBuffer sluString = new StringBuffer();
            for (int i = 0; i < idData.length; ++i) {
                sluString.append(String.format("%02X", idData[i]));
            }
            ret = sluString.toString();
        }
        return ret;
    }

    public static String getTargetDpSluIdString(SJmoLdevDetail targetLdev, Map<String, byte[]> sluIdMap) {
        String ret = "?";
        if (null == targetLdev || null == sluIdMap) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "getTargetSluIdString", "parameter is null.");
            return ret;
        }
        if (targetLdev.isValidIndex()) {
            if (targetLdev.getBSlu()) {
                byte[] sluIdResult = sluIdMap.get(targetLdev.toString());
                if (sluIdResult != null) {
                    ret = SJctrTiReplicationUtility.createAluSluIdString(sluIdResult);
                }
            } else {
                ret = "-";
            }
        }
        return ret;
    }

    public static String getTargetSnapshotSluIdString(SJmoLdevDetail targetPrimaryLdev, SJmoLdevDetail targetSecondaryLdev, Map<String, byte[]> sluIdMap, SJmoLocalReplicationTiPairVolInfo rowData) {
        String ret = "?";
        if (null == targetPrimaryLdev || null == targetSecondaryLdev || null == sluIdMap || null == rowData) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "getTargetSnapshotSluIdString", "parameter is null.");
            return ret;
        }
        if (!targetSecondaryLdev.isValidIndex()) {
            if (targetSecondaryLdev.getSLdkc() == -1 && targetSecondaryLdev.getSCu() == -1 && targetSecondaryLdev.getSLdev() == -1) {
                if (targetPrimaryLdev.getBSlu()) {
                    SJmoLdevIndex setLdevId = new SJmoLdevIndex();
                    setLdevId.setLdevIndex(rowData.getSLdkc(), rowData.getSCu(), rowData.getSLdev());
                    StringBuffer key = new StringBuffer();
                    key.append(setLdevId.toString());
                    key.append(SJctrComUtility.toHexString(rowData.getMu(), 4, true));
                    byte[] sluIdResult = sluIdMap.get(key.toString());
                    ret = sluIdResult == null ? "-" : SJctrTiReplicationUtility.createAluSluIdString(sluIdResult);
                } else {
                    ret = "-";
                }
            }
        } else {
            SJmoLdevIndex setLdevId = new SJmoLdevIndex();
            if (targetPrimaryLdev.getBSlu()) {
                setLdevId.setLdevIndex(rowData.getSLdkc(), rowData.getSCu(), rowData.getSLdev());
                StringBuffer key = new StringBuffer();
                key.append(setLdevId.toString());
                key.append(SJctrComUtility.toHexString(rowData.getMu(), 4, true));
                byte[] sluIdResult = sluIdMap.get(key.toString());
                ret = sluIdResult == null ? "-" : SJctrTiReplicationUtility.createAluSluIdString(sluIdResult);
            } else {
                ret = "-";
            }
        }
        return ret;
    }

    public String getCascadeString(SJmoLocalReplicationTiPairVolInfo pairVolInfo) {
        String ret = "?";
        if (pairVolInfo != null) {
            ret = pairVolInfo.isBCascade() ? this.guidanceHandle.getGuidance("ENABLED") : this.guidanceHandle.getGuidance("DISABLED");
        }
        return ret;
    }

    public String getPairCloneTypeString(SJmoLocalReplicationTiPairVolInfo pairVolInfo) {
        String ret = "?";
        if (pairVolInfo != null) {
            ret = pairVolInfo.isBCascade() && pairVolInfo.isBClone() ? this.guidanceHandle.getGuidance("CLONE") : this.guidanceHandle.getGuidance("PAIR_TYPE_SNAPSHOT");
        }
        return ret;
    }

    public static SJmoTiPvolInfo getRootLdevOnce(SJmoLdevIndex checkVol, SJmoTiPvolInfo[] infos) {
        int index;
        SJmoTiPvolInfo rootLdev = null;
        if (checkVol != null && infos != null && 0 <= (index = Arrays.binarySearch(infos, checkVol))) {
            rootLdev = infos[index];
        }
        return rootLdev;
    }

    public static int getNumOfTiClonePair(SJmoLocalReplicationPairVolInfoMgr pairVolMgr, SJmoLdevIndex searchLdev) {
        int iRtn = 0;
        if (pairVolMgr == null || searchLdev == null) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "getNumOfTiClonePair", "parameter is null.");
            SJctrCreateTIPairUtility.createError(107001);
        }
        SJmoLocalReplicationPairVolInfo pairVolInfo = pairVolMgr.getLocalReplicationPairVolInfo(searchLdev);
        while (pairVolInfo != null && pairVolInfo.isVolPos(0x800000)) {
            if (pairVolInfo.isBCascade() && pairVolInfo.isBClone()) {
                ++iRtn;
            }
            pairVolInfo = SJctrTiReplicationUtility.getHighTipair(pairVolInfo, pairVolMgr);
        }
        return iRtn;
    }

    public static Map<Long, List<SJmoLdevIndex>> CreateLdevCapMap(List<SJmoLdevDetail> svolAvaList) {
        if (svolAvaList == null) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "CreateLdevCapMap", "parameter is null.");
            SJctrCreateTIPairUtility.createError(107001);
        }
        HashMap<Long, List<SJmoLdevIndex>> volCapMap = new HashMap<Long, List<SJmoLdevIndex>>();
        for (SJmoLdevDetail ldev : svolAvaList) {
            long ldevCap = ldev.getLLDEVLBASize();
            List<SJmoLdevDetail> ldevIndexList = null;
            ldevIndexList = volCapMap.containsKey(ldevCap) ? (List)volCapMap.get(ldevCap) : new ArrayList<SJmoLdevDetail>();
            ldevIndexList.add(ldev);
            volCapMap.put(ldevCap, ldevIndexList);
        }
        for (Map.Entry entry : volCapMap.entrySet()) {
            List LdevList = (List)entry.getValue();
            Collections.sort(LdevList);
        }
        return volCapMap;
    }

    public static int getNumCascadeTiDepth(SJmoLocalReplicationPairVolInfo pairInfo, SJmoLocalReplicationPairVolInfoMgr pairVolMgr) {
        int irtn = 0;
        if (pairInfo == null || pairVolMgr == null) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "getNumCascadeTiDepth", "parameter is null.");
            SJctrCreateTIPairUtility.createError(107001);
        }
        while (pairInfo != null && pairInfo.isVolPos(0x800000)) {
            ++irtn;
            pairInfo = SJctrTiReplicationUtility.getHighTipair(pairInfo, pairVolMgr);
        }
        return irtn;
    }

    public static SJmoLocalReplicationPairVolInfo getHighTipair(SJmoLocalReplicationPairVolInfo pairInfo, SJmoLocalReplicationPairVolInfoMgr pairVolMgr) {
        SJmoLdevIndex pvol;
        SJmoLocalReplicationPairVolInfo pPairVol;
        SJmoLocalReplicationPairVolInfo rtnPair = null;
        if (pairInfo == null || pairVolMgr == null) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "getHighTipair", "parameter is null.");
            SJctrCreateTIPairUtility.createError(107001);
        }
        if (pairInfo.isVolPos(0x800000) && (pPairVol = pairVolMgr.getLocalReplicationPairVolInfo(pvol = pairInfo.getPVolIndex())) != null && pPairVol.isVolPos(0x800000)) {
            rtnPair = pPairVol;
        }
        return rtnPair;
    }

    public static List<SJmoLocalReplicationPairVolInfo> getLowTiPairList(SJmoLocalReplicationPairVolInfo pairInfo, List<SJmoLocalReplicationPairVolInfo> treeData) {
        List<SJmoLocalReplicationPairVolInfo> rtnList = new ArrayList<SJmoLocalReplicationPairVolInfo>();
        if (pairInfo == null || treeData == null) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "getLowTiPairList", "parameter is null.");
            SJctrCreateTIPairUtility.createError(107001);
        }
        if (pairInfo.isVolPos(0x800000) && !SJctrTiReplicationUtility.isFloatingDevice(pairInfo)) {
            rtnList = SJctrTiReplicationUtility.getSamenessLayerPairList(pairInfo, treeData);
        }
        return rtnList;
    }

    public static Object getObjCascadehaveModel(SJmoLdevIndex ldevIndex, SJmoLocalReplicationPairVolInfoMgr pairMgr, SJmoTiPvolStatus tiPVolStatus, List<?> ssDataInfoList) {
        Object objRtn = null;
        Object[] tiPVolArray = tiPVolStatus.getTiPvolInfo();
        int index = Arrays.binarySearch(tiPVolArray, ldevIndex);
        if (index >= 0) {
            Object rootInfo;
            objRtn = rootInfo = tiPVolArray[index];
        } else {
            SJmoLocalReplicationPairVolInfo pairVolInfo = pairMgr.getLocalReplicationPairVolInfo(ldevIndex);
            if (pairVolInfo != null && pairVolInfo.isVolPos(0x800000)) {
                objRtn = pairVolInfo;
            } else if (ssDataInfoList != null && ssDataInfoList.size() > 0) {
                for (Object info : ssDataInfoList) {
                    SJctrCreateSnapshotDataInfo ssData = (SJctrCreateSnapshotDataInfo)info;
                    if (ssData.getIndex() != ldevIndex.getIndex()) continue;
                    objRtn = info;
                    break;
                }
            }
        }
        return objRtn;
    }

    public static boolean checkLeafPairList(List<SJmoLocalReplicationPairVolInfo> tiPairVolInfoList, SJmoLocalReplicationPairVolInfoMgr pairVolMgr) {
        boolean rtn = true;
        if (null == tiPairVolInfoList || null == pairVolMgr) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "checkLeafPairList", "parameter is null.");
            SJctrCreateTIPairUtility.createError(107001);
        }
        for (SJmoLocalReplicationPairVolInfo pairsVolInfo : tiPairVolInfoList) {
            if (SJctrTiReplicationUtility.isFloatingDevice(pairsVolInfo) || !SJctrTiReplicationUtility.checkTiPVol(pairsVolInfo, pairVolMgr)) continue;
            rtn = false;
            break;
        }
        return rtn;
    }

    public static boolean checkLeafTiPairList(List<SJmoLocalReplicationTiPairVolInfo> tiPairVolInfoList, SJmoLocalReplicationPairVolInfoMgr pairVolMgr) {
        boolean rtn = true;
        if (null == tiPairVolInfoList || null == pairVolMgr) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "checkLeafTiPairList", "parameter is null.");
            SJctrCreateTIPairUtility.createError(107001);
        }
        for (SJmoLocalReplicationTiPairVolInfo pairsVolInfo : tiPairVolInfoList) {
            SJmoLdevIndex svolIndex;
            if (SJctrTiReplicationUtility.isFloatingDevice(pairsVolInfo) || !SJctrTiReplicationUtility.checkTiPVol(svolIndex = pairsVolInfo.getsVolIndex(), pairVolMgr)) continue;
            rtn = false;
            break;
        }
        return rtn;
    }

    public static boolean checkTiPVol(SJmoLdevIndex ldevIndex, SJmoLocalReplicationPairVolInfoMgr pairVolMgr) {
        SJmoLocalReplicationPairVolInfo pPairVol;
        boolean rtn = false;
        if (null == ldevIndex || null == pairVolMgr) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "checkTiPVol", "parameter is null.");
            SJctrCreateTIPairUtility.createError(107001);
        }
        if ((pPairVol = pairVolMgr.getLocalReplicationPairVolInfo(ldevIndex)) != null && pPairVol.isVolPos(0x400000)) {
            rtn = true;
        }
        return rtn;
    }

    public static boolean checkContainsCloneTiPair(List<SJmoLocalReplicationTiPairVolInfo> checkPairList) {
        if (checkPairList == null) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "checkContainsCloneTiPair", "parameter is null.");
            SJctrCreateTIPairUtility.createError(107001);
        }
        boolean ret = false;
        for (SJmoLocalReplicationTiPairVolInfo checkPair : checkPairList) {
            if (!SJctrTiReplicationUtility.isCloneTiPair(checkPair)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public static boolean isCloneTiPair(SJmoLocalReplicationTiPairVolInfo checkPair) {
        if (checkPair == null) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "isCloneTiPair", "parameter is null.");
            SJctrCreateTIPairUtility.createError(107001);
        }
        boolean ret = false;
        if (checkPair.isBClone()) {
            ret = true;
        }
        return ret;
    }

    public static boolean checkClonePairStatusCopy(List<SJmoLocalReplicationPairVolInfo> tiPairVolInfoList) {
        boolean rtn = false;
        if (tiPairVolInfoList == null) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "checkClonePairStatusCopy", "parameter is null.");
            SJctrCreateTIPairUtility.createError(107001);
        }
        for (SJmoLocalReplicationPairVolInfo pairsVolInfo : tiPairVolInfoList) {
            if (pairsVolInfo.isBClone()) {
                short status = pairsVolInfo.getSPairStatus();
                switch (status) {
                    case 560: {
                        rtn = true;
                        break;
                    }
                }
            }
            if (!rtn) continue;
            break;
        }
        return rtn;
    }

    public static List<SJmoSnapshotSetInfo> getSnpashotGroupListMixedCascadeAttr(List<SJctrCreateTIPairInfo> tiPairInfoList) {
        ArrayList<SJmoSnapshotSetInfo> ssgListMixedCascadeAttr = new ArrayList<SJmoSnapshotSetInfo>();
        HashMap<Integer, Boolean> cascadeAttrMap = new HashMap<Integer, Boolean>();
        for (SJctrCreateTIPairInfo pairInfo : tiPairInfoList) {
            SJmoSnapshotSetInfo snapShotGroupInfo = pairInfo.getSnapshotGroupInfo();
            if (snapShotGroupInfo == null || ssgListMixedCascadeAttr.contains(snapShotGroupInfo)) continue;
            boolean bCascade = pairInfo.isBCascade();
            int snapshotGroupId = snapShotGroupInfo.getISnapshotSetId();
            if (cascadeAttrMap.containsKey(snapshotGroupId)) {
                if (bCascade == (Boolean)cascadeAttrMap.get(snapshotGroupId)) continue;
                ssgListMixedCascadeAttr.add(snapShotGroupInfo);
                continue;
            }
            cascadeAttrMap.put(snapshotGroupId, bCascade);
        }
        return ssgListMixedCascadeAttr;
    }

    public static boolean isMixedCascadeAttrForCreateTiPairInfo(List<SJctrCreateTIPairInfo> createTiPairInfoList) {
        boolean isMixed = false;
        if (createTiPairInfoList != null && createTiPairInfoList.size() >= 2) {
            boolean isCascadeFirstPair = createTiPairInfoList.get(0).isBCascade();
            for (SJctrCreateTIPairInfo pairInfo : createTiPairInfoList) {
                if (pairInfo.isBCascade() == isCascadeFirstPair) continue;
                isMixed = true;
                break;
            }
        }
        return isMixed;
    }

    public static boolean isMixedCascadeAttrForTiPairInfo(List<SJmoLocalReplicationTiPairVolInfo> tiPairInfoList) {
        boolean isMixed = false;
        if (tiPairInfoList != null && tiPairInfoList.size() >= 2) {
            boolean isCascadeFirstPair = tiPairInfoList.get(0).isBCascade();
            for (SJmoLocalReplicationTiPairVolInfo pairInfo : tiPairInfoList) {
                if (pairInfo.isBCascade() == isCascadeFirstPair) continue;
                isMixed = true;
                break;
            }
        }
        return isMixed;
    }

    public static boolean isMixedCascadeAttrForRootVolInfo(List<SJmoTiPvolInfo> rootVolInfoList) {
        boolean isMixed = false;
        if (rootVolInfoList != null && rootVolInfoList.size() >= 2) {
            boolean isCascadeFirstRootVol = rootVolInfoList.get(0).getBCascade();
            for (SJmoTiPvolInfo rootVolInfo : rootVolInfoList) {
                if (rootVolInfo.getBCascade() == isCascadeFirstRootVol) continue;
                isMixed = true;
                break;
            }
        }
        return isMixed;
    }

    public static List<SJmoTiPvolInfo> getRootVolListMultipleHierarchyForLReplicaInfo(List<SJmoLocalReplicationPairVolInfo> pairList, List<SJmoTiPvolInfo> tiRootList, SJmoLocalReplicationPairVolInfoMgr pairMgr) {
        if (pairList == null || tiRootList == null || pairMgr == null) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "getRootVolListMultipleHierarchyForLReplicaInfo", "param is null.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        ArrayList<SJmoTiPvolInfo> rtnRootLdevList = new ArrayList<SJmoTiPvolInfo>();
        Collections.sort(tiRootList);
        for (SJmoLocalReplicationPairVolInfo pairVolInfo : pairList) {
            if (!SJctrTiReplicationUtility.isMultipleHierarchyTiPairInfo(pairVolInfo)) continue;
            int iIndex = Collections.binarySearch(tiRootList, pairVolInfo.getRootLdev());
            if (iIndex >= 0) {
                if (rtnRootLdevList.contains(tiRootList.get(iIndex))) continue;
                rtnRootLdevList.add(tiRootList.get(iIndex));
                continue;
            }
            SJctrLogUty.error("SJctrTiReplicationUtility", "getRootVolListMultipleHierarchyForLReplicaInfo", "TI root volume is not found.");
            SJctrCreateTIPairUtility.createError(107001);
        }
        Collections.sort(rtnRootLdevList);
        return rtnRootLdevList;
    }

    public static boolean isMultipleHierarchyTiPairInfo(SJmoLocalReplicationPairVolInfo pairVolInfo) {
        if (pairVolInfo == null) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "isMultipleHierarchyTiPairInfo", "param is null.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        boolean brtn = false;
        if (pairVolInfo.getPVolIndex().getIndex() != pairVolInfo.getRootLdev().getIndex()) {
            brtn = true;
        }
        return brtn;
    }

    public static List<SJmoTiPvolInfo> getRootVolListMultipleHierarchyForTiPairInfo(List<SJmoLocalReplicationTiPairVolInfo> tiPairList, List<SJmoTiPvolInfo> rootInfoList, SJmoLocalReplicationPairVolInfoMgr pairMgr) {
        if (tiPairList == null || pairMgr == null) {
            SJctrLogUty.error("SJctrTiReplicationUtility", "getRootVolListMultipleHierarchyForTiPairInfo", "param is null.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        ArrayList<SJmoTiPvolInfo> rtnRootLdevList = new ArrayList<SJmoTiPvolInfo>();
        Collections.sort(rootInfoList);
        for (SJmoLocalReplicationTiPairVolInfo tiInfo : tiPairList) {
            SJmoLocalReplicationPairVolInfo pairInfo = new SJmoLocalReplicationPairVolInfo(2);
            SJmoLdevIndex svolIndex = tiInfo.getsVolIndex();
            pairInfo.setLdevIndex(svolIndex.getSLdkc(), svolIndex.getSCu(), svolIndex.getSLdev());
            pairInfo.setAlPVolIndex(tiInfo.getAlPVolIndex());
            pairInfo.setBCascade(tiInfo.isBCascade());
            pairInfo.setBClone(tiInfo.isBClone());
            pairInfo.setRootLdev(tiInfo.getRootLdev());
            pairInfo.setIPairVolPos(0x800000);
            if (!SJctrTiReplicationUtility.isMultipleHierarchyTiPairInfo(pairInfo)) continue;
            int iIndex = Collections.binarySearch(rootInfoList, pairInfo.getRootLdev());
            if (iIndex >= 0) {
                if (rtnRootLdevList.contains(rootInfoList.get(iIndex))) continue;
                rtnRootLdevList.add(rootInfoList.get(iIndex));
                continue;
            }
            SJctrLogUty.error("SJctrTiReplicationUtility", "getRootVolListMultipleHierarchyForLReplicaInfo", "TI root volume is not found.");
            SJctrCreateTIPairUtility.createError(107001);
        }
        Collections.sort(rtnRootLdevList);
        return rtnRootLdevList;
    }

    public static boolean chkTiSameLayerContainStatus(List<SJmoLocalReplicationPairVolInfo> checkPairList, List<SJmoLocalReplicationPairVolInfo> selectedTreeList, int checkFlg) {
        if (checkPairList == null || selectedTreeList == null) {
            SJctrLogUty.error("SJctrReplicationUtility", "chkTiSameLayerContainStatus", "argument is null.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        boolean bRet = false;
        Map<Integer, List<SJmoLocalReplicationPairVolInfo>> pairMap = SJctrTiReplicationUtility.getSameLayerPairListMap(checkPairList, selectedTreeList);
        for (Map.Entry<Integer, List<SJmoLocalReplicationPairVolInfo>> entry : pairMap.entrySet()) {
            List<SJmoLocalReplicationPairVolInfo> pairList = entry.getValue();
            if (!SJctrTiReplicationUtility.chkContainsPairStatus(pairList, checkFlg)) continue;
            bRet = true;
            break;
        }
        return bRet;
    }

    public static boolean chkContainsPairStatus(List<SJmoLocalReplicationPairVolInfo> pairList, int chkStatusFlg) {
        if (pairList == null) {
            SJctrLogUty.error("SJctrReplicationUtility", "chkContainsPairStatus", "argument is null.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        boolean bRet = false;
        switch (chkStatusFlg) {
            case 0: {
                bRet = SJctrTiReplicationUtility.containsPairStatus_Copy_RS_R(pairList);
                break;
            }
            case 1: {
                bRet = SJctrTiReplicationUtility.containsPairStatus_Copy_RS_R_PSUS_SP(pairList);
                break;
            }
        }
        return bRet;
    }

    public static List<SJmoLdevIndex> getSelectedPairPvolList(List<SJmoLocalReplicationPairVolInfo> checkPairList) {
        if (checkPairList == null) {
            SJctrLogUty.error("SJctrReplicationUtility", "getSelectedPairPvolList", "checkPairList is null.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        ArrayList<SJmoLdevIndex> pVolList = new ArrayList<SJmoLdevIndex>();
        HashSet<Integer> indexSet = new HashSet<Integer>();
        for (SJmoLocalReplicationPairVolInfo checkPair : checkPairList) {
            SJmoLdevIndex pVol = new SJmoLdevIndex();
            pVol = checkPair.getPVolIndex();
            if (pVol == null || !indexSet.add(pVol.getIndex())) continue;
            pVolList.add(pVol);
        }
        return pVolList;
    }

    public static Map<Integer, List<SJmoLocalReplicationPairVolInfo>> getSameLayerPairListMap(List<SJmoLocalReplicationPairVolInfo> checkPairList, List<SJmoLocalReplicationPairVolInfo> treeList) {
        if (checkPairList == null || treeList == null) {
            SJctrLogUty.error("SJctrReplicationUtility", "getSameLayerPairListMap", "argument is null.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        SJctrLocalReplicationTiPairComparator comparator = new SJctrLocalReplicationTiPairComparator();
        Collections.sort(checkPairList, comparator);
        HashMap<Integer, List<SJmoLocalReplicationPairVolInfo>> rtnMap = new HashMap<Integer, List<SJmoLocalReplicationPairVolInfo>>();
        List<SJmoLdevIndex> pvolList = SJctrTiReplicationUtility.getSelectedPairPvolList(checkPairList);
        for (SJmoLdevIndex pvol : pvolList) {
            ArrayList pairList = new ArrayList();
            rtnMap.put(pvol.getIndex(), pairList);
        }
        for (SJmoLocalReplicationPairVolInfo treeData : treeList) {
            int iPvolIndex;
            int i = Collections.binarySearch(checkPairList, treeData, comparator);
            if (0 <= i || !rtnMap.containsKey(iPvolIndex = treeData.getPVolIndex().getIndex())) continue;
            List pairList = (List)rtnMap.get(iPvolIndex);
            pairList.add(treeData);
        }
        return rtnMap;
    }

    public static void checkSelectedPairForSplit(List<SJmoLocalReplicationPairVolInfo> checkPairList, SJmoLocalReplicationPairVolInfoMgr pairMgr, List<SJmoLocalReplicationPairVolInfo> selectedTreeList) {
        if (checkPairList == null || pairMgr == null || selectedTreeList == null) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkSelectedPairForSplit", "argument is null.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        if (!SJctrTiReplicationUtility.chkTiPairCloneAndSsMixed(checkPairList)) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkSelectedPairForSplit", "checkPairList Mixed Clone and snapshot Pair.");
            throw SJctrTiReplicationUtility.makeException(206306);
        }
        if (SJctrTiReplicationUtility.chkTiSameLayerContainStatus(checkPairList, selectedTreeList, 0)) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkSelectedPairForSplit", "SamenessLayerPair COPY(RS-R) Exists.");
            throw SJctrTiReplicationUtility.makeException(206308);
        }
    }

    public static void checkSelectedPairForSplitFromOperate(List<SJmoLocalReplicationPairVolInfo> checkPairList, SJmoLocalReplicationPairVolInfoMgr pairMgr, List<SJmoLocalReplicationPairVolInfo> selectedTreeList) {
        if (checkPairList == null || pairMgr == null || selectedTreeList == null) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkSelectedPairForSplitFromOperate", "argument is null.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        try {
            SJctrTiReplicationUtility.checkSelectedPairForSplit(checkPairList, pairMgr, selectedTreeList);
        }
        catch (SJcException e) {
            SJcMessage msgObj = e.getMsg();
            String errorMsgCode = msgObj.getMsgID();
            if (errorMsgCode.equals(Integer.toString(206306))) {
                throw SJctrTiReplicationUtility.makeException(206307);
            }
            if (errorMsgCode.equals(Integer.toString(206308))) {
                throw SJctrTiReplicationUtility.makeException(206309);
            }
            throw e;
        }
    }

    public static int checkSelectedPairForResync(List<SJmoLocalReplicationPairVolInfo> checkPairList, List<SJmoLocalReplicationPairVolInfo> selectedTreeList, SJctrLdevUtility ldevUtil) {
        if (checkPairList == null || selectedTreeList == null) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkSelectedPairForResync", "argument is null.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        int iRtn = 2;
        if (SJctrTiReplicationUtility.checkContainsClonePair(checkPairList)) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkSelectedPairForResync", "checkPairList Contains Clone Pair.");
            throw SJctrTiReplicationUtility.makeException(206310);
        }
        int[] chkStatusPSUE = new int[]{592};
        boolean chkFlg = true;
        for (SJmoLocalReplicationPairVolInfo pairInfo : checkPairList) {
            if (!SJctrReplicationUtility.checkLocalPairVolStatus(pairInfo, chkStatusPSUE)) continue;
            SJctrLogUty.info("SJctrReplicationUtility", "checkSelectedPairForResync", "Contains PSUE. P-VOL = " + ldevUtil.toLdevDisplay(pairInfo.getPVolIndex()) + "  MU# = " + pairInfo.getSMuNum());
            iRtn |= 1;
            chkFlg = false;
            break;
        }
        if (chkFlg && SJctrTiReplicationUtility.chkTiSameLayerContainStatus(checkPairList, selectedTreeList, 1)) {
            iRtn |= 1;
        }
        return iRtn;
    }

    public static void checkSelectedPairForResyncFromOperate(List<SJmoLocalReplicationPairVolInfo> checkPairList, SJmoLocalReplicationPairVolInfoMgr pairMgr, List<SJmoLocalReplicationPairVolInfo> selectedTreeList, SJctrLdevUtility util) {
        if (checkPairList == null || pairMgr == null || selectedTreeList == null || util == null) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkSelectedPairForResync", "argument is null.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        try {
            SJctrTiReplicationUtility.checkSelectedPairForResync(checkPairList, selectedTreeList, util);
        }
        catch (SJcException e) {
            SJcMessage msgObj = e.getMsg();
            String errorMsgCode = msgObj.getMsgID();
            if (errorMsgCode.equals(Integer.toString(206310))) {
                throw SJctrTiReplicationUtility.makeException(206311);
            }
            throw e;
        }
    }

    public static boolean chkTiPairCloneAndSsMixed(List<SJmoLocalReplicationPairVolInfo> checkPairList) {
        if (checkPairList == null || checkPairList.size() == 0) {
            SJctrLogUty.error("SJctrReplicationUtility", "isSelectedCloneSnapshotMixPair", "checkPairList is invalid.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        boolean bRet = true;
        boolean bExClone = checkPairList.get(0).isBClone();
        for (SJmoLocalReplicationPairVolInfo chkPair : checkPairList) {
            if (chkPair.isBClone() == bExClone) continue;
            bRet = false;
            break;
        }
        return bRet;
    }

    public static boolean checkContainsClonePair(List<SJmoLocalReplicationPairVolInfo> checkPairList) {
        if (checkPairList == null) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkContainsClonePair", "checkPairList is null.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        boolean bRet = false;
        for (SJmoLocalReplicationPairVolInfo checkPair : checkPairList) {
            if (!checkPair.isBClone()) continue;
            bRet = true;
            break;
        }
        return bRet;
    }

    public static List<SJmoLdevIndex> getRootLdevDeduplicationList(List<SJmoLocalReplicationPairVolInfo> checkPairList, SJmoTiPvolInfo[] infos) {
        if (checkPairList == null || infos == null) {
            SJctrLogUty.error("SJctrReplicationUtility", "getRootLdevSet", "argument is null.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        ArrayList<SJmoLdevIndex> rootLdevList = new ArrayList<SJmoLdevIndex>();
        HashSet<Integer> rootLdevSet = new HashSet<Integer>();
        for (SJmoLocalReplicationPairVolInfo checkPair : checkPairList) {
            SJmoTiPvolInfo sVolLdev;
            SJmoLdevIndex rootLdev = new SJmoLdevIndex();
            rootLdev = checkPair.getRootLdev();
            if (rootLdev != null && rootLdevSet.add(rootLdev.getIndex())) {
                rootLdevList.add(rootLdev);
            }
            if (!checkPair.isBClone() || null == (sVolLdev = SJctrTiReplicationUtility.getRootLdevOnce(checkPair, infos)) || !rootLdevSet.add(sVolLdev.getIndex())) continue;
            rootLdevList.add(sVolLdev);
        }
        return rootLdevList;
    }

    public static List<SJmoLocalReplicationPairVolInfo> getSamenessLayerPairList(SJmoLdevIndex selectedPairPvol, List<SJmoLocalReplicationPairVolInfo> selectedTreeList) {
        if (selectedPairPvol == null || selectedTreeList == null) {
            SJctrLogUty.error("SJctrReplicationUtility", "getSamenessLayerPairList", "argument is null.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        ArrayList<SJmoLocalReplicationPairVolInfo> samenessLayerPairList = new ArrayList<SJmoLocalReplicationPairVolInfo>();
        int pvolIndex = selectedPairPvol.getIndex();
        for (SJmoLocalReplicationPairVolInfo treePairData : selectedTreeList) {
            if (pvolIndex != treePairData.getPVolIndex().getIndex()) continue;
            samenessLayerPairList.add(treePairData);
        }
        return samenessLayerPairList;
    }

    public static boolean containsPairStatus_Copy_RS_R(List<SJmoLocalReplicationPairVolInfo> checkPairList) {
        if (checkPairList == null) {
            SJctrLogUty.error("SJctrReplicationUtility", "containsPairStatus_Copy_RS_R", "checkPairList is null.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        boolean bRet = false;
        for (SJmoLocalReplicationPairVolInfo checkPair : checkPairList) {
            if (checkPair.getSPairStatus() != 584) continue;
            bRet = true;
            break;
        }
        return bRet;
    }

    public static boolean containsPairStatus_Copy_RS_R_PSUS_SP(List<SJmoLocalReplicationPairVolInfo> checkPairList) {
        if (checkPairList == null) {
            SJctrLogUty.error("SJctrReplicationUtility", "containsPairStatus_Copy_RS_R", "checkPairList is null.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        boolean bRet = false;
        for (SJmoLocalReplicationPairVolInfo checkPair : checkPairList) {
            if (checkPair.getSPairStatus() != 584 && (!checkPair.isBClone() || checkPair.getSPairStatus() != 560)) continue;
            bRet = true;
            break;
        }
        return bRet;
    }

    public static void checkSelectedPairForDelete(List<SJmoLocalReplicationPairVolInfo> checkPairList, SJmoLocalReplicationPairVolInfoMgr pairMgr) {
        if (checkPairList == null || pairMgr == null) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkSelectedPairForDelete", "parameter is null.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        if (!SJctrTiReplicationUtility.checkLeafPairList(checkPairList, pairMgr)) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkSelectedPairForDeleteFromOperate", "Selected Pair is not Leaf.");
            throw SJctrTiReplicationUtility.makeException(206316);
        }
    }

    public static void checkSelectedPairForRemove2ndVol(List<SJmoLocalReplicationPairVolInfo> checkPairList, SJmoLocalReplicationPairVolInfoMgr pairMgr) {
        if (checkPairList == null || pairMgr == null) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkSelectedPairForRemove2ndVol", "parameter is null.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        if (!SJctrTiReplicationUtility.checkLeafPairList(checkPairList, pairMgr)) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkSelectedPairForRemove2ndVolFromOperate", "Selected Pair is not Leaf.");
            throw SJctrTiReplicationUtility.makeException(206316);
        }
        if (SJctrTiReplicationUtility.checkContainsClonePair(checkPairList)) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkSelectedPairForRemove2ndVolFromOperate", "Selected Pair is not Leaf.");
            throw SJctrTiReplicationUtility.makeException(206310);
        }
    }

    public static void checkSelectedPairForDeleteFromOperate(List<SJmoLocalReplicationPairVolInfo> checkPairList, SJmoLocalReplicationPairVolInfoMgr pairMgr) {
        if (checkPairList == null || pairMgr == null) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkSelectedPairForDeleteFromOperate", "parameter is null.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        try {
            SJctrTiReplicationUtility.checkSelectedPairForDelete(checkPairList, pairMgr);
        }
        catch (SJcException e) {
            SJcMessage msgObj = e.getMsg();
            String errorMsgCode = msgObj.getMsgID();
            if (errorMsgCode.equals(Integer.toString(206316))) {
                throw SJctrTiReplicationUtility.makeException(206317);
            }
            throw e;
        }
    }

    public static void checkSelectedPairForRemove2ndVolFromOperate(List<SJmoLocalReplicationPairVolInfo> checkPairList, SJmoLocalReplicationPairVolInfoMgr pairMgr) {
        if (checkPairList == null || pairMgr == null) {
            SJctrLogUty.error("SJctrReplicationUtility", "checkSelectedPairForRemove2ndVolFromOperate", "parameter is null.");
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        try {
            SJctrTiReplicationUtility.checkSelectedPairForRemove2ndVol(checkPairList, pairMgr);
        }
        catch (SJcException e) {
            SJcMessage msgObj = e.getMsg();
            if (msgObj.getMsgID().equals(Integer.toString(206316))) {
                e = SJctrTiReplicationUtility.makeException(206317);
            } else if (msgObj.getMsgID().equals(Integer.toString(206310))) {
                e = SJctrTiReplicationUtility.makeException(206311);
            }
            throw e;
        }
    }

    protected static void checkLocalPairVolStatusForSsCascadeSi(SJmoLocalReplicationPairVolInfo svolpair, SJmoLocalReplicationPairVolInfo pvolpair, int[][] checkStatus) {
        boolean bstatus;
        if (svolpair.isVolPos(0x800000) && pvolpair.isVolPos(8) && !(bstatus = SJctrReplicationUtility.checkLocalPairVolStatus(pvolpair, checkStatus[7]))) {
            SJctrLogUty.error("SJctrReplicationTiUtility", "checkLocalPairVolStatusForSsCascadeSi", "Selected pair is invalid status. -pvol:" + pvolpair + " -status:" + pvolpair.getSPairStatus());
            SJctrError err = new SJctrError(209, 22, 206326);
            SJcException exp = err.createException();
            throw exp;
        }
    }

    public static long getPvolMuIndexKey(SJmoLdevIndex pvolIndex, int mu) {
        long key = -1L;
        long lMu = mu;
        long lPvolIndexKey = pvolIndex.getIndex();
        if (pvolIndex != null) {
            key = lMu << 24 | lPvolIndexKey;
        }
        return key;
    }

    public static long getPvolMuIndexKey(SJmoTiPvolMu pvolMu) {
        long key = -1L;
        if (pvolMu != null) {
            key = SJctrTiReplicationUtility.getPvolMuIndexKey(pvolMu, pvolMu.getMu());
        }
        return key;
    }

    public static Set<Integer> getSetSnapshotGroupId(List<SJctrCreateTIPairInfo> tiPairList) {
        HashSet<Integer> snapshotGroupIdSet = new HashSet<Integer>();
        if (tiPairList != null) {
            for (SJctrCreateTIPairInfo tiPair : tiPairList) {
                SJmoSnapshotSetInfo snapshotGroupInfo = tiPair.getSnapshotGroupInfo();
                if (snapshotGroupInfo == null) continue;
                snapshotGroupIdSet.add(snapshotGroupInfo.getISnapshotSetId());
            }
        }
        return snapshotGroupIdSet;
    }

    public static class SJctrPvolPairCounts {
        private long snapshotDataCount = -1L;
        private long psuePairCount = -1L;

        SJctrPvolPairCounts(long snapshotData, long psuePairs) {
            this.snapshotDataCount = snapshotData;
            this.psuePairCount = psuePairs;
        }

        void setSnapshotDataCount(long snapshotDataCount) {
            this.snapshotDataCount = snapshotDataCount;
        }

        public long getSnapshotDataCount() {
            return this.snapshotDataCount;
        }

        void setPsuePairCount(long psuePairCount) {
            this.psuePairCount = psuePairCount;
        }

        public long getPsuePairCount() {
            return this.psuePairCount;
        }
    }
}

