/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.column.SJctrPathNumFromLdevDetailColumn;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrPathNumColumnFromPortLunTableKey
extends SJctrPathNumFromLdevDetailColumn {
    protected HashMap<String, Integer> pathNumMap = null;

    public SJctrPathNumColumnFromPortLunTableKey(String key) {
        super(key);
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortLunInfo.class);
        list.add(SJmoGetLdevDetail.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        SJctrPortLunTableKey tableKey = (SJctrPortLunTableKey)index;
        SJmoPortLunDetail portLuDetail = tableKey.getPortLunDetail();
        List<?> ldevDetailList = modelData.get(SJmoGetLdevDetail.class);
        SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
        ldevIndex.setSLdkc(portLuDetail.getSLDKC());
        ldevIndex.setSCu(portLuDetail.getSCU());
        ldevIndex.setSLdev(portLuDetail.getSLDEV());
        SJmoLdevDetail ldevDetail = null;
        int i = Collections.binarySearch(ldevDetailList, ldevIndex);
        if (i >= 0) {
            ldevDetail = (SJmoLdevDetail)ldevDetailList.get(i);
        }
        ArrayList<SJmoLdevDetail> list = new ArrayList<SJmoLdevDetail>();
        list.add(ldevDetail);
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJmoLdevDetail ldevDetail = (SJmoLdevDetail)dataList.get(0);
        SJctrLdevUtility util = this.getTable().getComUtility().getLdevUtility();
        String strNum = util.toPathDisplay(ldevDetail);
        if (this.pathNumMap == null) {
            this.pathNumMap = new HashMap(this.getTable().getRowCount());
        }
        int num = -1;
        if (ldevDetail != null) {
            num = ldevDetail.getILUPathNumber();
        }
        this.pathNumMap.put(strNum, num);
        return strNum;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        int num = -1;
        String strNum = this.getString(dat);
        Integer numInt = this.pathNumMap.get(strNum);
        if (numInt != null) {
            num = numInt;
        }
        return num;
    }
}

