/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetHDPRelation;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrPoolManagementTaskColumnFromLdevDetail
extends SJctrColumn {
    public SJctrPoolManagementTaskColumnFromLdevDetail(String key) {
        super(key);
        this.setPartsId("POOL_MANAGE_TASK");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetHDPRelation.class);
        list.add(SJmoGetLdevDetail.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoHDPRelation> retList = new ArrayList<SJmoHDPRelation>();
        if (null != index && index instanceof SJmoLdevDetail) {
            SJmoLdevDetail ldevDtl = (SJmoLdevDetail)index;
            ArrayList hdpRelList = new ArrayList(modelData.get(SJmoGetHDPRelation.class));
            int iHdpRelIdx = Collections.binarySearch(hdpRelList, ldevDtl);
            if (0 <= iHdpRelIdx) {
                SJmoHDPRelation hdpRel = (SJmoHDPRelation)hdpRelList.get(iHdpRelIdx);
                retList.add(hdpRel);
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getNeedModelData", "index is null or Class Error");
        }
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String strRtn = "?";
        SJmoHDPRelation hdpRel = null;
        if (null != dataList && 0 != dataList.size()) {
            hdpRel = (SJmoHDPRelation)dataList.get(0);
            SJctrComUtility comUtl = this.getTable().getComUtility();
            SJctrPoolUtility poolUtl = comUtl.getPoolUtility();
            strRtn = poolUtl.toPoolManagementTaskDisplay(hdpRel);
        }
        return strRtn;
    }

    @Override
    public int getFilterType() {
        return 3;
    }
}

