/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.replication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.wizard.replication.com.SJctrGetLDEVLUPathInfo;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrPVolHGNameColumnFromPairVolInfo
extends SJctrColumn {
    private Map<Integer, List<SJmoPortLunDetail>> ldevLUPathInfoMap = null;

    public SJctrPVolHGNameColumnFromPairVolInfo(String key) {
        super(key);
        this.setPartsId("HG_NAME");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortHostGroupInfo.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        List<SJmoPortLunDetail> portLunDtlList;
        ArrayList<SJmoHostGroupInfo> retList = new ArrayList<SJmoHostGroupInfo>();
        SJmoLocalReplicationPairVolInfo pairVolInfo = (SJmoLocalReplicationPairVolInfo)index;
        if (pairVolInfo.isVolPos(256)) {
            return retList;
        }
        this.ldevLUPathInfoMap = (Map)modelData.get(SJctrGetLDEVLUPathInfo.class).get(0);
        SJmoLdevIndex pVolIndex = pairVolInfo.getPVolIndex();
        if (pVolIndex != null && (portLunDtlList = this.ldevLUPathInfoMap.get(SJctrReplicationUtility.getLdevIndexKey(pVolIndex))) != null) {
            SJmoHostGroupInfo targetHG = null;
            SJmoPortLunDetail portLunDtl = portLunDtlList.get(0);
            List<?> portHGList = modelData.get(SJmoGetPortHostGroupInfo.class);
            int portIndex = Collections.binarySearch(portHGList, portLunDtl);
            if (portIndex >= 0) {
                SJmoPortHostGroupInfo portHGInfo = (SJmoPortHostGroupInfo)portHGList.get(portIndex);
                ArrayList hgInfoList = portHGInfo.getAlPortHostGroup();
                for (SJmoHostGroupInfo hgInfo : hgInfoList) {
                    if (hgInfo.getSHostGroup() != portLunDtl.getSHostGroup()) continue;
                    targetHG = hgInfo;
                    break;
                }
            }
            retList.add(targetHG);
        }
        return retList;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "-";
        if (!dataList.isEmpty()) {
            SJmoHostGroupInfo hgInfo = (SJmoHostGroupInfo)dataList.get(0);
            if (hgInfo != null) {
                SJctrPortUtility util = this.getTable().getComUtility().getPortUtility();
                ret = util.toHostGroupNameDisplay(hgInfo);
            } else {
                ret = "?";
            }
        }
        return ret;
    }
}

