/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.column.replication;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrpMirror;

public class SJctrPathWatchTimeColumnFromUrJnlGrpMirror
extends SJctrColumn {
    public SJctrPathWatchTimeColumnFromUrJnlGrpMirror(String key) {
        super(key);
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setLabel(util.getGuidance("PATH_WATCH_TIME"));
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJmoUniversalReplicatorJnlGrpMirror jnlGrpMirror = (SJmoUniversalReplicatorJnlGrpMirror)dataList.get(0);
        SJctrRemoteReplicationUtility remoteReplicaUty = this.getTable().getComUtility().getRemoteReplicationUtility();
        return remoteReplicaUty.getPathWatchTimeString(jnlGrpMirror);
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        long minute = -2L;
        int CARRY_NUM = 10;
        int WEIGHT_HOUR = 1;
        int WEIGHT_DAY = 2;
        SJmoUniversalReplicatorJnlGrpMirror jnlGrpMirror = (SJmoUniversalReplicatorJnlGrpMirror)this.getPrimaryKeyObject(dat);
        if (jnlGrpMirror != null) {
            if (SJctrRemoteReplicationUtility.isDisableStatusForDispPathWatchTime(jnlGrpMirror)) {
                minute = -1L;
            } else {
                int iPathBlockWatchTime = jnlGrpMirror.getPathBlockWatchTime();
                int pathBlockWatchValue = iPathBlockWatchTime & 0x3F;
                pathBlockWatchValue *= CARRY_NUM;
                int iPathBlockWatchTimeUnit = iPathBlockWatchTime & 0xC0;
                switch (iPathBlockWatchTimeUnit) {
                    case 0: {
                        minute = pathBlockWatchValue;
                        break;
                    }
                    case 64: {
                        minute = pathBlockWatchValue * 60;
                        minute += (long)WEIGHT_HOUR;
                        break;
                    }
                    case 128: {
                        minute = pathBlockWatchValue * 60 * 24;
                        minute += (long)WEIGHT_DAY;
                        break;
                    }
                    default: {
                        SJctrLogUty.error(this.getClass().getSimpleName(), "getNumber", "Path Block Watch Time is invalid value.");
                    }
                }
            }
        }
        return minute;
    }
}

