/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.com.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.event.SJctrEventListener;
import sanproject.sn2.controller.com.model.event.SJctrItemStateEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemStateLintener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.com.model.event.SJctrObjectSetListener;

public abstract class SJctrDataObjectModel<T extends SJctrDataObject> {
    protected final List<SJctrGetDirectWrapper> directList;
    private final Map<Class<?>, List<?>> basicDataMap;
    private final Map<String, SJctrDataObjectModel<? extends SJctrDataObject>> childDataModel;
    protected SJctrLogUty logUty = new SJctrLogUty();
    private final ArrayList<SJctrEventListener> eventListeners;
    private final Map<SJctrNotifyState, SJctrMessageEventListener> messageEventListeners;
    private T manageData;
    private SJctrDataController dataController;
    private boolean receiveFlg;
    private boolean listenerFlg;
    private boolean changeCheckFlg = true;
    private Set<String> userDataKey;
    private boolean restoreFlg = true;
    private boolean dirty;
    public static final String CTRL_USER = "CTRL_USER";
    private SJctrDataObjectModel<?> parent;

    public SJctrDataObjectModel() {
        this.logUty.setTitle(this.getClass().getSimpleName());
        this.childDataModel = new LinkedHashMap<String, SJctrDataObjectModel<? extends SJctrDataObject>>();
        this.directList = new ArrayList<SJctrGetDirectWrapper>();
        this.basicDataMap = new HashMap();
        this.manageData = this.createManageData();
        this.eventListeners = new ArrayList();
        this.messageEventListeners = new HashMap<SJctrNotifyState, SJctrMessageEventListener>();
        this.receiveFlg = true;
        this.listenerFlg = true;
    }

    public final void addDataModel(String key, SJctrDataObjectModel<? extends SJctrDataObject> model) {
        if (key == null || model == null) {
            return;
        }
        model.setDataController(this.dataController);
        model.setParent(this);
        this.childDataModel.put(key, model);
        if (this.dataController == null || this.dataController.getOwner() == null) {
            return;
        }
        SJctrUserController userCtr = this.dataController.getOwner();
        SJctrLogUty childLogUty = userCtr.createLogUty();
        childLogUty.setTitle(model.getClass().getSimpleName());
        model.setLogUty(childLogUty);
    }

    public SJctrDataObjectModel<? extends SJctrDataObject> getDataModel(String key) {
        return this.childDataModel.get(key);
    }

    public final Set<String> keySet() {
        return this.childDataModel.keySet();
    }

    public void addObjectSetListener(SJctrObjectSetListener listener) {
        this.addEventListener(listener);
    }

    public List<SJctrGetDirectWrapper> createModelDirect() {
        ArrayList<SJctrGetDirectWrapper> childDirectList = new ArrayList<SJctrGetDirectWrapper>();
        for (SJctrDataObjectModel<? extends SJctrDataObject> dataModel : this.childDataModel.values()) {
            List<SJctrGetDirectWrapper> list = dataModel.createModelDirect();
            childDirectList.addAll(list);
        }
        this.makeModelDirect();
        childDirectList.addAll(this.directList);
        return childDirectList;
    }

    public Map<String, Map<String, Object>> getActionMenu() {
        HashMap<String, Map<String, Object>> actionMap = new HashMap<String, Map<String, Object>>();
        for (SJctrDataObjectModel<? extends SJctrDataObject> dataModel : this.childDataModel.values()) {
            Map<String, Map<String, Object>> map = dataModel.getActionMenu();
            actionMap.putAll(map);
        }
        return actionMap;
    }

    public List<?> getBasicDataList(Class<?> cls) {
        List<?> list = this.basicDataMap.get(cls);
        if (list == null) {
            list = new ArrayList(0);
        }
        return list;
    }

    public final Map<Class<?>, List<?>> getBasicDataMap() {
        return this.basicDataMap;
    }

    public Object getDataObject(SJctrDataObject inputObject) {
        SJctrDataObject data = null;
        if (this.receiveFlg) {
            Set<String> targetKeySet;
            if (inputObject == null) {
                inputObject = new SJctrDataObject();
                targetKeySet = this.keySet();
            } else {
                targetKeySet = inputObject.getDataMap().keySet();
            }
            if (targetKeySet.size() != 0) {
                this.logUty.putlog("getDataObject", "Get key=" + targetKeySet.toString());
            }
            data = (SJctrDataObject)this.getManageData();
            for (Map.Entry<String, SJctrDataObjectModel<? extends SJctrDataObject>> entry : this.childDataModel.entrySet()) {
                String key = entry.getKey();
                if (targetKeySet.contains(key)) {
                    SJctrDataObject keyObject;
                    SJctrDataObjectModel<? extends SJctrDataObject> model = entry.getValue();
                    Object value = model.getDataObject(keyObject = (SJctrDataObject)inputObject.getData(key));
                    if (value == null) continue;
                    data.setData(key, value);
                    continue;
                }
                data.getDataMap().remove(key);
            }
        }
        return data;
    }

    protected String makeExportString() {
        return "";
    }

    public final void getExport(StringBuilder buf) {
        buf.append(this.makeExportString());
        for (SJctrDataObjectModel<? extends SJctrDataObject> model : this.childDataModel.values()) {
            model.getExport(buf);
        }
    }

    public void setOwnControlData(HashMap<String, Object> controlData) {
    }

    public void setPreOwnControlData(HashMap<String, Object> controlData) {
    }

    protected void dataRestoreFailed(String key, Object obj) {
        this.getLogUty().putlog("dataRestoreFailed", key + ":value=" + obj);
    }

    public void divideModelData(Map<SJctrGetDirectWrapper, List<?>> models) {
        for (SJctrDataObjectModel<? extends SJctrDataObject> dataModel : this.childDataModel.values()) {
            dataModel.divideModelData(models);
        }
        this.setModelData(models);
        this.setControllerData();
    }

    public void makeDataModel() {
        for (SJctrDataObjectModel<? extends SJctrDataObject> dataModel : this.childDataModel.values()) {
            dataModel.makeDataModel();
        }
        long time = System.currentTimeMillis();
        this.makeDataObject();
        SJctrLogUty.debug("DataModel", "makeDataModel", System.currentTimeMillis() - time + "ms");
    }

    public HashMap<String, Object> getOwnControlData() {
        HashMap<String, Object> controlData = new HashMap<String, Object>();
        return controlData;
    }

    protected final Set<String> getUserDataKey() {
        return this.userDataKey;
    }

    public final void setUserDataKey(Set<String> set) {
        this.userDataKey = set;
    }

    public void resetOwnControlData() {
    }

    public boolean isRestoreFlg() {
        return this.restoreFlg;
    }

    public void setRestoreFlg(boolean restoreFlg) {
        this.restoreFlg = restoreFlg;
    }

    public void setControlData(HashMap<String, Object> controlData) {
        for (Map.Entry<String, SJctrDataObjectModel<? extends SJctrDataObject>> entry : this.childDataModel.entrySet()) {
            String key = entry.getKey();
            SJctrDataObjectModel<? extends SJctrDataObject> dataModel = entry.getValue();
            HashMap<String, Object> childMap = null;
            Object childObj = controlData.get(key);
            childMap = childObj instanceof HashMap ? (HashMap<String, Object>)childObj : new HashMap<String, Object>();
            dataModel.setControlData(childMap);
        }
        if (this.isRestoreFlg()) {
            this.setOwnControlData(controlData);
        }
    }

    public void setPreControlData(HashMap<String, Object> controlData) {
        for (Map.Entry<String, SJctrDataObjectModel<? extends SJctrDataObject>> entry : this.childDataModel.entrySet()) {
            String key = entry.getKey();
            SJctrDataObjectModel<? extends SJctrDataObject> dataModel = entry.getValue();
            HashMap<String, Object> childMap = null;
            Object childObj = controlData.get(key);
            childMap = childObj instanceof HashMap ? (HashMap<String, Object>)childObj : new HashMap<String, Object>();
            dataModel.setPreControlData(childMap);
        }
        if (this.isRestoreFlg()) {
            this.setPreOwnControlData(controlData);
        }
    }

    public HashMap<String, Object> getControlData() {
        HashMap<String, Object> controlData = new HashMap<String, Object>();
        for (Map.Entry<String, SJctrDataObjectModel<? extends SJctrDataObject>> entry : this.childDataModel.entrySet()) {
            String key = entry.getKey();
            SJctrDataObjectModel<? extends SJctrDataObject> dataModel = entry.getValue();
            controlData.put(key, dataModel.getControlData());
        }
        HashMap<String, Object> map = null;
        if (this.isRestoreFlg() && (map = this.getOwnControlData()) != null) {
            Set<String> keySet = this.getUserDataKey();
            if (keySet != null) {
                map.put(CTRL_USER, keySet);
            }
            controlData.putAll(map);
        }
        return controlData;
    }

    public final Map<String, Object> getControlDataWithDlgForWiz() {
        HashMap<String, Object> controlData = new HashMap<String, Object>();
        for (Map.Entry<String, SJctrDataObjectModel<? extends SJctrDataObject>> entry : this.childDataModel.entrySet()) {
            String key = entry.getKey();
            SJctrDataObjectModel<? extends SJctrDataObject> dataModel = entry.getValue();
            Map<String, Object> ctrlData = dataModel.getOwnControlDataWithDlgForWiz();
            if (ctrlData == null || ctrlData.isEmpty()) continue;
            controlData.put(key, ctrlData);
        }
        Map<String, Object> ctrlData = this.getOwnControlDataWithDlgForWiz();
        if (ctrlData != null && !ctrlData.isEmpty()) {
            controlData.putAll(ctrlData);
        }
        return controlData;
    }

    protected Map<String, Object> getOwnControlDataWithDlgForWiz() {
        return Collections.emptyMap();
    }

    public void resetControlData() {
        for (SJctrDataObjectModel<? extends SJctrDataObject> dataModel : this.childDataModel.values()) {
            dataModel.resetControlData();
        }
        this.resetOwnControlData();
    }

    public final List<?> setBasicData(Class<?> key, List<?> value) {
        return this.basicDataMap.put(key, value);
    }

    public void setDataObject(Object setObject) {
        if (setObject instanceof SJctrDataObject) {
            SJctrDataObject setData = (SJctrDataObject)setObject;
            for (Map.Entry<String, SJctrDataObjectModel<? extends SJctrDataObject>> entry : this.childDataModel.entrySet()) {
                String key = entry.getKey();
                if (!setData.containsKey(key)) continue;
                Object obj = setData.getData(key);
                SJctrDataObjectModel<? extends SJctrDataObject> model = entry.getValue();
                model.setDataObject(obj);
            }
        }
        this.fireObjectSet(setObject);
    }

    protected final void fireObjectSet(Object setObject) {
        for (SJctrEventListener listener : this.getEventListeners()) {
            if (!(listener instanceof SJctrObjectSetListener)) continue;
            ((SJctrObjectSetListener)listener).doAction(setObject);
        }
    }

    public void setEnableListener(boolean flg) {
        this.listenerFlg = flg;
    }

    public boolean isEnableListener() {
        return this.listenerFlg;
    }

    protected final List<SJctrEventListener> getEventListeners() {
        ArrayList<SJctrEventListener> retListener = this.listenerFlg ? this.eventListeners : new ArrayList(0);
        return retListener;
    }

    public final void addEventListener(SJctrEventListener listener) {
        if (listener == null) {
            return;
        }
        this.eventListeners.add(listener);
    }

    protected final <E extends SJctrEventListener> List<E> getEventListeners(Class<E> cls) {
        List<SJctrEventListener> list = this.getEventListeners();
        int size = list.size();
        ArrayList<SJctrEventListener> retList = new ArrayList<SJctrEventListener>(size);
        for (int i = 0; i < size; ++i) {
            SJctrEventListener listener = list.get(i);
            if (!cls.isInstance(listener)) continue;
            retList.add(listener);
        }
        return retList;
    }

    public void setDataController(SJctrDataController dataController) {
        if (dataController == null) {
            return;
        }
        this.dataController = dataController;
        for (SJctrDataObjectModel<? extends SJctrDataObject> model : this.childDataModel.values()) {
            model.setDataController(dataController);
        }
    }

    protected abstract T createManageData();

    public final T getManageData() {
        return this.manageData;
    }

    public SJctrDataController getDataController() {
        return this.dataController;
    }

    protected abstract void makeDataObject();

    protected abstract void makeModelDirect();

    public final void addMessageEventListener(SJctrNotifyState state, SJctrMessageEventListener listener) {
        this.messageEventListeners.put(state, listener);
    }

    public SJctrLogUty getLogUty() {
        return this.logUty;
    }

    public void setLogUty(SJctrLogUty logUty) {
        this.logUty = logUty;
        if (this.dataController == null || this.dataController.getOwner() == null) {
            return;
        }
        SJctrUserController userCtr = this.dataController.getOwner();
        for (SJctrDataObjectModel<? extends SJctrDataObject> model : this.childDataModel.values()) {
            SJctrLogUty childLogUty = userCtr.createLogUty();
            childLogUty.setTitle(model.getClass().getSimpleName());
            model.setLogUty(childLogUty);
        }
    }

    protected void setControllerData() {
    }

    protected final void setManageData(T data) {
        this.manageData = data;
    }

    protected void setModelData(Map<SJctrGetDirectWrapper, List<?>> models) {
        this.basicDataMap.clear();
        for (SJctrGetDirectWrapper wrapper : this.directList) {
            List<?> dataList = models.get(wrapper);
            if (dataList == null) {
                dataList = new ArrayList(0);
            }
            this.basicDataMap.put(wrapper.getKindClass(), dataList);
        }
        this.directList.clear();
    }

    public final boolean isDirty() {
        for (SJctrDataObjectModel<? extends SJctrDataObject> model : this.childDataModel.values()) {
            if (!model.isDirty()) continue;
            return true;
        }
        return this.dirty;
    }

    public void initGuidance(SJctrComUtility util) {
        for (SJctrDataObjectModel<? extends SJctrDataObject> dataModel : this.childDataModel.values()) {
            dataModel.initGuidance(util);
        }
    }

    public void setDirty() {
        this.dirty = true;
    }

    public final void setDirtyAll() {
        for (SJctrDataObjectModel<? extends SJctrDataObject> model : this.childDataModel.values()) {
            model.setDirtyAll();
        }
        this.dirty = true;
    }

    public final SJctrDataObject getDirtyTarget() {
        SJctrDataObject retObject = null;
        for (Map.Entry<String, SJctrDataObjectModel<? extends SJctrDataObject>> entry : this.childDataModel.entrySet()) {
            SJctrDataObjectModel<? extends SJctrDataObject> model = entry.getValue();
            if (!model.isDirty()) continue;
            if (retObject == null) {
                retObject = new SJctrDataObject();
            }
            String key = entry.getKey();
            SJctrDataObject data = model.getDirtyTarget();
            retObject.setData(key, data);
        }
        return retObject;
    }

    public final void clearDirty() {
        for (SJctrDataObjectModel<? extends SJctrDataObject> model : this.childDataModel.values()) {
            model.clearDirty();
        }
        this.dirty = false;
    }

    public final void setParent(SJctrDataObjectModel<?> model) {
        this.parent = model;
    }

    public final void fireMessageEvent(SJctrNotifyState state) {
        SJctrMessageEvent message = new SJctrMessageEvent(this, state);
        this.dataController.doMessageEvent(message);
    }

    public final void fireMessageEvent(SJctrNotifyState state, Object obj) {
        SJctrMessageEvent message = new SJctrMessageEvent(this, state, obj);
        this.dataController.doMessageEvent(message);
    }

    public void doMessageEvent(SJctrMessageEvent message) {
        for (SJctrDataObjectModel<? extends SJctrDataObject> model : this.childDataModel.values()) {
            model.doMessageEvent(message);
        }
        SJctrNotifyState state = message.getNotifyState();
        SJctrMessageEventListener listener = this.messageEventListeners.get(state);
        if (listener != null) {
            listener.doMessageAction(message, this);
        }
    }

    public Serializable getData() {
        return null;
    }

    public void setData(Serializable data) {
    }

    void addItemStateChangeLintener(SJctrItemStateLintener listener) {
        this.addEventListener(listener);
    }

    void fireItemStateChanged() {
        SJctrItemStateEvent<T> event = null;
        this.setDirty();
        for (SJctrEventListener listener : this.getEventListeners()) {
            if (!(listener instanceof SJctrItemStateLintener)) continue;
            if (event == null) {
                event = new SJctrItemStateEvent<T>(this, this.getManageData());
            }
            ((SJctrItemStateLintener)listener).stateChanged(event);
        }
    }

    public final SJctrComUtility getComUtility() {
        return this.getDataController().getOwner().getComUtility();
    }

    public void setReceiveOnly() {
        this.receiveFlg = false;
    }

    public void clearData() {
        for (String key : this.keySet()) {
            this.getDataModel(key).clearData();
        }
        this.clearModelData();
    }

    protected void clearModelData() {
    }

    public final boolean isChange() {
        if (this.changeCheckFlg) {
            if (this.dirty) {
                return true;
            }
            for (SJctrDataObjectModel<? extends SJctrDataObject> model : this.childDataModel.values()) {
                if (!model.isChange()) continue;
                return true;
            }
        }
        return false;
    }

    public void setChangeCheck(boolean changeCheckFlg) {
        this.changeCheckFlg = changeCheckFlg;
    }
}

