/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.account.rsg.rsgs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.comparator.SJctrRsgInfoRsgNameComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.topwindow.account.rsg.SJctrRsgsSummaryModel;
import sanproject.sn2.controller.topwindow.account.rsg.rsgs.SJctrRsgsActionMenuModel;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgInfo;
import sanproject.sn2.controller.wizard.account.rsg.com.SJctrRsgsRscTopTableModel;
import sanproject.sn2.controller.wizard.account.rsg.deletersgs.SJctrDeleteRsgsSubWizard;
import sanproject.sn2.controller.wizard.account.rsg.editrsg.SJctrEditRsgSubWizard;

public class SJctrRsgsRsgsDC
extends SJctrDataController {
    private static final int DISP_ID = 9985;
    public static final String KEY_SUMMARY = "COM_SUMMARY";
    public static final String KEY_TABLE = "COM_TABLE";
    public static final String KEY_ACTION_MENU = "COM_ACTION_MENU";

    public SJctrRsgsRsgsDC() throws SJcException {
        super(9985);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_SUMMARY, new SJctrRsgsSummaryModel());
        this.addDataObjectModel(KEY_TABLE, new SJctrRsgsRscTopTableModel());
        this.addDataObjectModel(KEY_ACTION_MENU, new SJctrRsgsActionMenuModel());
    }

    private void initListener() {
        this.addMessageEventListener(RSG_RSGS_MSG.SELECT_EDIT_RSG, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrRsgsRsgsDC.this.makeEditRSG(event, dstModel);
            }
        });
        this.addMessageEventListener(RSG_RSGS_MSG.SELECT_DEL_RSG, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrRsgsRsgsDC.this.makeDeleteRSG(event, dstModel);
            }
        });
    }

    private void makeEditRSG(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrRsgsRscTopTableModel rsgsRscTopTable = (SJctrRsgsRscTopTableModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRsgList = rsgsRscTopTable.getSelectedRowData();
        SJctrRsgInfo rsgData = (SJctrRsgInfo)selectedRsgList.get(0);
        if (0 == rsgData.getRsgInfo().getRsgInfo().getRsgId()) {
            this.getLogUty().putlog("makeEditRSG", "The resource group 0 cannot be edited.");
            SJctrError err = new SJctrError(207, 22, 105292);
            SJcException exp = err.createException();
            throw exp;
        }
        if (SJctrRsgUtility.isSysRsg(rsgData.getRsgInfo().getRsgInfo())) {
            this.getLogUty().putlog("makeEditRSG", "Selected RSG is System RSG.");
            throw SJctrRsgUtility.makeException(205168);
        }
        ArrayList<SJctrRsgInfo> rsgDataList = new ArrayList<SJctrRsgInfo>();
        rsgDataList.add(rsgData);
        HashMap param = new HashMap();
        param.put(SJctrRsgInfo.class.getName(), rsgDataList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrEditRsgSubWizard.class, param);
        this.addUpdateDisp(wizardRelated);
    }

    private void makeDeleteRSG(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrRsgsRscTopTableModel rsgsRscTopTable = (SJctrRsgsRscTopTableModel)this.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRsgList = rsgsRscTopTable.getSelectedRowData();
        if (SJctrRsgUtility.isIncludeRsg0(selectedRsgList)) {
            this.getLogUty().putlog("makeDeleteRSG", "The resource group 0 cannot be deleted.");
            SJctrError err = new SJctrError(207, 22, 105291);
            SJcException exp = err.createException();
            throw exp;
        }
        if (SJctrRsgUtility.isIncludeDifferentVdkc(selectedRsgList)) {
            this.getLogUty().putlog("makeDeleteRSG", "selected RSGs are join different VDKCs");
            SJctrError err = new SJctrError(207, 22, 205066);
            SJcException exp = err.createException();
            throw exp;
        }
        List<Object> deleteRsgList = selectedRsgList;
        Collections.sort(deleteRsgList, new SJctrRsgInfoRsgNameComparator());
        HashMap param = new HashMap();
        param.put(SJctrRsgInfo.class.getName(), deleteRsgList);
        SJctrRelatedDispDataObject wizardRelated = this.createWizard(SJctrDeleteRsgsSubWizard.class, param);
        this.addUpdateDisp(wizardRelated);
    }

    public static enum RSG_RSGS_MSG implements SJctrNotifyState
    {
        SELECT_EDIT_RSG,
        SELECT_DEL_RSG;

    }
}

