/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.alert.comdialog.alertproperties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import sanproject.serverux.dataimpl.DISKgetErrorLogInfoEx;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.topwindow.alert.comdialog.alertproperties.SJctrAlertPropertiesSummaryModel;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;

public class SJctrAlertPropertiesDC
extends SJctrDialogDataController {
    public static final int DISP_ID = 34664473;
    public static final String KEY_SUMMARY = "COM_SUMMARY";
    public static final String KEY_DETAIL_BTN = "COM_BTN_DETAIL";
    private List<DISKgetErrorLogInfoEx> selectErrorInfoList = null;
    private int currentIndex = 0;
    public static final String KEY_ALERT_LIST = "ALERT_LIST";
    private final int colcPageOne = 1;

    public SJctrAlertPropertiesDC() throws SJcException {
        super(34664473);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_SUMMARY, new SJctrAlertPropertiesSummaryModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(Collections.unmodifiableSet(EnumSet.of(SJctrFooterDataModel.Button.BACK, SJctrFooterDataModel.Button.NEXT, SJctrFooterDataModel.Button.CLOSE))));
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> dataList = this.getCache(KEY_ALERT_LIST);
        if (dataList == null || dataList.size() == 0) {
            SJctrError err = new SJctrError(2, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        this.selectErrorInfoList = new ArrayList<DISKgetErrorLogInfoEx>(dataList.size());
        for (Object errorInfo : dataList) {
            if (!(errorInfo instanceof DISKgetErrorLogInfoEx)) {
                SJctrError err = new SJctrError(2, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            this.selectErrorInfoList.add((DISKgetErrorLogInfoEx)errorInfo);
        }
        return ret;
    }

    @Override
    public void makeDataModel() {
        SJctrAlertPropertiesSummaryModel summary = (SJctrAlertPropertiesSummaryModel)this.getDataObjectModel(KEY_SUMMARY);
        summary.setErrorInfoList(this.selectErrorInfoList);
        super.makeDataModel();
    }

    @Override
    protected void updateFooter() {
        super.updateFooter();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        if (this.currentIndex > 0 && this.currentIndex < this.selectErrorInfoList.size()) {
            footer.setEnableButton(SJctrFooterDataModel.Button.BACK, true);
        } else {
            footer.setEnableButton(SJctrFooterDataModel.Button.BACK, false);
        }
        if (this.currentIndex >= 0 && this.currentIndex < this.selectErrorInfoList.size() - 1) {
            footer.setEnableButton(SJctrFooterDataModel.Button.NEXT, true);
        } else {
            footer.setEnableButton(SJctrFooterDataModel.Button.NEXT, false);
        }
    }

    private void initListener() {
        this.addMessageEventListener(SJctrWizardDataController.WIZ_MSG.BACK, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAlertPropertiesDC.this.backAction();
            }
        });
        this.addMessageEventListener(SJctrWizardDataController.WIZ_MSG.NEXT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAlertPropertiesDC.this.nextAction();
            }
        });
    }

    private void backAction() {
        if (this.currentIndex - 1 >= 0) {
            --this.currentIndex;
            this.updateFooter();
            SJctrAlertPropertiesSummaryModel summary = (SJctrAlertPropertiesSummaryModel)this.getDataObjectModel(KEY_SUMMARY);
            summary.makeSummary(this.currentIndex);
            summary.setDirty();
        } else {
            this.updateFooter();
            SJctrLogUty.warn(SJctrAlertPropertiesDC.class.getSimpleName(), "backAction", "currentIndex : " + this.currentIndex);
        }
    }

    private void nextAction() {
        if (this.currentIndex + 1 <= this.selectErrorInfoList.size() - 1) {
            ++this.currentIndex;
            this.updateFooter();
            SJctrAlertPropertiesSummaryModel summary = (SJctrAlertPropertiesSummaryModel)this.getDataObjectModel(KEY_SUMMARY);
            summary.makeSummary(this.currentIndex);
            summary.setDirty();
        } else {
            this.updateFooter();
            SJctrLogUty.warn(SJctrAlertPropertiesDC.class.getSimpleName(), "nextAction", "currentIndex : " + this.currentIndex + ",selectErrorInfoList.size : " + this.selectErrorInfoList.size());
        }
    }
}

