/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.arraygroup.com;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.model.data.inf.SJmoDataIndex_IF;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgIndex;

public class SJctrArrayGroupUtility {
    public static final String PG_TYPE_INTERNAL = "INTERNAL";
    public static final String PG_TYPE_EXTERNAL = "EXTERNAL";

    public static String createFolderName(int iFB4) {
        String rtn = "";
        if (iFB4 >= 0 && iFB4 <= 64) {
            rtn = PG_TYPE_INTERNAL;
        } else if (iFB4 >= 101 && iFB4 <= 16484) {
            rtn = PG_TYPE_EXTERNAL;
        }
        return rtn;
    }

    public static List<SJmoPgDetail> extractAvailablePgList(List<SJmoPgDetail> pgList, SJmoRSGgetAllRsgs rsg, SJctrUserController user) {
        SJctrResourceGroupUtility util = new SJctrResourceGroupUtility(user, rsg);
        ArrayList<SJmoPgDetail> extractedList = new ArrayList<SJmoPgDetail>();
        List<SJmoPgIndex> workList = util.extractPg(pgList);
        Collections.sort(workList);
        for (SJmoPgIndex index : workList) {
            extractedList.add((SJmoPgDetail)index);
        }
        return extractedList;
    }

    public static List<SJmoLdevDetail> extractAvailableLdevList(List<SJmoLdevDetail> targetList, SJmoRSGgetAllRsgs rsg, SJctrUserController user) {
        SJctrResourceGroupUtility util = new SJctrResourceGroupUtility(user, rsg);
        ArrayList<SJmoLdevDetail> extractedList = new ArrayList<SJmoLdevDetail>();
        List<SJmoLdevIndex> workList = util.extractLdev(targetList);
        Collections.sort(workList);
        for (SJmoLdevIndex index : workList) {
            extractedList.add((SJmoLdevDetail)index);
        }
        return extractedList;
    }

    public static SJmoRSGgetRsg getBelongToRsg(SJmoDataIndex_IF targetIndex, List<SJmoRSGgetRsg> rsgList) {
        for (SJmoRSGgetRsg rsg : rsgList) {
            int index;
            List<? extends SJmoDataIndex_IF> searchSouceList = SJctrArrayGroupUtility.getTargetResouceList(targetIndex, rsg);
            if (searchSouceList == null || searchSouceList.size() == 0 || (index = Collections.binarySearch(searchSouceList, targetIndex)) < 0) continue;
            return rsg;
        }
        return null;
    }

    public static List<? extends SJmoDataIndex_IF> getTargetResouceList(SJmoDataIndex_IF targetIndex, SJmoRSGgetRsg rsg) {
        if (targetIndex instanceof SJmoPgIndex) {
            return rsg.getVdevs();
        }
        if (targetIndex instanceof SJmoLdevIndex) {
            return rsg.getLdevs();
        }
        return new ArrayList();
    }
}

