/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.topwindow.base;

import java.util.ArrayList;
import java.util.HashMap;
import sanproject.sn2.controller.com.data.SJctrNestedListDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrMenuDataModel;
import sanproject.sn2.controller.com.model.SJctrNestedListDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.topwindow.base.SJctrAccordionTreeModel;
import sanproject.sn2.controller.topwindow.base.SJctrTopWindowDC;

public class SJctrCrumbTrailModel
extends SJctrMenuDataModel {
    private SJctrAccordionTreeModel activeTreeModel = null;
    private static final String MENU_SYSTEM = "SYSTEM";
    private static final String KEY_LABERU = "label";
    public static final String COM_CHILD = "children";
    public static final String COM_SLASH = "\\";

    public SJctrCrumbTrailModel() {
        this.init();
    }

    @Override
    protected HashMap<String, Object> createItem(String name, String label) {
        HashMap<String, Object> item = super.createItem(name, label);
        SJctrMenuDataModel.Item.setLink(item, true);
        SJctrMenuDataModel.Item.setSelect(item, false);
        return item;
    }

    private void init() {
        this.addMessageEventListener(SJctrTopWindowDC.TOP_MSG.MOVE_CRUMB, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCrumbTrailModel.this.activeTreeModel = (SJctrAccordionTreeModel)event.getSource();
                SJctrNestedListDataModel nestListDataModel = (SJctrNestedListDataModel)event.getNofifyObject();
                SJctrCrumbTrailModel.this.makeCrumbTrail(nestListDataModel);
                SJctrCrumbTrailModel.this.setDirty();
            }
        });
    }

    @Override
    protected void setAction(SJctrNestedListDataObject nestedList) {
        if (this.activeTreeModel != null) {
            this.activeTreeModel.setAction(nestedList);
        }
    }

    private void makeCrumbTrail(SJctrNestedListDataModel nestListDataModel) {
        this.removeAllItems();
        String name = nestListDataModel.getSelection();
        this.addItem(name);
        for (String key : this.getItemMap().keySet()) {
            HashMap<String, Object> orgItem = nestListDataModel.getItem(key);
            String orgLabel = SJctrMenuDataModel.Item.getLabel(orgItem);
            HashMap<String, Object> item = this.getItem(key);
            SJctrMenuDataModel.Item.setLabel(item, orgLabel);
        }
        HashMap<String, Object> item = this.getItem(name);
        SJctrMenuDataModel.Item.setLink(item, false);
        SJctrMenuDataModel.Item.setSelect(item, true);
    }

    public void makeCrumbTrail(String name, String label) {
        this.removeAllItems();
        HashMap<String, Object> itemMap = this.createItem(name, label);
        this.addItem(itemMap);
        for (String key : this.getItemMap().keySet()) {
            HashMap<String, Object> orgItem = this.getItem(key);
            String orgLabel = SJctrMenuDataModel.Item.getLabel(orgItem);
            HashMap<String, Object> item = this.getItem(key);
            SJctrMenuDataModel.Item.setLabel(item, orgLabel);
        }
    }

    public String getName() {
        String sName = "";
        HashMap<String, Object> hItem = this.getItem(MENU_SYSTEM);
        if (hItem.containsKey(KEY_LABERU)) {
            sName = sName + hItem.get(KEY_LABERU);
            sName = this.getMenu(sName, hItem);
        }
        return sName;
    }

    public String getMenu(String sName, HashMap<String, Object> hItem) {
        ArrayList arrayinfo;
        if (hItem.containsKey(COM_CHILD) && (hItem = (HashMap)(arrayinfo = (ArrayList)hItem.get(COM_CHILD)).get(0)).containsKey(KEY_LABERU)) {
            sName = sName + COM_SLASH + hItem.get(KEY_LABERU);
            sName = this.getMenu(sName, hItem);
        }
        return sName;
    }
}

